/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-06 19:37:08 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `qjfda_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21689 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=61656 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=65473 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `level` varchar(25) NOT NULL DEFAULT '',
  `event_type` varchar(25) NOT NULL DEFAULT '',
  `details` text NOT NULL,
  `stacktrace` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=645 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` varchar(25) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `type` varchar(25) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `network_id` bigint(20) NOT NULL DEFAULT 0,
  `site_id` bigint(20) NOT NULL DEFAULT 0,
  `logtime` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) NOT NULL DEFAULT '',
  `username` varchar(150) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) DEFAULT NULL,
  `referer_info` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `country_code` varchar(50) DEFAULT NULL,
  `event_data` longtext DEFAULT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) NOT NULL,
  `meta_key2` varchar(255) NOT NULL,
  `meta_key3` varchar(255) NOT NULL,
  `meta_key4` varchar(255) NOT NULL,
  `meta_key5` varchar(255) NOT NULL,
  `meta_value1` varchar(255) NOT NULL,
  `meta_value2` text NOT NULL,
  `meta_value3` text NOT NULL,
  `meta_value4` longtext NOT NULL,
  `meta_value5` longtext NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_logged_in_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `ip_address` varchar(45) NOT NULL DEFAULT '',
  `site_id` bigint(20) NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `expires` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) NOT NULL DEFAULT '',
  `lock_reason` varchar(128) NOT NULL DEFAULT '',
  `unlock_key` varchar(128) NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT 1,
  `backtrace_log` text NOT NULL,
  `ip_lookup_result` longtext DEFAULT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `released` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_message_store` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_key` text NOT NULL,
  `message_value` text NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) NOT NULL DEFAULT '',
  `block_reason` varchar(128) NOT NULL DEFAULT '',
  `country_origin` varchar(50) NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT 0,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_asp_index` (
  `doc` bigint(20) NOT NULL DEFAULT 0,
  `term` varchar(150) NOT NULL DEFAULT '0',
  `term_reverse` varchar(150) NOT NULL DEFAULT '0',
  `blogid` mediumint(9) NOT NULL DEFAULT 0,
  `content` mediumint(9) NOT NULL DEFAULT 0,
  `title` mediumint(9) NOT NULL DEFAULT 0,
  `comment` mediumint(9) NOT NULL DEFAULT 0,
  `tag` mediumint(9) NOT NULL DEFAULT 0,
  `link` mediumint(9) NOT NULL DEFAULT 0,
  `author` mediumint(9) NOT NULL DEFAULT 0,
  `category` mediumint(9) NOT NULL DEFAULT 0,
  `excerpt` mediumint(9) NOT NULL DEFAULT 0,
  `taxonomy` mediumint(9) NOT NULL DEFAULT 0,
  `customfield` mediumint(9) NOT NULL DEFAULT 0,
  `post_type` varchar(50) NOT NULL DEFAULT 'post',
  `item` bigint(20) NOT NULL DEFAULT 0,
  `lang` varchar(20) NOT NULL DEFAULT '0',
  UNIQUE KEY `doctermitem` (`doc`,`term`,`blogid`),
  KEY `term_ptype_bid_lang` (`term`(20),`post_type`(20),`blogid`,`lang`(10)),
  KEY `rterm_ptype_bid_lang` (`term_reverse`(20),`post_type`(20),`blogid`,`lang`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_asp_synonyms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(50) NOT NULL,
  `synonyms` text NOT NULL,
  `lang` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `keyword` (`keyword`,`lang`),
  KEY `keyword_lang` (`keyword`,`lang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_awb_critical_css` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `css_key` varchar(255) NOT NULL,
  `mobile_css` longtext NOT NULL,
  `desktop_css` longtext NOT NULL,
  `mobile_preloads` longtext NOT NULL,
  `desktop_preloads` longtext NOT NULL,
  `updated_at` varchar(25) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_fusion_form_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` bigint(20) NOT NULL,
  `value` longtext DEFAULT NULL,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_fusion_form_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_name` varchar(256) NOT NULL,
  `field_label` varchar(256) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_fusion_form_submissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `ip` varchar(512) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) NOT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_fusion_forms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT 0,
  `submissions_count` bigint(20) DEFAULT 0,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=186505 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16573 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=7316 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_royal_myaccount` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `menuID` int(10) NOT NULL,
  `menuName` varchar(150) NOT NULL,
  `menusSettingData` text NOT NULL,
  `menuContent` text NOT NULL,
  `menuSlug` varchar(90) NOT NULL,
  `menuSort` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `qjfda_royal_story_highlights` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` text DEFAULT NULL,
  `image_url_full` text DEFAULT NULL,
  `image_url` text DEFAULT NULL,
  `status` enum('active','deactive') DEFAULT NULL,
  `deactive_from` datetime DEFAULT NULL,
  `show_story_time` int(11) DEFAULT 8,
  `open_links` enum('_blank','_self') DEFAULT NULL,
  `display_size` enum('contain','cover') DEFAULT NULL,
  `publish_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_royal_story_stories` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `highlight_id` bigint(20) NOT NULL,
  `type` enum('simple','products','categorys') DEFAULT NULL,
  `title` text DEFAULT NULL,
  `excerpt` text DEFAULT NULL,
  `image_url` text DEFAULT NULL,
  `link` text DEFAULT NULL,
  `button_type` enum('button','image') DEFAULT NULL,
  `button_color_text` varchar(255) DEFAULT NULL,
  `button_color_bg` varchar(255) DEFAULT NULL,
  `button_text_image` text DEFAULT NULL,
  `button_image_bg` text DEFAULT NULL,
  `products` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`products`)),
  `categorys` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`categorys`)),
  `sort_category` text DEFAULT NULL,
  `limit_product_show` int(11) DEFAULT NULL,
  `status` enum('active','deactive') DEFAULT NULL,
  `deactive_from` datetime DEFAULT NULL,
  `publish_date` datetime DEFAULT NULL,
  `num_order` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_sj_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `users_emails` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=1792 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=614 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1792 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15762 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`),
  KEY `billing_email` (`billing_email`),
  KEY `type_status` (`type`,`status`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`,`meta_value`(100)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`,`meta_value`(100))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text NOT NULL,
  `text2` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=489 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT NULL,
  `viewport` longtext DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `qjfda_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL,
  `status` varchar(255) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=InnoDB AUTO_INCREMENT=483 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `qjfda_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL,
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT NULL,
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL,
  `queue_name` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `hash` (`hash`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: qjfda_actionscheduler_actions */
INSERT INTO `qjfda_actionscheduler_actions` VALUES("582", "action_scheduler/migration_hook", "failed", "2023-04-14 15:52:44", "2023-04-14 19:22:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1681487564;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1681487564;}", "1", "1", "2023-04-14 15:52:50", "2023-04-14 19:22:50", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("588", "action_scheduler/migration_hook", "failed", "2023-06-06 12:50:49", "2023-06-06 17:20:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686055849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686055849;}", "1", "1", "2023-06-06 12:51:12", "2023-06-06 17:21:12", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("591", "action_scheduler/migration_hook", "failed", "2023-06-07 09:55:35", "2023-06-07 14:25:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686131735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686131735;}", "1", "1", "2023-06-07 09:55:36", "2023-06-07 14:25:36", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("594", "action_scheduler/migration_hook", "failed", "2023-06-07 16:06:02", "2023-06-07 20:36:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686153962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686153962;}", "1", "1", "2023-06-08 10:52:27", "2023-06-08 15:22:27", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("597", "action_scheduler/migration_hook", "failed", "2023-06-08 12:00:02", "2023-06-08 16:30:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686225602;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686225602;}", "1", "1", "2023-06-08 12:00:31", "2023-06-08 16:30:31", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("600", "action_scheduler/migration_hook", "failed", "2023-06-08 17:04:24", "2023-06-08 21:34:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1686243864;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1686243864;}", "1", "1", "2023-06-08 17:05:24", "2023-06-08 21:35:24", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("2478", "action_scheduler/migration_hook", "failed", "2023-11-01 10:59:47", "2023-11-01 14:29:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698836387;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698836387;}", "1", "1", "2023-11-01 11:00:08", "2023-11-01 14:30:08", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("2587", "action_scheduler/migration_hook", "failed", "2023-11-02 12:19:27", "2023-11-02 15:49:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1698927567;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1698927567;}", "1", "1", "2023-11-02 12:20:30", "2023-11-02 15:50:30", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("3033", "action_scheduler/migration_hook", "failed", "2023-12-09 15:43:27", "2023-12-09 19:13:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1702136607;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1702136607;}", "1", "1", "2023-12-09 15:43:46", "2023-12-09 19:13:46", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("3620", "action_scheduler/migration_hook", "failed", "2023-12-20 12:55:37", "2023-12-20 16:25:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1703076937;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1703076937;}", "1", "1", "2023-12-20 15:31:19", "2023-12-20 19:01:19", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("8124", "action_scheduler/migration_hook", "failed", "2024-04-30 12:31:24", "2024-04-30 16:01:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714480284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714480284;}", "1", "1", "2024-04-30 12:31:54", "2024-04-30 16:01:54", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("8128", "action_scheduler/migration_hook", "failed", "2024-05-01 10:01:39", "2024-05-01 13:31:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714557699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714557699;}", "1", "1", "2024-05-01 10:01:59", "2024-05-01 13:31:59", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17643", "rocket_job_warmup", "failed", "2025-01-13 18:35:39", "2025-01-13 18:35:39", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17644", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17645", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/watch\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17646", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/clothing\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17647", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/photography-equipment\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17648", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/modern-mobile\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17649", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\\/apple\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17650", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\\/samsung-phone\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17651", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/watch\\/ingersoll-watch\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17652", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/watch\\/samsung-watch\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17653", "rocket_job_warmup_url", "failed", "2025-01-13 18:35:42", "2025-01-13 18:35:42", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/photography-equipment\\/camera\\/\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-03-18 10:08:06", "2025-03-18 13:38:06", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("17714", "action_scheduler/migration_hook", "failed", "2025-03-18 10:38:28", "2025-03-18 14:08:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1742294308;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1742294308;}", "1", "1", "2025-03-18 10:38:38", "2025-03-18 14:08:38", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("18854", "action_scheduler/migration_hook", "failed", "2025-08-04 20:46:28", "2025-08-05 00:16:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754340388;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754340388;}", "1", "1", "2025-08-04 20:46:29", "2025-08-05 00:16:29", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("20187", "rocket_job_warmup", "failed", "2025-08-11 15:32:28", "2025-08-11 15:32:28", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-08-11 15:33:50", "2025-08-11 19:03:50", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("20355", "action_scheduler/migration_hook", "failed", "2025-08-12 00:01:49", "2025-08-12 03:31:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1754956909;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1754956909;}", "1", "1", "2025-08-25 11:23:00", "2025-08-25 14:53:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21216", "woocommerce_cleanup_sessions", "complete", "2025-09-23 23:26:01", "2025-09-24 02:56:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758669961;s:18:\"\0*\0first_timestamp\";i:1756144622;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758669961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "11", "1", "2025-12-31 11:15:55", "2025-12-31 14:45:55", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21217", "woocommerce_refresh_order_count_cache", "complete", "2025-09-23 23:26:01", "2025-09-24 02:56:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758669961;s:18:\"\0*\0first_timestamp\";i:1751507902;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758669961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-12-31 11:15:55", "2025-12-31 14:45:55", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21218", "woocommerce_scheduled_sales", "complete", "2025-09-24 11:26:01", "2025-09-24 14:56:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713161;s:18:\"\0*\0first_timestamp\";i:1756155600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-31 11:15:55", "2025-12-31 14:45:55", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21219", "woocommerce_cleanup_draft_orders", "complete", "2025-09-24 11:26:01", "2025-09-24 14:56:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713161;s:18:\"\0*\0first_timestamp\";i:1657982695;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-31 11:15:55", "2025-12-31 14:45:55", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21220", "wc_admin_daily_wrapper", "complete", "2025-09-24 11:26:01", "2025-09-24 14:56:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713161;s:18:\"\0*\0first_timestamp\";i:1756123022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-31 11:15:55", "2025-12-31 14:45:55", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21221", "woocommerce_cleanup_personal_data", "complete", "2025-09-24 11:26:02", "2025-09-24 14:56:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713162;s:18:\"\0*\0first_timestamp\";i:1756123032;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-31 11:15:56", "2025-12-31 14:45:56", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21222", "woocommerce_cleanup_logs", "complete", "2025-09-24 11:26:02", "2025-09-24 14:56:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713162;s:18:\"\0*\0first_timestamp\";i:1756133822;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-31 11:15:56", "2025-12-31 14:45:56", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21223", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-24 11:26:02", "2025-09-24 14:56:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713162;s:18:\"\0*\0first_timestamp\";i:1756133822;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-12-31 11:15:56", "2025-12-31 14:45:56", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21224", "woocommerce_geoip_updater", "complete", "2025-10-08 11:26:02", "2025-10-08 14:56:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759922762;s:18:\"\0*\0first_timestamp\";i:1756123082;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759922762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "11", "1", "2025-12-31 11:15:56", "2025-12-31 14:45:56", "61392", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21226", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-24 11:26:02", "2025-09-24 14:56:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758713162;s:18:\"\0*\0first_timestamp\";i:1756123021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758713162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2025-12-31 11:15:56", "2025-12-31 14:45:56", "61392", NULL, "20");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21396", "action_scheduler/migration_hook", "failed", "2025-09-23 11:48:48", "2025-09-23 15:18:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758628128;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758628128;}", "1", "1", "2025-09-23 11:49:49", "2025-09-23 15:19:49", "61287", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21398", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-23 14:28:04", "2025-09-23 17:58:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758637684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758637684;}", "11", "1", "2025-12-31 11:15:55", "2025-12-31 14:45:55", "61391", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21466", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 12:15:55", "2025-12-31 15:45:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767183355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767183355;}", "11", "1", "2025-12-31 12:23:13", "2025-12-31 15:53:13", "61452", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21467", "woocommerce_cleanup_sessions", "complete", "2025-12-31 23:15:55", "2026-01-01 02:45:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767222955;s:18:\"\0*\0first_timestamp\";i:1756144622;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767222955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "11", "1", "2026-01-06 15:16:55", "2026-01-06 18:46:55", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21468", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 23:15:55", "2026-01-01 02:45:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767222955;s:18:\"\0*\0first_timestamp\";i:1751507902;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767222955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2026-01-06 15:16:55", "2026-01-06 18:46:55", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21469", "woocommerce_scheduled_sales", "complete", "2026-01-01 11:15:55", "2026-01-01 14:45:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266155;s:18:\"\0*\0first_timestamp\";i:1756155600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-06 15:16:55", "2026-01-06 18:46:55", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21470", "woocommerce_cleanup_draft_orders", "complete", "2026-01-01 11:15:55", "2026-01-01 14:45:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266155;s:18:\"\0*\0first_timestamp\";i:1657982695;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-06 15:16:55", "2026-01-06 18:46:55", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21471", "wc_admin_daily_wrapper", "complete", "2026-01-01 11:15:55", "2026-01-01 14:45:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266155;s:18:\"\0*\0first_timestamp\";i:1756123022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-06 15:16:55", "2026-01-06 18:46:55", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21472", "woocommerce_cleanup_personal_data", "complete", "2026-01-01 11:15:56", "2026-01-01 14:45:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266156;s:18:\"\0*\0first_timestamp\";i:1756123032;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-06 15:16:56", "2026-01-06 18:46:56", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21473", "woocommerce_cleanup_logs", "complete", "2026-01-01 11:15:56", "2026-01-01 14:45:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266156;s:18:\"\0*\0first_timestamp\";i:1756133822;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-06 15:16:56", "2026-01-06 18:46:56", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21474", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-01 11:15:56", "2026-01-01 14:45:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266156;s:18:\"\0*\0first_timestamp\";i:1756133822;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2026-01-06 15:16:56", "2026-01-06 18:46:56", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21475", "woocommerce_geoip_updater", "pending", "2026-01-15 11:15:56", "2026-01-15 14:45:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768475756;s:18:\"\0*\0first_timestamp\";i:1756123082;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768475756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21476", "generate_category_lookup_table_wrapper", "complete", "2025-12-31 11:16:06", "2025-12-31 14:46:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179766;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179766;}", "11", "1", "2025-12-31 11:17:48", "2025-12-31 14:47:48", "61394", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21477", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-01 11:15:56", "2026-01-01 14:45:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767266156;s:18:\"\0*\0first_timestamp\";i:1756123021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767266156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "1", "2026-01-06 15:16:56", "2026-01-06 18:46:56", "61495", NULL, "20");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21479", "rocket_job_warmup", "complete", "2025-12-31 11:17:54", "2025-12-31 11:17:54", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2025-12-31 11:19:00", "2025-12-31 14:49:00", "61397", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21524", "fetch_patterns", "complete", "2025-12-31 11:19:22", "2025-12-31 14:49:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179962;}", "5", "1", "2025-12-31 11:21:41", "2025-12-31 14:51:41", "61405", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21525", "woocommerce_run_update_callback", "complete", "2025-12-31 11:19:23", "2025-12-31 14:49:23", "{\"update_callback\":\"wc_update_1030_add_comments_date_type_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179963;}", "3", "1", "2025-12-31 11:21:41", "2025-12-31 14:51:41", "61405", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21526", "woocommerce_run_update_callback", "complete", "2025-12-31 11:19:24", "2025-12-31 14:49:24", "{\"update_callback\":\"wc_update_1040_add_idx_date_paid_status_parent\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179964;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179964;}", "3", "1", "2025-12-31 11:21:41", "2025-12-31 14:51:41", "61405", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21527", "woocommerce_run_update_callback", "complete", "2025-12-31 11:19:25", "2025-12-31 14:49:25", "{\"update_callback\":\"wc_update_1040_cleanup_legacy_ptk_patterns_fetching\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179965;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179965;}", "3", "1", "2025-12-31 11:21:41", "2025-12-31 14:51:41", "61405", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21528", "woocommerce_update_db_to_current_version", "complete", "2025-12-31 11:19:26", "2025-12-31 14:49:26", "{\"version\":\"10.4.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767179966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767179966;}", "3", "1", "2025-12-31 11:21:41", "2025-12-31 14:51:41", "61405", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21579", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 13:23:13", "2025-12-31 16:53:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767187393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767187393;}", "11", "1", "2025-12-31 13:24:30", "2025-12-31 16:54:30", "61489", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21580", "woocommerce_cancel_unpaid_orders", "complete", "2025-12-31 14:24:30", "2025-12-31 17:54:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767191070;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767191070;}", "11", "1", "2026-01-06 15:16:55", "2026-01-06 18:46:55", "61495", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21587", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 16:16:55", "2026-01-06 19:46:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767716215;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767716215;}", "11", "1", "2026-01-06 16:20:44", "2026-01-06 19:50:44", "61535", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21589", "woocommerce_refresh_order_count_cache", "pending", "2026-01-07 03:16:55", "2026-01-07 06:46:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767755815;s:18:\"\0*\0first_timestamp\";i:1751507902;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767755815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21590", "woocommerce_scheduled_sales", "pending", "2026-01-07 15:16:55", "2026-01-07 18:46:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799015;s:18:\"\0*\0first_timestamp\";i:1756155600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21591", "woocommerce_cleanup_draft_orders", "pending", "2026-01-07 15:16:55", "2026-01-07 18:46:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799015;s:18:\"\0*\0first_timestamp\";i:1657982695;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21592", "wc_admin_daily_wrapper", "pending", "2026-01-07 15:16:55", "2026-01-07 18:46:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799015;s:18:\"\0*\0first_timestamp\";i:1756123022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21593", "woocommerce_cleanup_personal_data", "pending", "2026-01-07 15:16:56", "2026-01-07 18:46:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799016;s:18:\"\0*\0first_timestamp\";i:1756123032;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21594", "woocommerce_cleanup_logs", "pending", "2026-01-07 15:16:56", "2026-01-07 18:46:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799016;s:18:\"\0*\0first_timestamp\";i:1756133822;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21595", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2026-01-07 15:16:56", "2026-01-07 18:46:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799016;s:18:\"\0*\0first_timestamp\";i:1756133822;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21596", "woocommerce_cleanup_sessions", "pending", "2026-01-07 03:00:00", "2026-01-07 06:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767754800;s:18:\"\0*\0first_timestamp\";i:1767754800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767754800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21597", "generate_category_lookup_table_wrapper", "complete", "2026-01-06 15:17:06", "2026-01-06 18:47:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767712626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767712626;}", "11", "1", "2026-01-06 15:18:04", "2026-01-06 18:48:04", "61497", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21598", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-01-07 15:16:56", "2026-01-07 18:46:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767799016;s:18:\"\0*\0first_timestamp\";i:1756123021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767799016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "10", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21600", "rocket_job_warmup", "complete", "2026-01-06 15:17:54", "2026-01-06 15:17:54", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2026-01-06 15:18:07", "2026-01-06 18:48:07", "61497", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21602", "action_scheduler/migration_hook", "complete", "2026-01-06 15:19:27", "2026-01-06 18:49:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767712767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767712767;}", "1", "1", "2026-01-06 15:19:34", "2026-01-06 18:49:34", "61502", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21603", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 17:20:44", "2026-01-06 20:50:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767720044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767720044;}", "11", "1", "2026-01-06 17:21:19", "2026-01-06 20:51:19", "61565", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21604", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 18:21:19", "2026-01-06 21:51:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767723679;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767723679;}", "11", "1", "2026-01-06 18:21:37", "2026-01-06 21:51:37", "61599", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21605", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-06 19:21:37", "2026-01-06 22:51:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767727297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767727297;}", "11", "1", "2026-01-06 19:22:32", "2026-01-06 22:52:32", "61631", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21606", "woocommerce_cancel_unpaid_orders", "pending", "2026-01-06 20:22:32", "2026-01-06 23:52:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767730952;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767730952;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21607", "action_scheduler/migration_hook", "complete", "2026-01-06 19:29:50", "2026-01-06 22:59:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767727790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767727790;}", "1", "1", "2026-01-06 19:29:55", "2026-01-06 22:59:55", "61641", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21608", "action_scheduler/migration_hook", "failed", "2026-01-06 19:30:55", "2026-01-06 23:00:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767727855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767727855;}", "1", "1", "2026-01-06 19:32:27", "2026-01-06 23:02:27", "61644", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21609", "rocket_preload_job_load_initial_sitemap", "complete", "2026-01-06 19:30:03", "2026-01-06 19:30:03", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:27", "2026-01-06 23:02:27", "61644", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21610", "rocket_job_warmup", "complete", "2026-01-06 19:30:04", "2026-01-06 19:30:04", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "7", "1", "2026-01-06 19:32:27", "2026-01-06 23:02:27", "61644", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21611", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:32:27", "2026-01-06 19:32:27", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:27", "2026-01-06 23:02:27", "61645", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21612", "rocket_preload_job_check_finished", "complete", "2026-01-06 19:33:29", "2026-01-06 23:03:29", "[1767727949]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767728009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767728009;}", "4", "1", "2026-01-06 19:34:34", "2026-01-06 23:04:34", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21613", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:32:29", "2026-01-06 19:32:29", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/jmary-camera-tripod\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:38", "2026-01-06 23:02:38", "61648", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21614", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:32:29", "2026-01-06 19:32:29", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/ingersoll-women-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:41", "2026-01-06 23:02:41", "61648", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21615", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:32:29", "2026-01-06 19:32:29", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/jooti-jeans\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:44", "2026-01-06 23:02:44", "61648", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21616", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:32:29", "2026-01-06 19:32:29", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/samsung-galaxy-a42-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:47", "2026-01-06 23:02:47", "61648", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21617", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:32:29", "2026-01-06 19:32:29", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/versus-versace-men-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:32:50", "2026-01-06 23:02:50", "61648", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21618", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/samsung-galaxy-a51\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:38", "2026-01-06 23:04:38", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21619", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/apple-iphone-14-promax-512gb-mobile-phone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:41", "2026-01-06 23:04:41", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21620", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:44", "2026-01-06 23:04:44", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21621", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/samsung-galaxy-a52s-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:47", "2026-01-06 23:04:47", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21622", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/author\\/iranavada\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:50", "2026-01-06 23:04:50", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21623", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\\/apple\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:53", "2026-01-06 23:04:53", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21624", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:34:56", "2026-01-06 23:04:56", "61650", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21625", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/modern-mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:05", "2026-01-06 23:05:05", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21626", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/iphone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:08", "2026-01-06 23:05:08", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21627", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/%D8%A2%DB%8C%D9%81%D9%88%D9%86\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:11", "2026-01-06 23:05:11", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21628", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:14", "2026-01-06 23:05:14", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21629", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:17", "2026-01-06 23:05:17", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21630", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/body-structure\\/metal-and-glass-body\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:20", "2026-01-06 23:05:20", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21631", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/body-structure\\/%D9%81%D8%B1%DB%8C%D9%85-%D8%A7%D8%B2-%D8%AC%D9%86%D8%B3-%D8%A2%D9%84%D9%88%D9%85%DB%8C%D9%86%DB%8C%D9%88%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:23", "2026-01-06 23:05:23", "61651", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21632", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/blue\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:33", "2026-01-06 23:05:33", "61652", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21633", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/gray\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:36", "2026-01-06 23:05:36", "61652", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21634", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/gold\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:39", "2026-01-06 23:05:39", "61652", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21635", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/black\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:43", "2026-01-06 23:05:43", "61652", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21636", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/dimensions\\/146-7x71-5x7-4-mm\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:46", "2026-01-06 23:05:46", "61652", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21637", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/memory\\/256gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:49", "2026-01-06 23:05:49", "61652", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21638", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/memory\\/512gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:35:59", "2026-01-06 23:05:59", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21639", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/ram\\/12gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:02", "2026-01-06 23:06:02", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21640", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/ram\\/6gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:05", "2026-01-06 23:06:05", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21641", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/sim-des\\/nano-size-8-8-x-12-3-mm\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:08", "2026-01-06 23:06:08", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21642", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:33", "2026-01-06 19:34:33", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/sim-number\\/two-sim-cards\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:11", "2026-01-06 23:06:11", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21643", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/special-features\\/fingerprint-sensor\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:14", "2026-01-06 23:06:14", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21644", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/special-features\\/suitable-for-photography\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:17", "2026-01-06 23:06:17", "61653", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21645", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/special-features\\/suitable-for-selfie-photography\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:26", "2026-01-06 23:06:26", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21646", "rocket_preload_job_check_finished", "pending", "2026-01-06 19:35:34", "2026-01-06 23:05:34", "[1767728074]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767728134;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767728134;}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21647", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/weight\\/189g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:29", "2026-01-06 23:06:29", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21648", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/royal-brand-list\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:32", "2026-01-06 23:06:32", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21649", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\\/samsung-phone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:35", "2026-01-06 23:06:35", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21650", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/home-1\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:38", "2026-01-06 23:06:38", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21651", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/photography-equipment\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:41", "2026-01-06 23:06:41", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21652", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/photography-equipment\\/camera\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:44", "2026-01-06 23:06:44", "61654", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21653", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/blog\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:48", "2026-01-06 23:06:48", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21654", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/compare-products\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:51", "2026-01-06 23:06:51", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21655", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/wishlist\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:54", "2026-01-06 23:06:54", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21656", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:36:57", "2026-01-06 23:06:57", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21657", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/clothing\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:37:00", "2026-01-06 23:07:00", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21658", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/watch\\/ingersoll-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:37:03", "2026-01-06 23:07:03", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21659", "rocket_preload_job_preload_url", "complete", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/watch\\/samsung-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "1", "2026-01-06 19:37:06", "2026-01-06 23:07:06", "61655", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21660", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:34:34", "2026-01-06 19:34:34", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/photography-equipment\\/camera-tripod\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21661", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/jmary-camera-tripod\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21662", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/ingersoll-women-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21663", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/jooti-jeans\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21664", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/samsung-galaxy-a42-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21665", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/versus-versace-men-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21666", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/samsung-galaxy-a51\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21667", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/apple-iphone-14-promax-512gb-mobile-phone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21668", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21669", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product\\/samsung-galaxy-a52s-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21670", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/author\\/iranavada\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21671", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\\/apple\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21672", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/mobile-phone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21673", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-category\\/modern-mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21674", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/iphone\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21675", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/%D8%A2%DB%8C%D9%81%D9%88%D9%86\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21676", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "2026-01-06 19:36:45", "2026-01-06 23:06:45", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21677", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21678", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/body-structure\\/metal-and-glass-body\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21679", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/body-structure\\/%D9%81%D8%B1%DB%8C%D9%85-%D8%A7%D8%B2-%D8%AC%D9%86%D8%B3-%D8%A2%D9%84%D9%88%D9%85%DB%8C%D9%86%DB%8C%D9%88%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21680", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/blue\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21681", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/gray\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21682", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/gold\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21683", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/color\\/black\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21684", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/dimensions\\/146-7x71-5x7-4-mm\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21685", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/memory\\/256gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21686", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/memory\\/512gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21687", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/ram\\/12gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `qjfda_actionscheduler_actions` VALUES("21688", "rocket_preload_job_preload_url", "pending", "2026-01-06 19:36:10", "2026-01-06 19:36:10", "[\"https:\\/\\/user.iranavada.ir\\/royal104130\\/ram\\/6gb\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: qjfda_actionscheduler_claims */
INSERT INTO `qjfda_actionscheduler_claims` VALUES("44140", "2023-09-12 14:49:34");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("45055", "2023-12-20 12:56:01");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("45278", "2023-12-20 18:41:21");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("45349", "2024-02-19 18:48:25");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("57959", "2024-07-18 18:37:09");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("57978", "2024-07-19 12:24:26");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("58576", "2025-01-12 16:47:30");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("59039", "2025-01-13 18:38:32");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("59114", "2025-05-20 13:54:46");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("59225", "2025-07-15 13:41:33");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60714", "2025-08-07 12:32:36");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60721", "2025-08-07 12:43:35");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60724", "2025-08-07 12:50:30");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60727", "2025-08-07 12:57:35");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60734", "2025-08-07 13:08:06");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60785", "2025-08-07 17:31:23");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60805", "2025-08-07 19:25:10");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("60962", "2025-08-11 23:44:04");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61159", "2025-08-25 17:23:39");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61180", "2025-09-05 12:04:12");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61181", "2025-09-05 12:10:31");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61183", "2025-09-05 12:16:36");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61217", "2025-09-05 12:44:28");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61222", "2025-09-05 12:52:30");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61253", "2025-09-05 13:19:07");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61386", "2025-09-23 13:41:42");
INSERT INTO `qjfda_actionscheduler_claims` VALUES("61389", "2025-09-23 13:48:45");

/* INSERT TABLE DATA: qjfda_actionscheduler_groups */
INSERT INTO `qjfda_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("4", "rocket-preload");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("5", "");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("6", "wc_batch_processes");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("7", "rocket-atf-warmup");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("8", "wc_delete_related_product_transients_group");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("9", "count");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("10", "ActionScheduler");
INSERT INTO `qjfda_actionscheduler_groups` VALUES("11", "woocommerce");

/* INSERT TABLE DATA: qjfda_actionscheduler_logs */
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1727", "582", "ایجاد فعالیت", "2023-04-14 15:51:44", "2023-04-14 19:21:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1728", "582", "عملیات توسط WP Cron شروع شد", "2023-04-14 15:52:50", "2023-04-14 19:22:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1729", "582", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-04-14 15:52:50", "2023-04-14 19:22:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1745", "588", "ایجاد فعالیت", "2023-06-06 12:49:49", "2023-06-06 17:19:49");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1746", "588", "عملیات توسط Async Request شروع شد", "2023-06-06 12:51:12", "2023-06-06 17:21:12");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1747", "588", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-06 12:51:12", "2023-06-06 17:21:12");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1754", "591", "ایجاد فعالیت", "2023-06-07 09:54:35", "2023-06-07 14:24:35");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1755", "591", "عملیات توسط WP Cron شروع شد", "2023-06-07 09:55:36", "2023-06-07 14:25:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1756", "591", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-07 09:55:36", "2023-06-07 14:25:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1763", "594", "ایجاد فعالیت", "2023-06-07 16:05:02", "2023-06-07 20:35:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1764", "594", "عملیات توسط WP Cron شروع شد", "2023-06-08 10:52:27", "2023-06-08 15:22:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1765", "594", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-08 10:52:28", "2023-06-08 15:22:28");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1772", "597", "ایجاد فعالیت", "2023-06-08 11:59:02", "2023-06-08 16:29:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1773", "597", "عملیات توسط Async Request شروع شد", "2023-06-08 12:00:31", "2023-06-08 16:30:31");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1774", "597", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-08 12:00:31", "2023-06-08 16:30:31");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1781", "600", "ایجاد فعالیت", "2023-06-08 17:03:24", "2023-06-08 21:33:24");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1782", "600", "عملیات توسط WP Cron شروع شد", "2023-06-08 17:05:24", "2023-06-08 21:35:24");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("1783", "600", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-06-08 17:05:24", "2023-06-08 21:35:24");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("7412", "2478", "ایجاد فعالیت", "2023-11-01 10:58:47", "2023-11-01 14:28:47");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("7413", "2478", "عملیات توسط Async Request شروع شد", "2023-11-01 11:00:08", "2023-11-01 14:30:08");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("7414", "2478", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-11-01 11:00:08", "2023-11-01 14:30:08");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("7739", "2587", "ایجاد فعالیت", "2023-11-02 12:18:27", "2023-11-02 15:48:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("7740", "2587", "عملیات توسط WP Cron شروع شد", "2023-11-02 12:20:30", "2023-11-02 15:50:30");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("7741", "2587", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-11-02 12:20:30", "2023-11-02 15:50:30");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("9077", "3033", "ایجاد فعالیت", "2023-12-09 15:42:27", "2023-12-09 19:12:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("9078", "3033", "عملیات توسط WP Cron شروع شد", "2023-12-09 15:43:46", "2023-12-09 19:13:46");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("9079", "3033", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-12-09 15:43:46", "2023-12-09 19:13:46");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("10746", "3620", "ایجاد فعالیت", "2023-12-20 12:54:37", "2023-12-20 16:24:37");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("10912", "3620", "عملیات توسط WP Cron شروع شد", "2023-12-20 15:31:19", "2023-12-20 19:01:19");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("10913", "3620", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-12-20 15:31:19", "2023-12-20 19:01:19");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("24415", "8124", "ایجاد فعالیت", "2024-04-30 12:30:24", "2024-04-30 16:00:24");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("24416", "8124", "عملیات توسط WP Cron شروع شد", "2024-04-30 12:31:54", "2024-04-30 16:01:54");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("24417", "8124", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-04-30 12:31:54", "2024-04-30 16:01:54");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("24427", "8128", "ایجاد فعالیت", "2024-05-01 10:00:39", "2024-05-01 13:30:39");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("24428", "8128", "عملیات توسط WP Cron شروع شد", "2024-05-01 10:01:59", "2024-05-01 13:31:59");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("24429", "8128", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-01 10:01:59", "2024-05-01 13:31:59");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52966", "17643", "ایجاد فعالیت", "2025-01-13 18:35:39", "2025-01-13 22:05:39");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52967", "17644", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52968", "17645", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52969", "17646", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52970", "17647", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52971", "17648", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52972", "17649", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52973", "17650", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52974", "17651", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52975", "17652", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("52976", "17653", "ایجاد فعالیت", "2025-01-13 18:35:42", "2025-01-13 22:05:42");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53082", "17643", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53083", "17644", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53084", "17645", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53085", "17646", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53086", "17647", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53087", "17648", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53088", "17649", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53089", "17650", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53090", "17651", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53091", "17652", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53092", "17653", "عمل مجدد تنظیم شد", "2025-03-18 10:06:36", "2025-03-18 13:36:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53113", "17643", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53114", "17643", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53115", "17644", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53116", "17644", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53117", "17645", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53118", "17645", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53119", "17646", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53120", "17646", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53121", "17647", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53122", "17647", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53123", "17648", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53124", "17648", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53125", "17649", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53126", "17649", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53127", "17650", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53128", "17650", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53129", "17651", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53130", "17651", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53131", "17652", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53132", "17652", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53133", "17653", "عملیات توسط WP Cron شروع شد", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53134", "17653", "اقدام از طریق WP Cron انجام نشد: اقدام زمانبندی‌ شده برای rocket_job_warmup_url اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:08:06", "2025-03-18 13:38:06");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53271", "17714", "ایجاد فعالیت", "2025-03-18 10:37:28", "2025-03-18 14:07:28");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53310", "17714", "عملیات توسط Async Request شروع شد", "2025-03-18 10:38:38", "2025-03-18 14:08:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("53311", "17714", "اقدام از طریق Async Request انجام نشد: اقدام زمانبندی‌ شده برای action_scheduler/migration_hook اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-03-18 10:38:38", "2025-03-18 14:08:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("56737", "18854", "عملیات ایجاد شد", "2025-08-04 20:45:28", "2025-08-05 00:15:28");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("56738", "18854", "عملیات با Async Request شروع شد", "2025-08-04 20:46:29", "2025-08-05 00:16:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("56739", "18854", "عملکرد از طریقAsync Request انجام نشد:اقدام زمانبندی‌ شده برای action_scheduler/migration_hook اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-08-04 20:46:29", "2025-08-05 00:16:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("60754", "20187", "عملیات ایجاد شد", "2025-08-11 15:32:28", "2025-08-11 19:02:28");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("60855", "20187", "عملیات با WP Cron شروع شد", "2025-08-11 15:33:50", "2025-08-11 19:03:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("60856", "20187", "عملکرد از طریقWP Cron انجام نشد:اقدام زمانبندی‌ شده برای rocket_job_warmup اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-08-11 15:33:50", "2025-08-11 19:03:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("61276", "20355", "عملیات ایجاد شد", "2025-08-12 00:00:49", "2025-08-12 03:30:49");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("61366", "20355", "عملیات با WP Cron شروع شد", "2025-08-25 11:23:00", "2025-08-25 14:53:00");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("61367", "20355", "عملکرد از طریقWP Cron انجام نشد:اقدام زمانبندی‌ شده برای action_scheduler/migration_hook اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-08-25 11:23:00", "2025-08-25 14:53:00");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64077", "21216", "عملیات ایجاد شد", "2025-09-23 11:26:01", "2025-09-23 14:56:01");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64080", "21217", "عملیات ایجاد شد", "2025-09-23 11:26:01", "2025-09-23 14:56:01");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64083", "21218", "عملیات ایجاد شد", "2025-09-23 11:26:01", "2025-09-23 14:56:01");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64086", "21219", "عملیات ایجاد شد", "2025-09-23 11:26:01", "2025-09-23 14:56:01");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64089", "21220", "عملیات ایجاد شد", "2025-09-23 11:26:01", "2025-09-23 14:56:01");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64092", "21221", "عملیات ایجاد شد", "2025-09-23 11:26:02", "2025-09-23 14:56:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64095", "21222", "عملیات ایجاد شد", "2025-09-23 11:26:02", "2025-09-23 14:56:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64098", "21223", "عملیات ایجاد شد", "2025-09-23 11:26:02", "2025-09-23 14:56:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64101", "21224", "عملیات ایجاد شد", "2025-09-23 11:26:02", "2025-09-23 14:56:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64105", "21226", "عملیات ایجاد شد", "2025-09-23 11:26:02", "2025-09-23 14:56:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64615", "21396", "عملیات ایجاد شد", "2025-09-23 11:47:48", "2025-09-23 15:17:48");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64616", "21396", "عملیات با WP Cron شروع شد", "2025-09-23 11:49:49", "2025-09-23 15:19:49");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64617", "21396", "عملکرد از طریقWP Cron انجام نشد:اقدام زمانبندی‌ شده برای action_scheduler/migration_hook اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2025-09-23 11:49:49", "2025-09-23 15:19:49");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64622", "21398", "عملیات ایجاد شد", "2025-09-23 13:28:04", "2025-09-23 16:58:04");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64865", "21398", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64866", "21466", "عملیات ایجاد شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64867", "21398", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64868", "21216", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64869", "21216", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64870", "21467", "عملیات ایجاد شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64871", "21217", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64872", "21217", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64873", "21468", "عملیات ایجاد شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64874", "21218", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64875", "21218", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64876", "21469", "عملیات ایجاد شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64877", "21219", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64878", "21219", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64879", "21470", "عملیات ایجاد شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64880", "21220", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64881", "21220", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64882", "21471", "عملیات ایجاد شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64883", "21221", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:55", "2025-12-31 14:45:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64884", "21221", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64885", "21472", "عملیات ایجاد شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64886", "21222", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64887", "21222", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64888", "21473", "عملیات ایجاد شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64889", "21223", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64890", "21223", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64891", "21474", "عملیات ایجاد شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64892", "21224", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64893", "21224", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64894", "21475", "عملیات ایجاد شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64895", "21226", "عملیات با WP Cron شروع شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64896", "21476", "عملیات ایجاد شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64897", "21226", "عملیات با WP Cron تکمیل شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64898", "21477", "عملیات ایجاد شد", "2025-12-31 11:15:56", "2025-12-31 14:45:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64900", "21476", "عملیات با Async Request شروع شد", "2025-12-31 11:17:48", "2025-12-31 14:47:48");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64901", "21476", "عملیات با Async Request تکمیل شد", "2025-12-31 11:17:48", "2025-12-31 14:47:48");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64904", "21479", "عملیات ایجاد شد", "2025-12-31 11:17:54", "2025-12-31 14:47:54");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64905", "21479", "عملیات با Async Request شروع شد", "2025-12-31 11:19:00", "2025-12-31 14:49:00");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64906", "21479", "عملیات با Async Request تکمیل شد", "2025-12-31 11:19:00", "2025-12-31 14:49:00");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64968", "21524", "عملیات ایجاد شد", "2025-12-31 11:19:22", "2025-12-31 14:49:22");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64971", "21525", "عملیات ایجاد شد", "2025-12-31 11:19:23", "2025-12-31 14:49:23");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64972", "21526", "عملیات ایجاد شد", "2025-12-31 11:19:23", "2025-12-31 14:49:23");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64973", "21527", "عملیات ایجاد شد", "2025-12-31 11:19:23", "2025-12-31 14:49:23");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("64974", "21528", "عملیات ایجاد شد", "2025-12-31 11:19:23", "2025-12-31 14:49:23");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65056", "21524", "عملیات با Async Request شروع شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65057", "21524", "عملیات با Async Request تکمیل شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65058", "21525", "عملیات با Async Request شروع شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65059", "21525", "عملیات با Async Request تکمیل شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65060", "21526", "عملیات با Async Request شروع شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65061", "21526", "عملیات با Async Request تکمیل شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65062", "21527", "عملیات با Async Request شروع شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65063", "21527", "عملیات با Async Request تکمیل شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65064", "21528", "عملیات با Async Request شروع شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65065", "21528", "عملیات با Async Request تکمیل شد", "2025-12-31 11:21:41", "2025-12-31 14:51:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65204", "21466", "عملیات با WP Cron شروع شد", "2025-12-31 12:23:13", "2025-12-31 15:53:13");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65205", "21579", "عملیات ایجاد شد", "2025-12-31 12:23:13", "2025-12-31 15:53:13");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65206", "21466", "عملیات با WP Cron تکمیل شد", "2025-12-31 12:23:13", "2025-12-31 15:53:13");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65207", "21579", "عملیات با Async Request شروع شد", "2025-12-31 13:24:30", "2025-12-31 16:54:30");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65208", "21580", "عملیات ایجاد شد", "2025-12-31 13:24:30", "2025-12-31 16:54:30");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65209", "21579", "عملیات با Async Request تکمیل شد", "2025-12-31 13:24:30", "2025-12-31 16:54:30");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65228", "21580", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65229", "21587", "عملیات ایجاد شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65230", "21580", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65231", "21467", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65232", "21467", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65234", "21468", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65235", "21468", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65236", "21589", "عملیات ایجاد شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65237", "21469", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65238", "21469", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65239", "21590", "عملیات ایجاد شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65240", "21470", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65241", "21470", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65242", "21591", "عملیات ایجاد شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65243", "21471", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65244", "21471", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65245", "21592", "عملیات ایجاد شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65246", "21472", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:55", "2026-01-06 18:46:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65247", "21472", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65248", "21593", "عملیات ایجاد شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65249", "21473", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65250", "21473", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65251", "21594", "عملیات ایجاد شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65252", "21474", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65253", "21474", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65254", "21595", "عملیات ایجاد شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65255", "21477", "عملیات با WP Cron شروع شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65257", "21596", "عملیات ایجاد شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65258", "21597", "عملیات ایجاد شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65259", "21477", "عملیات با WP Cron تکمیل شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65260", "21598", "عملیات ایجاد شد", "2026-01-06 15:16:56", "2026-01-06 18:46:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65262", "21600", "عملیات ایجاد شد", "2026-01-06 15:17:54", "2026-01-06 18:47:54");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65263", "21597", "عملیات با Async Request شروع شد", "2026-01-06 15:18:04", "2026-01-06 18:48:04");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65264", "21597", "عملیات با Async Request تکمیل شد", "2026-01-06 15:18:04", "2026-01-06 18:48:04");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65268", "21600", "عملیات با Async Request شروع شد", "2026-01-06 15:18:07", "2026-01-06 18:48:07");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65269", "21600", "عملیات با Async Request تکمیل شد", "2026-01-06 15:18:07", "2026-01-06 18:48:07");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65272", "21602", "عملیات ایجاد شد", "2026-01-06 15:18:27", "2026-01-06 18:48:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65273", "21602", "عملیات با Async Request شروع شد", "2026-01-06 15:19:34", "2026-01-06 18:49:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65274", "21602", "عملیات با Async Request تکمیل شد", "2026-01-06 15:19:34", "2026-01-06 18:49:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65275", "21587", "عملیات با WP Cron شروع شد", "2026-01-06 16:20:44", "2026-01-06 19:50:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65276", "21603", "عملیات ایجاد شد", "2026-01-06 16:20:44", "2026-01-06 19:50:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65277", "21587", "عملیات با WP Cron تکمیل شد", "2026-01-06 16:20:44", "2026-01-06 19:50:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65278", "21603", "عملیات با Async Request شروع شد", "2026-01-06 17:21:19", "2026-01-06 20:51:19");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65279", "21604", "عملیات ایجاد شد", "2026-01-06 17:21:19", "2026-01-06 20:51:19");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65280", "21603", "عملیات با Async Request تکمیل شد", "2026-01-06 17:21:19", "2026-01-06 20:51:19");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65281", "21604", "عملیات با Async Request شروع شد", "2026-01-06 18:21:37", "2026-01-06 21:51:37");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65282", "21605", "عملیات ایجاد شد", "2026-01-06 18:21:37", "2026-01-06 21:51:37");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65283", "21604", "عملیات با Async Request تکمیل شد", "2026-01-06 18:21:37", "2026-01-06 21:51:37");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65284", "21605", "عملیات با Async Request شروع شد", "2026-01-06 19:22:32", "2026-01-06 22:52:32");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65285", "21606", "عملیات ایجاد شد", "2026-01-06 19:22:32", "2026-01-06 22:52:32");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65286", "21605", "عملیات با Async Request تکمیل شد", "2026-01-06 19:22:32", "2026-01-06 22:52:32");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65287", "21607", "عملیات ایجاد شد", "2026-01-06 19:28:50", "2026-01-06 22:58:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65288", "21607", "عملیات با Async Request شروع شد", "2026-01-06 19:29:55", "2026-01-06 22:59:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65289", "21607", "عملیات با Async Request تکمیل شد", "2026-01-06 19:29:55", "2026-01-06 22:59:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65290", "21608", "عملیات ایجاد شد", "2026-01-06 19:29:55", "2026-01-06 22:59:55");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65291", "21609", "عملیات ایجاد شد", "2026-01-06 19:30:03", "2026-01-06 23:00:03");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65292", "21610", "عملیات ایجاد شد", "2026-01-06 19:30:04", "2026-01-06 23:00:04");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65293", "21609", "عملیات با Async Request شروع شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65294", "21611", "عملیات ایجاد شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65295", "21609", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65296", "21610", "عملیات با Async Request شروع شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65297", "21610", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65298", "21608", "عملیات با Async Request شروع شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65299", "21608", "عملکرد از طریقAsync Request انجام نشد:اقدام زمانبندی‌ شده برای action_scheduler/migration_hook اجرا نمیشود، زیرا هیچ callbacks ثبت نشده است.", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65300", "21611", "عملیات با Async Request شروع شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65301", "21611", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:27", "2026-01-06 23:02:27");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65302", "21612", "عملیات ایجاد شد", "2026-01-06 19:32:29", "2026-01-06 23:02:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65303", "21613", "عملیات ایجاد شد", "2026-01-06 19:32:29", "2026-01-06 23:02:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65304", "21614", "عملیات ایجاد شد", "2026-01-06 19:32:29", "2026-01-06 23:02:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65305", "21615", "عملیات ایجاد شد", "2026-01-06 19:32:29", "2026-01-06 23:02:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65306", "21616", "عملیات ایجاد شد", "2026-01-06 19:32:29", "2026-01-06 23:02:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65307", "21617", "عملیات ایجاد شد", "2026-01-06 19:32:29", "2026-01-06 23:02:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65308", "21613", "عملیات با Async Request شروع شد", "2026-01-06 19:32:34", "2026-01-06 23:02:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65309", "21613", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:38", "2026-01-06 23:02:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65310", "21614", "عملیات با Async Request شروع شد", "2026-01-06 19:32:38", "2026-01-06 23:02:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65311", "21614", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:41", "2026-01-06 23:02:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65312", "21615", "عملیات با Async Request شروع شد", "2026-01-06 19:32:41", "2026-01-06 23:02:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65313", "21615", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:44", "2026-01-06 23:02:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65314", "21616", "عملیات با Async Request شروع شد", "2026-01-06 19:32:44", "2026-01-06 23:02:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65315", "21616", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:47", "2026-01-06 23:02:47");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65316", "21617", "عملیات با Async Request شروع شد", "2026-01-06 19:32:47", "2026-01-06 23:02:47");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65317", "21617", "عملیات با Async Request تکمیل شد", "2026-01-06 19:32:50", "2026-01-06 23:02:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65318", "21618", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65319", "21619", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65320", "21620", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65321", "21621", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65322", "21622", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65323", "21623", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65324", "21624", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65325", "21625", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65326", "21626", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65327", "21627", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65328", "21628", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65329", "21629", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65330", "21630", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65331", "21631", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65332", "21632", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65333", "21633", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65334", "21634", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65335", "21635", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65336", "21636", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65337", "21637", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65338", "21638", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65339", "21639", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65340", "21640", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65341", "21641", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65342", "21642", "عملیات ایجاد شد", "2026-01-06 19:34:33", "2026-01-06 23:04:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65343", "21643", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65344", "21644", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65345", "21612", "عملیات با Async Request شروع شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65346", "21645", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65347", "21646", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65348", "21612", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65349", "21618", "عملیات با Async Request شروع شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65350", "21647", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65351", "21648", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65352", "21649", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65353", "21650", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65354", "21651", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65355", "21652", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65356", "21653", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65357", "21654", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65358", "21655", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65359", "21656", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65360", "21657", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65361", "21658", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65362", "21659", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65363", "21660", "عملیات ایجاد شد", "2026-01-06 19:34:34", "2026-01-06 23:04:34");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65364", "21618", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:38", "2026-01-06 23:04:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65365", "21619", "عملیات با Async Request شروع شد", "2026-01-06 19:34:38", "2026-01-06 23:04:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65366", "21619", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:41", "2026-01-06 23:04:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65367", "21620", "عملیات با Async Request شروع شد", "2026-01-06 19:34:41", "2026-01-06 23:04:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65368", "21620", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:44", "2026-01-06 23:04:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65369", "21621", "عملیات با Async Request شروع شد", "2026-01-06 19:34:44", "2026-01-06 23:04:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65370", "21621", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:47", "2026-01-06 23:04:47");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65371", "21622", "عملیات با Async Request شروع شد", "2026-01-06 19:34:47", "2026-01-06 23:04:47");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65372", "21622", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:50", "2026-01-06 23:04:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65373", "21623", "عملیات با Async Request شروع شد", "2026-01-06 19:34:50", "2026-01-06 23:04:50");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65374", "21623", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:53", "2026-01-06 23:04:53");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65375", "21624", "عملیات با Async Request شروع شد", "2026-01-06 19:34:53", "2026-01-06 23:04:53");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65376", "21624", "عملیات با Async Request تکمیل شد", "2026-01-06 19:34:56", "2026-01-06 23:04:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65377", "21625", "عملیات با Async Request شروع شد", "2026-01-06 19:35:02", "2026-01-06 23:05:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65378", "21625", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:05", "2026-01-06 23:05:05");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65379", "21626", "عملیات با Async Request شروع شد", "2026-01-06 19:35:05", "2026-01-06 23:05:05");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65380", "21626", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:08", "2026-01-06 23:05:08");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65381", "21627", "عملیات با Async Request شروع شد", "2026-01-06 19:35:08", "2026-01-06 23:05:08");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65382", "21627", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:11", "2026-01-06 23:05:11");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65383", "21628", "عملیات با Async Request شروع شد", "2026-01-06 19:35:11", "2026-01-06 23:05:11");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65384", "21628", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:14", "2026-01-06 23:05:14");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65385", "21629", "عملیات با Async Request شروع شد", "2026-01-06 19:35:14", "2026-01-06 23:05:14");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65386", "21629", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:17", "2026-01-06 23:05:17");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65387", "21630", "عملیات با Async Request شروع شد", "2026-01-06 19:35:17", "2026-01-06 23:05:17");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65388", "21630", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:20", "2026-01-06 23:05:20");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65389", "21631", "عملیات با Async Request شروع شد", "2026-01-06 19:35:20", "2026-01-06 23:05:20");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65390", "21631", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:23", "2026-01-06 23:05:23");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65391", "21632", "عملیات با Async Request شروع شد", "2026-01-06 19:35:30", "2026-01-06 23:05:30");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65392", "21632", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:33", "2026-01-06 23:05:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65393", "21633", "عملیات با Async Request شروع شد", "2026-01-06 19:35:33", "2026-01-06 23:05:33");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65394", "21633", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:36", "2026-01-06 23:05:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65395", "21634", "عملیات با Async Request شروع شد", "2026-01-06 19:35:36", "2026-01-06 23:05:36");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65396", "21634", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:39", "2026-01-06 23:05:39");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65397", "21635", "عملیات با Async Request شروع شد", "2026-01-06 19:35:39", "2026-01-06 23:05:39");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65398", "21635", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:43", "2026-01-06 23:05:43");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65399", "21636", "عملیات با Async Request شروع شد", "2026-01-06 19:35:43", "2026-01-06 23:05:43");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65400", "21636", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:46", "2026-01-06 23:05:46");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65401", "21637", "عملیات با Async Request شروع شد", "2026-01-06 19:35:46", "2026-01-06 23:05:46");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65402", "21637", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:49", "2026-01-06 23:05:49");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65403", "21638", "عملیات با Async Request شروع شد", "2026-01-06 19:35:56", "2026-01-06 23:05:56");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65404", "21638", "عملیات با Async Request تکمیل شد", "2026-01-06 19:35:59", "2026-01-06 23:05:59");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65405", "21639", "عملیات با Async Request شروع شد", "2026-01-06 19:35:59", "2026-01-06 23:05:59");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65406", "21639", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:02", "2026-01-06 23:06:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65407", "21640", "عملیات با Async Request شروع شد", "2026-01-06 19:36:02", "2026-01-06 23:06:02");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65408", "21640", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:05", "2026-01-06 23:06:05");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65409", "21641", "عملیات با Async Request شروع شد", "2026-01-06 19:36:05", "2026-01-06 23:06:05");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65410", "21641", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:08", "2026-01-06 23:06:08");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65411", "21642", "عملیات با Async Request شروع شد", "2026-01-06 19:36:08", "2026-01-06 23:06:08");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65412", "21661", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65413", "21662", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65414", "21663", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65415", "21664", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65416", "21665", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65417", "21666", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65418", "21667", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65419", "21668", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65420", "21669", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65421", "21670", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65422", "21671", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65423", "21672", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65424", "21673", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65425", "21674", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65426", "21675", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65427", "21676", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65428", "21677", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65429", "21678", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65430", "21679", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65431", "21680", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65432", "21681", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65433", "21682", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65434", "21683", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65435", "21684", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65436", "21685", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65437", "21686", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65438", "21687", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65439", "21688", "عملیات ایجاد شد", "2026-01-06 19:36:10", "2026-01-06 23:06:10");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65440", "21642", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:11", "2026-01-06 23:06:11");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65441", "21643", "عملیات با Async Request شروع شد", "2026-01-06 19:36:11", "2026-01-06 23:06:11");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65442", "21643", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:14", "2026-01-06 23:06:14");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65443", "21644", "عملیات با Async Request شروع شد", "2026-01-06 19:36:14", "2026-01-06 23:06:14");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65444", "21644", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:17", "2026-01-06 23:06:17");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65445", "21645", "عملیات با Async Request شروع شد", "2026-01-06 19:36:23", "2026-01-06 23:06:23");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65446", "21645", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:26", "2026-01-06 23:06:26");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65447", "21647", "عملیات با Async Request شروع شد", "2026-01-06 19:36:26", "2026-01-06 23:06:26");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65448", "21647", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:29", "2026-01-06 23:06:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65449", "21648", "عملیات با Async Request شروع شد", "2026-01-06 19:36:29", "2026-01-06 23:06:29");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65450", "21648", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:32", "2026-01-06 23:06:32");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65451", "21649", "عملیات با Async Request شروع شد", "2026-01-06 19:36:32", "2026-01-06 23:06:32");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65452", "21649", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:35", "2026-01-06 23:06:35");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65453", "21650", "عملیات با Async Request شروع شد", "2026-01-06 19:36:35", "2026-01-06 23:06:35");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65454", "21650", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:38", "2026-01-06 23:06:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65455", "21651", "عملیات با Async Request شروع شد", "2026-01-06 19:36:38", "2026-01-06 23:06:38");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65456", "21651", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:41", "2026-01-06 23:06:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65457", "21652", "عملیات با Async Request شروع شد", "2026-01-06 19:36:41", "2026-01-06 23:06:41");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65458", "21652", "عملیات با Async Request تکمیل شد", "2026-01-06 19:36:44", "2026-01-06 23:06:44");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65459", "21653", "عملیات با WP Cron شروع شد", "2026-01-06 19:36:45", "2026-01-06 23:06:45");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65460", "21653", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:36:48", "2026-01-06 23:06:48");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65461", "21654", "عملیات با WP Cron شروع شد", "2026-01-06 19:36:48", "2026-01-06 23:06:48");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65462", "21654", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:36:51", "2026-01-06 23:06:51");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65463", "21655", "عملیات با WP Cron شروع شد", "2026-01-06 19:36:51", "2026-01-06 23:06:51");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65464", "21655", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:36:54", "2026-01-06 23:06:54");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65465", "21656", "عملیات با WP Cron شروع شد", "2026-01-06 19:36:54", "2026-01-06 23:06:54");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65466", "21656", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:36:57", "2026-01-06 23:06:57");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65467", "21657", "عملیات با WP Cron شروع شد", "2026-01-06 19:36:57", "2026-01-06 23:06:57");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65468", "21657", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:37:00", "2026-01-06 23:07:00");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65469", "21658", "عملیات با WP Cron شروع شد", "2026-01-06 19:37:00", "2026-01-06 23:07:00");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65470", "21658", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:37:03", "2026-01-06 23:07:03");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65471", "21659", "عملیات با WP Cron شروع شد", "2026-01-06 19:37:03", "2026-01-06 23:07:03");
INSERT INTO `qjfda_actionscheduler_logs` VALUES("65472", "21659", "عملیات با WP Cron تکمیل شد", "2026-01-06 19:37:06", "2026-01-06 23:07:06");

/* INSERT TABLE DATA: qjfda_aiowps_audit_log */
INSERT INTO `qjfda_aiowps_audit_log` VALUES("623", "1", "1", "", "88.135.68.100", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"10.2.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:21:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:194;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:84:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:237;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:93:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:93:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:676;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:56:\"/home/iranava6/user.iranavada.ir/royal104130/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179761", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("624", "1", "1", "", "88.135.68.100", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.8.2\",\"new_version\":\"6.9\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:145;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:78:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/update-core.php\";s:4:\"line\";i:1603;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:86:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:178;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:93:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:93:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:715;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:56:\"/home/iranava6/user.iranavada.ir/royal104130/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179780", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("625", "1", "1", "", "88.135.68.100", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"10.2.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:95:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:95:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:93:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:93:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:56:\"/home/iranava6/user.iranavada.ir/royal104130/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179783", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("626", "1", "1", "iravada", "178.131.150.51", "info", "successful_login", "{\"successful_login\":{\"username\":\"iravada\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:134:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:134:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:57:\"/home/iranava6/user.iranavada.ir/royal104130/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179792", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("627", "1", "1", "iravada", "178.131.150.51", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WP Rocket\",\"version\":\"3.16.2.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179874", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("628", "1", "1", "iravada", "178.131.150.51", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All-In-One Security (AIOS)\",\"version\":\"5.4.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179934", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("629", "1", "1", "iravada", "178.131.150.51", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"all-in-one-wp-security-and-firewall\",\"version\":\"5.4.4\"}}", "a:18:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:95:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:95:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179938", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("630", "1", "1", "iravada", "178.131.150.51", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u062d\\u0645\\u0644 \\u0648 \\u0646\\u0642\\u0644 \\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"4.3.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179944", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("631", "1", "1", "iravada", "178.131.150.51", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0641\\u06cc\\u0644\\u062f\\u0647\\u0627\\u06cc \\u062a\\u0633\\u0648\\u06cc\\u0647\\u200c\\u062d\\u0633\\u0627\\u0628 \\u0627\\u0646\\u0639\\u0637\\u0627\\u0641\\u200c\\u067e\\u0630\\u06cc\\u0631\",\"version\":\"4.1.31\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179951", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("632", "1", "1", "iravada", "178.131.150.51", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"10.4.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179962", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("633", "1", "1", "iravada", "178.131.150.51", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"10.4.3\"}}", "a:18:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:95:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:95:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:343;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179965", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("634", "1", "1", "iravada", "178.131.150.51", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633 \\u0641\\u0627\\u0631\\u0633\\u06cc\",\"version\":\"9.3.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767179971", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("635", "1", "1", "iravada", "178.131.168.170", "info", "successful_login", "{\"successful_login\":{\"username\":\"iravada\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:134:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:134:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:57:\"/home/iranava6/user.iranavada.ir/royal104130/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767712641", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("636", "1", "1", "iravada", "178.131.168.170", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WP Rocket\",\"version\":\"3.16.2.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767712674", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("637", "1", "1", "iravada", "178.131.168.170", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"WP Rocket\",\"version\":\"3.16.2.1\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767712706", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("638", "1", "1", "iravada", "178.131.24.171", "info", "successful_login", "{\"successful_login\":{\"username\":\"iravada\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:134:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:134:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:110:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/woocommerce/includes/class-wc-form-handler.php\";s:4:\"line\";i:1033;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:13:\"process_login\";s:5:\"class\";s:15:\"WC_Form_Handler\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:60:\"/home/iranava6/user.iranavada.ir/royal104130/wp-settings.php\";s:4:\"line\";i:764;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:58:\"/home/iranava6/user.iranavada.ir/royal104130/wp-config.php\";s:4:\"line\";i:84;s:4:\"args\";a:1:{i:0;s:60:\"/home/iranava6/user.iranavada.ir/royal104130/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:56:\"/home/iranava6/user.iranavada.ir/royal104130/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:58:\"/home/iranava6/user.iranavada.ir/royal104130/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:63:\"/home/iranava6/user.iranavada.ir/royal104130/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:56:\"/home/iranava6/user.iranavada.ir/royal104130/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:54:\"/home/iranava6/user.iranavada.ir/royal104130/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:63:\"/home/iranava6/user.iranavada.ir/royal104130/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1767725748", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("639", "1", "1", "iravada", "178.131.24.171", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Transients Manager\",\"version\":\"2.0.7\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:84:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:987;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4497;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767726382", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("640", "1", "1", "iravada", "178.131.24.171", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Transients Manager\",\"version\":\"2.0.7\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767726389", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("641", "1", "1", "iravada", "178.131.24.171", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"Transients Manager\",\"version\":\"2.0.7\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767727728", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("642", "1", "1", "iravada", "178.131.24.171", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"Transients Manager\",\"version\":\"2.0.7\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4774;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767727738", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("643", "1", "1", "iravada", "178.131.24.171", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0622\\u0648\\u0627\\u062f\\u0627 \\u0647\\u0633\\u062a\\u0647 \\u0645\\u0631\\u06a9\\u0632\\u06cc\",\"version\":\"5.14.2.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:88:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:419;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:79:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4653;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:68:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767727769", "");
INSERT INTO `qjfda_aiowps_audit_log` VALUES("644", "1", "1", "iravada", "178.131.24.171", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WP Rocket\",\"version\":\"3.16.2.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:136:\"/home/iranava6/user.iranavada.ir/royal104130/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:341;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:74:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/class-wp-hook.php\";s:4:\"line\";i:365;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/iranava6/user.iranavada.ir/royal104130/wp-includes/plugin.php\";s:4:\"line\";i:522;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:73:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:65:\"/home/iranava6/user.iranavada.ir/royal104130/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1767727804", "");

/* INSERT TABLE DATA: qjfda_aiowps_logged_in_users */
INSERT INTO `qjfda_aiowps_logged_in_users` VALUES("31", "1", "iravada", "178.131.24.171", "1", "1767712641", "1767898548");

/* INSERT TABLE DATA: qjfda_asp_index */
INSERT INTO `qjfda_asp_index` VALUES("6", "پروشاپ", "پاشورپ", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("6", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("6", "فروشگاه", "هاگشورف", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("6", "فروشگاه پروشاپ رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "-100px", "xp001-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "-90px", "xp09-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ":", ":", "1", "101", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-body", "ydob-noisuf.", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-column-3{width:100%", "%001:htdiw{3-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-column-4{width:100%", "%001:htdiw{4-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-column-4{width:66.666666666667%", "%766666666666.66:htdiw{4-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-column-5{width:100%", "%001:htdiw{5-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-column-5{width:33.333333333333%", "%333333333333.33:htdiw{5-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-nested-column-2{width:100%", "%001:htdiw{2-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-builder-nested-column-3{width:100%", "%001:htdiw{3-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button-icon-divider", "redivid-noci-nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button-icon-divider{border-color:#ffffff", "ffffff#:roloc-redrob{redivid-noci-nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button-text", "txet-nottub-noisuf.", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-3", "3-nottub.nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-3:active", "evitca:3-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-3:active{border-color:#ffffff", "ffffff#:roloc-redrob{evitca:3-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-3:active{color:#ffffff", "ffffff#:roloc{evitca:3-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-3:focus", "sucof:3-nottub.nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-3:hover", "revoh:3-nottub.nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-button.button-4", "4-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-flex-container.fusion-builder-row-3{", "{3-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-flex-container.fusion-builder-row-4{", "{4-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-woo-cart_table-2", "2-elbat_trac-oow-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ".fusion-woo-cart_table-2{margin-bottom:40px", "xp04:mottob-nigram{2-elbat_trac-oow-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "(max-width:750px)", ")xp057:htdiw-xam(", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-body", "ydob-noisuf.{", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-5{margin-top:5px", "xp5:pot-nigram{5-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-6{margin-top:0px", "xp0:pot-nigram{6-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-6{margin-top:5px", "xp5:pot-nigram{6-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-7{margin-top:0px", "xp0:pot-nigram{7-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-7{margin-top:5px", "xp5:pot-nigram{7-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-8{margin-top:0px", "xp0:pot-nigram{8-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{.fusion-title.fusion-title-8{margin-top:5px", "xp5:pot-nigram{8-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{border-color:#ffffff", "ffffff#:roloc-redrob{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{border-radius:0px", "xp0:suidar-redrob{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{color:#ffffff", "ffffff#:roloc{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{margin-right", "thgir-nigram{", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "{padding-top", "pot-gniddap{", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}", "}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-builder-column-3", "3-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-builder-column-4", "4-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-builder-column-5", "5-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-builder-nested-column-2", "2-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-builder-nested-column-3", "3-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-button.button-3", "3-nottub.nottub-noisuf.}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-button.button-3:hover", "revoh:3-nottub.nottub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-button.button-3:hover,.button-3:focus,.fusion-button.button-3:active{background:", ":dnuorgkcab{evitca:3-nottub.nottub-noisuf.,sucof:3-nottub.,revoh:3-nottub.nottub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-button.button-3{background:", ":dnuorgkcab{3-nottub.nottub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-woo-cart_table-2", "2-elbat_trac-oow-noisuf.}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}.fusion-woo-cart_table-2.shop_table", "elbat_pohs.2-elbat_trac-oow-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}}", "}}", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}}@media", "aidem@}}", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "}@media", "aidem@}", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "@media", "aidem@", "1", "36", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "#269984", "489962#", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "#d0b57e", "e75b0d#", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", ">", ">", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "0", "0", "1", "17", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "0.98%", "%89.0", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "098", "890", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "0px", "xp0", "1", "22", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "100px", "xp001", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "10vw", "wv01", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "2", "2", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "2.5vw", "wv5.2", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "20px", "xp02", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "25px", "xp52", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "25vw", "wv52", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "3", "3", "1", "23", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "3:active", "evitca:3", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "3:focus", "sucof:3", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "3:hover", "revoh:3", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "3.5vw", "wv5.3", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "30", "03", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "30px", "xp03", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "333333333333", "333333333333", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "35px", "xp53", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "35vw", "wv53", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "3vw", "wv3", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "4", "4", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "4%", "%4", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "5", "5", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "50px", "xp05", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "5vw", "wv5", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "6", "6", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "65px", "xp56", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "666666666667", "766666666666", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "7", "7", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "8", "8", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "85px", "xp58", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "8vw", "wv8", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "90px", "xp09", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "98", "89", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "and", "dna", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "background:", ":dnuorgkcab", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "body", "ydob", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "border", "redrob", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "border-radius:0px", "xp0:suidar-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bordercolor:#ffffff", "ffffff#:rolocredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "borderradius:0px", "xp0:suidarredrob", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bottom", "mottob", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bottom:0px", "xp0:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bottom:10px", "xp01:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bottom:20px", "xp02:mottob", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bottom:40px", "xp04:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "bottom:5px", "xp5:mottob", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "builder", "redliub", "1", "34", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "button", "nottub", "1", "49", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "cart", "trac", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "color:#ffffff", "ffffff#:roloc", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "column", "nmuloc", "1", "45", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "container", "reniatnoc", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "divider", "redivid", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "flex", "xelf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "font", "tnof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusion", "noisuf", "1", "121", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbody", "ydobnoisuf", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn3", "3nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn3width:100", "001:htdiw3nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn4", "4nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn4width:100", "001:htdiw4nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn4width:66666666666667", "76666666666666:htdiw4nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn5", "5nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn5width:100", "001:htdiw5nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildercolumn5width:33333333333333", "33333333333333:htdiw5nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildernestedcolumn2", "2nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildernestedcolumn2width:100", "001:htdiw2nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildernestedcolumn3", "3nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuildernestedcolumn3width:100", "001:htdiw3nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3", "3nottubnottubnoisuf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3:active", "evitca:3nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3:activebordercolor:#ffffff", "ffffff#:rolocredrobevitca:3nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3:activecolor:#ffffff", "ffffff#:rolocevitca:3nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3:focus", "sucof:3nottubnottubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3:hover", "revoh:3nottubnottubnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3:hoverbutton3:focusfusionbuttonbutton3:activebackground:", ":dnuorgkcabevitca:3nottubnottubnoisufsucof:3nottubrevoh:3nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton3background:", ":dnuorgkcab3nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonbutton4", "4nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonicondivider", "redividnocinottubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttonicondividerbordercolor:#ffffff", "ffffff#:rolocredrobredividnocinottubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionbuttontext", "txetnottubnoisuf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionflexcontainerfusionbuilderrow3", "3worredliubnoisufreniatnocxelfnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionflexcontainerfusionbuilderrow4", "4worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle5margintop:5px", "xp5:potnigram5eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle6margintop:0px", "xp0:potnigram6eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle6margintop:5px", "xp5:potnigram6eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle7margintop:0px", "xp0:potnigram7eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle7margintop:5px", "xp5:potnigram7eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle8margintop:0px", "xp0:potnigram8eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusiontitlefusiontitle8margintop:5px", "xp5:potnigram8eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionwoocarttable2", "2elbattracoownoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionwoocarttable2marginbottom:40px", "xp04:mottobnigram2elbattracoownoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "fusionwoocarttable2shoptable", "elbatpohs2elbattracoownoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "height:auto", "otua:thgieh", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "i", "i", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "i,.fusion-button.button-3:active", "evitca:3-nottub.nottub-noisuf.,i", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "i,.fusion-button.button-3:focus", "sucof:3-nottub.nottub-noisuf.,i", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "icon", "noci", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "ifusionbuttonbutton3:active", "evitca:3nottubnottubnoisufi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "ifusionbuttonbutton3:focus", "sucof:3nottubnottubnoisufi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "important", "tnatropmi", "1", "76", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "left", "tfel", "1", "25", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "left:0px", "xp0:tfel", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin", "nigram", "1", "83", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-bottom", "mottob-nigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-bottom:0px", "xp0:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-bottom:10px", "xp01:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-bottom:20px", "xp02:mottob-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-bottom:5px", "xp5:mottob-nigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-left", "tfel-nigram", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-left:0px", "xp0:tfel-nigram", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-right", "thgir-nigram", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-right:0px", "xp0:thgir-nigram", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margin-top", "pot-nigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginbottom", "mottobnigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginbottom:0px", "xp0:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginbottom:10px", "xp01:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginbottom:20px", "xp02:mottobnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginbottom:5px", "xp5:mottobnigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginleft", "tfelnigram", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginleft:0px", "xp0:tfelnigram", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginright", "thgirnigram", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "marginright:0px", "xp0:thgirnigram", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "margintop", "potnigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "max", "xam", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "maxwidth:1024px", "xp4201:htdiwxam", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "maxwidth:750px", "xp057:htdiwxam", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "nested", "detsen", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "only", "ylno", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "order", "redro", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "padding", "gniddap", "1", "43", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "padding-bottom", "mottob-gniddap", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "padding-bottom:20px", "xp02:mottob-gniddap", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "padding-left", "tfel-gniddap", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "padding-right", "thgir-gniddap", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "padding-top", "pot-gniddap", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "paddingbottom", "mottobgniddap", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "paddingbottom:20px", "xp02:mottobgniddap", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "paddingleft", "tfelgniddap", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "paddingright", "thgirgniddap", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "paddingtop", "potgniddap", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "radius:0px", "xp0:suidar", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "right", "thgir", "1", "25", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "right:0px", "xp0:thgir", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "row", "wor", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "screen", "neercs", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "shop", "pohs", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "size:18px", "xp81:ezis", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "table", "elbat", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "tbody", "ydobt", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "td", "dt", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "text", "txet", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "th", "ht", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "th{font-size:18px", "xp81:ezis-tnof{ht", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "th{padding-top:20px", "xp02:pot-gniddap{ht", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "thead", "daeht", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "thfontsize:18px", "xp81:ezistnofht", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "thpaddingtop:20px", "xp02:potgniddapht", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "title", "eltit", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "top", "pot", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "top:0px", "xp0:pot", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "top:20px", "xp02:pot", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "top:5px", "xp5:pot", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "tr", "rt", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "tr{height:auto", "otua:thgieh{rt", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "trheight:auto", "otua:thgiehrt", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "width:100", "001:htdiw", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "width:1024px", "xp4201:htdiw", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "width:33", "33:htdiw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "width:66", "66:htdiw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "width:750px", "xp057:htdiw", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "woo", "oow", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "wrapper", "repparw", "1", "15", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "آوادا", "اداوآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "ادامه", "همادا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "ارسال", "لاسرا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "اعمال", "لامعا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "ایران", "ناریا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "اینجا", "اجنیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "برای", "یارب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "بروز", "زورب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "بروزرسانی", "یناسرزورب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "پرداخت", "تخادرپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "تخفیف", "فیفخت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "تعداد", "دادعت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "جمع", "عمج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "خرید", "دیرخ", "1", "2", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "دارید", "دیراد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "رسانی", "یناسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "سبد", "دبس", "1", "3", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "سبد خرید رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "سلام", "مالس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "شهر", "رهش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "عزیز", "زیزع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "قیمت", "تمیق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "کد", "دک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "کدتخفیف:", ":فیفختدک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "کل", "لک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "کنید", "دینک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "کوپن", "نپوک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "مبلغ", "غلبم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "مجموع:", ":عومجم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "محاسبه", "هبساحم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "محصول", "لوصحم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "نام", "مان", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("7", "وارد", "دراو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "-100px", "xp001-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "،", "،", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ":", ":", "1", "73", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-body", "ydob-noisuf.", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-builder-column-3{width:100%", "%001:htdiw{3-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-builder-column-4{width:100%", "%001:htdiw{4-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-builder-column-4{width:57%", "%75:htdiw{4-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-builder-column-5{width:100%", "%001:htdiw{5-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-builder-column-5{width:43%", "%34:htdiw{5-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-builder-nested-column-1{width:100%", "%001:htdiw{1-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button-icon-divider", "redivid-noci-nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button-icon-divider{border-color:#269984", "489962#:roloc-redrob{redivid-noci-nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button-icon-divider{border-color:#48cab2", "2bac84#:roloc-redrob{redivid-noci-nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button-text", "txet-nottub-noisuf.", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button.button-2", "2-nottub.nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button.button-2:active", "evitca:2-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button.button-2:active{border-color:#ffffff", "ffffff#:roloc-redrob{evitca:2-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button.button-2:active{color:#269984", "489962#:roloc{evitca:2-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button.button-2:focus", "sucof:2-nottub.nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-button.button-2:hover", "revoh:2-nottub.nottub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-flex-container.fusion-builder-row-3{", "{3-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ".fusion-flex-container.fusion-builder-row-4{", "{4-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "(max-width:750px)", ")xp057:htdiw-xam(", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{.fusion-body", "ydob-noisuf.{", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{.fusion-title.fusion-title-4{margin-top:5px", "xp5:pot-nigram{4-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{.fusion-title.fusion-title-5{margin-top:5px", "xp5:pot-nigram{5-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{.fusion-title.fusion-title-6{margin-top:5px", "xp5:pot-nigram{6-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{border-color:#ffffff", "ffffff#:roloc-redrob{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{color:#48cab2", "2bac84#:roloc{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{margin-right", "thgir-nigram{", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "{padding-top", "pot-gniddap{", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}", "}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-builder-column-3", "3-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-builder-column-4", "4-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-builder-column-5", "5-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-builder-nested-column-1", "1-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-button.button-2", "2-nottub.nottub-noisuf.}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-button.button-2:hover", "revoh:2-nottub.nottub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-button.button-2:hover,.button-2:focus,.fusion-button.button-2:active{background:", ":dnuorgkcab{evitca:2-nottub.nottub-noisuf.,sucof:2-nottub.,revoh:2-nottub.nottub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}.fusion-button.button-2{background:", ":dnuorgkcab{2-nottub.nottub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}}", "}}", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}}@media", "aidem@}}", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "}@media", "aidem@}", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "@media", "aidem@", "1", "29", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", ">", ">", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "0", "0", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "0.98%", "%89.0", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "098", "890", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "0px", "xp0", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "1", "1", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "100px", "xp001", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "10px", "xp01", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "10vw", "wv01", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "132", "231", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "153", "351", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "178", "871", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "2", "2", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "2:active", "evitca:2", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "2:focus", "sucof:2", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "2:hover", "revoh:2", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "202", "202", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "20px", "xp02", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "3", "3", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "30", "03", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "38", "83", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "4", "4", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "5", "5", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "5%", "%5", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "50px", "xp05", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "6", "6", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "65px", "xp56", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "72", "27", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "8vw", "wv8", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "95px", "xp59", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "98", "89", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "and", "dna", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "background:", ":dnuorgkcab", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "body", "ydob", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "border", "redrob", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "border-radius:0px", "xp0:suidar-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "bordercolor:#ffffff", "ffffff#:rolocredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "borderradius:0px", "xp0:suidarredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "bottom", "mottob", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "bottom:0px", "xp0:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "bottom:10px", "xp01:mottob", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "bottom:5px", "xp5:mottob", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "builder", "redliub", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "button", "nottub", "1", "47", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "color:#269984", "489962#:roloc", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "color:#48cab2", "2bac84#:roloc", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "color:#ffffff", "ffffff#:roloc", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "column", "nmuloc", "1", "36", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "container", "reniatnoc", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "divider", "redivid", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "flex", "xelf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusion", "noisuf", "1", "99", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbody", "ydobnoisuf", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn3", "3nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn3width:100", "001:htdiw3nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn4", "4nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn4width:100", "001:htdiw4nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn4width:57", "75:htdiw4nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn5", "5nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn5width:100", "001:htdiw5nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildercolumn5width:43", "34:htdiw5nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildernestedcolumn1", "1nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuildernestedcolumn1width:100", "001:htdiw1nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2", "2nottubnottubnoisuf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2:active", "evitca:2nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2:activebordercolor:#ffffff", "ffffff#:rolocredrobevitca:2nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2:activecolor:#269984", "489962#:rolocevitca:2nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2:focus", "sucof:2nottubnottubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2:hover", "revoh:2nottubnottubnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2:hoverbutton2:focusfusionbuttonbutton2:activebackground:", ":dnuorgkcabevitca:2nottubnottubnoisufsucof:2nottubrevoh:2nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonbutton2background:", ":dnuorgkcab2nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonicondivider", "redividnocinottubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonicondividerbordercolor:#269984", "489962#:rolocredrobredividnocinottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttonicondividerbordercolor:#48cab2", "2bac84#:rolocredrobredividnocinottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionbuttontext", "txetnottubnoisuf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionflexcontainerfusionbuilderrow3", "3worredliubnoisufreniatnocxelfnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusionflexcontainerfusionbuilderrow4", "4worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusiontitlefusiontitle4margintop:5px", "xp5:potnigram4eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusiontitlefusiontitle5margintop:5px", "xp5:potnigram5eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "fusiontitlefusiontitle6margintop:5px", "xp5:potnigram6eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "i", "i", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "i,.fusion-button.button-2:active", "evitca:2-nottub.nottub-noisuf.,i", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "i,.fusion-button.button-2:focus", "sucof:2-nottub.nottub-noisuf.,i", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "icon", "noci", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "ifusionbuttonbutton2:active", "evitca:2nottubnottubnoisufi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "ifusionbuttonbutton2:focus", "sucof:2nottubnottubnoisufi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "important", "tnatropmi", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "left", "tfel", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "left:0px", "xp0:tfel", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin", "nigram", "1", "61", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-bottom", "mottob-nigram", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-bottom:0px", "xp0:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-bottom:10px", "xp01:mottob-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-bottom:5px", "xp5:mottob-nigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-left", "tfel-nigram", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-left:0px", "xp0:tfel-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-right", "thgir-nigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-right:0px", "xp0:thgir-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margin-top", "pot-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginbottom", "mottobnigram", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginbottom:0px", "xp0:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginbottom:10px", "xp01:mottobnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginbottom:5px", "xp5:mottobnigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginleft", "tfelnigram", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginleft:0px", "xp0:tfelnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginright", "thgirnigram", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "marginright:0px", "xp0:thgirnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "margintop", "potnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "max", "xam", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "maxwidth:1024px", "xp4201:htdiwxam", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "maxwidth:750px", "xp057:htdiwxam", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "nested", "detsen", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "only", "ylno", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "order", "redro", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "padding", "gniddap", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "padding-bottom", "mottob-gniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "padding-left", "tfel-gniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "padding-right", "thgir-gniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "padding-top", "pot-gniddap", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "paddingbottom", "mottobgniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "paddingleft", "tfelgniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "paddingright", "thgirgniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "paddingtop", "potgniddap", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "radius:0px", "xp0:suidar", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "rgba", "abgr", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "rgba(38,153,132,0)", ")0,231,351,83(abgr", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "rgba(72,202,178,0)", ")0,871,202,27(abgr", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "rgba381531320", "023135183abgr", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "rgba722021780", "087120227abgr", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "right", "thgir", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "right:0px", "xp0:thgir", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "row", "wor", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "screen", "neercs", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "text", "txet", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "title", "eltit", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "top", "pot", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "top:5px", "xp5:pot", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "width:100", "001:htdiw", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "width:1024px", "xp4201:htdiw", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "width:43", "34:htdiw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "width:57", "75:htdiw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "width:750px", "xp057:htdiw", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "wrapper", "repparw", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "آدرس", "سردآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "ارسال", "لاسرا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "اطلاعات", "تاعالطا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "اینجا", "اجنیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "بازگشت", "تشگزاب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "بررسی", "یسررب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "به", "هب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "پرداخت", "تخادرپ", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "پرداخت رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "تخفیف", "فیفخت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "توسط", "طسوت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "ثبت", "تبث", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "خرید", "دیرخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "خریدار", "رادیرخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "خواهد", "دهاوخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "خود", "دوخ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "دارید؟", "؟دیراد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "در", "رد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "دقت", "تقد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "را", "ار", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "سبد", "دبس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "سفارش", "شرافس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "شد", "دش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "شده", "هدش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "شما", "امش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "کد", "دک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "کردن", "ندرک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "کنيد", "دينک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "کنید", "دینک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "محصول", "لوصحم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "مشخصات", "تاصخشم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "و", "و", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("8", "وارد", "دراو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "-ms-flex-order:", ":redro-xelf-sm-", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "-ms-flexbox", "xobxelf-sm-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "-webkit-flex", "xelf-tikbew-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "-webkit-flex-flow:", ":wolf-xelf-tikbew-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "-webkit-order:", ":redro-tikbew-", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "،", "،", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ":", ":", "1", "175", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ":1499", "9941:", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".avada-woocommerce-myaccount-heading{", "{gnidaeh-tnuoccaym-ecremmocoow-adava.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-body", "ydob-noisuf.", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-10{width:100%", "%001:htdiw{01-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-10{width:80%", "%08:htdiw{01-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-11{width:100%", "%001:htdiw{11-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-12{width:100%", "%001:htdiw{21-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-12{width:50%", "%05:htdiw{21-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-13{width:100%", "%001:htdiw{31-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-13{width:50%", "%05:htdiw{31-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-14{width:100%", "%001:htdiw{41-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-14{width:50%", "%05:htdiw{41-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-15{width:100%", "%001:htdiw{51-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-15{width:50%", "%05:htdiw{51-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-16{width:100%", "%001:htdiw{61-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-17{width:100%", "%001:htdiw{71-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-9{width:100%", "%001:htdiw{9-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-column-9{width:20%", "%02:htdiw{9-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-builder-nested-column-1{width:100%", "%001:htdiw{1-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-button.button-2", "2-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-flex-container.fusion-builder-row-3-1{", "{1-3-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-flex-container.fusion-builder-row-3{", "{3-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-flex-container.fusion-builder-row-4{", "{4-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-form-1677", "7761-mrof-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-form-tooltip", "pitloot-mrof-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-form-tooltip-content{color:#ffffff", "ffffff#:roloc{tnetnoc-pitloot-mrof-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".fusion-tabs.fusion-tabs-2", "2-sbat-noisuf.sbat-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".nav-tabs", "sbat-van.", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".nav-tabs,.fusion-tabs.fusion-tabs-2", "2-sbat-noisuf.sbat-noisuf.,sbat-van.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".nav-tabs{background-color:#ffffff", "ffffff#:roloc-dnuorgkcab{sbat-van.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".nav,.fusion-tabs.fusion-tabs-2", "2-sbat-noisuf.sbat-noisuf.,van.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".tab-content", "tnetnoc-bat.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".tab-pane{background-color:#ffffff", "ffffff#:roloc-dnuorgkcab{enap-bat.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".tab-pane{border-color:#ffffff", "ffffff#:roloc-redrob{enap-bat.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".woocommerce-myaccount-content", "tnetnoc-tnuoccaym-ecremmocoow.", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ".woocommerce-myaccount-content{", "{tnetnoc-tnuoccaym-ecremmocoow.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "(", "(", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "(max-width:750px)", ")xp057:htdiw-xam(", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "(در", "رد(", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ")", ")", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{", "{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{.fusion-body", "ydob-noisuf.{", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{.fusion-title.fusion-title-3{margin-top:0px", "xp0:pot-nigram{3-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{.fusion-title.fusion-title-3{margin-top:5px", "xp5:pot-nigram{3-eltit-noisuf.eltit-noisuf.{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{.fusion-title.fusion-title-4{margin-top:5px", "xp5:pot-nigram{4-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{\"form_id\":\"1677\",\"form_post_id\":\"1677\",\"post_id\":1499,\"form_type\":\"database\",\"confirmation_type\":\"message\",\"redirect_url\":\"\",\"field_labels\":{\"name\":\"", "5460u7260u6460u\":\"eman-tsal\",\"5460u7260u6460u\":\"eman\"{:\"slebal_dleif\",\"\":\"lru_tcerider\",\"egassem\":\"epyt_noitamrifnoc\",\"esabatad\":\"epyt_mrof\",9941:\"di_", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{border-radius:4px", "xp4:suidar-redrob{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{margin-right", "thgir-nigram{", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "{padding-top", "pot-gniddap{", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}", "}", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-10", "01-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-11", "11-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-12", "21-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-13", "31-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-14", "41-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-15", "51-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-16", "61-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-17", "71-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-column-9", "9-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-builder-nested-column-1", "1-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}.fusion-tabs.fusion-tabs-2", "2-sbat-noisuf.sbat-noisuf.}", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}}", "}}", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}}@media", "aidem@}}", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "}@media", "aidem@}", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "@media", "aidem@", "1", "46", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "*", "*", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "&#8221", "1228#&", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "&times", "semit&", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "=", "=", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", ">", ">", "1", "34", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "0", "0", "1", "63", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "0.98%", "%89.0", "1", "40", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "000", "000", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "03:30", "03:30", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "098", "890", "1", "40", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "0px", "xp0", "1", "56", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1", "1", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1.225%", "%522.1", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1.96%", "%69.1", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "10", "01", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "10px", "xp01", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "11", "11", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "11%", "%11", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "12", "21", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1225", "5221", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "۱۳", "۳۱", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1300d", "d0031", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1399", "9931", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1399-12-20t12:09:06+03:30", "03:30+60:90:21t02-21-9931", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1399-12-20t12:23:47+03:30", "03:30+74:32:21t02-21-9931", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1399-12-20t12:30:52+03:30", "03:30+25:03:21t02-21-9931", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "13991220t12:09:0603:30", "03:3060:90:21t02219931", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "13991220t12:23:4703:30", "03:3074:32:21t02219931", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "13991220t12:30:5203:30", "03:3025:03:21t02219931", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "14", "41", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "14,700,000", "000,007,41", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "14700000", "00000741", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "15", "51", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "15700000", "00000751", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "16", "61", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "1677", "7761", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "17", "71", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "17%", "%71", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "196", "691", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "2", "2", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "2:", ":2", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "20", "02", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "20%", "%02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "20t12:09:06", "60:90:21t02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "20t12:23:47", "74:32:21t02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "20t12:30:52", "25:03:21t02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "225", "522", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "2264", "4622", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "3", "3", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "3%", "%3", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "30px", "xp03", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "32", "23", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "3333333333", "3333333333", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "4", "4", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "4.9%", "%9.4", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "40px", "xp04", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "450", "054", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "49", "94", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "5", "5", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "5,000,000", "000,000,5", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "5%", "%5", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "500", "005", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "500,000", "000,005", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "500000", "000005", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "5000000", "0000005", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "50px", "xp05", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "549000", "000945", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "55", "55", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "55,000,000", "000,000,55", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "550", "055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "550,000", "000,055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "550000", "000055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "55000000", "00000055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "59000000", "00000095", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "5px", "xp5", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "6", "6", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "6%", "%6", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "6040000", "0000406", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7", "7", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7,450,000", "000,054,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7,500,000", "000,005,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7%", "%7", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "700", "007", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "700,000", "000,007", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "700000", "000007", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7450000", "0000547", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7500000", "0000057", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "765000", "000567", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "7850000", "0000587", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "8", "8", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "8%", "%8", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "800", "008", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "800,000", "000,008", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "800000", "000008", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "8100000", "0000018", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "820", "028", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "820,000", "000,028", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "820000", "000028", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "899000", "000998", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "9", "9", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "9%", "%9", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "96", "69", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "98", "89", "1", "40", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a", "a", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a:hover", "revoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a:hover{background-color:#ffffff", "ffffff#:roloc-dnuorgkcab{revoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a:hoverbackgroundcolor:#ffffff", "ffffff#:rolocdnuorgkcabrevoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a.tab-link,.fusion-tabs.fusion-tabs-2", "2-sbat-noisuf.sbat-noisuf.,knil-bat.a", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a.tab-link:focus{background-color:#ffffff", "ffffff#:roloc-dnuorgkcab{sucof:knil-bat.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a.tab-link:focus{border-right-color:#ffffff", "ffffff#:roloc-thgir-redrob{sucof:knil-bat.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a.tab-link:hover,.fusion-tabs.fusion-tabs-2", "2-sbat-noisuf.sbat-noisuf.,revoh:knil-bat.a", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a.tab-link{border-top-color:#f7fafd", "dfaf7f#:roloc-pot-redrob{knil-bat.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "a20", "02a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "active", "evitca", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "and", "dna", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "atablink:focusbackgroundcolor:#ffffff", "ffffff#:rolocdnuorgkcabsucof:knilbata", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "atablink:focusborderrightcolor:#ffffff", "ffffff#:rolocthgirredrobsucof:knilbata", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "atablink:hoverfusiontabsfusiontabs2", "2sbatnoisufsbatnoisufrevoh:knilbata", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "atablinkbordertopcolor:#f7fafd", "dfaf7f#:rolocpotredrobknilbata", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "atablinkfusiontabsfusiontabs2", "2sbatnoisufsbatnoisufknilbata", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "avada", "adava", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "avadawoocommercemyaccountheading", "gnidaehtnuoccaymecremmocoowadava", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "background", "dnuorgkcab", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "background-color:#333333", "333333#:roloc-dnuorgkcab", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "background-color:#f7fafd", "dfaf7f#:roloc-dnuorgkcab", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "backgroundcolor:#333333", "333333#:rolocdnuorgkcab", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "backgroundcolor:#f7fafd", "dfaf7f#:rolocdnuorgkcab", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "body", "ydob", "1", "33", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "border", "redrob", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "border-color:#333333", "333333#:roloc-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "border-top-color:#ffffff", "ffffff#:roloc-pot-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "bordercolor:#333333", "333333#:rolocredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "borderradius:4px", "xp4:suidarredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "bordertopcolor:#ffffff", "ffffff#:rolocpotredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "bottom", "mottob", "1", "26", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "bottom:0px", "xp0:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "bottom:10px", "xp01:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "bottom:5px", "xp5:mottob", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "builder", "redliub", "1", "63", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "button", "nottub", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "child", "dlihc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "color:#333333", "333333#:roloc", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "color:#f7fafd", "dfaf7f#:roloc", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "color:#ffffff", "ffffff#:roloc", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "column", "nmuloc", "1", "92", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "confirmation", "noitamrifnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "container", "reniatnoc", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "content", "tnetnoc", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "database", "esabatad", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "display:", ":yalpsid", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "display:flex", "xelf:yalpsid", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "div", "vid", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "email", "liame", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "eos", "soe", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "field", "dleif", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "flex", "xelf", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "flex-flow:", ":wolf-xelf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "flexbox", "xobxelf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "flexflow:", ":wolfxelf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "flow:", ":wolf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "form", "mrof", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "formcreatorconfig", "gifnocrotaercmrof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "formcreatorconfig_1677", "7761_gifnocrotaercmrof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "formcreatorconfig1677", "7761gifnocrotaercmrof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "formid:1677formpostid:1677postid:1499formtype:databaseconfirmationtype:messageredirecturl:fieldlabels:name:u0646u0627u0645lastname:u0646u0627u0645", "5460u7260u6460u:emantsal5460u7260u6460u:eman:slebaldleif:lrutcerideregassem:epytnoitamrifnocesabatad:epytmrof9941:ditsop7761:ditsopmrof7761:dimrof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusion", "noisuf", "1", "167", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbody", "ydobnoisuf", "1", "33", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn10", "01nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn10width:100", "001:htdiw01nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn10width:80", "08:htdiw01nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn11", "11nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn11width:100", "001:htdiw11nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn12", "21nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn12width:100", "001:htdiw21nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn12width:50", "05:htdiw21nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn13", "31nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn13width:100", "001:htdiw31nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn13width:50", "05:htdiw31nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn14", "41nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn14width:100", "001:htdiw41nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn14width:50", "05:htdiw41nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn15", "51nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn15width:100", "001:htdiw51nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn15width:50", "05:htdiw51nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn16", "61nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn16width:100", "001:htdiw61nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn17", "71nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn17width:100", "001:htdiw71nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn9", "9nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn9width:100", "001:htdiw9nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildercolumn9width:20", "02:htdiw9nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildernestedcolumn1", "1nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuildernestedcolumn1width:100", "001:htdiw1nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionbuttonbutton2", "2nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionflexcontainerfusionbuilderrow3", "3worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionflexcontainerfusionbuilderrow31", "13worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionflexcontainerfusionbuilderrow4", "4worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionform1677", "7761mrofnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionformtooltip", "pitlootmrofnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusionformtooltipcontentcolor:#ffffff", "ffffff#:roloctnetnocpitlootmrofnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusiontabsfusiontabs2", "2sbatnoisufsbatnoisuf", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusiontitlefusiontitle3margintop:0px", "xp0:potnigram3eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusiontitlefusiontitle3margintop:5px", "xp5:potnigram3eltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "fusiontitlefusiontitle4margintop:5px", "xp5:potnigram4eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "galaxy", "yxalag", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "heading", "gnidaeh", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "id", "di", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "important", "tnatropmi", "1", "89", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "jootijeans", "snaejitooj", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "kp", "pk", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "kp-2264", "4622-pk", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "kp2264", "4622pk", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "labels", "slebal", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "last", "tsal", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "lc", "cl", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "left", "tfel", "1", "43", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "left:0px", "xp0:tfel", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "li", "il", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "li.active", "evitca.il", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "liactive", "evitcail", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "link", "knil", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "link:focus", "sucof:knil", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "link:hover", "revoh:knil", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "logics", "scigol", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "lumix", "ximul", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin", "nigram", "1", "102", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-bottom", "mottob-nigram", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-bottom:0px", "xp0:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-bottom:10px", "xp01:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-bottom:5px", "xp5:mottob-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-left", "tfel-nigram", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-left:0px", "xp0:tfel-nigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-right", "thgir-nigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-right:0px", "xp0:thgir-nigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margin-top", "pot-nigram", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginbottom", "mottobnigram", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginbottom:0px", "xp0:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginbottom:10px", "xp01:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginbottom:5px", "xp5:mottobnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginleft", "tfelnigram", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginleft:0px", "xp0:tfelnigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginright", "thgirnigram", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "marginright:0px", "xp0:thgirnigram", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "margintop", "potnigram", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "max", "xam", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "maxwidth:1024px", "xp4201:htdiwxam", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "maxwidth:750px", "xp057:htdiwxam", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "message", "egassem", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "moshtari", "irathsom", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ms", "sm", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "msflexbox", "xobxelfsm", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "msflexorder:", ":redroxelfsm", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "myaccount", "tnuoccaym", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "name", "eman", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "nav", "van", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "navfusiontabsfusiontabs2", "2sbatnoisufsbatnoisufvan", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "navtabs", "sbatvan", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "navtabsbackgroundcolor:#ffffff", "ffffff#:rolocdnuorgkcabsbatvan", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "navtabsfusiontabsfusiontabs2", "2sbatnoisufsbatnoisufsbatvan", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "nested", "detsen", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "none", "enon", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "nowrap", "parwon", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "number", "rebmun", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "only", "ylno", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "order", "redro", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "order:", ":redro", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "p", "p", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "p:first", "tsrif:p", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "p:first-child", "dlihc-tsrif:p", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "p:firstchild", "dlihctsrif:p", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "padding", "gniddap", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "padding-bottom", "mottob-gniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "padding-left", "tfel-gniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "padding-right", "thgir-gniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "padding-top", "pot-gniddap", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "paddingbottom", "mottobgniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "paddingleft", "tfelgniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "paddingright", "thgirgniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "paddingtop", "potgniddap", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "pane", "enap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "post", "tsop", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "r840", "048r", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "radius:4px", "xp4:suidar", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "redirect", "tcerider", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "right", "thgir", "1", "44", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "right:0px", "xp0:thgir", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "row", "wor", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "screen", "neercs", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "sm", "ms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "sm-r840", "048r-ms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "smr840", "048rms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "span", "naps", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "span{", "{naps", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "tab", "bat", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "tabcontent", "tnetnocbat", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "tabpanebackgroundcolor:#ffffff", "ffffff#:rolocdnuorgkcabenapbat", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "tabpanebordercolor:#ffffff", "ffffff#:rolocredrobenapbat", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "tabs", "sbat", "1", "36", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "telephone", "enohpelet", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "title", "eltit", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "tooltip", "pitloot", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "top", "pot", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "top:0px", "xp0:pot", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "top:5px", "xp5:pot", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "type", "epyt", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u0627u06ccu0645u06ccu0644", "4460ucc60u5460ucc60u7260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062au0644u0641u0646", "6460u1460u4460ua260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062au0645u0627u0633", "3360u7260u5460ua260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062au0645u0627u0633\",\"message\":\"u0645u062au0646", "6460ua260u5460u\":\"egassem\",\"3360u7260u5460ua260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062au0645u0627u0633message:u0645u062au0646", "6460ua260u5460u:egassem3360u7260u5460ua260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062eu0627u0646u0648u0627u062fu06afu06cc", "cc60ufa60uf260u7260u8460u6460u7260ue260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062eu0627u0646u0648u0627u062fu06afu06cc\",\"your_email\":\"u0627u06ccu0645u06ccu0644\",\"your_telephone_number\":\"u062au0644u0641u0646", "6460u1460u4460ua260u\":\"rebmun_enohpelet_ruoy\",\"4460ucc60u5460ucc60u7260u\":\"liame_ruoy\",\"cc60ufa60uf260u7260u8460u6460u7260ue260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u062eu0627u0646u0648u0627u062fu06afu06ccyouremail:u0627u06ccu0645u06ccu0644yourtelephonenumber:u062au0644u0641u0646", "6460u1460u4460ua260u:rebmunenohpeletruoy4460ucc60u5460ucc60u7260u:liameruoycc60ufa60uf260u7260u8460u6460u7260ue260u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u0645u062au0646", "6460ua260u5460u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u0646u0627u0645", "5460u7260u6460u", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u067eu06ccu0627u0645", "5460u7260ucc60ue760u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u067eu06ccu0627u0645\"},\"field_logics\":{\"name\":\"\",\"last-name\":\"\",\"your_email\":\"\",\"your_telephone_number\":\"\",\"message\":\"\"}}", "}}\"\":\"egassem\",\"\":\"rebmun_enohpelet_ruoy\",\"\":\"liame_ruoy\",\"\":\"eman-tsal\",\"\":\"eman\"{:\"scigol_dleif\",}\"5460u7260ucc60ue760u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "u067eu06ccu0627u0645fieldlogics:name:lastname:youremail:yourtelephonenumber:message:", ":egassem:rebmunenohpeletruoy:liameruoy:emantsal:eman:scigoldleif5460u7260ucc60ue760u", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "url", "lru", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "var", "rav", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "waikiki", "ikikiaw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "watch3", "3hctaw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "webkit", "tikbew", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "webkitflex", "xelftikbew", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "webkitflexflow:", ":wolfxelftikbew", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "webkitorder:", ":redrotikbew", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "width:100", "001:htdiw", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "width:1024px", "xp4201:htdiw", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "width:20", "02:htdiw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "width:50", "05:htdiw", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "width:750px", "xp057:htdiw", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "width:80", "08:htdiw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "woocommerce", "ecremmocoow", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "woocommercemyaccountcontent", "tnetnoctnuoccaymecremmocoow", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "wrap", "parw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "wrapper", "repparw", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "your", "ruoy", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آخرین", "نیرخآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آدرس", "سردآ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آدرس‌های", "یاه‌سردآ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آرا", "ارآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آرایشی", "یشیارآ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آموزش‌های", "یاه‌شزومآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آوادا", "اداوآ", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آیفون", "نوفیآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "آینده", "هدنیآ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اخیرتان", "ناتریخا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ارتباط", "طابترا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ارسال", "لاسرا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "از", "زا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "است", "تسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "استفاده", "هدافتسا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اسم", "مسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اضافه", "هفاضا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اطلاعات", "تاعالطا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اطلاعیه", "هیعالطا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اطلاعیه:", ":هیعالطا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ال", "لا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "انواع", "عاونا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ایران", "ناریا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ایمیل", "لیمیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ایمیل&nbsp", "psbn&لیمیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "این", "نیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "اینگرسول", "لوسرگنیا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "با", "اب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "باشید", "دیشاب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "برای", "یارب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "برس", "سرب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بشناسید", "دیسانشب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بصورت", "تروصب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بعدی", "یدعب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بگذارید", "دیراذگب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بگذارید)", ")دیراذگب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بگیرید", "دیریگب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بهتر", "رتهب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "بهداشتی", "یتشادهب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پایگاه", "هاگیاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پایه", "هیاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پاییزه", "هزییاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پر", "رپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پرداخت", "تخادرپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پسرانه", "هنارسپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پشتیبانی", "ینابیتشپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پوش", "شوپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پيشخوان", "ناوخشيپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پیام", "مایپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پیراهن", "نهاریپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پیشخوان", "ناوخشیپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پیش‌فرض", "ضرف‌شیپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "پیشین", "نیشیپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تخفیف", "فیفخت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تخفیف‌ها", "اه‌فیفخت", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تغییر", "رییغت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تغییرات", "تارییغت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تکرار", "رارکت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تلفن", "نفلت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تلگرام", "مارگلت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تلگرام،", "،مارگلت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تماس", "سامت", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تهران", "نارهت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "تومان", "ناموت", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ثبت", "تبث", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "جامه", "هماج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "جای", "یاج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "جدید", "دیدج", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "جزییات", "تاییزج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "جوش", "شوج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "جیماری", "یرامیج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "حساب", "باسح", "1", "3", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "حساب کاربری رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "حساب‌کاربری", "یربراک‌باسح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "حمل", "لمح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خارج", "جراخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خالی", "یلاخ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خانوادگی", "یگداوناخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خانوادگی&nbsp", "psbn&یگداوناخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خروج", "جورخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خرید", "دیرخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خریدهای", "یاهدیرخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خطا", "اطخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خواهد", "دهاوخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خواهند", "دنهاوخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "خود", "دوخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دانش", "شناد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دانلودی", "یدولناد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "در", "رد", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "درمان", "نامرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دست", "تسد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دسترس", "سرتسد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دو", "ود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دوربین", "نیبرود", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دیجیتال", "لاتیجید", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "دیده", "هدید", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ذخیره", "هریخذ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "را", "ار", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "راهنمای", "یامنهار", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "روی", "یور", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "زنانه", "هنانز", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "زیر", "ریز", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ساعت", "تعاس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سامسونگ", "گنوسماس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سفارش", "شرافس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سفارش‌های", "یاه‌شرافس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سفارشی", "یشرافس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سلام", "مالس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سه", "هس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سی", "یس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سیستم", "متسیس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "سیم", "میس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "شد", "دش", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "شد،", "،دش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "شرکت", "تکرش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "شما", "امش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "شوید", "دیوش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "صحیح", "حیحص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "صفحه", "هحفص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "صورت", "تروص", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "صورتحساب", "باسحتروص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "صورتحساب‌تان", "نات‌باسحتروص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "صورتی", "یتروص", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ضروری", "یرورض", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "طریق", "قیرط", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "طور", "روط", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ظرفیت", "تیفرظ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "عبور", "روبع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "عکاسی", "یساکع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "علاقمندی‌ها", "اه‌یدنمقالع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "علاقمندی‌های", "یاه‌یدنمقالع", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "فایل‌های", "یاه‌لیاف", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "فرم", "مرف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "فروش", "شورف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "فروشگاه", "هاگشورف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "فیلدهای", "یاهدلیف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "قرار", "رارق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "قصد", "دصق", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کاربری", "یربراک", "1", "2", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کاربری‌تان،", "،نات‌یربراک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کارت", "تراک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کارشناسان", "ناسانشراک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کانن", "نناک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کد", "دک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کدهای", "یاهدک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کلمه", "هملک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کلیک", "کیلک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کنید", "دینک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "کنیدو", "ودینک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "که", "هک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "گذرواژه", "هژاورذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "گوشی", "یشوگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "گیگابایت&hellip", "pilleh&تیاباگیگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "لطفا", "افطل", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "لوازم", "مزاول", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "لیست", "تسیل", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "لینک", "کنیل", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ما", "ام", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ماسک", "کسام", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "متن", "نتم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مجدد", "ددجم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "محصولات", "تالوصحم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "محصولی", "یلوصحم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مدل", "لدم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مدیر", "ریدم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مدیریت", "تیریدم", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مردانه", "هنادرم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مرور", "رورم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مستقیم", "میقتسم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مشاهده،", "،هدهاشم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "منتشر", "رشتنم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "منتظر", "رظتنم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مواجه", "هجاوم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "موبایل", "لیابوم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مورد", "دروم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "موفقیت", "تیقفوم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "مي‌گیرد", "دریگ‌يم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "می‌توانید", "دیناوت‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "می‌تونید", "دینوت‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "می‌شوند", "دنوش‌یم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "می‌شوند.", ".دنوش‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نام", "مان", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نام&nbsp", "psbn&مان", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ندارد", "درادن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ندارید", "دیرادن", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ندید", "دیدن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نشده", "هدشن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نظرات", "تارظن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نقل", "لقن", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نمایشی&nbsp", "psbn&یشیامن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نمایید", "دییامن", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نوروز", "زورون", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نیست", "تسین", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نیست.", ".تسین", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نیستید؟", "؟دیتسین", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "نیکون", "نوکین", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "هفته", "هتفه", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "هنوز", "زونه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "هودی", "یدوه", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "هوشمند", "دنمشوه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "هیچ", "چیه", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "و", "و", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "واتساب", "باستاو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "واتساپ", "پاستاو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "واتساپ،", "،پاستاو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "وجود", "دوجو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ویرایش", "شیاریو", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("9", "ویژه", "هژیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ":", ":", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ".fusion-body", "ydob-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ".fusion-breadcrumbs.fusion-breadcrumbs-2{font-size:12px", "xp21:ezis-tnof{2-sbmurcdaerb-noisuf.sbmurcdaerb-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ".fusion-builder-column-1{width:100%", "%001:htdiw{1-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ".fusion-flex-container.fusion-builder-row-2{", "{2-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "(max-width:640px)", ")xp046:htdiw-xam(", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "{.fusion-body", "ydob-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "{.fusion-title.fusion-title-2{margin-top:5px", "xp5:pot-nigram{2-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "{margin-right", "thgir-nigram{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "{padding-top", "pot-gniddap{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}", "}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}.fusion-breadcrumbs.fusion-breadcrumbs-2", "2-sbmurcdaerb-noisuf.sbmurcdaerb-noisuf.}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}.fusion-breadcrumbs.fusion-breadcrumbs-2{color:#607d8b", "b8d706#:roloc{2-sbmurcdaerb-noisuf.sbmurcdaerb-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}.fusion-builder-column-1", "1-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}}", "}}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}}@media", "aidem@}}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "}@media", "aidem@}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "@media", "aidem@", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "/", "/", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", ">", ">", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "0", "0", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "0.98%", "%89.0", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "000&nbsp", "psbn&000", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "098", "890", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "0px", "xp0", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "1", "1", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "12", "21", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "128", "821", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "1399", "9931", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "2", "2", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "2%", "%2", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "20px", "xp02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "23", "32", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "23,300,000&nbsp", "psbn&000,003,32", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "23300000&nbsp", "psbn&00000332", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "3", "3", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "3,830,000&nbsp", "psbn&000,038,3", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "30", "03", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "300", "003", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "30px", "xp03", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "32", "23", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "3830000&nbsp", "psbn&0000383", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "43", "34", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "43,490,000&nbsp", "psbn&000,094,34", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "43490000&nbsp", "psbn&00009434", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "490", "094", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "830", "038", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "98", "89", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a", "a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a:hover", "revoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a:hover{color:#48cab2", "2bac84#:roloc{revoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a:hovercolor:#48cab2", "2bac84#:rolocrevoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a{color:#607d8b", "b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a11", "11a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a2176", "6712a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "a2408", "8042a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "acolor:#607d8b", "b8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "and", "dna", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "body", "ydob", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "bottom", "mottob", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "bottom:10px", "xp01:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "bottom:5px", "xp5:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "breadcrumbs", "sbmurcdaerb", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "builder", "redliub", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "color:#48cab2", "2bac84#:roloc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "color:#607d8b", "b8d706#:roloc", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "column", "nmuloc", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "container", "reniatnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "flex", "xelf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "font", "tnof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusion", "noisuf", "1", "27", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionbody", "ydobnoisuf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionbreadcrumbsfusionbreadcrumbs2", "2sbmurcdaerbnoisufsbmurcdaerbnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionbreadcrumbsfusionbreadcrumbs2color:#607d8b", "b8d706#:roloc2sbmurcdaerbnoisufsbmurcdaerbnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionbreadcrumbsfusionbreadcrumbs2fontsize:12px", "xp21:ezistnof2sbmurcdaerbnoisufsbmurcdaerbnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionbuildercolumn1", "1nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionbuildercolumn1width:100", "001:htdiw1nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusionflexcontainerfusionbuilderrow2", "2worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "fusiontitlefusiontitle2margintop:5px", "xp5:potnigram2eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "galaxy", "yxalag", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "important", "tnatropmi", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "iphone", "enohpi", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "left", "tfel", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin", "nigram", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin-bottom", "mottob-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin-bottom:10px", "xp01:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin-bottom:5px", "xp5:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin-left", "tfel-nigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin-right", "thgir-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margin-top", "pot-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "marginbottom", "mottobnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "marginbottom:10px", "xp01:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "marginbottom:5px", "xp5:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "marginleft", "tfelnigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "marginright", "thgirnigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "margintop", "potnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "max", "xam", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "maxwidth:1024px", "xp4201:htdiwxam", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "maxwidth:640px", "xp046:htdiwxam", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "mini", "inim", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "only", "ylno", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "padding", "gniddap", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "padding-bottom", "mottob-gniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "padding-left", "tfel-gniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "padding-right", "thgir-gniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "padding-top", "pot-gniddap", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "paddingbottom", "mottobgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "paddingleft", "tfelgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "paddingright", "thgirgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "paddingtop", "potgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "pro", "orp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "right", "thgir", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "row", "wor", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "screen", "neercs", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "size:12px", "xp21:ezis", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "span", "naps", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "title", "eltit", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "top", "pot", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "top:5px", "xp5:pot", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "width:100", "001:htdiw", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "width:1024px", "xp4201:htdiw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "width:640px", "xp046:htdiw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "wrapper", "repparw", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "اپل", "لپا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "افزودن", "ندوزفا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "انبار", "رابنا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "بهمن", "نمهب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "تومان", "ناموت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "خانه", "هناخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "خرید", "دیرخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "در", "رد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "دو", "ود", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "سامسونگ", "گنوسماس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "سبد", "دبس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "سیم", "میس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "شما", "امش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "ظرفیت", "تیفرظ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "علاقمندی‌ها", "اه‌یدنمقالع", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "علاقمندی‌های", "یاه‌یدنمقالع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "کارت", "تراک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "گوشی", "یشوگ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "گیگابایت", "تیاباگیگ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "لیست", "تسیل", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "لیست علاقمندی‌ها رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "مدل", "لدم", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "موبایل", "لیابوم", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("31", "موجود", "دوجوم", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "آگاه", "هاگآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "آینده", "هدنیآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ارائه", "هئارا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "از", "زا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "است", "تسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "است.", ".تسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "استفاده", "هدافتسا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "اسلامی", "یمالسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "اصول", "لوصا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "الکترونیک", "کینورتکلا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ایجاد", "داجیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ایران،", "،ناریا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "این", "نیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "با", "اب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "باشید", "دیشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "برگه", "هگرب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "بنویسید", "دیسیونب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "به", "هب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "بودن", "ندوب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "پذیرش", "شریذپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "پذیرفتن", "نتفریذپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "پروشاپ", "پاشورپ", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "پروفایل", "لیافورپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "تجارت", "تراجت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "تشویقی،", "،یقیوشت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "تصویری", "یریوصت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "تغییر", "رییغت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "تغییراتی", "یتارییغت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "توافق", "قفاوت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "توافق‏‌های", "یاه‌‏قفاوت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "توجه", "هجوت", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "توسط", "طسوت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ثبت", "تبث", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "جایگزین", "نیزگیاج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "جمهوری", "یروهمج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "حقوق", "قوقح", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "حمایت", "تیامح", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "خدمات", "تامدخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "خودتون", "نوتدوخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "داشته", "هتشاد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "در", "رد", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ذکر", "رکذ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رسانه", "هناسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رسانی", "یناسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رعایت", "تیاعر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رو", "ور", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "روز", "زور", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رویه‏‌ها", "اه‌‏هیور", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "رویه‏‌های", "یاه‌‏هیور", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "زمان", "نامز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "سایت", "تیاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "سایر", "ریاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "سرویس‌ها", "اه‌سیورس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "سرویس‏‌های", "یاه‌‏سیورس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "سفارش", "شرافس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "سوی", "یوس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شخصی،", "،یصخش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شده", "هدش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شرایط", "طیارش", "1", "4", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شرایط و مقررات فروشگاه رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شما", "امش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شود", "دوش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "شود،", "،دوش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "صفحه", "هحفص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "صورتی", "یتروص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "طرح‏‌های", "یاه‌‏حرط", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "عمومی", "یمومع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "فروشگاه", "هاگشورف", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "قانون", "نوناق", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "قبلی", "یلبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "قوانین", "نیناوق", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "کاربر", "ربراک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "کاربران", "ناربراک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "کامل", "لماک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "کلیه", "هیلک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "کننده", "هدننک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "که", "هک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "لازم", "مزال", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "متعاقبا", "ابقاعتم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "محسوب", "بوسحم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "مرتبط", "طبترم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "مستمر", "رمتسم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "مصرف", "فرصم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "معنای", "یانعم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "معنی", "ینعم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "مقررات", "تاررقم", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "منتشر", "رشتنم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "مندرج،", "،جردنم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "منطبق", "قبطنم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "موظف", "فظوم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "می", "یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "می‏‌شود", "دوش‌‏یم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "می‏‌شود.", ".دوش‌‏یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "می‏‌کنید", "دینک‌‏یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "نحوه", "هوحن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "نیز", "زین", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "هر", "ره", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "هرگونه", "هنوگره", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "همچنین", "نینچمه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "همین", "نیمه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "هنگام", "ماگنه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "و", "و", "1", "16", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "وب‏‌سایت", "تیاس‌‏بو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ورود", "دورو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("32", "ویدئوهای", "یاهوئدیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "-15px", "xp51-", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "-2)", ")2-", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "-45px", "xp54-", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "،", "،", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ":", ":", "1", "678", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".crossfade-images{background-color:#48cab2", "2bac84#:roloc-dnuorgkcab{segami-edafssorc.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-body", "ydob-noisuf.", "1", "51", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-23{width:100%", "%001:htdiw{32-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-24{width:100%", "%001:htdiw{42-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-24{width:66.666666666667%", "%766666666666.66:htdiw{42-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-25{width:100%", "%001:htdiw{52-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-25{width:33.333333333333%", "%333333333333.33:htdiw{52-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-26{width:100%", "%001:htdiw{62-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-27{width:100%", "%001:htdiw{72-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-28{width:100%", "%001:htdiw{82-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-29{width:100%", "%001:htdiw{92-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-30{width:25%", "%52:htdiw{03-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-30{width:50%", "%05:htdiw{03-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-31{width:25%", "%52:htdiw{13-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-31{width:50%", "%05:htdiw{13-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-32{width:25%", "%52:htdiw{23-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-32{width:50%", "%05:htdiw{23-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-33{width:25%", "%52:htdiw{33-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-33{width:50%", "%05:htdiw{33-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-34{width:100%", "%001:htdiw{43-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-34{width:50%", "%05:htdiw{43-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-35{width:100%", "%001:htdiw{53-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-35{width:50%", "%05:htdiw{53-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-36{width:100%", "%001:htdiw{63-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-37{width:100%", "%001:htdiw{73-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-37{width:90%", "%09:htdiw{73-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-38", "83-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-39", "93-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-40", "04-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-41", "14-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-42", "24-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-43", "34-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-44", "44-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-column-45", "54-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-27{width:100%", "%001:htdiw{72-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-27{width:8%", "%8:htdiw{72-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-28", "82-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-28{filter:", ":retlif{82-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-28{width:12%", "%21:htdiw{82-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-28{width:33.333333333333%", "%333333333333.33:htdiw{82-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-28{width:50%", "%05:htdiw{82-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-29", "92-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-29{filter:", ":retlif{92-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-29{width:12%", "%21:htdiw{92-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-29{width:33.333333333333%", "%333333333333.33:htdiw{92-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-29{width:50%", "%05:htdiw{92-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-30", "03-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-30{filter:", ":retlif{03-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-30{width:12%", "%21:htdiw{03-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-30{width:33.333333333333%", "%333333333333.33:htdiw{03-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-30{width:50%", "%05:htdiw{03-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-31", "13-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-31{filter:", ":retlif{13-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-31{width:12%", "%21:htdiw{13-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-31{width:33.333333333333%", "%333333333333.33:htdiw{13-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-31{width:50%", "%05:htdiw{13-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-32", "23-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-32{filter:", ":retlif{23-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-32{width:12%", "%21:htdiw{23-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-32{width:33.333333333333%", "%333333333333.33:htdiw{23-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-32{width:50%", "%05:htdiw{23-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-33", "33-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-33{filter:", ":retlif{33-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-33{width:12%", "%21:htdiw{33-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-33{width:33.333333333333%", "%333333333333.33:htdiw{33-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-33{width:50%", "%05:htdiw{33-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-34", "43-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-34{filter:", ":retlif{43-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-34{width:100%", "%001:htdiw{43-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-34{width:12%", "%21:htdiw{43-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-35{width:100%", "%001:htdiw{53-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-35{width:8%", "%8:htdiw{53-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-36{width:100%", "%001:htdiw{63-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-37{width:100%", "%001:htdiw{73-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-38{width:100%", "%001:htdiw{83-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-39{width:100%", "%001:htdiw{93-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-40{width:100%", "%001:htdiw{04-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-41{width:100%", "%001:htdiw{14-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-42{width:100%", "%001:htdiw{24-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-43{width:100%", "%001:htdiw{34-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-44{width:100%", "%001:htdiw{44-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-45{width:100%", "%001:htdiw{54-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-46{width:100%", "%001:htdiw{64-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-47{width:100%", "%001:htdiw{74-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-48{width:100%", "%001:htdiw{84-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-49{width:100%", "%001:htdiw{94-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-50{width:100%", "%001:htdiw{05-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-51{width:100%", "%001:htdiw{15-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-52{width:100%", "%001:htdiw{25-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-builder-nested-column-53{width:100%", "%001:htdiw{35-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-column-inner-bg", "gb-renni-nmuloc-noisuf.", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-column-inner-bg{margin-left:calc((25px)/", "/)xp52((clac:tfel-nigram{gb-renni-nmuloc-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "134", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-10{", "{01-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-11{", "{11-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-12{", "{21-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-13{", "{31-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-14{", "{41-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-15{", "{51-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-16{", "{61-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-17{", "{71-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-flex-container.fusion-builder-row-18{", "{81-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-grid-column", "nmuloc-dirg-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-grid-column{padding-left:calc((25px)/", "/)xp52((clac:tfel-gniddap{nmuloc-dirg-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-post-card-image-1", "1-egami-drac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-post-card-image-1{border-top-left-radius:7px", "xp7:suidar-tfel-pot-redrob{1-egami-drac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-post-cards.fusion-post-cards-2", "2-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".fusion-row", "wor-noisuf.", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ".infinite-scroll-hide{display:none", "enon:yalpsid{edih-llorcs-etinifni.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "(max-width:750px)", ")xp057:htdiw-xam(", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{", "{", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-body", "ydob-noisuf.{", "1", "84", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-11{margin-top:5px", "xp5:pot-nigram{11-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-12{margin-top:5px", "xp5:pot-nigram{21-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-13{margin-top:5px", "xp5:pot-nigram{31-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-14{margin-top:5px", "xp5:pot-nigram{41-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-15{margin-top:5px", "xp5:pot-nigram{51-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-16{margin-top:5px", "xp5:pot-nigram{61-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-17{margin-top:5px", "xp5:pot-nigram{71-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-18{margin-top:5px", "xp5:pot-nigram{81-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-19{margin-top:5px", "xp5:pot-nigram{91-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{.fusion-title.fusion-title-20{margin-top:5px", "xp5:pot-nigram{02-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{margin-right", "thgir-nigram{", "1", "82", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "{padding-top", "pot-gniddap{", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}", "}", "1", "32", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-23", "32-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-24", "42-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-25", "52-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-26", "62-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-27", "72-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-28", "82-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-29", "92-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-30", "03-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-31", "13-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-32", "23-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-33", "33-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-34", "43-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-35", "53-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-36", "63-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-column-37", "73-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-27", "72-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-28", "82-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-28:hover{filter:", ":retlif{revoh:82-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-29", "92-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-29:hover{filter:", ":retlif{revoh:92-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-30", "03-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-30:hover{filter:", ":retlif{revoh:03-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-31", "13-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-31:hover{filter:", ":retlif{revoh:13-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-32", "23-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-32:hover{filter:", ":retlif{revoh:23-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-33", "33-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-33:hover{filter:", ":retlif{revoh:33-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-34", "43-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-34:hover{filter:", ":retlif{revoh:43-nmuloc-detsen-redliub-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-35", "53-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-36", "63-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-37", "73-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-38", "83-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-39", "93-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-40", "04-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-41", "14-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-42", "24-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-43", "34-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-44", "44-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-45", "54-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-46", "64-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-47", "74-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-48", "84-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-49", "94-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-50", "05-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-51", "15-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-52", "25-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-builder-nested-column-53", "35-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-flex-container", "reniatnoc-xelf-noisuf.}", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}.fusion-post-cards.fusion-post-cards-2", "2-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}", "}}", "1", "44", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-13", "31-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-14", "41-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-15", "51-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-16", "61-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-17", "71-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-18", "81-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-19", "91-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}.fusion-title.fusion-title-text.fusion-title-20", "02-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}}@media", "aidem@}}", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}@media", "aidem@}", "1", "42", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-10:hover", "revoh:01-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-11:hover", "revoh:11-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-12:hover", "revoh:21-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-13:hover", "revoh:31-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-14:hover", "revoh:41-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-8:hover", "revoh:8-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "}a.fb-icon-element.fontawesome-icon.fb-icon-element-9:hover", "revoh:9-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "@media", "aidem@", "1", "198", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "/", "/", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "#00bcd4", "4dcb00#", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "#ffffff", "ffffff#", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", ">", ">", "1", "158", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "0", "0", "1", "255", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "0.3s", "s3.0", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "0.98%", "%89.0", "1", "142", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "000", "000", "1", "33", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "000&nbsp", "psbn&000", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "03s", "s30", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "0888888888889", "9888888888880", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "098", "890", "1", "142", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "0px", "xp0", "1", "231", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "0w5546", "6455w0", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1", "1", "1", "22", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1,190,000", "000,091,1", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1.0888888888889%", "%9888888888880.1", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1.96%", "%69.1", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1%", "%1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "10", "01", "1", "45", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "10:hover", "revoh:01", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "100", "001", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "10888888888889", "98888888888801", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "10px", "xp01", "1", "62", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "11", "11", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "11:hover", "revoh:11", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "11%", "%11", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1190000", "0000911", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "12", "21", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "12:hover", "revoh:21", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "12.25%", "%52.21", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1225", "5221", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "128", "821", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "۱۳", "۳۱", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "13:hover", "revoh:31", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1300d", "d0031", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "14", "41", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "14,700,000", "000,007,41", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "14:hover", "revoh:41", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "14700000", "00000741", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "15", "51", "1", "29", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "15700000", "00000751", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "15px", "xp51", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "16", "61", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1666666666667", "7666666666661", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "17", "71", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "17,600,000", "000,006,71", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "17%", "%71", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "17600000", "00000671", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "17799000", "00099771", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "18", "81", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "18-55mm", "mm55-81", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "1855mm", "mm5581", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "19", "91", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "190", "091", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "196", "691", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "2", "2", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "2.94%", "%49.2", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "2)", ")2", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "20", "02", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "20px", "xp02", "1", "17", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "2264", "4622", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "23", "32", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "23,300,000", "000,003,32", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "230", "032", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "230,000", "000,032", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "230000", "000032", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "23300000", "00000332", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "24", "42", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "25", "52", "1", "17", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "256", "652", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "25600", "00652", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "25600-100", "001-00652", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "25600100", "00100652", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "25px", "xp52", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "26", "62", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "27", "72", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "28", "82", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "28:hover", "revoh:82", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "29", "92", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "29:hover", "revoh:92", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "294", "492", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "295", "592", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "3", "3", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "3,295,000", "000,592,3", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "30", "03", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "30:hover", "revoh:03", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "30%", "%03", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "300", "003", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "31", "13", "1", "17", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "31,500,000", "000,005,13", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "31:hover", "revoh:13", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "31500000", "00000513", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "32", "23", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "32:hover", "revoh:23", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "3295000", "0005923", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "33", "33", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "33:hover", "revoh:33", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "333333333333", "333333333333", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "336", "633", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "34", "43", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "34:hover", "revoh:43", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "35", "53", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "36", "63", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "37", "73", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "38", "83", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "39", "93", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "3s", "s3", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "4", "4", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "4,000,000", "000,000,4", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "40", "04", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "400", "004", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "4000000", "0000004", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "41", "14", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "42", "24", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "43", "34", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "44", "44", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "45", "54", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "450", "054", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "45px", "xp54", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "46", "64", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "47", "74", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "48", "84", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "49", "94", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "5", "5", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "5,000,000", "000,000,5", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "5%", "%5", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "50", "05", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "500", "005", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "500,000", "000,005", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "500000", "000005", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "5000000", "0000005", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "50px", "xp05", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "51", "15", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "52", "25", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "53", "35", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "549000", "000945", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "55", "55", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "55,000,000&nbsp", "psbn&000,000,55", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "550", "055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "550,000", "000,055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "550000", "000055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "55000000&nbsp", "psbn&00000055", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "55mm", "mm55", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "59", "95", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "59,000,000&nbsp", "psbn&000,000,95", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "59000000&nbsp", "psbn&00000095", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "6", "6", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "6%", "%6", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "600", "006", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "6040000", "0000406", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "666666666667", "766666666666", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7", "7", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7,336,000", "000,633,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7,450,000", "000,054,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7,450,000&nbsp", "psbn&000,054,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7,500,000", "000,005,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7,850,000&nbsp", "psbn&000,058,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7%", "%7", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "70", "07", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "70%", "%07", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "700", "007", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "700,000&nbsp", "psbn&000,007", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "700000&nbsp", "psbn&000007", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7336000", "0006337", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7450000", "0000547", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7450000&nbsp", "psbn&0000547", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7500000", "0000057", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "765", "567", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "765,000&nbsp", "psbn&000,567", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "765000&nbsp", "psbn&000567", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7850000", "0000587", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "7850000&nbsp", "psbn&0000587", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8", "8", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8,000,000", "000,000,8", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8:hover", "revoh:8", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8.1666666666667%", "%7666666666661.8", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8%", "%8", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "800", "008", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "800,000", "000,008", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "800000", "000008", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8000000", "0000008", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8100000", "0000018", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "81666666666667", "76666666666618", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "820", "028", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "820,000&nbsp", "psbn&000,028", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "820000&nbsp", "psbn&000028", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "850", "058", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "8600000", "0000068", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "899000", "000998", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "9", "9", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "9:hover", "revoh:9", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "9%", "%9", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "94", "49", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "96", "69", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "98", "89", "1", "146", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a", "a", "1", "22", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a:hover", "revoh:a", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a:hover{color:#48cab2}", "}2bac84#:roloc{revoh:a", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a:hovercolor:#48cab2", "2bac84#:rolocrevoh:a", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-10{", "{01-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-11{", "{11-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-12{", "{21-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-13{", "{31-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-14{", "{41-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-8{", "{8-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a.fb-icon-element.fontawesome-icon.fb-icon-element-9{", "{9-tnemele-noci-bf.noci-emosewatnof.tnemele-noci-bf.a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-13", "31-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-14", "41-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-15", "51-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-16", "61-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-17", "71-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-18", "81-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-19", "91-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-20", "02-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a11", "11a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a20", "02a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "a42", "24a", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle13", "31eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle14", "41eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle15", "51eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle16", "61eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle17", "71eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle18", "81eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle19", "91eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle20", "02eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement10", "01tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement10:hover", "revoh:01tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement11", "11tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement11:hover", "revoh:11tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement12", "21tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement12:hover", "revoh:21tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement13", "31tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement13:hover", "revoh:31tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement14", "41tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement14:hover", "revoh:41tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement8", "8tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement8:hover", "revoh:8tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement9", "9tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "afbiconelementfontawesomeiconfbiconelement9:hover", "revoh:9tnemelenocibfnociemosewatnoftnemelenocibfa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "and", "dna", "1", "104", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "aps", "spa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "aps-c", "c-spa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "apsc", "cspa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "background", "dnuorgkcab", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "bg", "gb", "1", "22", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "body", "ydob", "1", "135", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "border", "redrob", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "border-bottom-left-radius:7px", "xp7:suidar-tfel-mottob-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "border-bottom-right-radius:7px", "xp7:suidar-thgir-mottob-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "border-top-right-radius:7px", "xp7:suidar-thgir-pot-redrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "borderbottomleftradius:7px", "xp7:suidartfelmottobredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "borderbottomrightradius:7px", "xp7:suidarthgirmottobredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "bordertoprightradius:7px", "xp7:suidarthgirpotredrob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "bottom", "mottob", "1", "112", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "bottom:10px", "xp01:mottob", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "bottom:5px", "xp5:mottob", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "builder", "redliub", "1", "304", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "c", "c", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "card", "drac", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "cards", "sdrac", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "color:", ":roloc", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "color:#48cab2", "2bac84#:roloc", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "color:#607d8b", "b8d706#:roloc", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "column", "nmuloc", "1", "453", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "container", "reniatnoc", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "crossfade", "edafssorc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "crossfadeimagesbackgroundcolor:#48cab2", "2bac84#:rolocdnuorgkcabsegamiedafssorc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "display:none", "enon:yalpsid", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "dual", "laud", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ease", "esae", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ef", "fe", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ef-s", "s-fe", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "efs", "sfe", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "element", "tnemele", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "eos", "soe", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fb", "bf", "1", "28", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "filter", "retlif", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "filter:", ":retlif", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "flex", "xelf", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fontawesome", "emosewatnof", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusion", "noisuf", "1", "753", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbody", "ydobnoisuf", "1", "135", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn23", "32nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn23width:100", "001:htdiw32nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn24", "42nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn24width:100", "001:htdiw42nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn24width:66666666666667", "76666666666666:htdiw42nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn25", "52nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn25width:100", "001:htdiw52nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn25width:33333333333333", "33333333333333:htdiw52nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn26", "62nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn26width:100", "001:htdiw62nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn27", "72nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn27width:100", "001:htdiw72nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn28", "82nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn28width:100", "001:htdiw82nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn29", "92nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn29width:100", "001:htdiw92nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn30", "03nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn30width:25", "52:htdiw03nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn30width:50", "05:htdiw03nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn31", "13nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn31width:25", "52:htdiw13nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn31width:50", "05:htdiw13nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn32", "23nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn32width:25", "52:htdiw23nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn32width:50", "05:htdiw23nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn33", "33nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn33width:25", "52:htdiw33nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn33width:50", "05:htdiw33nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn34", "43nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn34width:100", "001:htdiw43nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn34width:50", "05:htdiw43nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn35", "53nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn35width:100", "001:htdiw53nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn35width:50", "05:htdiw53nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn36", "63nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn36width:100", "001:htdiw63nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn37", "73nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn37width:100", "001:htdiw73nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn37width:90", "09:htdiw73nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn38", "83nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn39", "93nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn40", "04nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn41", "14nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn42", "24nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn43", "34nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn44", "44nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildercolumn45", "54nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn27", "72nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn27width:100", "001:htdiw72nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn27width:8", "8:htdiw72nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn28", "82nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn28:hoverfilter:", ":retlifrevoh:82nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn28filter:", ":retlif82nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn28width:12", "21:htdiw82nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn28width:33333333333333", "33333333333333:htdiw82nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn28width:50", "05:htdiw82nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn29", "92nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn29:hoverfilter:", ":retlifrevoh:92nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn29filter:", ":retlif92nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn29width:12", "21:htdiw92nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn29width:33333333333333", "33333333333333:htdiw92nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn29width:50", "05:htdiw92nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn30", "03nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn30:hoverfilter:", ":retlifrevoh:03nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn30filter:", ":retlif03nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn30width:12", "21:htdiw03nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn30width:33333333333333", "33333333333333:htdiw03nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn30width:50", "05:htdiw03nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn31", "13nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn31:hoverfilter:", ":retlifrevoh:13nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn31filter:", ":retlif13nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn31width:12", "21:htdiw13nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn31width:33333333333333", "33333333333333:htdiw13nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn31width:50", "05:htdiw13nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn32", "23nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn32:hoverfilter:", ":retlifrevoh:23nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn32filter:", ":retlif23nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn32width:12", "21:htdiw23nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn32width:33333333333333", "33333333333333:htdiw23nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn32width:50", "05:htdiw23nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn33", "33nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn33:hoverfilter:", ":retlifrevoh:33nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn33filter:", ":retlif33nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn33width:12", "21:htdiw33nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn33width:33333333333333", "33333333333333:htdiw33nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn33width:50", "05:htdiw33nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn34", "43nmulocdetsenredliubnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn34:hoverfilter:", ":retlifrevoh:43nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn34filter:", ":retlif43nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn34width:100", "001:htdiw43nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn34width:12", "21:htdiw43nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn35", "53nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn35width:100", "001:htdiw53nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn35width:8", "8:htdiw53nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn36", "63nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn36width:100", "001:htdiw63nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn37", "73nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn37width:100", "001:htdiw73nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn38", "83nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn38width:100", "001:htdiw83nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn39", "93nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn39width:100", "001:htdiw93nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn40", "04nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn40width:100", "001:htdiw04nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn41", "14nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn41width:100", "001:htdiw14nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn42", "24nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn42width:100", "001:htdiw24nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn43", "34nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn43width:100", "001:htdiw34nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn44", "44nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn44width:100", "001:htdiw44nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn45", "54nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn45width:100", "001:htdiw54nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn46", "64nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn46width:100", "001:htdiw64nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn47", "74nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn47width:100", "001:htdiw74nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn48", "84nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn48width:100", "001:htdiw84nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn49", "94nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn49width:100", "001:htdiw94nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn50", "05nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn50width:100", "001:htdiw05nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn51", "15nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn51width:100", "001:htdiw15nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn52", "25nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn52width:100", "001:htdiw25nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn53", "35nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionbuildernestedcolumn53width:100", "001:htdiw35nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusioncolumninnerbg", "gbrenninmulocnoisuf", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusioncolumninnerbgmarginleft:calc25px/", "/xp52clac:tfelnigramgbrenninmulocnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "134", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainer", "reniatnocxelfnoisuf", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow10", "01worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow11", "11worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow12", "21worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow13", "31worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow14", "41worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow15", "51worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow16", "61worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow17", "71worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionflexcontainerfusionbuilderrow18", "81worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiongridcolumn", "nmulocdirgnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiongridcolumnpaddingleft:calc25px/", "/xp52clac:tfelgniddapnmulocdirgnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionpostcardimage1", "1egamidractsopnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionpostcardimage1bordertopleftradius:7px", "xp7:suidartfelpotredrob1egamidractsopnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionpostcardsfusionpostcards2", "2sdractsopnoisufsdractsopnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusionrow", "wornoisuf", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle11margintop:5px", "xp5:potnigram11eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle12margintop:5px", "xp5:potnigram21eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle13margintop:5px", "xp5:potnigram31eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle14margintop:5px", "xp5:potnigram41eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle15margintop:5px", "xp5:potnigram51eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle16margintop:5px", "xp5:potnigram61eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle17margintop:5px", "xp5:potnigram71eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle18margintop:5px", "xp5:potnigram81eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle19margintop:5px", "xp5:potnigram91eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitle20margintop:5px", "xp5:potnigram02eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle13", "31eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle14", "41eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle15", "51eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle16", "61eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle17", "71eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle18", "81eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle19", "91eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "fusiontitlefusiontitletextfusiontitle20", "02eltitnoisuftxeteltitnoisufeltitnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "galaxy", "yxalag", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "gps", "spg", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "grid", "dirg", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "hide", "edih", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "icon", "noci", "1", "42", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "image", "egami", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "images", "segami", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "important", "tnatropmi", "1", "408", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "infinite", "etinifni", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "infinitescrollhidedisplay:none", "enon:yalpsidedihllorcsetinifni", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "inner", "renni", "1", "22", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "invert", "trevni", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "invert(0%)", ")%0(trevni", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "invert(10%)", ")%01(trevni", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "invert0", "0trevni", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "invert10", "01trevni", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "iphone", "enohpi", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "iso", "osi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "jootijeans", "snaejitooj", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "kp", "pk", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "kp-2264", "4622-pk", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "kp2264", "4622pk", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "lc", "cl", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "lcw", "wcl", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "lcw-0w5546", "6455w0-wcl", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "lcw0w5546", "6455w0wcl", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left", "tfel", "1", "187", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left:0", "0:tfel", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left:0px", "xp0:tfel", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left:1", "1:tfel", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left:2", "2:tfel", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left:8", "8:tfel", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "left:calc", "clac:tfel", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "lumix", "ximul", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "m51", "15m", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "m515f/dsn", "nsd/f515m", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin", "nigram", "1", "482", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-bottom", "mottob-nigram", "1", "51", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-bottom:10px", "xp01:mottob-nigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-bottom:5px", "xp5:mottob-nigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left", "tfel-nigram", "1", "126", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left:0.98%", "%89.0:tfel-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left:0px", "xp0:tfel-nigram", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left:1.96%", "%69.1:tfel-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left:2.94%", "%49.2:tfel-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left:8.1666666666667%", "%7666666666661.8:tfel-nigram", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-left:calc((25px)/", "/)xp52((clac:tfel-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right", "thgir-nigram", "1", "44", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right:0.98%", "%89.0:thgir-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right:0px", "xp0:thgir-nigram", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right:1.96%", "%69.1:thgir-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right:2.94%", "%49.2:thgir-nigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right:8.1666666666667%", "%7666666666661.8:thgir-nigram", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-right:calc((25px)/", "/)xp52((clac:thgir-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margin-top", "pot-nigram", "1", "53", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginbottom", "mottobnigram", "1", "51", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginbottom:10px", "xp01:mottobnigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginbottom:5px", "xp5:mottobnigram", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft", "tfelnigram", "1", "126", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft:098", "890:tfelnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft:0px", "xp0:tfelnigram", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft:196", "691:tfelnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft:294", "492:tfelnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft:81666666666667", "76666666666618:tfelnigram", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginleft:calc25px/", "/xp52clac:tfelnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright", "thgirnigram", "1", "126", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright:098", "890:thgirnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright:0px", "xp0:thgirnigram", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright:196", "691:thgirnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright:294", "492:thgirnigram", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright:81666666666667", "76666666666618:thgirnigram", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "marginright:calc25px/", "/xp52clac:thgirnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "margintop", "potnigram", "1", "53", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "max", "xam", "1", "104", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "maxwidth:1024px", "xp4201:htdiwxam", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "maxwidth:750px", "xp057:htdiwxam", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "mini", "inim", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "nested", "detsen", "1", "197", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "only", "ylno", "1", "104", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "order", "redro", "1", "84", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "padding", "gniddap", "1", "240", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "padding-bottom", "mottob-gniddap", "1", "59", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "padding-left", "tfel-gniddap", "1", "59", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "padding-right", "thgir-gniddap", "1", "59", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "padding-right:calc((25px)/", "/)xp52((clac:thgir-gniddap", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "padding-top", "pot-gniddap", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "paddingbottom", "mottobgniddap", "1", "59", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "paddingleft", "tfelgniddap", "1", "59", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "paddingright", "thgirgniddap", "1", "59", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "paddingright:calc25px/", "/xp52clac:thgirgniddap", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "paddingtop", "potgniddap", "1", "61", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "pixel", "lexip", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "post", "tsop", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "pro", "orp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "r840", "048r", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "r850", "058r", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "radius:7px", "xp7:suidar", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right", "thgir", "1", "187", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right:0", "0:thgir", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right:0px", "xp0:thgir", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right:1", "1:thgir", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right:2", "2:thgir", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right:8", "8:thgir", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "right:calc", "clac:thgir", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "row", "wor", "1", "30", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "s", "s", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "screen", "neercs", "1", "104", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "scroll", "llorcs", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "sm", "ms", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "sm-m515f/dsn", "nsd/f515m-ms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "sm-r840", "048r-ms", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "sm-r850", "058r-ms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "smm515f/dsn", "nsd/f515mms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "smr840", "048rms", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "smr850", "058rms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "stm", "mts", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "text", "txet", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "title", "eltit", "1", "88", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "top", "pot", "1", "116", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "top:5px", "xp5:pot", "1", "20", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "transition:", ":noitisnart", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ul", "lu", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ul.fusion-grid", "dirg-noisuf.lu", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ul.fusion-grid{margin-right:calc((25px)/", "/)xp52((clac:thgir-nigram{dirg-noisuf.lu", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ulfusiongrid", "dirgnoisuflu", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ulfusiongridmarginright:calc25px/", "/xp52clac:thgirnigramdirgnoisuflu", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "waikiki", "ikikiaw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "watch3", "3hctaw", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:100", "001:htdiw", "1", "81", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:1024px", "xp4201:htdiw", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:12", "21:htdiw", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:25", "52:htdiw", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:33", "33:htdiw", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:50", "05:htdiw", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:66", "66:htdiw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:750px", "xp057:htdiw", "1", "52", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:8", "8:htdiw", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "width:90", "09:htdiw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "wrapper", "repparw", "1", "134", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "آخرین", "نیرخآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "آرا", "ارآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "آرایشی", "یشیارآ", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "آستین:", ":نیتسآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "آقایان", "نایاقآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "آلومینیوم", "موینیمولآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "اپل", "لپا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "اداری", "یرادا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "از", "زا", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "اسپرت", "ترپسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "استایل‌های", "یاه‌لیاتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "استر", "رتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "استقامتی", "یتماقتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "اصلی", "یلصا", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ال", "لا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "اندازه", "هزادنا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "انواع", "عاونا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ایده‌ها", "اه‌هدیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "اینگرسول", "لوسرگنیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "با", "اب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "باقیمانده", "هدنامیقاب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بدن", "ندب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "برای", "یارب", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "برس", "سرب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "برینگ", "گنیرب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بشناسید", "دیسانشب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بعدی", "یدعب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بلند", "دنلب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بهتر", "رتهب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بهترین", "نیرتهب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بهداشتی", "یتشادهب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "بیش", "شیب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پارچه", "هچراپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پایان", "نایاپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پایه", "هیاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پایه:", ":هیاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پاییزه", "هزییاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پسرانه", "هنارسپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پلی", "یلپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پن", "نپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پنبه،", "،هبنپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پوش", "شوپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پوشاک", "کاشوپ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پیراهن", "نهاریپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "پیشنهادهای", "یاهداهنشیپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تا", "ات", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تجهیزات", "تازیهجت", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تحمل", "لمحت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تخفیف", "فیفخت", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تعداد", "دادعت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تمرینات", "تانیرمت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "تومان", "ناموت", "1", "31", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ثانیه", "هیناث", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جامه", "هماج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جای", "یاج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جنس:", ":سنج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جوتی", "یتوج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جوش", "شوج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جیماری", "یرامیج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "جینز", "زنیج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "حساسیت", "تیساسح", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "حسگر", "رگسح", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "خانم‌ها", "اه‌مناخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "خرید", "دیرخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "دارد", "دراد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "در", "رد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "درمان", "نامرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "دو", "ود", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "دوربین", "نیبرود", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "دیجیتال", "لاتیجید", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "را", "ار", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "راهنمای", "یامنهار", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "رسمی", "یمسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "رنگی", "یگنر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "روزمره", "هرمزور", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "زبری:", ":یربز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "زمان", "نامز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "زمستانی", "یناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "زنانه", "هنانز", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ساعت", "تعاس", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سامسونگ", "گنوسماس", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سایز", "زیاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سرعت", "تعرس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سلامتی", "یتمالس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سه", "هس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سویشرت", "ترشیوس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سی", "یس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "سیم", "میس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "شنا", "انش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "صفحه", "هحفص", "1", "2", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "صفحه اصلی رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "صورت", "تروص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ظرفیت", "تیفرظ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "عکاسی", "یساکع", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "فایده", "هدیاف", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "فریم", "میرف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "فوکوس", "سوکوف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "قابلیت", "تیلباق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "قبلی", "یلبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "قد", "دق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "قطعات", "تاعطق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "کاربری", "یربراک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "کارت", "تراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "کالای", "یالاک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "کانن", "نناک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "کد", "دک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "که", "هک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "کیلو", "ولیک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "گوشی", "یشوگ", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "گیگ", "گیگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "گیگ&hellip", "pilleh&گیگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "گیگابایت&hellip", "pilleh&تیاباگیگ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "لباس:", ":سابل", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "لمسی", "یسمل", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "لنز", "زنل", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "لوازم", "مزاول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ماسک", "کسام", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مبلمان", "ناملبم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مچی", "یچم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "محصول", "لوصحم", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "محصول:", ":لوصحم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مد", "دم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مدل", "لدم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مردانه", "هنادرم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مقالات", "تالاقم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مگاپیکسل", "لسکیپاگم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "مناسب", "بسانم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "موبایل", "لیابوم", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نخ", "خن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ندارد", "درادن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نرم", "مرن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نرمی", "یمرن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نصب", "بصن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نقطه", "هطقن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نمایش", "شیامن", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نمی‌روند", "دنور‌یمن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نوع", "عون", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "نیکون", "نوکین", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "هد", "ده", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "هد:", ":ده", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "همه", "همه", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "هودی", "یدوه", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "هوشمند", "دنمشوه", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "هیچ", "چیه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "و", "و", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "والیبال", "لابیلاو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ورزش", "شزرو", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ورزشی", "یشزرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ورساچه", "هچاسرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ورسوس", "سوسرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "وزن:", ":نزو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "وقت", "تقو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("35", "ویژه", "هژیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "&nbsp", "psbn&", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "12", "21", "1", "3", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "content/uploads/2021/02/iphone", "enohpi/20/1202/sdaolpu/tnetnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "http://user", "resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "http://user.iranavada.ir/pro-royal2/wp-content/uploads/2021/02/iphone-12-promax.mp4", "4pm.xamorp-21-enohpi/20/1202/sdaolpu/tnetnoc-pw/2layor-orp/ri.adavanari.resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "http://useriranavadair/proroyal2/wpcontent/uploads/2021/02/iphone12promaxmp4", "4pmxamorp21enohpi/20/1202/sdaolpu/tnetnocpw/2layororp/riadavanariresu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "iphone", "enohpi", "1", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ir/pro", "orp/ri", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "iranavada", "adavanari", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "max", "xam", "1", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "mp4", "4pm", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "pro", "orp", "1", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "promax", "xamorp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "royal2/wp", "pw/2layor", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "آیفون", "نوفیآ", "1", "1", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "از", "زا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "استایل", "لیاتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بخش‌ها", "اه‌شخب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بررسی", "یسررب", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بررسی گوشی iphone 12 pro max", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بصورت", "تروصب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بیرون", "نوریب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "پرومکس", "سکمورپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "توضیح", "حیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "دادیم", "میداد", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "در", "رد", "1", "19", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "درباره", "هرابرد", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "دو", "ود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "رفتن‌های", "یاه‌نتفر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "زمستانی", "یناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "شرح", "حرش", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کامل", "لماک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "گوشی", "یشوگ", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "معرفی", "یفرعم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "میدیم", "میدیم", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "میدیم.", ".میدیم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "نفره", "هرفن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "و", "و", "1", "55", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "ویدئو", "وئدیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("171", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "&nbsp", "psbn&", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "۱۸", "۸۱", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "۱۸ اشتباه رایج در ورزش کردن که تمام تلاشتان ر", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ارتباط", "طابترا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "از", "زا", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "است؟", "؟تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "اشتباه", "هابتشا", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "باد", "داب", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "به", "هب", "1", "3", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تحقیقات", "تاقیقحت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تلاشتان", "ناتشالت", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تمام", "مامت", "1", "3", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "چه", "هچ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "خواب", "باوخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "در", "رد", "1", "20", "1", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "درباره‌ی", "ی‌هرابرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "را", "ار", "1", "8", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "رایج", "جیار", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ساعات", "تاعاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "فنا", "انف", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "قبل", "لبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کردن", "ندرک", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "که", "هک", "1", "8", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "مفید", "دیفم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "مقدار", "رادقم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "مناسب‌اند؟", "؟دنا‌بسانم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "می‌دهند", "دنهد‌یم", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "می‌گویند؟", "؟دنیوگ‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "و", "و", "1", "56", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ورزش", "شزرو", "1", "2", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "ورزش‌هایی", "ییاه‌شزرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("176", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "&nbsp", "psbn&", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "۱۰", "۰۱", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "۱۰ تمرین ورزشی برای تناسب اندام خانم‌ها در خا", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ارتباط", "طابترا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "از", "زا", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "است؟", "؟تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "اندام", "مادنا", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "برای", "یارب", "1", "10", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تحقیقات", "تاقیقحت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تمرین", "نیرمت", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تناسب", "بسانت", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "چه", "هچ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "خانم‌ها", "اه‌مناخ", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "خانه", "هناخ", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "خواب", "باوخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "در", "رد", "1", "20", "1", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "درباره‌ی", "ی‌هرابرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ساعات", "تاعاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "قبل", "لبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "مفید", "دیفم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "مقدار", "رادقم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "مناسب‌اند؟", "؟دنا‌بسانم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "می‌گویند؟", "؟دنیوگ‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "و", "و", "1", "56", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ورزش", "شزرو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ورزش‌هایی", "ییاه‌شزرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "ورزشی", "یشزرو", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("183", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "-", "-", "1", "61", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "–", "–", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ":", ":", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ".fusion-body", "ydob-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ".fusion-breadcrumbs.fusion-breadcrumbs-2{font-size:12px", "xp21:ezis-tnof{2-sbmurcdaerb-noisuf.sbmurcdaerb-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ".fusion-builder-column-1{width:100%", "%001:htdiw{1-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ".fusion-flex-container.fusion-builder-row-2{", "{2-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "(max-width:640px)", ")xp046:htdiw-xam(", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "(کیت)", ")تیک(", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "{.fusion-body", "ydob-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "{.fusion-title.fusion-title-2{margin-top:5px", "xp5:pot-nigram{2-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "{margin-right", "thgir-nigram{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "{padding-top", "pot-gniddap{", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}", "}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}.fusion-breadcrumbs.fusion-breadcrumbs-2", "2-sbmurcdaerb-noisuf.sbmurcdaerb-noisuf.}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}.fusion-breadcrumbs.fusion-breadcrumbs-2{color:#607d8b", "b8d706#:roloc{2-sbmurcdaerb-noisuf.sbmurcdaerb-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}.fusion-builder-column-1", "1-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}}", "}}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}}@media", "aidem@}}", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "}@media", "aidem@}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "@media", "aidem@", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "/", "/", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", ">", ">", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "0", "0", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "0.98%", "%89.0", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "000&nbsp", "psbn&000", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "040", "040", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "098", "890", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "0px", "xp0", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "1", "1", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "100", "001", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "100-25600", "00652-001", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "10025600", "00652001", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "110", "011", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "131x100x76", "67x001x131", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "2", "2", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "2%", "%2", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "20", "02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "20,100,000&nbsp", "psbn&000,001,02", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "20100000&nbsp", "psbn&00000102", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "25600", "00652", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "30px", "xp03", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "336", "633", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "53", "35", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "549", "945", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "549,000&nbsp", "psbn&000,945", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "549000&nbsp", "psbn&000945", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "6", "6", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "6,040,000&nbsp", "psbn&000,040,6", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "6040000&nbsp", "psbn&0000406", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "60px", "xp06", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "655", "556", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "7", "7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "7,336,000&nbsp", "psbn&000,633,7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "7336000&nbsp", "psbn&0006337", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "77d", "d77", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "98", "89", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "a", "a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "a:hover", "revoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "a:hover{color:#48cab2", "2bac84#:roloc{revoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "a:hovercolor:#48cab2", "2bac84#:rolocrevoh:a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "a{color:#607d8b", "b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "acolor:#607d8b", "b8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "and", "dna", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "aps", "spa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "aps-c", "c-spa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "apsc", "cspa", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "body", "ydob", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "bottom", "mottob", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "bottom:10px", "xp01:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "bottom:5px", "xp5:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "breadcrumbs", "sbmurcdaerb", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "builder", "redliub", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "c", "c", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "canon", "nonac", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "color:#48cab2", "2bac84#:roloc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "color:#607d8b", "b8d706#:roloc", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "column", "nmuloc", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "container", "reniatnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "dslr", "rlsd", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "dx", "xd", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "dx+", "+xd", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "eos", "soe", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "flex", "xelf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "font", "tnof", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusion", "noisuf", "1", "27", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionbody", "ydobnoisuf", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionbreadcrumbsfusionbreadcrumbs2", "2sbmurcdaerbnoisufsbmurcdaerbnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionbreadcrumbsfusionbreadcrumbs2color:#607d8b", "b8d706#:roloc2sbmurcdaerbnoisufsbmurcdaerbnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionbreadcrumbsfusionbreadcrumbs2fontsize:12px", "xp21:ezistnof2sbmurcdaerbnoisufsbmurcdaerbnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionbuildercolumn1", "1nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionbuildercolumn1width:100", "001:htdiw1nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusionflexcontainerfusionbuilderrow2", "2worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "fusiontitlefusiontitle2margintop:5px", "xp5:potnigram2eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "galaxy", "yxalag", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "important", "tnatropmi", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "iso", "osi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "jeanswest", "tsewsnaej", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "kit", "tik", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "left", "tfel", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin", "nigram", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin-bottom", "mottob-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin-bottom:10px", "xp01:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin-bottom:5px", "xp5:mottob-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin-left", "tfel-nigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin-right", "thgir-nigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margin-top", "pot-nigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "marginbottom", "mottobnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "marginbottom:10px", "xp01:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "marginbottom:5px", "xp5:mottobnigram", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "marginleft", "tfelnigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "marginright", "thgirnigram", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "margintop", "potnigram", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "max", "xam", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "maxwidth:1024px", "xp4201:htdiwxam", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "maxwidth:640px", "xp046:htdiwxam", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "only", "ylno", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "padding", "gniddap", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "padding-bottom", "mottob-gniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "padding-left", "tfel-gniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "padding-right", "thgir-gniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "padding-top", "pot-gniddap", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "paddingbottom", "mottobgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "paddingleft", "tfelgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "paddingright", "thgirgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "paddingtop", "potgniddap", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "r850", "058r", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "right", "thgir", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "row", "wor", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "screen", "neercs", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "size:12px", "xp21:ezis", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "sm", "ms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "sm-r850", "058r-ms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "smr850", "058rms", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "span", "naps", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "title", "eltit", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "top", "pot", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "top:5px", "xp5:pot", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "watch3", "3hctaw", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "width:100", "001:htdiw", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "width:1024px", "xp4201:htdiw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "width:640px", "xp046:htdiw", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "wrapper", "repparw", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "آقایان", "نایاقآ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ابعاد", "داعبا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "اتوکشی", "یشکوتا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "افزودن", "ندوزفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "امکان", "ناکما", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "اینگرسول", "لوسرگنیا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "با", "اب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "بدنه", "هندب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "برای", "یارب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "بسته", "هتسب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "بند", "دنب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "به", "هب", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "پاییز", "زییاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "پاییزه", "هزییاپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "پیراهن", "نهاریپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "تومان", "ناموت", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "جلوبسته", "هتسبولج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "جنس", "سنج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "جیب", "بیج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "جین", "نیج", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "حساسیت", "تیساسح", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "حسگر", "رگسح", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "خانم‌ها", "اه‌مناخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "خانه", "هناخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "خرید", "دیرخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "خشک‌شویی", "ییوش‌کشخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "خیر", "ریخ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "دارد", "دراد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "دامنه", "هنماد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "درجه", "هجرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "دستی", "یتسد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "دمای", "یامد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "دوربین", "نیبرود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "رسمی", "یمسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "رنگ", "گنر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "رنگ‌های", "یاه‌گنر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "روزمره", "هرمزور", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "رویال", "لایور", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "زمستان", "ناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "زنانه", "هنانز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ساده", "هداس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "سازنده", "هدنزاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ساعت", "تعاس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "سامسونگ", "گنوسماس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "سانتی‌گراد", "دارگ‌یتناس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "سبد", "دبس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "سگکی", "یکگس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "شدن", "ندش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "شرکت", "تکرش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "شستشو", "وشتسش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "شیشه", "هشیش", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "صفحه", "هحفص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "صورت", "تروص", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ضد", "دض", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "طرح", "حرط", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "عکاسی", "یساکع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "عنوان", "ناونع", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "فرم", "مرف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "فصول", "لوصف", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "فلز", "زلف", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "قفل", "لفق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "کاربری", "یربراک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "کالا", "الاک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "کانن", "نناک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "کلاه", "هالک", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "کیت", "تیک", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "گرد", "درگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "گرم", "مرگ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "گلس", "سلگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "گوریلا", "الیروگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "لنز", "زنل", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ماشینی", "ینیشام", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ماکزیمم", "ممیزکام", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مبلغ", "غلبم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مجزا", "ازجم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "محصولات", "تالوصحم", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مدل", "لدم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مردانه", "هنادرم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مشابه", "هباشم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مشکی", "یکشم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مقایسه", "هسیاقم", "1", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مقایسه محصولات رویال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "مناسب", "بسانم", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "میلیمتر", "رتمیلیم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "نحوه", "هوحن", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ندارد", "درادن", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "نفوذ", "ذوفن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "نوع", "عون", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "همراه", "هارمه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "هوشمند", "دنمشوه", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "ورزشی", "یشزرو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "وزن", "نزو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "وست", "تسو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("916", "یا", "ای", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "&nbsp", "psbn&", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "12", "21", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "5", "5", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "5 برند برتر ساعت هوشمند", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "content/uploads/2021/02/iphone", "enohpi/20/1202/sdaolpu/tnetnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "http://user", "resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "http://user.iranavada.ir/pro-royal2/wp-content/uploads/2021/02/iphone-12-promax.mp4", "4pm.xamorp-21-enohpi/20/1202/sdaolpu/tnetnoc-pw/2layor-orp/ri.adavanari.resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "http://useriranavadair/proroyal2/wpcontent/uploads/2021/02/iphone12promaxmp4", "4pmxamorp21enohpi/20/1202/sdaolpu/tnetnocpw/2layororp/riadavanariresu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "iphone", "enohpi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ir/pro", "orp/ri", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "iranavada", "adavanari", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "max", "xam", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "mp4", "4pm", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "pro", "orp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "promax", "xamorp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "royal2/wp", "pw/2layor", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "آیفون", "نوفیآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "از", "زا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "استایل", "لیاتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "برتر", "رترب", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بررسی", "یسررب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "برند", "دنرب", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بیرون", "نوریب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "پرومکس", "سکمورپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "در", "رد", "1", "19", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "دنیا", "ایند", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "دو", "ود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "رفتن‌های", "یاه‌نتفر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "زمستانی", "یناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ساعت", "تعاس", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "گوشی", "یشوگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "معرفی", "یفرعم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "نفره", "هرفن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "هوشمند", "دنمشوه", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "و", "و", "1", "55", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "ویدئو", "وئدیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("949", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "&nbsp", "psbn&", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "12", "21", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "content/uploads/2021/02/iphone", "enohpi/20/1202/sdaolpu/tnetnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "http://user", "resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "http://user.iranavada.ir/proroyal1400/wp-content/uploads/2021/02/iphone-12-promax.mp4", "4pm.xamorp-21-enohpi/20/1202/sdaolpu/tnetnoc-pw/0041layororp/ri.adavanari.resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "http://useriranavadair/proroyal1400/wpcontent/uploads/2021/02/iphone12promaxmp4", "4pmxamorp21enohpi/20/1202/sdaolpu/tnetnocpw/0041layororp/riadavanariresu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "iphone", "enohpi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ir/proroyal1400/wp", "pw/0041layororp/ri", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "iranavada", "adavanari", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "max", "xam", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "mp4", "4pm", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "pro", "orp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "promax", "xamorp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "s21", "12s", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "آیفون", "نوفیآ", "1", "1", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "از", "زا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "استایل", "لیاتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "اولترا", "ارتلوا", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "با", "اب", "1", "21", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بررسی", "یسررب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بیرون", "نوریب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "پرو", "ورپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "پرومکس", "سکمورپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "در", "رد", "1", "19", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "درباره", "هرابرد", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "دو", "ود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "دوربین", "نیبرود", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "رفتن‌های", "یاه‌نتفر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "زمستانی", "یناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "سلفی", "یفلس", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گلکسی", "یسکلگ", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گوشی", "یشوگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "معرفی", "یفرعم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "مقایسه", "هسیاقم", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "مقایسه دوربین گلکسی s21 اولترا با آیفون ۱۲", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "مکس", "سکم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "میخوایم", "میاوخیم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "نفره", "هرفن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "و", "و", "1", "55", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "ویدئو", "وئدیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("959", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "&nbsp", "psbn&", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "12", "21", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "۲۰۲۱", "۱۲۰۲", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "۵", "۵", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "۸", "۸", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "۸ موبایل ضد آب برتر که می‌توانید بخرید", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "content/uploads/2021/02/iphone", "enohpi/20/1202/sdaolpu/tnetnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "http://user", "resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "http://user.iranavada.ir/proroyal1400/wp-content/uploads/2021/02/iphone-12-promax.mp4", "4pm.xamorp-21-enohpi/20/1202/sdaolpu/tnetnoc-pw/0041layororp/ri.adavanari.resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "http://useriranavadair/proroyal1400/wpcontent/uploads/2021/02/iphone12promaxmp4", "4pmxamorp21enohpi/20/1202/sdaolpu/tnetnocpw/0041layororp/riadavanariresu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "iphone", "enohpi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ir/proroyal1400/wp", "pw/0041layororp/ri", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "iranavada", "adavanari", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "max", "xam", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "mp4", "4pm", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "pro", "orp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "promax", "xamorp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "آب", "بآ", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "آیفون", "نوفیآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "از", "زا", "1", "12", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "استایل", "لیاتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "انتظار", "راظتنا", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بخرید", "دیرخب", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "برتر", "رترب", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بررسی", "یسررب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بیرون", "نوریب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "پرومکس", "سکمورپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "جذاب", "باذج", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "داریم", "میراد", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "در", "رد", "1", "19", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "درباره", "هرابرد", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "دو", "ود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "رفتن‌های", "یاه‌نتفر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "زمستانی", "یناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "سال", "لاس", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ضد", "دض", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "که", "هک", "1", "8", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گوشی", "یشوگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گوشی‌های", "یاه‌یشوگ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "معرفی", "یفرعم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "موبایل", "لیابوم", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "می‌توانید", "دیناوت‌یم", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "میخوایم", "میاوخیم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "نفره", "هرفن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "هوشمند", "دنمشوه", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "و", "و", "1", "55", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ویدئو", "وئدیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "ویژگی", "یگژیو", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("960", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "&nbsp", "psbn&", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "10", "01", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "10 تکنیک عکاسی در طبیعت را یاد بگیرید", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "12", "21", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "content/uploads/2021/02/iphone", "enohpi/20/1202/sdaolpu/tnetnoc", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "http://user", "resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "http://user.iranavada.ir/pro-royal2/wp-content/uploads/2021/02/iphone-12-promax.mp4", "4pm.xamorp-21-enohpi/20/1202/sdaolpu/tnetnoc-pw/2layor-orp/ri.adavanari.resu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "http://useriranavadair/proroyal2/wpcontent/uploads/2021/02/iphone12promaxmp4", "4pmxamorp21enohpi/20/1202/sdaolpu/tnetnocpw/2layororp/riadavanariresu//:ptth", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "iphone", "enohpi", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ir/pro", "orp/ri", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "iranavada", "adavanari", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "max", "xam", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "mp4", "4pm", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "pro", "orp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "promax", "xamorp", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "royal2/wp", "pw/2layor", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "آیفون", "نوفیآ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "از", "زا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "استایل", "لیاتسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بررسی", "یسررب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بگیرید", "دیریگب", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بیرون", "نوریب", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "پرومکس", "سکمورپ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "تکنیک", "کینکت", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "در", "رد", "1", "19", "1", "0", "0", "0", "0", "0", "3", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "درباره", "هرابرد", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "دو", "ود", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "را", "ار", "1", "8", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "رفتن‌های", "یاه‌نتفر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "زمستانی", "یناتسمز", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "طبیعت", "تعیبط", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "عکاسی", "یساکع", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "گوشی", "یشوگ", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "معرفی", "یفرعم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "نفره", "هرفن", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "و", "و", "1", "55", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "ویدئو", "وئدیو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("961", "یاد", "دای", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "&nbsp", "psbn&", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "10", "01", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "10 فایده ورزش شنا برای بدن", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "۲۳", "۳۲", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ارتباط", "طابترا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "از", "زا", "1", "13", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "است؟", "؟تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بخورید", "دیروخب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بدن", "ندب", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "برای", "یارب", "1", "10", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بعد", "دعب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "تحقیقات", "تاقیقحت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "چه", "هچ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "خواب", "باوخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "خوراکی", "یکاروخ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "در", "رد", "1", "20", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "درباره‌ی", "ی‌هرابرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ساعات", "تاعاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "شنا", "انش", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "فایده", "هدیاف", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "قبل", "لبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "مفید", "دیفم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "مقدار", "رادقم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "مناسب‌اند؟", "؟دنا‌بسانم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "می‌گویند؟", "؟دنیوگ‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "نباید", "دیابن", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "نوشیدنی", "یندیشون", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "هرگز", "زگره", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "و", "و", "1", "56", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ورزش", "شزرو", "1", "2", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "ورزش‌هایی", "ییاه‌شزرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("974", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "&nbsp", "psbn&", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ارتباط", "طابترا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "از", "زا", "1", "13", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "است؟", "؟تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "استقامتی", "یتماقتسا", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "برای", "یارب", "1", "10", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بعد", "دعب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بهترین", "نیرتهب", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بهترین تمرینات استقامتی والیبال", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تحقیقات", "تاقیقحت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تغذیه", "هیذغت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تمرینات", "تانیرمت", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "چه", "هچ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "خواب", "باوخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "در", "رد", "1", "20", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "درباره‌ی", "ی‌هرابرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ریکاوری", "یرواکیر", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ساعات", "تاعاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "سریع‌تر", "رت‌عیرس", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "عضله‌سازی", "یزاس‌هلضع", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "قبل", "لبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "مفید", "دیفم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "مقدار", "رادقم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "مناسب‌اند؟", "؟دنا‌بسانم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "می‌گویند؟", "؟دنیوگ‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "و", "و", "1", "56", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "والیبال", "لابیلاو", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ورزش", "شزرو", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "ورزش‌هایی", "ییاه‌شزرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("975", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "&nbsp", "psbn&", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "10", "01", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "10 فایده دو برای بدن", "", "1", "0", "1", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "آینده", "هدنیآ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ابزارهای", "یاهرازبا", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ارائه", "هئارا", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ارتباط", "طابترا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "از", "زا", "1", "13", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "اساسا", "اساسا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "است", "تسا", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "است؟", "؟تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "است.", ".تسا", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "استفاده", "هدافتسا", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "اصلی", "یلصا", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "افزارها", "اهرازفا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "الخصوص", "صوصخلا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "امید", "دیما", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "اهل", "لها", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ای", "یا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ایپسوم", "موسپیا", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ایجاد", "داجیا", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "این", "نیا", "1", "3", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "با", "اب", "1", "21", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "باشد", "دشاب", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "باشد.", ".دشاب", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "بدن", "ندب", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "بدید", "دیدب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "برای", "یارب", "1", "10", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "بلکه", "هکلب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "بنویسید:", ":دیسیونب", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "به", "هب", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "بهبود", "دوبهب", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "بیشتری", "یرتشیب", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "پایان", "نایاپ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "پست", "تسپ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "پیشرو", "ورشیپ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "پیوسته", "هتسویپ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "تا", "ات", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "تایپ", "پیات", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "تحقیقات", "تاقیقحت", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "تکنولوژی", "یژولونکت", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "تمام", "مامت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "توان", "ناوت", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "توضیحات", "تاحیضوت", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "تولید", "دیلوت", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "جامعه", "هعماج", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "جوابگوی", "یوگباوج", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "چاپ", "پاچ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "چاپگرها", "اهرگپاچ", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "چکیده", "هدیکچ", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "چه", "هچ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "حال", "لاح", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "حروفچینی", "ینیچفورح", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "خلاقی", "یقالخ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "خواب", "باوخ", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "داشت", "تشاد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "در", "رد", "1", "20", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "درباره‌ی", "ی‌هرابرد", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "درصد", "دصرد", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "دستاوردهای", "یاهدرواتسد", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "دشواری", "یراوشد", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "دنیای", "یایند", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "دو", "ود", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "را", "ار", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "راهکارها", "اهراکهار", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "رایانه", "هنایار", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "رسد", "دسر", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "رسد.", ".دسر", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "رو", "ور", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "روزنامه", "همانزور", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "زبان", "نابز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "زیادی", "یدایز", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ساختگی", "یگتخاس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "سادگی", "یگداس", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ساعات", "تاعاس", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ستون", "نوتس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "سخت", "تخس", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "سطرآنچنان", "نانچنآرطس", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "سه", "هس", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "سوالات", "تالاوس", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "شامل", "لماش", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "شرایط", "طیارش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "شصت", "تصش", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "شناخت", "تخانش", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "صحبت", "تبحص", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "صنعت", "تعنص", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "صورت", "تروص", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "طراحان", "ناحارط", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "طراحی", "یحارط", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "طلبد", "دبلط", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "علی", "یلع", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "فارسی", "یسراف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "فایده", "هدیاف", "1", "0", "1", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "فراوان", "ناوارف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "فرهنگ", "گنهرف", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "فعلی", "یلعف", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "قبل", "لبق", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "قرار", "رارق", "1", "2", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "قسمت", "تمسق", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کاربردهای", "یاهدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کاربردی", "یدربراک", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کتابهای", "یاهباتک", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کرد", "درک", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کرد.", ".درک", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کنیم", "مینک", "1", "0", "0", "0", "0", "0", "0", "0", "2", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کنیم.", ".مینک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "که", "هک", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "کوتاه", "هاتوک", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "گذشته،", "،هتشذگ", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "گرافیک", "کیفارگ", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "گیرد", "دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "گیرد.لورم", "مرول.دریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "گیردلورم", "مرولدریگ", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "لازم", "مزال", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "لورم", "مرول", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "متخصصان", "ناصصختم", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "متن", "نتم", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "متنوع", "عونتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "متون", "نوتم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "مثلا", "الثم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "مجله", "هلجم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "مفید", "دیفم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "مقدار", "رادقم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "مناسب‌اند؟", "؟دنا‌بسانم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "موجود", "دوجوم", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "مورد", "دروم", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "می", "یم", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "می‌تونید", "دینوت‌یم", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "می‌گویند؟", "؟دنیوگ‌یم", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "نامفهوم", "موهفمان", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "نرم", "مرن", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "نیاز", "زاین", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "هدف", "فده", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "و", "و", "1", "56", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ورزش", "شزرو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "ورزش‌هایی", "ییاه‌شزرو", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "وزمان", "نامزو", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("976", "یا", "ای", "1", "0", "0", "0", "0", "0", "0", "0", "1", "0", "0", "post", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "-15px", "xp51-", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "-2)", ")2-", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "-20px", "xp02-", "1", "17", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ":", ":", "1", "1007", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".crossfade-images{background-color:#48cab2", "2bac84#:roloc-dnuorgkcab{segami-edafssorc.", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-body", "ydob-noisuf.", "1", "64", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-34{width:100%", "%001:htdiw{43-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-35{width:100%", "%001:htdiw{53-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-35{width:66.666666666667%", "%766666666666.66:htdiw{53-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-36{width:100%", "%001:htdiw{63-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-36{width:33.333333333333%", "%333333333333.33:htdiw{63-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-37{width:100%", "%001:htdiw{73-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-38{width:100%", "%001:htdiw{83-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-39", "93-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-40", "04-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-41", "14-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-42", "24-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-43", "34-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-44", "44-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-45{width:100%", "%001:htdiw{54-nmuloc-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-46", "64-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-47", "74-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-48", "84-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-49", "94-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-50", "05-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-51{width:100%", "%001:htdiw{15-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-51{width:50%", "%05:htdiw{15-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-52", "25-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-53", "35-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-54", "45-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-55", "55-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-56{width:100%", "%001:htdiw{65-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-56{width:50%", "%05:htdiw{65-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-57", "75-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-58", "85-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-59", "95-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-60", "06-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-61{width:100%", "%001:htdiw{16-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-61{width:80%", "%08:htdiw{16-nmuloc-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-62", "26-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-63", "36-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-64", "46-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-65", "56-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-66", "66-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-column-67", "76-nmuloc-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-50{width:100%", "%001:htdiw{05-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-50{width:33.333333333333%", "%333333333333.33:htdiw{05-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-51{width:100%", "%001:htdiw{15-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-51{width:66.666666666667%", "%766666666666.66:htdiw{15-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-52{width:100%", "%001:htdiw{25-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-52{width:33.333333333333%", "%333333333333.33:htdiw{25-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-53{width:100%", "%001:htdiw{35-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-53{width:66.666666666667%", "%766666666666.66:htdiw{35-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-54{width:100%", "%001:htdiw{45-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-54{width:33.333333333333%", "%333333333333.33:htdiw{45-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-55{width:100%", "%001:htdiw{55-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-55{width:66.666666666667%", "%766666666666.66:htdiw{55-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-56{width:100%", "%001:htdiw{65-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-56{width:33.333333333333%", "%333333333333.33:htdiw{65-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-57{width:100%", "%001:htdiw{75-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-57{width:66.666666666667%", "%766666666666.66:htdiw{75-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-58{width:100%", "%001:htdiw{85-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-58{width:33.333333333333%", "%333333333333.33:htdiw{85-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-59{width:100%", "%001:htdiw{95-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-59{width:66.666666666667%", "%766666666666.66:htdiw{95-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-60{width:100%", "%001:htdiw{06-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-60{width:33.333333333333%", "%333333333333.33:htdiw{06-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-61{width:100%", "%001:htdiw{16-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-61{width:66.666666666667%", "%766666666666.66:htdiw{16-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-62{width:100%", "%001:htdiw{26-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-62{width:40%", "%04:htdiw{26-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-63{width:100%", "%001:htdiw{36-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-63{width:60%", "%06:htdiw{36-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-64{width:100%", "%001:htdiw{46-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-64{width:40%", "%04:htdiw{46-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-65{width:100%", "%001:htdiw{56-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-65{width:60%", "%06:htdiw{56-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-66{width:100%", "%001:htdiw{66-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-66{width:40%", "%04:htdiw{66-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-67{width:100%", "%001:htdiw{76-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-67{width:60%", "%06:htdiw{76-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-68{width:100%", "%001:htdiw{86-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-68{width:40%", "%04:htdiw{86-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-69{width:100%", "%001:htdiw{96-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-69{width:60%", "%06:htdiw{96-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-70{width:100%", "%001:htdiw{07-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-70{width:40%", "%04:htdiw{07-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-71{width:100%", "%001:htdiw{17-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-71{width:60%", "%06:htdiw{17-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-72{width:100%", "%001:htdiw{27-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-73{width:100%", "%001:htdiw{37-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-74{width:100%", "%001:htdiw{47-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-74{width:33.333333333333%", "%333333333333.33:htdiw{47-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-75{width:100%", "%001:htdiw{57-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-75{width:66.666666666667%", "%766666666666.66:htdiw{57-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-76{width:100%", "%001:htdiw{67-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-76{width:33.333333333333%", "%333333333333.33:htdiw{67-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-77{width:100%", "%001:htdiw{77-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-77{width:66.666666666667%", "%766666666666.66:htdiw{77-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-78{width:100%", "%001:htdiw{87-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-78{width:33.333333333333%", "%333333333333.33:htdiw{87-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-79{width:100%", "%001:htdiw{97-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-79{width:66.666666666667%", "%766666666666.66:htdiw{97-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-80{width:100%", "%001:htdiw{08-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-81{width:100%", "%001:htdiw{18-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-82{width:100%", "%001:htdiw{28-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-82{width:33.333333333333%", "%333333333333.33:htdiw{28-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-83{width:100%", "%001:htdiw{38-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-83{width:66.666666666667%", "%766666666666.66:htdiw{38-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-84{width:100%", "%001:htdiw{48-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-84{width:33.333333333333%", "%333333333333.33:htdiw{48-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-85{width:100%", "%001:htdiw{58-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-85{width:66.666666666667%", "%766666666666.66:htdiw{58-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-86{width:100%", "%001:htdiw{68-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-86{width:33.333333333333%", "%333333333333.33:htdiw{68-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-87{width:100%", "%001:htdiw{78-nmuloc-detsen-redliub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-87{width:66.666666666667%", "%766666666666.66:htdiw{78-nmuloc-detsen-redliub-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-88{width:100%", "%001:htdiw{88-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-89{width:100%", "%001:htdiw{98-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-90{width:100%", "%001:htdiw{09-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-91{width:100%", "%001:htdiw{19-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-92{width:100%", "%001:htdiw{29-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-93{width:100%", "%001:htdiw{39-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-94{width:100%", "%001:htdiw{49-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-95{width:100%", "%001:htdiw{59-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-96{width:100%", "%001:htdiw{69-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-97{width:100%", "%001:htdiw{79-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-98{width:100%", "%001:htdiw{89-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-builder-nested-column-99{width:100%", "%001:htdiw{99-nmuloc-detsen-redliub-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-button.button-4", "4-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-button.button-5", "5-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-button.button-6", "6-nottub.nottub-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-column-inner-bg{margin-left:calc((30px)/", "/)xp03((clac:tfel-nigram{gb-renni-nmuloc-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-column-inner-bg{margin-left:calc((50px)/", "/)xp05((clac:tfel-nigram{gb-renni-nmuloc-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-column-inner-bg{margin-top:calc((1px)/", "/)xp1((clac:pot-nigram{gb-renni-nmuloc-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-column-inner-bg{margin-top:calc((52px)/", "/)xp25((clac:pot-nigram{gb-renni-nmuloc-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-column-wrapper", "repparw-nmuloc-noisuf.", "1", "202", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-flex-container.fusion-builder-row-10{", "{01-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-flex-container.fusion-builder-row-6{", "{6-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-flex-container.fusion-builder-row-7{", "{7-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-flex-container.fusion-builder-row-8{", "{8-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-flex-container.fusion-builder-row-9{", "{9-wor-redliub-noisuf.reniatnoc-xelf-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid", "dirg-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column", "nmuloc-dirg-noisuf.", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column{padding-left:calc((30px)/", "/)xp03((clac:tfel-gniddap{nmuloc-dirg-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column{padding-left:calc((50px)/", "/)xp05((clac:tfel-gniddap{nmuloc-dirg-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column{padding-top:calc((1px)/", "/)xp1((clac:pot-gniddap{nmuloc-dirg-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column{padding-top:calc((52px)/", "/)xp25((clac:pot-gniddap{nmuloc-dirg-noisuf.", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column{width:100%", "%001:htdiw{nmuloc-dirg-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-grid-column{width:50%", "%05:htdiw{nmuloc-dirg-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-13{color:#a3a3a3", "3a3a3a#:roloc{31-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-14{color:#a3a3a3", "3a3a3a#:roloc{41-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-15{color:#a3a3a3", "3a3a3a#:roloc{51-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-16{color:#a3a3a3", "3a3a3a#:roloc{61-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-17{color:#a3a3a3", "3a3a3a#:roloc{71-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-18{color:#a3a3a3", "3a3a3a#:roloc{81-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-19{color:#a3a3a3", "3a3a3a#:roloc{91-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-20{color:#a3a3a3", "3a3a3a#:roloc{02-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-21{color:#a3a3a3", "3a3a3a#:roloc{12-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-22{color:#a3a3a3", "3a3a3a#:roloc{22-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-23{color:#a3a3a3", "3a3a3a#:roloc{32-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-meta-tb.fusion-meta-tb-24{color:#a3a3a3", "3a3a3a#:roloc{42-bt-atem-noisuf.bt-atem-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-card-image-1", "1-egami-drac-tsop-noisuf.", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-card-image-1{border-top-left-radius:7px", "xp7:suidar-tfel-pot-redrob{1-egami-drac-tsop-noisuf.", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-10", "01-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-11", "11-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-12", "21-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-13", "31-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-14", "41-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-8", "8-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".fusion-post-cards.fusion-post-cards-9", "9-sdrac-tsop-noisuf.sdrac-tsop-noisuf.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ".infinite-scroll-hide{display:none", "enon:yalpsid{edih-llorcs-etinifni.", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "(max-width:1024px)", ")xp4201:htdiw-xam(", "1", "91", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "(max-width:750px)", ")xp057:htdiw-xam(", "1", "91", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{", "{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-body", "ydob-noisuf.{", "1", "118", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-32{margin-top:5px", "xp5:pot-nigram{23-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-33{margin-top:5px", "xp5:pot-nigram{33-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-34{margin-top:5px", "xp5:pot-nigram{43-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-35{margin-top:5px", "xp5:pot-nigram{53-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-36{margin-top:5px", "xp5:pot-nigram{63-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-37{margin-top:5px", "xp5:pot-nigram{73-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-38{margin-top:5px", "xp5:pot-nigram{83-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-39{margin-top:5px", "xp5:pot-nigram{93-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-40{margin-top:5px", "xp5:pot-nigram{04-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-41{margin-top:5px", "xp5:pot-nigram{14-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-42{margin-top:5px", "xp5:pot-nigram{24-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-43{margin-top:5px", "xp5:pot-nigram{34-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-44{margin-top:5px", "xp5:pot-nigram{44-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-45{margin-top:5px", "xp5:pot-nigram{54-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-46{margin-top:5px", "xp5:pot-nigram{64-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-47{margin-top:5px", "xp5:pot-nigram{74-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-48{margin-top:5px", "xp5:pot-nigram{84-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-49{margin-top:5px", "xp5:pot-nigram{94-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-50{margin-top:5px", "xp5:pot-nigram{05-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-51{margin-top:5px", "xp5:pot-nigram{15-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-52{margin-top:5px", "xp5:pot-nigram{25-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-53{margin-top:5px", "xp5:pot-nigram{35-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-54{margin-top:5px", "xp5:pot-nigram{45-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-55{margin-top:5px", "xp5:pot-nigram{55-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-56{margin-top:5px", "xp5:pot-nigram{65-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-57{margin-top:5px", "xp5:pot-nigram{75-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-58{margin-top:5px", "xp5:pot-nigram{85-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-59{margin-top:5px", "xp5:pot-nigram{95-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-60{margin-top:5px", "xp5:pot-nigram{06-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-61{margin-top:5px", "xp5:pot-nigram{16-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{.fusion-title.fusion-title-62{margin-top:5px", "xp5:pot-nigram{26-eltit-noisuf.eltit-noisuf.{", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{border-radius:4px", "xp4:suidar-redrob{", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{margin-right", "thgir-nigram{", "1", "84", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{padding-right", "thgir-gniddap{", "1", "34", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "{padding-top", "pot-gniddap{", "1", "84", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}", "}", "1", "54", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-34", "43-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-35", "53-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-36", "63-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-37", "73-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-38", "83-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-45", "54-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-51", "15-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-56", "65-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-column-61", "16-nmuloc-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-50", "05-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-51", "15-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-52", "25-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-53", "35-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-54", "45-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-55", "55-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-56", "65-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-57", "75-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-58", "85-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-59", "95-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-60", "06-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-61", "16-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-62", "26-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-63", "36-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-64", "46-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-65", "56-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-66", "66-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-67", "76-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-68", "86-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-69", "96-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-70", "07-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-71", "17-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-72", "27-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-73", "37-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-74", "47-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-75", "57-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-76", "67-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-77", "77-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-78", "87-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-79", "97-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-80", "08-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-81", "18-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-82", "28-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-83", "38-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-84", "48-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-85", "58-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-86", "68-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-87", "78-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-88", "88-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-89", "98-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-90", "09-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-91", "19-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-92", "29-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-93", "39-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-94", "49-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-95", "59-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-96", "69-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-97", "79-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-98", "89-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-builder-nested-column-99", "99-nmuloc-detsen-redliub-noisuf.}", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-13", "31-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-14", "41-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-15", "51-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-16", "61-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-17", "71-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-18", "81-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-19", "91-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-20", "02-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-21", "12-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-22", "22-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-23", "32-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-meta-tb.fusion-meta-tb-24", "42-bt-atem-noisuf.bt-atem-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-10", "01-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-10{margin-bottom:65px", "xp56:mottob-nigram{01-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-11", "11-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-12", "21-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-12{margin-bottom:65px", "xp56:mottob-nigram{21-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-13", "31-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-14", "41-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-8", "8-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-9", "9-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}.fusion-post-cards.fusion-post-cards-9{margin-bottom:50px", "xp05:mottob-nigram{9-sdrac-tsop-noisuf.sdrac-tsop-noisuf.}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}", "}}", "1", "65", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-34", "43-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-35", "53-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-36", "63-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-37", "73-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-38", "83-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-39", "93-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-41", "14-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-42", "24-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-43", "34-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-44", "44-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-45", "54-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-47", "74-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-48", "84-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-49", "94-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-50", "05-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-52", "25-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-53", "35-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-54", "45-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-55", "55-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-57", "75-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-58", "85-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-59", "95-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-60", "06-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-61", "16-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}.fusion-title.fusion-title-text.fusion-title-62", "26-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}}", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}}@media", "aidem@}}", "1", "90", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "}@media", "aidem@}", "1", "61", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "@media", "aidem@", "1", "333", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "/", "/", "1", "48", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", ">", ">", "1", "223", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "0", "0", "1", "250", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "0.98%", "%89.0", "1", "110", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "098", "890", "1", "110", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "0px", "xp0", "1", "256", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "1", "1", "1", "31", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "1.225%", "%522.1", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "1.47%", "%74.1", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "10", "01", "1", "89", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "10%", "%01", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "10px", "xp01", "1", "100", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "11", "11", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "۱۲", "۲۱", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "1225", "5221", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "۱۳", "۳۱", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "14", "41", "1", "9", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "147", "741", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "15", "51", "1", "26", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "15px", "xp51", "1", "67", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "16", "61", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "17", "71", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "18", "81", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "19", "91", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "1px", "xp1", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "2", "2", "1", "109", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "2.94%", "%49.2", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "2)", ")2", "1", "36", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "20", "02", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "۲۰۲۱", "۱۲۰۲", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "20px", "xp02", "1", "80", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "21", "12", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "22", "22", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "225", "522", "1", "4", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "23", "32", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "24", "42", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "25px", "xp52", "1", "84", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "294", "492", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "3", "3", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "30px", "xp03", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "32", "23", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "33", "33", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "333333333333", "333333333333", "1", "26", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "34", "43", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "35", "53", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "36", "63", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "37", "73", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "38", "83", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "39", "93", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "4", "4", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "40", "04", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "41", "14", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "42", "24", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "43", "34", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "44", "44", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "45", "54", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "45px", "xp54", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "46", "64", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "47", "74", "1", "17", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "48", "84", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "49", "94", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "۵", "۵", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "5%", "%5", "1", "51", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "50", "05", "1", "19", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "50px", "xp05", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "51", "15", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "52", "25", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "52px", "xp25", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "53", "35", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "54", "45", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "55", "55", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "56", "65", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "57", "75", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "58", "85", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "59", "95", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "6", "6", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "6%", "%6", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "60", "06", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "60px", "xp06", "1", "10", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "61", "16", "1", "16", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "62", "26", "1", "11", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "63", "36", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "64", "46", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "65", "56", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "66", "66", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "666666666667", "766666666666", "1", "26", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "67", "76", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "68", "86", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "69", "96", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "7", "7", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "70", "07", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "70px", "xp07", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "71", "17", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "72", "27", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "73", "37", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "74", "47", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "75", "57", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "76", "67", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "77", "77", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "78", "87", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "79", "97", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "۸", "۸", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "8%", "%8", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "80", "08", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "81", "18", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "82", "28", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "83", "38", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "84", "48", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "85", "58", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "86", "68", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "87", "78", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "88", "88", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "89", "98", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "9", "9", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "90", "09", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "91", "19", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "92", "29", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "93", "39", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "94", "49", "1", "18", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "95", "59", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "96", "69", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "97", "79", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "98", "89", "1", "116", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "99", "99", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a", "a", "1", "37", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a:hover", "revoh:a", "1", "25", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a:hover{color:#48cab2}", "}2bac84#:roloc{revoh:a", "1", "25", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a:hovercolor:#48cab2", "2bac84#:rolocrevoh:a", "1", "25", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-34", "43-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-35", "53-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-36", "63-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-37", "73-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-38", "83-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-39", "93-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-41", "14-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-42", "24-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-43", "34-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-44", "44-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-45", "54-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-47", "74-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-48", "84-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-49", "94-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-50", "05-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-52", "25-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-53", "35-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-54", "45-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-55", "55-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-57", "75-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-58", "85-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-59", "95-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-60", "06-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-61", "16-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#607d8b}.fusion-title.fusion-title-text.fusion-title-62", "26-eltit-noisuf.txet-eltit-noisuf.eltit-noisuf.}b8d706#:roloc{a", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "a{color:#a3a3a3", "3a3a3a#:roloc{a", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle34", "43eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle35", "53eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle36", "63eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle37", "73eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle38", "83eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle39", "93eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle41", "14eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle42", "24eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle43", "34eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle44", "44eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle45", "54eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle47", "74eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle48", "84eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle49", "94eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle50", "05eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle52", "25eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle53", "35eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle54", "45eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle55", "55eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle57", "75eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle58", "85eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle59", "95eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle60", "06eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle61", "16eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#607d8bfusiontitlefusiontitletextfusiontitle62", "26eltitnoisuftxeteltitnoisufeltitnoisufb8d706#:roloca", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "acolor:#a3a3a3", "3a3a3a#:roloca", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "and", "dna", "1", "182", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "background", "dnuorgkcab", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bg", "gb", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "body", "ydob", "1", "182", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "border", "redrob", "1", "55", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "border-bottom-left-radius:7px", "xp7:suidar-tfel-mottob-redrob", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "border-bottom-right-radius:7px", "xp7:suidar-thgir-mottob-redrob", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "border-bottom-width:0", "0:htdiw-mottob-redrob", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "border-top-right-radius:7px", "xp7:suidar-thgir-pot-redrob", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "border-top-width:0", "0:htdiw-pot-redrob", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "borderbottomleftradius:7px", "xp7:suidartfelmottobredrob", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "borderbottomrightradius:7px", "xp7:suidarthgirmottobredrob", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "borderbottomwidth:0", "0:htdiwmottobredrob", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "borderradius:4px", "xp4:suidarredrob", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bordertoprightradius:7px", "xp7:suidarthgirpotredrob", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bordertopwidth:0", "0:htdiwpotredrob", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bottom", "mottob", "1", "179", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bottom:10px", "xp01:mottob", "1", "31", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bottom:50px", "xp05:mottob", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bottom:5px", "xp5:mottob", "1", "31", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bottom:65px", "xp56:mottob", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "bottom:calc", "clac:mottob", "1", "12", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "builder", "redliub", "1", "384", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "button", "nottub", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "card", "drac", "1", "14", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "cards", "sdrac", "1", "82", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "color:#48cab2", "2bac84#:roloc", "1", "32", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "color:#607d8b", "b8d706#:roloc", "1", "25", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "color:#a3a3a3", "3a3a3a#:roloc", "1", "24", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "column", "nmuloc", "1", "604", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "container", "reniatnoc", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "content", "tnetnoc", "1", "8", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "crossfade", "edafssorc", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "crossfadeimagesbackgroundcolor:#48cab2", "2bac84#:rolocdnuorgkcabsegamiedafssorc", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "display:none", "enon:yalpsid", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "flex", "xelf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusion", "noisuf", "1", "1240", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbody", "ydobnoisuf", "1", "182", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn34", "43nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn34width:100", "001:htdiw43nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn35", "53nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn35width:100", "001:htdiw53nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn35width:66666666666667", "76666666666666:htdiw53nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn36", "63nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn36width:100", "001:htdiw63nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn36width:33333333333333", "33333333333333:htdiw63nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn37", "73nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn37width:100", "001:htdiw73nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn38", "83nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn38width:100", "001:htdiw83nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn39", "93nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn40", "04nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn41", "14nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn42", "24nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn43", "34nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn44", "44nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn45", "54nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn45width:100", "001:htdiw54nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn46", "64nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn47", "74nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn48", "84nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn49", "94nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn50", "05nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn51", "15nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn51width:100", "001:htdiw15nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn51width:50", "05:htdiw15nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn52", "25nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn53", "35nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn54", "45nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn55", "55nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn56", "65nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn56width:100", "001:htdiw65nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn56width:50", "05:htdiw65nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn57", "75nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn58", "85nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn59", "95nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn60", "06nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn61", "16nmulocredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn61width:100", "001:htdiw16nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn61width:80", "08:htdiw16nmulocredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn62", "26nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn63", "36nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn64", "46nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn65", "56nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn66", "66nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildercolumn67", "76nmulocredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn50", "05nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn50width:100", "001:htdiw05nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn50width:33333333333333", "33333333333333:htdiw05nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn51", "15nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn51width:100", "001:htdiw15nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn51width:66666666666667", "76666666666666:htdiw15nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn52", "25nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn52width:100", "001:htdiw25nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn52width:33333333333333", "33333333333333:htdiw25nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn53", "35nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn53width:100", "001:htdiw35nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn53width:66666666666667", "76666666666666:htdiw35nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn54", "45nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn54width:100", "001:htdiw45nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn54width:33333333333333", "33333333333333:htdiw45nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn55", "55nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn55width:100", "001:htdiw55nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn55width:66666666666667", "76666666666666:htdiw55nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn56", "65nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn56width:100", "001:htdiw65nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn56width:33333333333333", "33333333333333:htdiw65nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn57", "75nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn57width:100", "001:htdiw75nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn57width:66666666666667", "76666666666666:htdiw75nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn58", "85nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn58width:100", "001:htdiw85nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn58width:33333333333333", "33333333333333:htdiw85nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn59", "95nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn59width:100", "001:htdiw95nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn59width:66666666666667", "76666666666666:htdiw95nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn60", "06nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn60width:100", "001:htdiw06nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn60width:33333333333333", "33333333333333:htdiw06nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn61", "16nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn61width:100", "001:htdiw16nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn61width:66666666666667", "76666666666666:htdiw16nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn62", "26nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn62width:100", "001:htdiw26nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn62width:40", "04:htdiw26nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn63", "36nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn63width:100", "001:htdiw36nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn63width:60", "06:htdiw36nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn64", "46nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn64width:100", "001:htdiw46nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn64width:40", "04:htdiw46nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn65", "56nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn65width:100", "001:htdiw56nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn65width:60", "06:htdiw56nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn66", "66nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn66width:100", "001:htdiw66nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn66width:40", "04:htdiw66nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn67", "76nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn67width:100", "001:htdiw76nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn67width:60", "06:htdiw76nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn68", "86nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn68width:100", "001:htdiw86nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn68width:40", "04:htdiw86nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn69", "96nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn69width:100", "001:htdiw96nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn69width:60", "06:htdiw96nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn70", "07nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn70width:100", "001:htdiw07nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn70width:40", "04:htdiw07nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn71", "17nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn71width:100", "001:htdiw17nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn71width:60", "06:htdiw17nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn72", "27nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn72width:100", "001:htdiw27nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn73", "37nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn73width:100", "001:htdiw37nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn74", "47nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn74width:100", "001:htdiw47nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn74width:33333333333333", "33333333333333:htdiw47nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn75", "57nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn75width:100", "001:htdiw57nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn75width:66666666666667", "76666666666666:htdiw57nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn76", "67nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn76width:100", "001:htdiw67nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn76width:33333333333333", "33333333333333:htdiw67nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn77", "77nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn77width:100", "001:htdiw77nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn77width:66666666666667", "76666666666666:htdiw77nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn78", "87nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn78width:100", "001:htdiw87nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn78width:33333333333333", "33333333333333:htdiw87nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn79", "97nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn79width:100", "001:htdiw97nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn79width:66666666666667", "76666666666666:htdiw97nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn80", "08nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn80width:100", "001:htdiw08nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn81", "18nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn81width:100", "001:htdiw18nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn82", "28nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn82width:100", "001:htdiw28nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn82width:33333333333333", "33333333333333:htdiw28nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn83", "38nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn83width:100", "001:htdiw38nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn83width:66666666666667", "76666666666666:htdiw38nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn84", "48nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn84width:100", "001:htdiw48nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn84width:33333333333333", "33333333333333:htdiw48nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn85", "58nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn85width:100", "001:htdiw58nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn85width:66666666666667", "76666666666666:htdiw58nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn86", "68nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn86width:100", "001:htdiw68nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn86width:33333333333333", "33333333333333:htdiw68nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn87", "78nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn87width:100", "001:htdiw78nmulocdetsenredliubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn87width:66666666666667", "76666666666666:htdiw78nmulocdetsenredliubnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn88", "88nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn88width:100", "001:htdiw88nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn89", "98nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn89width:100", "001:htdiw98nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn90", "09nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn90width:100", "001:htdiw09nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn91", "19nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn91width:100", "001:htdiw19nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn92", "29nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn92width:100", "001:htdiw29nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn93", "39nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn93width:100", "001:htdiw39nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn94", "49nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn94width:100", "001:htdiw49nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn95", "59nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn95width:100", "001:htdiw59nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn96", "69nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn96width:100", "001:htdiw69nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn97", "79nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn97width:100", "001:htdiw79nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn98", "89nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn98width:100", "001:htdiw89nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn99", "99nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuildernestedcolumn99width:100", "001:htdiw99nmulocdetsenredliubnoisuf", "1", "3", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuttonbutton4", "4nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuttonbutton5", "5nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionbuttonbutton6", "6nottubnottubnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusioncolumninnerbgmarginleft:calc30px/", "/xp03clac:tfelnigramgbrenninmulocnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusioncolumninnerbgmarginleft:calc50px/", "/xp05clac:tfelnigramgbrenninmulocnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusioncolumninnerbgmargintop:calc1px/", "/xp1clac:potnigramgbrenninmulocnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusioncolumninnerbgmargintop:calc52px/", "/xp25clac:potnigramgbrenninmulocnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusioncolumnwrapper", "repparwnmulocnoisuf", "1", "202", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionflexcontainerfusionbuilderrow10", "01worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionflexcontainerfusionbuilderrow6", "6worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionflexcontainerfusionbuilderrow7", "7worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionflexcontainerfusionbuilderrow8", "8worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionflexcontainerfusionbuilderrow9", "9worredliubnoisufreniatnocxelfnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongrid", "dirgnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumn", "nmulocdirgnoisuf", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumnpaddingleft:calc30px/", "/xp03clac:tfelgniddapnmulocdirgnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumnpaddingleft:calc50px/", "/xp05clac:tfelgniddapnmulocdirgnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumnpaddingtop:calc1px/", "/xp1clac:potgniddapnmulocdirgnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumnpaddingtop:calc52px/", "/xp25clac:potgniddapnmulocdirgnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumnwidth:100", "001:htdiwnmulocdirgnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiongridcolumnwidth:50", "05:htdiwnmulocdirgnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb13", "31btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb13color:#a3a3a3", "3a3a3a#:roloc31btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb14", "41btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb14color:#a3a3a3", "3a3a3a#:roloc41btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb15", "51btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb15color:#a3a3a3", "3a3a3a#:roloc51btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb16", "61btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb16color:#a3a3a3", "3a3a3a#:roloc61btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb17", "71btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb17color:#a3a3a3", "3a3a3a#:roloc71btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb18", "81btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb18color:#a3a3a3", "3a3a3a#:roloc81btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb19", "91btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb19color:#a3a3a3", "3a3a3a#:roloc91btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb20", "02btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb20color:#a3a3a3", "3a3a3a#:roloc02btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb21", "12btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb21color:#a3a3a3", "3a3a3a#:roloc12btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb22", "22btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb22color:#a3a3a3", "3a3a3a#:roloc22btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb23", "32btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb23color:#a3a3a3", "3a3a3a#:roloc32btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb24", "42btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionmetatbfusionmetatb24color:#a3a3a3", "3a3a3a#:roloc42btatemnoisufbtatemnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardimage1", "1egamidractsopnoisuf", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardimage1bordertopleftradius:7px", "xp7:suidartfelpotredrob1egamidractsopnoisuf", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards10", "01sdractsopnoisufsdractsopnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards10marginbottom:65px", "xp56:mottobnigram01sdractsopnoisufsdractsopnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards11", "11sdractsopnoisufsdractsopnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards12", "21sdractsopnoisufsdractsopnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards12marginbottom:65px", "xp56:mottobnigram21sdractsopnoisufsdractsopnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards13", "31sdractsopnoisufsdractsopnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards14", "41sdractsopnoisufsdractsopnoisuf", "1", "7", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards8", "8sdractsopnoisufsdractsopnoisuf", "1", "6", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards9", "9sdractsopnoisufsdractsopnoisuf", "1", "5", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusionpostcardsfusionpostcards9marginbottom:50px", "xp05:mottobnigram9sdractsopnoisufsdractsopnoisuf", "1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle32margintop:5px", "xp5:potnigram23eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle33margintop:5px", "xp5:potnigram33eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle34margintop:5px", "xp5:potnigram43eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle35margintop:5px", "xp5:potnigram53eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle36margintop:5px", "xp5:potnigram63eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle37margintop:5px", "xp5:potnigram73eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle38margintop:5px", "xp5:potnigram83eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle39margintop:5px", "xp5:potnigram93eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle40margintop:5px", "xp5:potnigram04eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle41margintop:5px", "xp5:potnigram14eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle42margintop:5px", "xp5:potnigram24eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle43margintop:5px", "xp5:potnigram34eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle44margintop:5px", "xp5:potnigram44eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle45margintop:5px", "xp5:potnigram54eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle46margintop:5px", "xp5:potnigram64eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle47margintop:5px", "xp5:potnigram74eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle48margintop:5px", "xp5:potnigram84eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle49margintop:5px", "xp5:potnigram94eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle50margintop:5px", "xp5:potnigram05eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle51margintop:5px", "xp5:potnigram15eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle52margintop:5px", "xp5:potnigram25eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle53margintop:5px", "xp5:potnigram35eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle54margintop:5px", "xp5:potnigram45eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle55margintop:5px", "xp5:potnigram55eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle56margintop:5px", "xp5:potnigram65eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle57margintop:5px", "xp5:potnigram75eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle58margintop:5px", "xp5:potnigram85eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle59margintop:5px", "xp5:potnigram95eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle60margintop:5px", "xp5:potnigram06eltitnoisufeltitnoisuf", "1", "2", "0", "0", "0", "0", "0", "0", "0", "0", "0", "page", "0", "");
INSERT INTO `qjfda_asp_index` VALUES("1290", "fusiontitlefusiontitle61margintop:5px", "xp5:potnigram16eltitnoisufeltitnoisuf", "1", "2", "0", "0"