<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class prdctfltr extends WP_Widget {

	public static $settings;

	function __construct() {

		$widget_ops = array(
			'classname'   => 'prdctfltr-widget',
			'description' => esc_html__( 'Product Filter widget version.', 'prdctfltr' ),
		);

		parent::__construct(
			'prdctfltr',
			'+ Product Filter',
			$widget_ops
		);

	}

	function pf_title( $args ) {

		$args['before'] = '<div class="pf-help-title">' . self::$settings['before'] . $args['before'];
		$args['after']  = $args['after'] . self::$settings['after'] . '</div>';

		return $args;

	}

	function widget( $args, $instance ) {

		if ( class_exists( 'XforWC_Product_Filters_Frontend' ) ) {

			self::$settings = array(
				'before' => $args['before_title'],
				'after'  => $args['after_title'],
			);

			add_filter( 'prdctfltr_filter_title_args', array( $this, 'pf_title' ) );

			global $prdctfltr_global;

			$prdctfltr_global['widget_search'] = true;
			$prdctfltr_global['unique_id']     = wp_doing_ajax() && isset( $prdctfltr_global['unique_id'] ) ? $prdctfltr_global['unique_id'] : uniqid( 'prdctfltr-' );

			$widget_opt = array(

				'keep_one_column'   => ( ! isset( $instance['keep_one_column'] ) || 'yes' === $instance['keep_one_column'] ? 'yes' : '' ),
				'use_widget_titles' => ( ! isset( $instance['use_widget_titles'] ) || 'yes' === $instance['use_widget_titles'] ? 'yes' : '' ),

				'preset'            => ( isset( $instance['template'] ) ? $instance['template'] : '' ),
				'disable_overrides' => ( isset( $instance['disable_overrides'] ) && 'yes' === $instance['disable_overrides'] ? 'yes' : '' ),
				'id'                => ( isset( $instance['id'] ) ? $instance['id'] : '' ),
				'class'             => ( isset( $instance['class'] ) ? $instance['class'] : '' ),
			);

			XforWC_Product_Filters_Frontend::$settings['widget'] = $widget_opt;
			$prdctfltr_global['widget_options']                  = $widget_opt;
			$prdctfltr_global['preset']                          = $widget_opt['preset'];
			$prdctfltr_global['disable_overrides']               = $widget_opt['disable_overrides'];

			if ( ! wp_doing_ajax() && ! isset( $prdctfltr_global['done_filters'] ) ) {
				XforWC_Product_Filters_Frontend::make_global( $_REQUEST, 'FALSE' );
			}

			echo wp_kses_post( $args['before_widget'] );

			if ( ! empty( $widget_opt['id'] ) || ! empty( $widget_opt['class'] ) ) {
				printf( '<div%s%s>', ! empty( $widget_opt['id'] ) ? ' id="' . esc_attr( $widget_opt['id'] ) . '"' : '', ! empty( $widget_opt['class'] ) ? ' class="' . esc_attr( $widget_opt['class'] ) . '"' : '' );
				include XforWC_Product_Filters_Frontend::$dir . 'templates/product-filter.php';
				echo '</div>';
			} else {
				include XforWC_Product_Filters_Frontend::$dir . 'templates/product-filter.php';
			}

			echo wp_kses_post( $args['after_widget'] );

			XforWC_Product_Filters_Frontend::$settings['widget'] = null;

			$prdctfltr_global['widget_search']  = null;
			$prdctfltr_global['widget_options'] = array();

			unset( $prdctfltr_global['unique_id'] );
			unset( $prdctfltr_global['preset'] );
			unset( $prdctfltr_global['disable_overrides'] );

			remove_filter( 'prdctfltr_filter_title_args', array( $this, 'pf_title' ) );
		}

	}

	function update( $new_instance, $old_instance ) {

		$instance = $old_instance;

		$instance['keep_one_column']   = isset( $new_instance['keep_one_column'] ) ? 'yes' : '';
		$instance['use_widget_titles'] = isset( $new_instance['use_widget_titles'] ) ? 'yes' : '';

		// $instance['preset']            = isset( $new_instance['preset'] ) ? $new_instance['preset'] : '';
		$instance['template']          = isset( $new_instance['template'] ) ? $new_instance['template'] : '';
		$instance['disable_overrides'] = isset( $new_instance['disable_overrides'] ) ? 'yes' : '';
		$instance['id']                = esc_attr( $new_instance['id'] );
		$instance['class']             = esc_attr( $new_instance['class'] );

		return $instance;

	}

	function form( $instance ) {

		$vars = array(
			'keep_one_column'   => 'yes',
			'use_widget_titles' => 'yes',
			'template'          => '',
			'disable_overrides' => 'no',
			'id'                => '',
			'class'             => '',
		);

		$instance = wp_parse_args( (array) $instance, $vars );

		$keep_one_column   = wp_strip_all_tags( $instance['keep_one_column'] );
		$use_widget_titles = wp_strip_all_tags( $instance['use_widget_titles'] );

		// $preset            = wp_strip_all_tags( $instance['preset'] );
		$template          = wp_strip_all_tags( $instance['template'] );
		$disable_overrides = wp_strip_all_tags( $instance['disable_overrides'] );
		$id                = wp_strip_all_tags( $instance['id'] );
		$class             = wp_strip_all_tags( $instance['class'] );
		?>
			<div>
				<p class="prdctfltr-box">
					<input type="checkbox" name="<?php echo esc_attr( $this->get_field_name( 'keep_one_column' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'keep_one_column' ) ); ?>" value="yes" <?php echo ( 'yes' === $keep_one_column ? ' checked' : '' ); ?> /> <label for="<?php echo esc_attr( $this->get_field_id( 'keep_one_column' ) ); ?>" class="prdctfltr-label"><?php esc_html_e( 'Keep one column', 'prdctfltr' ); ?></label>
				</p>

				<p class="prdctfltr-box">
					<input type="checkbox" name="<?php echo esc_attr( $this->get_field_name( 'use_widget_titles' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'use_widget_titles' ) ); ?>" value="yes" <?php echo ( 'yes' === $use_widget_titles ? ' checked' : '' ); ?> /> <label for="<?php echo esc_attr( $this->get_field_id( 'use_widget_titles' ) ); ?>" class="prdctfltr-label"><?php esc_html_e( 'Use widget style headings', 'prdctfltr' ); ?></label>
				</p>

				<p class="prdctfltr-box">
					<input type="checkbox" name="<?php echo esc_attr( $this->get_field_name( 'disable_overrides' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'disable_overrides' ) ); ?>" value="yes" <?php echo ( 'yes' === $disable_overrides ? ' checked' : '' ); ?> /> <label for="<?php echo esc_attr( $this->get_field_id( 'disable_overrides' ) ); ?>" class="prdctfltr-label"><?php esc_html_e( 'Disable presets manager settings', 'prdctfltr' ); ?></label>
				</p>

				<p class="prdctfltr-box">
					<label for="<?php echo esc_attr( $this->get_field_id( 'template' ) ); ?>" class="prdctfltr-label"><?php esc_html_e( 'Preset', 'prdctfltr' ); ?></label>
					<select name="<?php echo esc_attr( $this->get_field_name( 'template' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'template' ) ); ?>" class="widefat">
						<option value="default"<?php echo ( 'default' === $template ? ' selected="selected"' : '' ); ?>><?php esc_html_e( 'Default', 'prdctfltr' ); ?></option>
				<?php
					$presets = Prdctfltr()->get_presets();
				if ( is_array( $presets ) ) {
					foreach ( $presets as $k => $v ) {
						?>
								<option value="<?php echo esc_attr( $v['slug'] ); ?>"<?php echo ( $template === $v['slug'] ? ' selected="selected"' : '' ); ?>><?php echo esc_html( $v['name'] ); ?></option>
						<?php
					}
				}
				?>
					</select>
				</p>

				<p class="prdctfltr-box">
					<label for="<?php echo esc_attr( $this->get_field_id( 'id' ) ); ?>" class="prdctfltr-label"><?php esc_html_e( 'ID', 'prdctfltr' ); ?></label>
					<input type="text" name="<?php echo esc_attr( $this->get_field_name( 'id' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'id' ) ); ?>" value="<?php echo esc_attr( $id ); ?>" class="widefat" />
				</p>

				<p class="prdctfltr-box">
					<label for="<?php echo esc_attr( $this->get_field_id( 'class' ) ); ?>" class="prdctfltr-label"><?php esc_html_e( 'Class', 'prdctfltr' ); ?></label>
					<input type="text" name="<?php echo esc_attr( $this->get_field_name( 'class' ) ); ?>" id="<?php echo esc_attr( $this->get_field_id( 'class' ) ); ?>" value="<?php echo esc_attr( $class ); ?>" class="widefat" />
				</p>

			</div>

		<?php

	}

}

function prdctfltr_register_widgets() {
	register_widget( 'prdctfltr' );
}

add_action( 'widgets_init', 'prdctfltr_register_widgets' );
