<?php
if( !class_exists('Proshop_Royal') ) {
    
    class Proshop_Royal {

        // pr ===> Proshop Royal
        public function __construct() {

            // Load All Languages Needed On Child Theme
            add_action( 'after_setup_theme', array($this, 'royal_lang_setup') );

            // Add Custom Query For Get Products
            add_filter( 'woocommerce_product_data_store_cpt_get_products_query', array($this, 'handle_custom_query_var_special_carousel'), 10, 2 );

            // Enqueue WP Frontend Script/Style
            add_action( 'wp_enqueue_scripts', array($this, 'live_panel_and_avada_style'), 1000 );
            add_action( 'wp_print_styles', array($this, 'custom_demo_style') );

            // Enqueue WP Admin Script/Style
            add_action( 'admin_enqueue_scripts', array($this, 'custom_admin_style') );

            // Insert Meta Data On wp_head
            add_action( 'wp_head', array($this, 'iranavada_metadata') );

            /* Add proshop_royal Class to Body */
            add_filter( 'body_class', array($this, 'royal_body_classes') );

            // Return All PHP Files
            $this->load_php_file_needed();

            // Check Theme/plugin Update After Main Theme Loaded.
            add_action( 'after_setup_theme', array($this, 'ipl_check_update') );
            
            // Updater ID
            define('updaterID', '46800');
        }
        
        public function handle_custom_query_var_special_carousel( $query, $query_vars ) {

            if ( ! empty( $query_vars['_iranavadasopc'] ) ) {
                $query['meta_query'][] = array(
                    'key' => '_iranavadasopc',
                    'value' => esc_attr( $query_vars['_iranavadasopc'] ),
                );
            }
            return $query;
        }
        
        // Admin styles
        public function custom_admin_style() {
            wp_enqueue_style( 'iranavada-admin', get_stylesheet_directory_uri() . '/assets/rtl-admin.css', '', '2.19' );
        }
        
        // WP Print Styles/Scripts
        public function custom_demo_style() {
    
            if( class_exists('Royal_Option_Functions') ) {
                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            }

            wp_enqueue_style( 'iravada-demo-styles' , get_stylesheet_directory_uri() . '/assets/demo-styles.css', '', '10.4.13' );
            
            if( $this->check_plugin_activated('woocommerce/woocommerce.php') == true ) {
                
                if( is_shop() or is_product_category() or is_product_tag() or is_product_taxonomy() ) {
                    wp_enqueue_style( 'iravada-demo-archive-styles' , get_stylesheet_directory_uri() . '/assets/demo-archive-styles.css', '', '2.4' );
                }
                
                if( is_product() ) {
                    wp_enqueue_style( 'iravada-demo-single-styles' , get_stylesheet_directory_uri() . '/assets/demo-single-styles.css', '', '2.6' );
                }
                
                if( is_cart() or is_checkout() ) {
                    wp_enqueue_style( 'iravada-demo-cart-checkout-styles' , get_stylesheet_directory_uri() . '/assets/demo-cart-checkout-styles.css', '', '2.10' );
                }
            }
        
            if( is_rtl() ) {
                wp_enqueue_style( 'iravada-rtl-styles' , get_stylesheet_directory_uri() . '/assets/rtl-styles.css', '', '3.6.7' );
            }

            if( $get_royal_option_settings['readmore_status'] == 'yes' ) {
                wp_enqueue_script('royal-readmore-scripts', get_stylesheet_directory_uri() . '/assets/js/readmore-scripts.js', array('jquery'), '6.8', true);
                wp_enqueue_style( 'royal-readmore-styles' , get_stylesheet_directory_uri() . '/assets/readmore-style.css', '', '1.4' );
    			wp_localize_script( 'royal-readmore-scripts', 'readmore_data_localize', array( 
    				'ajax_url' => admin_url('admin-ajax.php'),
    				'show_hide_cover_color' => $get_royal_option_settings['show_more_cover_color'],
    			) );
            }
        }

        // Enqueue Script/Style 
        public function live_panel_and_avada_style() {

            wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', [] );

            //Just For Fusion Live Panel Frame
            if ( fusion_is_builder_frame() ) {
                wp_enqueue_style( 'fusion_app_rtl_panel_css', get_stylesheet_directory_uri() . '/assets/rtl-panel.css', '', '2.4');
            }
        }
        
        
        // Check Woocommerce Plugin Is Activated
        public static function check_plugin_activated($plugin_dir) {

            if( !function_exists('is_plugin_active') ) {
                include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
            }
            
            if( is_plugin_active($plugin_dir) ) {
                return true;
            }
        }
        
        
        // Load All PHP Files 
        public function load_php_file_needed() {
            
            require_once( get_stylesheet_directory() . '/includes/admin-screens/iravada-admin-notice-display.php' );
            require_once( get_stylesheet_directory() . '/includes/royal-admin-all-notices.php' );
            require_once( get_stylesheet_directory() . '/includes/royal-screen/royal-admin-screen.php' );
            require_once( get_stylesheet_directory() . '/includes/royal-manual-setup/core.php' );
            
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            if( $this->check_plugin_activated('fusion-builder/fusion-builder.php') == true ) {
                require_once( get_stylesheet_directory() . '/includes/iravada-elements/iravada-elements.php' );
            }
            
            require_once( get_stylesheet_directory() . '/includes/admin-screens/iranavada-admin.php' );
            require_once( get_stylesheet_directory() . '/includes/updater-core/plugin-update-checker.php' );
            require_once( get_stylesheet_directory() . '/includes/exclude-js.php' );

            if( $this->check_plugin_activated('woocommerce/woocommerce.php') == true ) {
                
                if( $this->check_plugin_activated('fusion-builder/fusion-builder.php') == true ) {
                    require_once(get_stylesheet_directory() . '/includes/royal-elements/royal-elements.php' );                    
                }
                
                require_once( get_stylesheet_directory() . '/includes/video-metabox/video-metabox.php' );
                require_once( get_stylesheet_directory() . '/includes/wc-orderby-instock.php' );
                require_once( get_stylesheet_directory() . '/includes/wc-variable-product-price-range.php' );
                require_once( get_stylesheet_directory() . '/includes/wc-sec-title-field.php' );
                require_once( get_stylesheet_directory() . '/includes/soon-product/wc-soon-product.php' );
                require_once( get_stylesheet_directory() . '/includes/wc-remove-additional-styles.php' );
                require_once( get_stylesheet_directory() . '/includes/royal-custom-fields.php' );

            }
            // add royal wishlist and compare menu to wordpress menus
            require_once( get_stylesheet_directory() . '/includes/irava-add-menu-nav.php' );
        }
        
        
        public function ipl_check_update() {
                
            // Child Theme Updater
            $child_theme_update_core = Puc_v4_Factory::buildUpdateChecker( METADATAURL_RCHN, __FILE__, 'IranAvada-Child' );

        }
        
        
        // Load Royal languages
        public function royal_lang_setup() {
            load_child_theme_textdomain( 'royal', get_stylesheet_directory() . '/languages' );
        }

        // Set Meta Data 
        public function iranavada_metadata() {
            
            if( class_exists('Royal_Option_Functions') ) {
                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            }
            
            ?>
            <meta name="designer" content="IranAvada" />
            <meta name="theme-color" content="<?php echo $get_royal_option_settings['royal_mobile_theme_color'] ? $get_royal_option_settings['royal_mobile_theme_color'] : '#48cab2' ?>">
            <?php
        }

        // Add BodyClass
        public function royal_body_classes( $classes ) {
            $classes[] = 'proshop_royal';
            return $classes;
        }

    }new Proshop_Royal();
}
