// Set Cookie Function
function setCookie(cname, cvalue, exdays) {

  const d = new Date();
  d.setTime(d.getTime() + (exdays*24*60*60*1000));
  let expires = "expires="+ d.toUTCString();
  document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";

}

// Get Register LicenseKey Button
const GetButtonRegisterClient = document.querySelector('#iranavada-register-license-button');

// Get Unregister LicenseKeyButton
const GetButtonUnregisterClient = document.querySelector('#iranavada-unregister-license-button');

// Get Register/Unregister/Check Connection Section Parent
const GetParentRegisterButton = document.querySelector('.iravada-ipl-register-license');

// Check Exists Register Button For Send Ajax Request
if( GetButtonRegisterClient ) {

  // Add Event Listener => Click For Send Ajax Request LicenseKey => Register
  GetButtonRegisterClient.addEventListener('click', RegisterLicenseAjax);

}

// Check Exists Unregister Button For Send Ajax Request
if( GetButtonUnregisterClient ) {

  // Add Event Listener => Click For Send Ajax Request LicenseKey => UnRegister
  GetButtonUnregisterClient.addEventListener('click', UnregisterLicenseAjax);

}

/* 
  * Function For Handle Ajax Request For Register LicenseKey On Dashboard => Admin Page
  * Register Action
*/
function RegisterLicenseAjax(e) {

  e.preventDefault();

  const GetLicenseKey = document.querySelector('#iranavada_activated_license').value;
  const GetLicenseStatusNotice = document.querySelector('.license-status-notice');
  const GetCurrentTargetClicked = e.currentTarget;
  
  if( GetLicenseKey == '' ) {

    if( wp_language.current_lang == 'fa-IR' ) {

      if( GetLicenseStatusNotice.classList.contains('error-notice') ) {

        GetLicenseStatusNotice.classList.remove('error-notice');
        GetLicenseStatusNotice.classList.add('warning-notice');

        GetLicenseStatusNotice.innerHTML = `<span>فیلد لایسنس خالی می‌باشد، جهت فعال‌سازی کلید لایسنس را در فیلد قرار دهید.</span>`;

      }

    }else {

      if( GetLicenseStatusNotice.classList.contains('error-notice') ) {

        GetLicenseStatusNotice.classList.remove('error-notice');
        GetLicenseStatusNotice.classList.add('warning-notice');

        GetLicenseStatusNotice.innerHTML = `<span>The license field is empty, put the license key in the field to activate it.</span>`;

      }

    }

  }else {

    jQuery.ajax({
            
      url: ir_admin_ajax_url.ajax_url,
      data:{
          action: "iravada_reg_license_by_user",
          licensekey: GetLicenseKey,
      },
      cache: false,
      type: "POST",
      beforeSend: function(result) {
  
        if( wp_language.current_lang == 'fa-IR' ) {
          GetCurrentTargetClicked.innerHTML = 'در حال فعال‌سازی';
        }else {
          GetCurrentTargetClicked.innerHTML = 'Registering License';
        }
        GetParentRegisterButton.classList.add('add-loader');
  
      },
      success: function(result){
  
        // Start Add NoticeSection Register Result

          if( result == 'ServerIsUnavailable' ) {

            GetLicenseStatusNotice.classList.remove('success-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>در حال حاضر سرور در دسترس نیست.</span>`;
              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>The server is unavailable, please try again.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }

          }
          
          if( result == 'GiftDomain' ) {
            
            if( wp_language.current_lang == 'fa-IR' ) {

              if( GetLicenseStatusNotice.classList.contains('error-notice') ) {
        
                GetLicenseStatusNotice.innerHTML = `<span>فعالسازی این قالب با لایسنس هدیه امکان پذیر نیست.</span>`;
        
              }

              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {
                GetLicenseStatusNotice.innerHTML = `<span>The server is unavailable, please try again.</span>`;
                GetCurrentTargetClicked.innerHTML = 'Active License';
            }

          }

          // IF For Check License Active
          if( result == 'LicenseActive' ) {
  
            if( wp_language.current_lang == 'fa-IR' ) {

              if( GetLicenseStatusNotice.classList.contains('error-notice') ) {

                GetLicenseStatusNotice.classList.remove('error-notice');
                GetLicenseStatusNotice.classList.add('success-notice');
        
                GetLicenseStatusNotice.innerHTML = `<span>لایسنس فعال است.</span>`;
        
              }else if( GetLicenseStatusNotice.classList.contains('warning-notice') ) {

                GetLicenseStatusNotice.classList.remove('warning-notice');
                GetLicenseStatusNotice.classList.add('success-notice');
        
                GetLicenseStatusNotice.innerHTML = `<span>لایسنس معتبر است.</span>`;

              }

              GetCurrentTargetClicked.innerHTML = 'غیرفعال‌سازی لایسنس';

            }else {
              GetCurrentTargetClicked.innerHTML = 'Deactivated Lisence';
            }

            // Add Unregister ID
            GetButtonRegisterClient.id = 'iranavada-unregister-license-button';
  
            // Add Unregister Class
            GetButtonRegisterClient.className = 'iranavada-unregister-license-button';

            // Reload For Active Theme
            setTimeout(function () {
              location.reload();
            }, 1000);
  
          }
  
          // IF For Check License Not Active OR License Empty
          if( result == 'CureentLicenseActiveOnAnotherDomain' ) {
  
            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>این لایسنس در دامنه دیگری فعال است.</span>`;
              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>Another domain has been registered for this license.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }
  
          }

          // If For Check License Not For Child
          if( result == 'ThisLicenseNotForChild' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>لایسنس وارد شده برای قالب فعلی نیست.</span>`;
              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>The license entered is not for the current theme.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }

          }

          // If For Check License Not For Child
          if( result == 'licenseWrong' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>لایسنس وارد شده نامعتبر است.</span>`;
              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>The license entered is wrong, please enter valid licensel.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }
            

          }

          // If For Check License Not For Child
          if( result == 'AdminDomainNotDetected' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>دامنه فعلی شما در دامنه‌های مجاز ایران آوادا تعریف نشده است.</span>`;
              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>Your current domain is not defined in Avada's authorized Iranian domains.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }
            

          }
          
        // End Add NoticeSection Register Result
  
      },
      complete: function (result) {
        
        // Remove Add Loader Class For Remove Loading Animation
        GetParentRegisterButton.classList.remove('add-loader');

      },
  
    });

  }

}

/* 
  * Function For Handle Ajax Request For Register LicenseKey On Dashboard => Admin Page
  * UnRegister Action
*/
function UnregisterLicenseAjax(e) {

    e.preventDefault();
    
    const GetLicenseField = document.querySelector('#iranavada_activated_license');
    const GetLicenseStatusNotice = document.querySelector('.license-status-notice');
    
    const GetCurrentTargetClicked = e.currentTarget;

    jQuery.ajax({
            
      url: ir_admin_ajax_url.ajax_url,
      data:{
          action: "iravada_unregister_license",
      },
      cache: false,
      type: "POST",
      beforeSend: function(result) {

        if( wp_language.current_lang == 'fa-IR' ) {

          GetCurrentTargetClicked.innerHTML = 'در حال غیرفعالسازی';

        }else {

          GetCurrentTargetClicked.innerHTML = 'Deactivating...';

        }

        GetParentRegisterButton.classList.add('add-loader');
    
      },
      success: function(result){
    
        if( result == 'ServerIsUnavailable' ) {

          GetLicenseStatusNotice.classList.remove('success-notice');
          GetLicenseStatusNotice.classList.add('warning-notice');

          if( wp_language.current_lang == 'fa-IR' ) {
    
            GetLicenseStatusNotice.innerHTML = `<span>در حال حاضر سرور در دسترس نیست.</span>`;
            GetCurrentTargetClicked.innerHTML = 'غیرفعالسازی قالب';

          }else {

            GetLicenseStatusNotice.innerHTML = `<span>The server is unavailable, please try again.</span>`;
            GetCurrentTargetClicked.innerHTML = 'Deactive Theme';

          }

        }

        if( result == 'LicenseDeactivated' ) {
    
          if( GetLicenseStatusNotice.classList.contains('success-notice') ) {

            GetLicenseStatusNotice.classList.remove('success-notice');
            GetLicenseStatusNotice.classList.add('error-notice');
    
            GetLicenseStatusNotice.innerHTML = `<span>لایسنس غیرفعال است.</span>`;
  
          }

          if( wp_language.current_lang == 'fa-IR' ) {

            GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';
  
          }else {
  
            GetCurrentTargetClicked.innerHTML = 'Active License';
  
          }
    
          // Add Unregister ID
          GetButtonUnregisterClient.id = 'iranavada-register-license-button';
    
          // Add Unregister Class
          GetButtonUnregisterClient.className = 'iranavada-register-license-button';
    
          // Return License Field Empty
          GetLicenseField.value = '';
    
          // Reload For Deactive Theme
          setTimeout(function () {
            location.reload();
          }, 1000);
          
        }
    
      },
      complete: function (result) {
    
        // Remove Add Loader Class For Remove Loading Animation
        GetParentRegisterButton.classList.remove('add-loader');
    
      },
    
    });

}

// Start Ajax Update Language Button

// Get Update Language Button
const GetUpdateLanguageButton = document.querySelector('.ipl-update-lang');

if( GetUpdateLanguageButton ) {

  // Add Event Listener For Update Language Button
  GetUpdateLanguageButton.addEventListener('click', IplUpdateLanguageIranavadaDashboard);

  function IplUpdateLanguageIranavadaDashboard(e) {

    e.preventDefault();

    // Get Update Button Parent
    const GetUpdateLanguageButtonParent = document.querySelector('.lang-update-button');

    // Get Update Language Button
    const GetUpdateLanguageButton       = document.querySelector('.ipl-update-lang');

    // Create Update Language Notice Tag
    const CreateUpdateLangNoticeTag     = document.createElement('span');

    // Get Parent Of Update Language Notice Section
    const GetParentUpdateLanguageBTN    = document.querySelector('.iranavada-update-section');

    jQuery.ajax({
              
      url: ir_admin_ajax_url.ajax_url,
      data:{
          action: "ipl_update_languages",
      },
      cache: false,
      type: "POST",
      beforeSend: function(result) {

        // Add Class For Display Loading  ==> 'add-loader'
        GetUpdateLanguageButtonParent.classList.add('add-loader');

        // Change Update Language Button Value 
        GetUpdateLanguageButton.value = 'در حال بروزرسانی...';

      },
      success: function(result){

        if( result == 'UpdateLanguagesSuccessfully' ) {

          // Add Class For Display Loading  ==> 'add-loader'
          GetUpdateLanguageButtonParent.classList.remove('add-loader');

          // Change Update Language Button Value 
          GetUpdateLanguageButton.value = 'فایل‌های زبان آپدیت شد';

          // Create Class List/AppendChild and Appended Notice To Update Section Notice ==> Language Update
          CreateUpdateLangNoticeTag.classList.add('iravada-update-language-notice', 'success-notice');
          CreateUpdateLangNoticeTag.appendChild( document.createTextNode('فایل‌های زبان با موفقیت بروز شد، منتظر باشید ...') );
          GetParentUpdateLanguageBTN.append(CreateUpdateLangNoticeTag);

          // Reload For After Update Languages
          setTimeout(function () {
            location.reload();
          }, 1000);

        }else {
          
        // Add Class For Display Loading  ==> 'add-loader'
          GetUpdateLanguageButtonParent.classList.remove('add-loader');
            
          // Create Class List/AppendChild and Appended Notice To Update Section Notice ==> Language Update
          CreateUpdateLangNoticeTag.classList.add('iravada-update-language-notice', 'error-notice');
          CreateUpdateLangNoticeTag.style.marginTop = '15px';
          CreateUpdateLangNoticeTag.style.display = 'block';
          CreateUpdateLangNoticeTag.appendChild( document.createTextNode('فایل های زبان ناقص هستند.') );
          GetParentUpdateLanguageBTN.append(CreateUpdateLangNoticeTag);
            
        }

      },
      complete: function (result) {},

    });
    
  }

  // End Ajax Update Language Button

}

// Check License Status
if( document.querySelector('.iranavada-check-license-button') ) {

  const CheckLicenseStatusBtn = document.querySelector('.iranavada-check-license-button');
  CheckLicenseStatusBtn.addEventListener('click', function(e) {

    e.preventDefault();

    const GetCurrentTargetClicked   = e.currentTarget;
    const GetLicenseKey             = document.querySelector('#iranavada_activated_license').value;
    const GetLicenseStatusNotice    = document.querySelector('.license-status-notice');

    jQuery.ajax({
              
      url: ir_admin_ajax_url.ajax_url,
      data:{
          action: "ipl_check_license_status",
          license: GetLicenseKey
      },
      cache: false,
      type: "POST",
      beforeSend: function(result) {

        if( wp_language.current_lang == 'fa-IR' ) {
          GetCurrentTargetClicked.innerHTML = 'در حال بررسی...';
        }else {
          GetCurrentTargetClicked.innerHTML = 'checking License...';
        }
        GetParentRegisterButton.classList.add('add-loader');

      },
      success: function(result){

        // Start Add NoticeSection Register Result

          // IF For Check License Active
          if( result == 'LicenseActive' ) {

            if( wp_language.current_lang == 'fa-IR' ) {

              if( GetLicenseStatusNotice.classList.contains('error-notice') ) {

                GetLicenseStatusNotice.classList.remove('error-notice');
                GetLicenseStatusNotice.classList.add('success-notice');
        
                GetLicenseStatusNotice.innerHTML = `<span>لایسنس فعال است.</span>`;
        
              }else if( GetLicenseStatusNotice.classList.contains('warning-notice') ) {

                GetLicenseStatusNotice.classList.remove('warning-notice');
                GetLicenseStatusNotice.classList.add('success-notice');
        
                GetLicenseStatusNotice.innerHTML = `<span>لایسنس فعال است.</span>`;

              }

              GetCurrentTargetClicked.innerHTML = 'غیرفعال‌سازی لایسنس';

            }else {
              GetCurrentTargetClicked.innerHTML = 'Deactivated Lisence';
            }

            // Reload For Deactive Theme
            setTimeout(function () {
              location.reload();
            }, 1000);

          }

          // IF For Check License Not Active OR License Empty
          if( result == 'CureentLicenseActiveOnAnotherDomain' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>این لایسنس در دامنه دیگری فعال است، در دامنه فعلی نمیتوانید از لایسنس فعلی استفاده نمایید.</span>`;
              GetCurrentTargetClicked.innerHTML = 'بررسی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>Another domain has been registered for this license.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }

          }

          // If For Check License Not For Child
          if( result == 'ThisLicenseNotForChild' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>لایسنس استفاده شده برای قالب فعلی نیست.</span>`;
              GetCurrentTargetClicked.innerHTML = 'بررسی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>The license entered is not for the current theme.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }

          }

          // If For Check License Not For Child
          if( result == 'licenseWrong' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>لایسنس فعلی اشتباه است، لطفا لایسنس قالب را از حساب کاربری خود برداشته و مجدد ثبت نمایید.</span>`;
              GetCurrentTargetClicked.innerHTML = 'بررسی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>The license entered is wrong, please enter valid licensel.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Check License';

            }
          
          }

          // If For Check License Not For Child
          if( result == 'AdminDomainNotDetected' ) {

            GetLicenseStatusNotice.classList.remove('error-notice');
            GetLicenseStatusNotice.classList.add('warning-notice');

            if( wp_language.current_lang == 'fa-IR' ) {
      
              GetLicenseStatusNotice.innerHTML = `<span>دامنه فعلی شما در دامنه‌های مجاز ایران آوادا تعریف نشده است.</span>`;
              GetCurrentTargetClicked.innerHTML = 'فعالسازی لایسنس';

            }else {

              GetLicenseStatusNotice.innerHTML = `<span>Your current domain is not defined in Avada's authorized Iranian domains.</span>`;
              GetCurrentTargetClicked.innerHTML = 'Active License';

            }
            

          }
        
        // End Add NoticeSection Register Result

      },
      complete: function (result) {

        // Remove Add Loader Class For Remove Loading Animation
        GetParentRegisterButton.classList.remove('add-loader');

      },

    });

  });

}