<?php
// admin-screens v2.4

if( !class_exists('Iranavada_Admin_Panel') ) {

    class Iranavada_Admin_Panel {
        
        protected $iranavada_panel_css_url = '';
        protected $iranavada_admin_screen_dir = '';
        protected $css_path = '';
        protected $js_path  = '';


        public function __construct() {

            $this->iranavada_panel_css_url = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/css';
            $this->iranavada_admin_screen_dir = get_stylesheet_directory() . '/includes/admin-screens/';

            $this->css_path    = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/css';
            $this->js_path     = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/js';

            // Admin Enqueue Scripts/Styles
            add_action( 'admin_enqueue_scripts', array($this, 'iranavada_enqueue_admin_scripts') );

            // Run All Required Files Needed
            $this->load_all_sections_needed();
            
        }

        // Wp Enqueue Admin Styles/Scripts
        public function iranavada_enqueue_admin_scripts() {

            $get_license_saved_user     = get_option('ipl_license_by_user');

            $domain = rtrim($_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'], '/');

            wp_enqueue_style('iranavada-panel-styles', $this->iranavada_panel_css_url . '/iravada-admin-styles.css', '', '1.6' );

            wp_register_script( 'irava-admin-script', $this->js_path . '/admin-scripts.js', '', '1.7', true );

            // Localize Script For Dashboard Script
            wp_localize_script( 'irava-admin-script', 'ir_admin_ajax_url', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
            wp_localize_script( 'irava-admin-script', 'wp_language', array( 'current_lang' => get_bloginfo('language') ) );
            

            if( get_option('ipl_license_by_user') ) {

                wp_enqueue_script( 'ipl-library', $this->js_path . '/library.js', '', '1.6', true );

                // Localize Script For Public Scripts
                wp_localize_script( 'ipl-public-script', 'public_loaclize_data', array( 
                    'ajax_url'              => admin_url( 'admin-ajax.php' ), 
                    'current_license'       => $get_license_saved_user, 
                    'home_url'              => $domain
                ) );
                
            }
            
        }

        // Load Admin Panels php
        public function load_all_sections_needed() {
            
            // Require Once IranAvada Dashboard
            require_once( $this->iranavada_admin_screen_dir . 'pages/iravada-dashboard.php' );
        }

    }new Iranavada_Admin_Panel();

}