<?php

if( !class_exists('Iravada_Dashboard_Screen') ) {

    class Iravada_Dashboard_Screen {
        
        protected $iranavada_admin_screen_dir = '';
        protected $mylocale = '';


        public function __construct() {

            $this->iranavada_admin_screen_dir = get_stylesheet_directory() . '/includes/admin-screens/';
            $this->mylocale = get_bloginfo('language');

            // Add Iranavada Admin Menu
            add_action( 'admin_menu', array($this, 'iravada_admin_dashboard_menu') );
        }

        // add iranavada admin menu function
        public function iravada_admin_dashboard_menu() {

            // add menu Commend
            add_menu_page( 
                __( 'Theme Lisence' , 'iravada' ),
                __( 'Theme Lisence' , 'iravada' ),
                'administrator', 
                'iranavada', 
                array($this, 'iranavada_dashboard_content'), 
                'dashicons-iranavada',
                '3.35'
            );
        }
        
        // Iranavada Dashboard Menu
        public function iranavada_dashboard_content() {

            wp_enqueue_script('irava-admin-script');

            $LicenseDB = get_option('ipl_license_by_user');

            ?><div class="iranavada-dashboard"><?php

                if( !class_exists('IRAVADA_ADMIN_HEADER') ) {
                    require_once( $this->iranavada_admin_screen_dir . 'admin-contents/iravada-admins-header.php' );
                }
                
                if( $this->mylocale == 'fa-IR' ) {
                    IRAVADA_ADMIN_HEADER::iravada_dashboard_header_design('dashboard');
                }

                $current_user = wp_get_current_user();
                $welcome_intro_img_path = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/img';

                if( $LicenseDB ) {
                    if( $this->mylocale == 'fa-IR' ){
                        ?>
                        <div class="rs-admin-box iranavada-dashboard-content welcome-intro">
                            <div class="iravada-welcome-media-container speed-monster">
                                <img src="<?php echo $welcome_intro_img_path . '/SiteSpeed-monster.webp?v=2' ?>" alt="" class="iravada-intro-banner">
                                <h3 class="sitespeed-monster-text">آموزش راه‌کارهای تضمینی افزایش سرعت لود سایت زیر 2.5 ثانیه</h3>
                                <a href="https://shetabwp.com/site-speed-monster/" class="welcome-intro-botton" target="_blank">مشاهده نمونه آموزش و سرفصل‌ها</a>
                            </div>
                            <?php if( updaterID == 23962 or updaterID == 46800 ) { ?>
                                <div class="iravada-welcome-media-container royal">
                                    <img src="<?php echo $welcome_intro_img_path . '/proshop-royal.webp?v=2' ?>" alt="" class="iravada-intro-banner"></a>
                                    <h3 class="royal-text">قالب فروشگاهی پروشاپ رویال با 100ها طراحی آماده با 70 قسمت آموزش</h3>
                                    <a href="https://iranavada.com/proshop-learning-list/" class="welcome-intro-botton" target="_blank">لیست آموزش‌های پروشاپ رویال</a>
                                </div>
                                <?php
                            }else { ?>
                                <div class="iravada-welcome-media-container royal">
                                    <img src="<?php echo $welcome_intro_img_path . '/proshop-royal.webp?v=2' ?>" alt="" class="iravada-intro-banner"></a>
                                    <h3 class="royal-text">قالب فروشگاهی پروشاپ رویال با 100ها طراحی آماده با 70 قسمت آموزش</h3>
                                    <a href="https://iranavada.com/wordpress-shop-theme/" class="welcome-intro-botton" target="_blank">مشاهده قالب پروشاپ رویال</a>
                                </div>
                                <?php 
                                } ?>
                        </div>
                        <div class="rs-admin-box iranavada-update-language">
                            <div class="iranavada-update-section">
                                <h1>آپدیت زبان قالب و افزونه</h1>
                                <span class="sep-border"></span>
                                <div class="lang-update-description">
                                    <p>اگر در بخش‌های مختلف قالب مشکلات ترجمه دارید، میتوانید با استفاده از دکمه روبرو آخرین آپدیت فایل زبان را دریافت کنید.</p>
                                </div>
                                <div class="lang-update-button"><span type="submit" class="button button-primary ipl-update-lang sync-language" />آپدیت فایل‌های زبان</span> </div>
                                <div class="lang-update-notice"></div>
                            </div>
                        </div>
                        <!--
                        <div class="rs-admin-box iranavada-suggest-host">
                            <div class="iranavada-host-seggestion">
                                <h1>شرکت‌های هاستینگ پیشنهاد ایران آوادا</h1>
                                <span class="sep-border"></span>
                                <p>با وجود شرکت‌های هاستیگ زیادی که در ایران سرویس ارائه می‌دهند، ممکن است انتخاب هاست مناسب برای کاربران آوادا و پروشاپ سخت باشد و ندانسته، سرویس‌های نامناسب تهیه کنند. به همین دلیل تصمیم گرفتیم کیفیت و امنیت را بیش از هر چیزی در اولویت قرار دهیم و چندین شرکت هاستینگ را بررسی و تست کنیم. شرکت‌هایی که بالاترین کیفیت و مسئولیت‌پذیری را در سرویس‌های خود ارائه می‌دهند را معرفی می‌کنیم. شدیدا پیشنهاد می‌کنیم، برای پروشاپ از این شرکت‌ها سرویس تهیه کنید.</p>
                                <a href="https://iranavada.com/host-suggest/" class="button button-primary iranavada-host-suggest-button" target="_blank">مشاهده هاست و کد تخفیف</a>
                            </div>
                        </div>
                        -->
                    <?php
                    }
                } ?>
                
                <div class="rs-admin-box iranavada-active-license">
                    <div class="iranvada-active-license-form">
                        <div class="iranavada-register-license top-section">
                            <h1><?php _e( 'Register Lisence' , 'iravada' ); ?></h1>
                        </div>
                        <div class="register-license-section">
                            <?php
                            
                            
                                ?>
                                <div class="iravada-ipl-register-license">
                                    <input type="text" name="iranavada_activated_license" id="iranavada_activated_license" value="<?= $LicenseDB ?>" placeholder="<?php _e( 'Enter Lisence Key' , 'iravada' ) ?>" <?php if( $LicenseDB == true ) { echo 'disabled'; } ?>>
                                    <?php 

                                        if( !$LicenseDB ) {
                                            ?><span class="iranavada-register-license-button" id="iranavada-register-license-button"><?php _e( 'Activate Lisence', 'iravada' ) ?></span><?php
                                        }elseif( $LicenseDB ) {
                                            ?><span class="iranavada-unregister-license-button" id="iranavada-unregister-license-button"><?php _e( 'Deactivate Lisence', 'iravada' ) ?></span><?php
                                        }
                                        
                                    ?>
                                </div>
                                <?php

                                if( $LicenseDB ) {
                                    
                                    if($LicenseDB == '33468b9efc4e7fbdfdd5c562f3d3e678') {
                                        ?>
                                            <div class="license-status-notice success-notice">
                                                <span>فعال شده در دامنه‌های مجاز و هدیه، توسط ایران آوادا.</span>
                                            </div>
                                        <?php
                                    }else {
                                        ?>
                                            <div class="license-status-notice success-notice">
                                                <span>لایسنس فعال است.</span>
                                            </div>
                                        <?php
                                    }

                                }elseif( !$LicenseDB ) {
                                    ?>
                                        <a href="#" target="_blank">کلید لایسنس را ندارید؟ برای دریافت کلیک کنید.</a>
                                        <div class="license-status-notice error-notice">
                                            <span>لایسنس غیرفعال است.</span>
                                        </div>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
                <?php

                if( !class_exists('IRAVADA_ADMIN_FOOTER') ) {
                    require_once( $this->iranavada_admin_screen_dir . 'admin-contents/iravada-admins-footer.php' );
                }
                
                if( $this->mylocale == 'fa-IR' ) {
                    IRAVADA_ADMIN_FOOTER::iravada_dashboard_footer_design();
                }

            ?></div><?php
        }

    }new Iravada_Dashboard_Screen();
}
