<?php

/* start add checkbox to edt page product on general tab */
add_filter( 'woocommerce_product_options_general_product_data', 'add_call_for_price_product_option' );
function add_call_for_price_product_option( $product_type_options ) {
    global $product;
    woocommerce_wp_checkbox(
        array(
            'id'            => '_iravada_call_for_price',
            'wrapper_class' => 'show_if_call_for_price',
            'label'         => __('<strong>تماس برای قیمت</strong>', 'woocommerce'),
            'description'   => __( '<strong>نکته مهم : </strong> نوع محصول را ساده انتخاب کرده و قیمت را حذف کنید (صفر وارد نکنید).<br> برای تغییر تنظیمات بخش تماس برای قیمت به <a href="admin.php?page=proshop_royal_admin_panel" target="_blank">تنظیمات پروشاپ</a> مراجعه کنید.', 'woocommerce' )
        )
    );
}
/* End add checkbox to edt page product on type Option */

/* Start Save Call For price Checkbox on Database */
add_action( 'woocommerce_process_product_meta', 'save_call_for_price_field' );
function save_call_for_price_field( $post_id ) {
    global $porduct;
    $custom_field_value = isset( $_POST['_iravada_call_for_price'] ) ? 'yes' : 'no';
    $product = wc_get_product( $post_id );
    $product->update_meta_data( '_iravada_call_for_price', $custom_field_value );
    $product->save();
}
/* End Save Call For price Checkbox on Database */

/* Start display custom text */
add_filter('woocommerce_empty_price_html' , 'custom_call_for_price' , 99); // add filter to empty price
function custom_call_for_price() {
    // display_iravada_cfp_args
    $display_iravada_cfp_args = array(
        'is-admin'      => is_admin(),
        'is-shop'       => is_shop(),
        'is-tag'        => is_tag(),
        'is-category'   => is_category(),
        'is-archive'    => is_archive()
    );
    global $product;
    if ( get_post_meta( $product->get_id(), '_iravada_call_for_price' , true )=='yes' && $product->is_type( 'simple' ) && is_single() ) {
        ?>
        <div class="content-message-single-product">
            <span class="iravada-call-for-price-box-title"><?php echo get_option('iravada_desc_text_cfp_title_fieldkey') ? get_option('iravada_desc_text_cfp_title_fieldkey') : 'برای استعلام قیمت تماس بگیرید'; ?></span>
            <p class="hide_calltoprice_shoppage"><?php echo get_option('iravada_desc_text_cfp_fieldkey') ? get_option('iravada_desc_text_cfp_fieldkey') : 'به دلیل نوسانات موجود در بازار برای استعلام قیمت بروز حتما با ما در تماس باشید، همچنین میتوانید با استفاده از دکمه زیر به صفحه تماس با ما هدایت شوید.'; ?></p>
            <a class="fusion-button button-flat button-large button-default button-1 fusion-button-default-span fusion-button-default-type" target="_blank" href="<?php echo get_option('iravada_capp_cfp_button_page_linkkey') ? get_option('iravada_capp_cfp_button_page_linkkey') : '#' ?>">
                <span><?php echo get_option('iravada_capp_cfp_button_text_namekey') ? get_option('iravada_capp_cfp_button_text_namekey') : 'صفحه تماس با ما' ?></span>
            </a>
        </div>
        <?php            
    }elseif( get_post_meta( $product->get_id(), '_iravada_call_for_price' , true )=='yes' && $product->is_type( 'simple' ) && $display_iravada_cfp_args ) {
        ?>
        <div class="iravada-shop-call-for-price">
            <span><?php echo get_option('iravada_desc_text_cfp_title_fieldkey') ? get_option('iravada_desc_text_cfp_title_fieldkey') : 'برای استعلام قیمت تماس بگیرید'; ?></span>
        </div>
        <?php    
    }

}
/* End display custom text */