<?php 
/**
 * Plugin Name: WP Rocket | Exclude JS scripts from Delay JS only at some URLs
 * Plugin URI: https://github.com/wp-media/wp-rocket-helpers/tree/master/static-files/wp-rocket-static-exclude-delay-js-per-url/
 * Description: Exclude JavaScript files from Delay JS only on specific pages instead of excluding them globally.
 * Version: 1.0
 * Author: WP Rocket Support Team
 * Author URI: https://wp-rocket.me
 * License:	GNU General Public License v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Copyright 2021 WP Media <support@wp-rocket.me>
 */
 

 // Namespaces must be declared before any other declaration.
 namespace WP_Rocket\Helpers\static_files\exclude\selective_delay_js_exclusions;
 
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit; 
 
function exclude_from_delay( $exclusions ) {

        /**
        STEP #1: ON THESE PAGES...
        Change the Slugs ("first-slug", etc, in this example) to the pages where you want to apply these exclusions.
        These are the URLs where the scripts from step 2 won't be delayed.
        For example: On the following pages (STEP #1), don't delay the following OWL Carousel scripts (STEP #2).
        **/
                
        $excluded_slugs = array(
            //'first-slug', 
            //'another-slug', 
            //'another-one', 
        );       
        
        if( is_product() ) {
            
            /** STEP #2: DON'T DELAY THESE SCRIPTS! in Product Page **/
            
            // $exclusions[] = '/jquery-?[0-9.](.*)(.min|.slim|.slim.min)?.js';
            // $exclusions[] = '/jquery-migrate(.min)?.js';
            
            // ** For All Avada js in upload folder
            $exclusions[] = '/uploads/fusion-scripts/(.*).min.js';
            $exclusions[] = 'window.off_canvas_';
            
            
            
            // PostCarts     
            $exclusions[] = '/wp-includes/js/jquery/jquery.min.js';
            $exclusions[] = '/fusion-builder/assets/js/min/general/fusion-post-cards.js';
            $exclusions[] = '/includes/lib/assets/min/js/general/fusion-carousel.js';
            $exclusions[] = '/includes/lib/assets/min/js/library/jquery.carouFredSel.js';
            
            
            // Avada Woo Product images and thumbnail galery
            $exclusions[] = '/assets/min/js/general/avada-woo-product-images.js';
            $exclusions[] = '/includes/lib/assets/min/js/library/jquery.flexslider.js';
            $exclusions[] = '/includes/lib/assets/min/js/library/modernizr.js';
            $exclusions[] = '/includes/lib/assets/min/js/general/fusion.js';
            $exclusions[] = '/includes/lib/assets/min/js/general/fusion-lightbox.js';
            $exclusions[] = '/includes/lib/assets/min/js/library/jquery.ilightbox.js';
            
            
            
            // PostCarts for scrole by finger
            $exclusions[] = '/assets/js/royal.js';
            $exclusions[] = '/includes/lib/assets/min/js/library/jquery.touchSwipe.js';
            
            // Avada quantity
            $exclusions[] = '/assets/min/js/general/avada-quantity.js';
            
            // display royal variable names
            $exclusions[] = '/option-panel/assets/js/variable-color-name.js';
            
            // change variable products variables
            $exclusions[] = '/woocommerce/assets/js/frontend/add-to-cart-variation.min.js';
            $exclusions[] = '/assets/min/js/general/avada-woo-variations.js';
            
            // display variable price
            $exclusions[] = '/wp-includes/js/underscore.min.js';
            $exclusions[] = '/wp-includes/js/wp-util.min.js';
            
            
            // z-index for modal
            $exclusions[] = '/assets/js/min/general/fusion-modal.js';
            
            // For mobile menu
            $exclusions[] = '/includes/lib/assets/min/js/library/modernizr.js';
            
            
            
            
            // Exclude for ALL
           // $exclusions[] = '';
        }
        
        
        /** STEP #3: DON'T DELAY THESE SCRIPTS TO All Pages! **/
        
        // For Off Convas
        // $exclusions[] = '/assets/js/min/general/awb-off-canvas.js';

        
    return $exclusions;

}

add_filter( 'rocket_delay_js_exclusions',  __NAMESPACE__ . '\exclude_from_delay' );
