<?php 

if( !class_exists('Irava_Add_Nav_Menu') ) {

    Class Irava_Add_Nav_Menu {

        public function __construct() {

            // Add special menu items meta box.
			add_action( 'admin_head-nav-menus.php', [ $this, 'irava_add_special_links_meta_box' ] );

        }

		/**
		 * Adds Avada special menu items meta box.
		 *
		 * @since  7.0
		 * @access public
		 * @return void
		 */
		public function irava_add_special_links_meta_box() {
			add_meta_box( 'plugin-slug-menu-metabox', "ایران آوادا", array($this, 'irava_special_menut_items'), 'nav-menus', 'side', 'default', array( /*custom params*/ ) );
		}

		/**
		 * Outputs contents of Avada special menu items meta box.
		 *
		 * @since  7.0
		 * @access public
		 * @return void
		 */
		public function irava_special_menut_items($object, $args) {
            global $nav_menu_selected_id;

            // Get Royal Options
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            // Check Wishlist Page Link Is isset
            if( isset( $get_royal_option_settings['wishlist_page'] ) ) {
              $Wishlist_page_link = get_permalink( $get_royal_option_settings['wishlist_page'] );
            }else {
              $Wishlist_page_link = '#';
            }

            // Check Compare Page Link Is isset
            if( isset( $get_royal_option_settings['compare_page'] ) ) {
              $compare_page_link = get_permalink( $get_royal_option_settings['compare_page'] );
            }else {
              $compare_page_link = '#';
            }

            // Create an array of objects that imitate Post objects
            $irava_menu_item = array(
              (object) array(
                'ID'                => 1,
                'object_id'         => 1,
                'type_label'        => 'Wishlist',
                'title'             => 'علاقمندی‌ها',
                'url'               => $Wishlist_page_link,
                'type'              => 'custom',
                'object'            => 'irava-royal-wishlist',
                'db_id'             => 0,
                'menu_item_parent'  => 0,
                'post_parent'       => 0,
                'target'            => '_blank',
                'attr_title'        => '',
                'description'       => '',
                'classes'           => array(),
                'xfn'               => '',
              ),
              (object) array(
                'ID'                => 2,
                'object_id'         => 2,
                'type_label'        => 'Compare',
                'title'             => 'مقایسه محصول',
                'url'               => $compare_page_link,
                'type'              => 'custom',
                'object'            => 'irava-royal-compare',
                'db_id'             => 0,
                'menu_item_parent'  => 0,
                'post_parent'       => 0,
                'target'            => '_blank',
                'attr_title'        => '',
                'description'       => '',
                'classes'           => array(),
                'xfn'               => '',
              ),
            );
          
            $db_fields = false;
            // If your links will be hierarchical, adjust the $db_fields array below
            if ( false ) { 
              $db_fields = array( 'parent' => 'parent', 'id' => 'post_parent' ); 
            }
          
            $walker = new Walker_Nav_Menu_Checklist( $db_fields );
            $removed_args = array( 'action', 'customlink-tab', 'edit-menu-item', 'menu-item', 'page-tab', '_wpnonce', );
            ?>
            <div id="plugin-slug-div">
              <div id="tabs-panel-plugin-slug-all" class="tabs-panel tabs-panel-active">
              <ul id="plugin-slug-checklist-pop" class="categorychecklist form-no-clear" >
                <?php echo walk_nav_menu_tree( array_map( 'wp_setup_nav_menu_item', $irava_menu_item ), 0, (object) array( 'walker' => $walker ) ); ?>
              </ul>
              <p class="button-controls">
                <span class="add-to-menu">
                  <input type="submit"<?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button-secondary submit-add-to-menu right" value="<?php esc_attr_e( 'Add to Menu' ); ?>" name="add-plugin-slug-menu-item" id="submit-plugin-slug-div" />
                  <span class="spinner"></span>
                </span>
              </p>
            </div>
            <?php
		}

    }new Irava_Add_Nav_Menu();

}
