<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_particle_background' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_particle_background
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {

			add_action( 'wp_enqueue_scripts', [$this, 'iw_particleJs_enqueue_script'] );
			add_shortcode( 'iravada_particle_background', [ $this, 'render' ] );

		}		

		public function iw_particleJs_enqueue_script() {
			wp_register_script( 'iw_particleJs', get_stylesheet_directory_uri() . '/includes/iravada-elements/includes/irava-particles-background-js/assets/js/irava-partials.js', false, '4.5' );
		}
		
		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
			    'irava_particles_absolute_fixed'        => 'absolute',
				'irava_particle_id_name'				=> '',
				'irava_partial_background_code_area'	=> '',
				'class'									=> '',
				'id'									=> '',
                'hide_on_mobile'  						=> fusion_builder_default_visibility( 'array' ), 
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

			$fusion_settings = fusion_get_fusion_settings();
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_particle_background' );
			$this->args = $defaults;
			
			ob_start();

				wp_enqueue_script('iw_particleJs');
				
				?>
					<script type="text/javascript">

						function paticaljs_irava() {
							particlesJS('<?php echo $this->args['irava_particle_id_name']; ?>', <?php echo base64_decode($this->args['irava_partial_background_code_area']); ?> );
						}

						setTimeout( paticaljs_irava,500);

					</script>
    				<style type="text/css">
        				<?php
        				
            				if( $this->args['irava_particles_absolute_fixed'] == 'absolute' ) {
            				    ?>
        				    	canvas.particles-js-canvas-el {
            						position: absolute;
            						top: 0;
            						left: 0;
            						z-index: 1;
            					}
            				    <?php
            				}
            				
            				if( $this->args['irava_particles_absolute_fixed'] == 'fixed' ) {
            				    ?>
        				    	canvas.particles-js-canvas-el {
            						position: fixed;
            						top: 0;
            						left: 0;
            						z-index: 1;
            					}
            				    <?php
            				}
        				
        				?>
    				</style>
				<?php

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_product_subtitle() {
			$attr = [ 
				'class' => 'iravada_capp_sec_title_style ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}

	}
	new iravada_particle_background();
}

function iravada_particle_background() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_particle_background', 
            [
                'name'            => __( 'IRAva Background Particle', 'iravada' ),
                'shortcode'       => 'iravada_particle_background',
                'icon'            => 'iravada_elements_icon particle_back',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

					[
						'type'        => 'textfield',
						'heading'     => __( 'Container ID', 'iravada' ),
						'description' => __( 'Input The Container ID Into Text Field For Display Particles Background.', 'iravada' ),
						'param_name'  => 'irava_particle_id_name',
						'value'       => '',
					],
					[
                      'type'        => 'radio_button_set',
                      'heading'     => __( 'Select Background Position', 'iravada' ),
                      'description' => __( 'Choose whether the background is fixed or absolute.', 'iravada' ),
                      'param_name'  => 'irava_particles_absolute_fixed',
                      'value'       => [
                            'absolute' => __( 'Absolute', 'iravada' ),
                            'fixed'    => __( 'Fixed', 'iravada' ),
                       ],
                       'default'    => 'absolute',
                    ],
					[
						'type'        => 'raw_textarea',
						'heading'     => __( 'Particle Json Code', 'iravada' ),
						'description' => __( 'Using the website « <strong>https://vincentgarreau.com/particles.js/</strong> » you can set the background of the container and download a json output. Then open the downloaded file and copy the code inside it and paste it in the box opposite.', 'iravada' ),
						'param_name'  => 'irava_partial_background_code_area',
						'value'       => '',
					],

					// End General Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_particle_background' );
