<?php 
// 3.0
if( !class_exists('Royal_Admin_Notices') ) {

    class Royal_Admin_Notices {

        public function __construct() {

            add_action( 'admin_notices', array($this, 'delete_royal_extra_plugins_notice') );
            
        }
        
        // Display Admin Notice On Perfect Brand is In Active
        public function delete_royal_extra_plugins_notice() {
            
            // woocommerce-page-builder-for-avada
            if( Proshop_Royal::check_plugin_activated('woocommerce-page-builder-for-avada/init.php') == true ) {
                ?>
                <div class="notice notice-error is-dismissible" style="background: #a35dc5; color: #fff; padding: 15px 30px; border: none; border-radius: 5px;">
                    <p style="font-size: 16px; line-height: 2;">WooCommerce Page Builder For Avada: نکات مهم حذف و کانفیگ حساب کاربری رویال<br>
                    1- قرار دادن شورتکد [woocommerce_my_account] در محتوای المان “محتوای مودال” در قالبساز » بخش هدر و حذف محتوای قبلی جهت لاگین.<br>
                    2- منوی صفحه ساز ووکامرس » My Account Builder هر 3 طراحی قبلی صفحه ساز ووکامرس رو حذف کنید.<br>
                    3- درون&zwnj;ریزی قالب حساب کاربری رویال از منوی ایران آوادا » تنظیمات » تنظیمات پیشفرض » دکمه قرمز نصب یا درون&zwnj;ریزی محتوا رو بزنید و بخش “درون&zwnj;ریزی قالب صفحه حساب کاربری” رو import کنید.<br>
                    4- <strong>مهم: </strong>ذخیره تنظیمات رویال از منوی ایران اوادا » تنظیمات » دکمه ذخیره تنظیمات. حتما یکبار تنظیمات باید ذخیره بشه تا حساب کاربری رویال فعال بشه.<br>
                    5- حذف افزونه WooCommerce Page Builder For Avada و در انتها شخصی سازی حساب کاربری، از منوی ایران آوادا » حساب کاربری رویال.</p>
                </div>
                <?php
            }
            
            // perfect woocommerce brands
            if( Proshop_Royal::check_plugin_activated('perfect-woocommerce-brands/perfect-woocommerce-brands.php') == true ) {
                ?>
                <div class="notice notice-error is-dismissible" style="background: #607d8b; color: #fff; padding: 15px 30px; border: none; border-radius: 5px;">
                    <p style="font-size: 16px; line-height: 2;">Perfect Brand: نکات مهم جهت حذف و کانفیگ رویال برند<br>
                    1- بررسی نامک برندهای قبلی از پیکربندی ووکامرس » تب برندها.<br>
                    2- وارد کردن همین نامک در منوی ایران آوادا » تنظیمات » بخش رویال برند » فیلد: نامک/ slug رویال برند<br>
                    3- انتقال برندهای قبلی به رویال برند. تنظیمات پروشاپ رویال » بخش رویال برند، دکمه درون ریزی برندها رو کلیک کنید.<br>
                    4- حذف افزونه Perfect Brand ، در غیر اینصورت صفحات آرشیو برند، خطای ۴۰۴ خواهند داشت.</p>
                </div>
                <?php
            }
            
            // woocommerce-group-attributes and welaunch-framework
            if( Proshop_Royal::check_plugin_activated('woocommerce-group-attributes/woocommerce-group-attributes.php') == true or Proshop_Royal::check_plugin_activated('welaunch-framework/welaunch-framework.php') == true ) {
                ?>
                <div class="notice notice-error is-dismissible" style="background: #ff5857; color: #fff; padding: 15px 30px; border: none; border-radius: 5px;">
                    <p style="font-size: 16px; line-height: 2;">دسته&zwnj;بندی ویژگیها و weLaunch Framework: نکات مهم حذف و کانفیگ دسته&zwnj;بندی ویژگی&zwnj;های رویال<br>
                    1- منوی ایران آوادا » زیرمنوی تنظیمات » زیرمنوی دسته&zwnj;بندی ویژگی&zwnj;ها<br>
                    پایین صفحه، دکمه » درون ریزی دسته&zwnj;بندی ویژگی&zwnj;ها را کلیک کنید تا دسته&zwnj;بندی ویژگی&zwnj;های قبلی به سیستم جدید منتقل شود.<br>
                    2- بررسی از منوی محصولات » دسته&zwnj;بندی ویژگی&zwnj;ها رویال » شده و لیست دسته&zwnj;بندی&zwnj;های منتقل شده را مشاهده کنید.<br>
                    3- حذف دو افزونه “دسته&zwnj;بندی ویژگیهای ووکامرس و weLaunch Framework”</p>
                </div>
                <?php
            }
            
            // نمایش نوتیس تخفیف تمدید
            date_default_timezone_set('Asia/Tehran'); // تنظیم منطقه زمانی به تهران
            $now = time(); // دریافت تاریخ فعلی
            $deadline = strtotime("2025-03-26 00:00:00"); // تنظیم تاریخ ۱۳ بدر ۱۴۰۴ (۲ آپریل ۲۰۲۵) 2025-04-03 00:00:00
            
            if ($now < $deadline && !isset($_COOKIE['hide_renewal_notice'])) {

                $back_img = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/img/bahar.webp';

                ?>
                <style>
                    .notice-renewal {
                        background-color: #ffb6c1;
                        background-image: url(<?= $back_img ?>);
                        background-position: top right;
                        background-repeat: no-repeat;
                        background-size: 300px;
                        color: white;
                        padding: 30px 50px;
                        position: relative;
                        border-radius: 7px;
                        font-size: 14px;
                        margin: 35px 0;
                        text-align: center;
                    }
                
                    .notice-renewal strong {
                        font-size: 19px;
                        color: #323232;
                    }
                    .notice-renewal p {
                        font-size: 17px;
                        line-height: 1.8;
                        font-weight: bold;
                    }
                    
                    .notice-renewal p.p1 {
                        color: #db334c;
                    }
                    
                    .notice-renewal p.p2 {
                        color: #323232;
                    }
                
                    .notice-renewal-button-parent {
                        margin-top: 10px;
                        display: flex;
                        justify-content: center;
                        gap: 10px;
                    }
                
                    .notice-renewal-button {
                        background: white;
                        color: #f16378;
                        padding: 9px 25px;
                        text-decoration: none;
                        border-radius: 6px;
                        font-weight: bold;
                    }
                    
                    .notice-renewal-button:hover {
                        color: #df3a52;
                    }
                
                    .notice-renewal-button:hover {
                        background: #f1f1f1;
                    }
                
                    .notice-renewal-close {
                        background: #f16378;
                        color: white;
                        border: none;
                        padding: 3px 12px;
                        cursor: pointer;
                        border-radius: 8px;
                        font-weight: bold;
                        position: absolute;
                        left: 15px;
                        top: 15px;
                    }
                
                    .notice-renewal-close:hover {
                        background: #df3a52;
                    }
                
                    .timer-container {
                            display: flex;
                            justify-content: center;
                            gap: 10px;
                            margin: 25px;
                    }
                
                    .timer-box {
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                        background: rgba(255, 255, 255, 0.2);
                        padding: 11px 5px 4px;
                        border-radius: 5px;
                        min-width: 60px;
                    }
                
                    .timer-value {
                        font-size: 20px;
                        font-weight: bold;
                    }
                
                    .timer-label {
                        font-size: 12px;
                        opacity: 0.9;
                    }
                </style>
                
                <div class="wrap">
                    <div class="notice-renewal">
                        <strong>تمدید لایسنس یکساله پروشاپ رویال با 30% تخفیف (برای اولین بار)</strong>
                        <span style="display: block; margin-top: 20px; font-size: 15px;">زمان تا 5 ام فروردین 1404</span>
                        <div class="timer-container">
                            <div class="timer-box">
                                <div id="seconds" class="timer-value">00</div>
                                <div class="timer-label">ثانیه</div>
                            </div>
                            <div class="timer-box">
                                <div id="minutes" class="timer-value">00</div>
                                <div class="timer-label">دقیقه</div>
                            </div>
                            <div class="timer-box">
                                <div id="hours" class="timer-value">00</div>
                                <div class="timer-label">ساعت</div>
                            </div>
                            <div class="timer-box">
                                <div id="days" class="timer-value">00</div>
                                <div class="timer-label">روز</div>
                            </div>
                        </div>
                        <p class="p1"> سلاااام. پیشاپیش عیدتون مبارک باشه. امیدوارم که تونسته باشیم در طول سال گذشته، خدمات ارزنده‌ای برای عزیزی چون شما ارائه بدیم. </br> به مناسبت عید نوروز برای اولین بار تخفیف تمدید لایسنس قالب پروشاپ رویال رو فراهم کردیم.</p>
                        <p class="p2"> با تمدید لایسنس یکساله، به اعتبار فعلی لایسنس شما، 365 روز اضافه میشه. این شرایط تمدید دیگه تکرار نمیشه. ازش استفاده کنید.</p>
                        <div class="notice-renewal-button-parent">
                            <a href="https://iranavada.com/account/irava-licenses/" target="_blank" class="notice-renewal-button">تمدید از حساب کاربری ایران آوادا</a>
                        </div>
                        <button class="notice-renewal-close">x</button>
                    </div>
                </div>
                
                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        
                        document.querySelector(".notice-renewal-close").addEventListener("click", function() {
                            document.querySelector(".notice-renewal").remove();
                            document.cookie = "hide_renewal_notice=true; path=/; max-age=" + (60 * 60 * 24 * 30); // ۳۰ روز اعتبار
                        });
                        
                    });
                
                    function updateTimer() {
                        const endDate = new Date("March 26, " + new Date().getFullYear() + " 00:00:00").getTime();
                        const now = new Date().getTime();
                        const timeLeft = endDate - now;
                
                        if (timeLeft > 0) {
                            const days = Math.floor(timeLeft / (1000 * 60 * 60 * 24));
                            const hours = Math.floor((timeLeft % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                            const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
                            const seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);
                
                            document.getElementById("days").innerHTML = days.toString().padStart(2, '0');
                            document.getElementById("hours").innerHTML = hours.toString().padStart(2, '0');
                            document.getElementById("minutes").innerHTML = minutes.toString().padStart(2, '0');
                            document.getElementById("seconds").innerHTML = seconds.toString().padStart(2, '0');
                        } else {
                            document.querySelector(".timer-container").innerHTML = "<strong>زمان به پایان رسید!</strong>";
                        }
                    }
                
                    setInterval(updateTimer, 1000);
                    updateTimer();
    
                </script>
                <?php
   
            }

        }

    } new Royal_Admin_Notices();

}
