<?php 

if( !class_exists('Royal_Brands_Shortcode') ) {

    class Royal_Brands_Shortcode {

        public function __construct() {

            add_shortcode( 'royal-brands', array($this, 'handle_royal_brands_content') );

        }

        // Handle Royal Brands Content
        public function handle_royal_brands_content( $atts ) {

            $atts = shortcode_atts(
                array(
                    'product_id'  => null,
                    'as_link'     => false,
                    'image_size'  => 'thumbnail',
                ),
                $atts,
                'royal-brands'
            );
    
            if ( ! $atts['product_id'] && is_singular( 'product' ) ) {
                $atts['product_id'] = get_the_ID();
            }
    
            $brands = wp_get_post_terms( $atts['product_id'], 'iravada-royal-brands' );
    
            foreach ( $brands as $key => $brand ) {
                $brands[ $key ]->term_link = get_term_link( $brand->term_id, 'iravada-royal-brands' );
                $brands[ $key ]->image     = wp_get_attachment_image( get_term_meta( $brand->term_id, 'royal_brands_logo', 1 ), $atts['image_size'] );

                ?>
                
                <?php
            }
    
            return Royal_Brands_Shortcode::render_template(
                'shortcodes',
                'brands',
                array(
                    'brands'      => $brands,
                    'as_link'     => $atts['as_link'],
                )
            );

        }

        public static function render_template( $folder = '', $name = '', $data = array() ) {

            if ( $folder ) {
                $folder = $folder . '/';
            }

            $template_file = get_stylesheet_directory() . '/includes/royal-brands/templates/' . $folder . $name . '.php';
    
            extract( $data );
    
            ob_start();
                include $template_file;
            return ob_get_clean();
        }

    } new Royal_Brands_Shortcode();

}