<?php 

if( !class_exists( 'Iravada_Royal_Brands_Custom_Fields' ) ) {

    class Iravada_Royal_Brands_Custom_Fields {

        public function __construct() {

            // Create Brand Section
            add_action( 'iravada-royal-brands_add_form_fields', array( $this, 'add_royal_brands_metafields' ) );
            add_action( 'create_iravada-royal-brands', array( $this, 'add_royal_brands_metafields_save' ) );

            // Edit Brand Section
            add_action( 'iravada-royal-brands_edit_form_fields', array( $this, 'add_royal_brands_metafields_form_edit' ) );
            add_action( 'edit_iravada-royal-brands', array( $this, 'add_royal_brands_metafields_save' ) );

            // Add Custom Columns For Royal Brand List
            add_filter( 'manage_iravada-royal-brands_custom_column', array( $this, 'royal_brands_taxonomy_custom_columns' ), 10, 3 );
            add_filter( 'manage_edit-iravada-royal-brands_columns', array( $this, 'royal_brands_taxonomy_columns_head' ) );

        }

        // Add New Meta Fields For Royal brands
        public function add_royal_brands_metafields() {

            ob_start();

            ?>
            <div class="form-field royal-brands-set-logo">
                <label for="royal_brands_logo"><?php esc_html_e( 'Brand Logo', 'royal' ); ?></label>
                <input type="text" name="royal_brands_logo" id="royal_brands_logo" value="">
                <a href="#" id="royal_brands_logo_select" class="button"><?php esc_html_e( 'Select image', 'royal' ); ?></a>
                <div class="royal-logo-preview"></div>
            </div>
            <?php

            echo ob_get_clean();

        }

        // Save Add New Brands Logo
        public function add_royal_brands_metafields_save( $term_id ) {

            $old_img = get_term_meta( $term_id, 'royal_brands_logo', true );
            $new_img = isset( $_POST['royal_brands_logo'] ) ? sanitize_text_field( wp_unslash( $_POST['royal_brands_logo'] ) ) : '';
    
            if ( $old_img && '' === $new_img ) {
                // Dont Do Anything
            } elseif ( $old_img !== $new_img ) {
                update_term_meta( $term_id, 'royal_brands_logo', $new_img );
            }

        }

        // Add MetaField For Edit Brands Page
        public function add_royal_brands_metafields_form_edit( $term ) {

            $term_value_image = get_term_meta( $term->term_id, 'royal_brands_logo', true );

            ob_start();
    
            ?>

            <table class="form-table">
                <tr class="form-field royal-brands-set-logo">
                    <th>
                        <label for="royal_brands_logo"><?php esc_html_e( 'Brand logo', 'royal' ); ?></label>
                    </th>
                    <td>
                        <input type="text" name="royal_brands_logo" id="royal_brands_logo" value="<?php echo esc_attr( $term_value_image ); ?>">
                        <a href="#" id="royal_brands_logo_select" class="button"><?php esc_html_e( 'Select image', 'royal' ); ?></a>

                        <?php $current_image = wp_get_attachment_image( $term_value_image, 'thumbnail', false ); ?>

                            <div class="royal-logo-preview">
                                <?php if ( ! empty( $current_image ) ) : ?>
                                    <span>
                                        <?php echo wp_kses_post( $current_image ); ?>
                                        <a href="#" class="remove-royal-brand-logo-selected">X</a>
                                    </span>
                                <?php endif; ?>
                            </div>

                    </td>
                </tr>
            </table>
    
            <?php

            echo ob_get_clean();

        }

        // Add Custom Columns To Royal Brands Taxonomy
        public function royal_brands_taxonomy_custom_columns( $c, $column_name, $term_id ) {

            switch ( $column_name ) {
                case 'logo':
                    $image = wp_get_attachment_image( get_term_meta( $term_id, 'royal_brands_logo', true), array( '40', '40' ), false );
                    return ( $image ) ? $image : wc_placeholder_img( array( '40', '40' ) );
                break;
            }

        }

        public function royal_brands_taxonomy_columns_head( $columns ) {
            $new_columns = array();
    
            if ( isset( $columns['cb'] ) ) {
                $new_columns['cb'] = $columns['cb'];
                unset( $columns['cb'] );
            }
    
            if ( isset( $columns['description'] ) ) {
                unset( $columns['description'] );
            }
    
            $new_columns['logo'] = __( 'Logo', 'royal' );
    
            return array_merge( $new_columns, $columns );
        }

    } new Iravada_Royal_Brands_Custom_Fields();

}