<?php

if( !class_exists( 'IRavada_Royal_Brands' ) ) {

    class IRavada_Royal_Brands {
        
        protected $include = '';
        protected $assetsJS = '';
        protected $assetsCSS = '';
        
        public function __construct() { 
            
            // Set Brands Path
            $this->include      = get_stylesheet_directory() . '/includes/royal-brands/inc/';
            $this->assetsJS     = get_stylesheet_directory_uri() . '/includes/royal-brands/assets/js/';
            $this->assetsCSS    = get_stylesheet_directory_uri() . '/includes/royal-brands/assets/css/';

            // Register Royal Brands For Products
            $this->register_royal_brands_taxonomy();

            // Load All Additional Files\
            $this->load_all_additional_files();

            // All Actions Needed
            add_action( 'admin_enqueue_scripts', array($this, 'royal_brands_scripts') );

            add_action('init', [$this, 'RoyalDisableWoocommerceBrands'], 99);

        }

        public function RoyalDisableWoocommerceBrands() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            $WoocommerceBrandStatus = isset($get_royal_option_settings['woocommerce_brand_status']) ? $get_royal_option_settings['woocommerce_brand_status'] : 'no';
            
            if( $WoocommerceBrandStatus == 'no' ) {
                update_option( 'wc_feature_woocommerce_brands_enabled', 'no' );
            }else {
                update_option( 'wc_feature_woocommerce_brands_enabled', 'yes' );
            }

        }

        // Register New Taxonomy For Product Post Type
        public function register_royal_brands_taxonomy() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            $brand_custom_slug = isset($get_royal_option_settings['royal_custom_brand_slug']) && !empty($get_royal_option_settings['royal_custom_brand_slug']) 
            ? $get_royal_option_settings['royal_custom_brand_slug'] 
            : 'brand';


            $labels = array(
                'name'                       => esc_html__( 'Royal Brands', 'royal' ),
                'singular_name'              => esc_html__( 'Royal Brand', 'royal' ),
                'menu_name'                  => esc_html__( 'Royal Brands', 'royal' ),
                'all_items'                  => esc_html__( 'All Brands', 'royal' ),
                'edit_item'                  => esc_html__( 'Edit Brand', 'royal' ),
                'view_item'                  => esc_html__( 'View Brand', 'royal' ),
                'update_item'                => esc_html__( 'Update Brand', 'royal' ),
                'add_new_item'               => esc_html__( 'Add New Brand', 'royal' ),
                'new_item_name'              => esc_html__( 'New Brand Name', 'royal' ),
                'parent_item'                => esc_html__( 'Parent Brand', 'royal' ),
                'parent_item_colon'          => esc_html__( 'Parent Brand:', 'royal' ),
                'search_items'               => esc_html__( 'Search Brands', 'royal' ),
                'popular_items'              => esc_html__( 'Popular Brands', 'royal' ),
                'separate_items_with_commas' => esc_html__( 'Separate brands with commas', 'royal' ),
                'add_or_remove_items'        => esc_html__( 'Add or remove brands', 'royal' ),
                'choose_from_most_used'      => esc_html__( 'Choose from the most used brands', 'royal' ),
                'not_found'                  => esc_html__( 'No brands found', 'royal' ),
            );
    
            $args = array(
                'hierarchical'      => true,
                'labels'            => $labels,
                'show_ui'           => true,
                'query_var'         => true,
                'public'            => true,
                'show_admin_column' => true,
                'show_in_rest'      => true,
                'rewrite'           => array(
                    'slug'			=> $brand_custom_slug,
					'with_front'	=> false, // ورود به ساختار برند ووکامرس و خارش شدن از ساختار پیوندهای یکتای وردپرس و بلاگ. حذف حالت /bolog/brand
					'hierarchical'	=> true,  // برای ساختار بهتر لینکها اگر برند والد فرزندی باشد، ساپورت کند.
                ),
            );
    
            register_taxonomy( 'iravada-royal-brands', array( 'product' ), $args );
        }

        // Load All Files Needed For Brands
        public function load_all_additional_files() {

            require_once( $this->include . 'register-options-for-brands.php' );
            require_once( $this->include . 'add-brands-shortcode.php' );
        }

        // Load All Scripts Needed
        public function royal_brands_scripts() {

            if( isset( $_GET['taxonomy'] ) && $_GET['taxonomy'] == 'iravada-royal-brands' ) {

                wp_enqueue_script( 'royal-brands-admin-scripts', $this->assetsJS . 'royal-brands-admin-scripts.js', array('jquery'), '2.1', true );
                wp_enqueue_style( 'royal-brands-admin-styles' , $this->assetsCSS . 'royal-brands-admin-style.css', '', '2.1' );
            }
        }
    } new IRavada_Royal_Brands();
}
// Update Permalinks For Brand Taxonomy Slug only once during theme activation
add_action( 'after_switch_theme', function() {
    $brands = new IRavada_Royal_Brands();
    $brands->register_royal_brands_taxonomy();
    flush_rewrite_rules();
});