<?php

/**
 * The template for displaying the a-z Listing
 *
 * @version 1.0.1
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

global $brand_count_product,
$display_brand_logo_state,
$brands_link_target_type,
$SearchBoxHeadTop;

if( is_admin_bar_showing() ) {
	$SearchBoxHeadTopOnLogedIn = floatval($SearchBoxHeadTop) + 32 . 'px';
}else {
	$SearchBoxHeadTopOnLogedIn = $SearchBoxHeadTop;
}

$display_brand_count = '';
?>

<?php if ( ! empty( $grouped_brands ) ) : ?>
	<div class="royal-az-listing">
		<div class="royal-az-listing-header" style="top: <?= $SearchBoxHeadTopOnLogedIn ?>;" data-top-margin-sticky="<?= $SearchBoxHeadTop ?>">
            <div class="royal-search-brands">
                <input type="text" class="royal-brands-search-input" placeholder="جستجوی برند">
            </div>
			<ul class="royal-clearfix">
				<?php foreach ( $grouped_brands as $letter => $brand_group ) : ?>
					<a href="#royal-az-listing-<?php echo esc_attr( $letter ); ?>"><li data-alpha="<?= esc_attr( $letter ); ?>"><?php echo strtoupper( esc_html( $letter ) ); ?></li></a>
				<?php endforeach; ?>
			</ul>
		</div>
		<div class="royal-az-listing-content">
		<?php foreach ( $grouped_brands as $letter => $brand_group ) : ?>
			<div id="royal-az-listing-<?php echo esc_attr( $letter ); ?>" data-alpha="<?= esc_attr( $letter ); ?>" class="royal-az-listing-row royal-clearfix">
				<p class="royal-az-listing-title"><?php echo strtoupper( esc_attr( $letter ) ); ?></p>
				<div class="royal-az-listing-row-in">
                    <ul class="royal-az-listing-col">
						<?php 
							foreach ( $brand_group as $brand ) : 

								// Display Brand Product Count
								if( $brand_count_product == 'true' ) {
									$display_brand_count = esc_html( $brand['brand_term']->name ) . ' (' . $brand['brand_term']->count . ') ';
								}else {
									$display_brand_count = esc_html( $brand['brand_term']->name );
								}

								// Display Brand Image
								$get_brand_image_id = get_term_meta( $brand['brand_term']->term_id, 'royal_brands_logo', true );
								$brand_logo 		= wp_get_attachment_image( $get_brand_image_id, array( '200', '200' ), false );
								$brand_logo_default = $brand_logo ? $brand_logo : wc_placeholder_img( array( '100', '40' ) );
							?>
								<a href="<?php echo esc_url( get_term_link( $brand['brand_term']->term_id ) ); ?>" target="<?= $brands_link_target_type ?>">
									<li class="AlphabrandLetter" data-alpha="<?= esc_attr( $letter ); ?>">
										<?php 

											// Check Display Brand Logo State
											if( $display_brand_logo_state == 'true' ) {
												?>
													<span class="brand-logo-img">
														<?= $brand_logo_default ?>
													</span>
												<?php
											}

										?>
										<span <?= FusionBuilder::attributes( 'brand-title' ) ?>>
											<?= $display_brand_count ?>
										</span>
									</li>
								</a>
							<?php 
							endforeach; 
						?>
					</ul>
				</div>
			</div>
		<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>
