<?php

/**
 * The template for displaying the "royal-brands" shortcode
 *
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );
?>

<?php if ( ! empty( $brands ) ) : ?>

<div class="royal-brand" style="width: var(--brand-shortcode-img-width);">

	<?php foreach ( $brands as $brand ) : ?>

	<a href="<?php echo esc_url( $brand->term_link ); ?>" title="<?php esc_html_e( 'View brand', 'royal' ); ?>">

		<?php if ( ! $as_link && ! empty( $brand->image ) ) : ?>

			<?php echo wp_kses_post( $brand->image ); ?>

		<?php else : ?>

			<?php echo esc_html( $brand->name ); ?>

		<?php endif; ?>

	</a>

	<?php endforeach; ?>

</div>

<?php endif; ?>
