function replaceQueryParam(param, newval, search) {
    var regex = new RegExp("([?;&])" + param + "[^&;]*[;&]?");
    var query = search.replace(regex, "$1").replace(/&$/, '');

    return (query.length > 2 ? query + "&" : "?") + (newval ? param + "=" + newval : '');
}

if( royal_compare_archive_js_data.single_status == true ) {
    // Dont Include Archive / Shop Js In Single
}else {

    // Set Product Add To Compare
    let GetAddToCompareBtn = document.querySelectorAll('.royal-add-to-compare-btn');
    GetAddToCompareBtn.forEach(AddCompareBtn => {

        AddCompareBtn.addEventListener('click', function(e) {

            e.preventDefault();

            let GetRoyalCompareBtn = document.querySelector('.royal-compare-button');

            // Select All Data Needed For Create Product Selected List To Compare
            let GetUlSelectedProduct        = document.querySelector('.royal-compare-selected-list');
            let GetProductSelectedName      = e.currentTarget.getAttribute('data-product-title');
            let GetProductSelectedID        = e.currentTarget.getAttribute('data-product-id');
            let GetProductSelectedImg       = e.currentTarget.getAttribute('data-product-image-url');

            e.currentTarget.classList.toggle('active');

            // Create Element LI For Selected Product List To Compare
            let CreateLiElement = document.createElement('li');
            CreateLiElement.classList.add(`royal-compare-list-selected-${GetProductSelectedID}`);
            let GetCurrentProductAddedToCompare = document.querySelector(`.royal-compare-list-selected-${GetProductSelectedID}`);
            
            // Inner Html Of li 
            CreateLiElement.innerHTML = `
                    <span class="royal-product-selected-img"><img src="${GetProductSelectedImg}" alt="${GetProductSelectedName}"/></span>
                    <span class="royal-product-selected-title">${GetProductSelectedName}</span>
            `;

            if( e.currentTarget.classList.contains('active') ) {
                GetUlSelectedProduct.appendChild(CreateLiElement);
            }else {
                GetCurrentProductAddedToCompare.remove();
            }

            let GetActiveCompares = document.querySelectorAll('.royal-add-to-compare-btn.active');
            if( GetActiveCompares.length <= 4 ) {
                
                var CompareSelectedIDS = [];
                GetActiveCompares.forEach(GetActivePid => {
                    CompareSelectedIDS.push(GetActivePid.getAttribute('data-product-id'));
                });

                // Royal Compare Box On Left Bottom Screen
                let GetComparePageUrlDynamicly = `${royal_compare_archive_js_data.compare_page_url}?product_ids=${CompareSelectedIDS}`;
                GetRoyalCompareBtn.innerHTML = `
                    <a href="${GetComparePageUrlDynamicly}" target="_blank" class="royal-compare-links">
                        <span class="royal-compare-text">مقایسه</span>
                        <span class="royal-compare-count">${GetActiveCompares.length} کالا</span>
                    </a>
                `;

                let GetRoyalCompareLink = document.querySelector('.royal-compare-links');
                if( GetRoyalCompareLink ) {

                    GetRoyalCompareLink.addEventListener('click', function(e) {
                    
                        e.preventDefault();

                        if( royal_compare_archive_js_data.compare_page_url == '' ) {
                            alert('برای مقایسه محصولات انتخاب شده، از تنظیمات قالب رویال برگه مقایسه رو تنظیم و یکبار صفحه را رفرش کنید.');
                        }else {
                            window.open(this.getAttribute('href'), '_blank');
                        }

                    });

                }

            }else {

                e.currentTarget.classList.remove('active');
                let GetCurrentProductAddedToCompare = document.querySelector(`.royal-compare-list-selected-${GetProductSelectedID}`);
                GetCurrentProductAddedToCompare.remove();

            }

            // Remove Royal Compare Link Tag
            if( GetActiveCompares.length <= 0 ) {
                GetRoyalCompareBtn.innerHTML = ``;
            }

        });

    });

}