// Popup JS
if( document.querySelector('.royal-compare-products') ) {

    let GetSerachBox = document.querySelectorAll('.compare-search-box');
    let GetPopUpOverlay = document.querySelector('.royal-compare-popup-overlay');
    let GetPopupCloseBtn = document.querySelector('.close-popup-x');

    GetSerachBox.forEach( SearchBox => {

        SearchBox.addEventListener('click', function(e) {

            GetPopUpOverlay.classList.add('active');

        });

    });

    // Click Event On Overlay
    GetPopUpOverlay.addEventListener('click', function(e) {

        if( e.currentTarget.classList.contains('active') ) {    
            e.currentTarget.classList.remove('active');
        }

    });

    // Close Popup By clicking On Close Btn
    GetPopupCloseBtn.addEventListener('click', function(e) {
        e.preventDefault();
        GetPopUpOverlay.classList.remove('active');
    });

}

// Remove Product From Compare => Remove btn
let getRemoveProductFromCompareBtn = document.querySelectorAll('.royal-remove-compare-icon');
getRemoveProductFromCompareBtn.forEach( RemoveBtn => {

    RemoveBtn.addEventListener('click', function(e) {

        e.preventDefault();

        let GetCurrentUrlLocation = window.location.search;
        let searchParams = new URLSearchParams(window.location.search);
        let GetCurrentClickedProductID = e.currentTarget.getAttribute('data-product-id');
        let GetParamItems = searchParams.get('product_ids').split(',');
        let GetIndexNumberClickedProduct = GetParamItems.indexOf(GetCurrentClickedProductID);

        if (GetIndexNumberClickedProduct > -1) {
            GetParamItems.splice(GetIndexNumberClickedProduct, 1);
        }
        GetCurrentUrlLocation = replaceQueryParam('product_ids', GetParamItems, GetCurrentUrlLocation);

        console.log(replaceQueryParam('product_ids', GetParamItems, GetCurrentUrlLocation));
        if( GetParamItems.length == 0 ) {
            window.location = window.location.pathname;
        }else {
            window.location = window.location.pathname + GetCurrentUrlLocation;
        }

    });
    
});

// Add Ajax To Search Product For Update Popup
let GetPopupSearchBox = document.querySelector('.serach-royal-compare-input');
let timeout = null;
GetPopupSearchBox.addEventListener('input', function(e) {

    e.preventDefault();

    let GetSearchValue = e.currentTarget.value;
    var minlength = 2;
    let searchParams = new URLSearchParams(window.location.search);
    let GetParamItems = searchParams.get('product_ids');
    let GetUrlProductIdsStatus;

    let GetLoaderSvgSection     = document.querySelector('.royal-serach-icon-popup svg');
    let GetSearchIconSection    = document.querySelector('.royal-serach-icon-popup i');
    let GetPopupContentParent   = document.querySelector('.royal-popup-content');
    
    if( GetParamItems ) {
        GetUrlProductIdsStatus = true;
    }else {
        GetUrlProductIdsStatus = false;
    }
    
    // clear last timeout check
    clearTimeout(timeout);
    
    if (GetSearchValue.length >= minlength) {

        timeout = setTimeout(function() {

            jQuery.ajax({
    
                url: royal_compare_js_data.ajax_url,
                data:{
                    action: "royal_compare_get_product_search_popup",
                    SearchValue: GetSearchValue,
                    ProductIdsExistesParam: GetUrlProductIdsStatus,
                    CurrentUrlLocation: document.location.href
                },
                cache: false,
                type: "POST",
                beforeSend: function(result) {

                    // Display Loader
                    GetSearchIconSection.style.display = 'none';
                    GetLoaderSvgSection.style.display = 'block';

                    // Add class To Popup Parent For Display Overlay Background
                    GetPopupContentParent.classList.add('requesting-product');

                },
                success: function(result) {

                    // Display Loader
                    GetSearchIconSection.style.display = 'block';
                    GetLoaderSvgSection.style.display = 'none';

                    // Add class To Popup Parent For Display Overlay Background
                    GetPopupContentParent.classList.remove('requesting-product');

                    // Inner Html From Ajax Result
                    document.querySelector('.royal-add-to-compare-product-list').innerHTML = result;
                },
                error: function (result) {},
                complete: function (result) {},
            });

        }, 1000);

    }

});

if( royal_compare_js_data.sticky_status == true ) {

    window.addEventListener('scroll', function(e) {

        const el = document.querySelector(".royal-compare-product-holder");
    
        if( window.scrollY > el.offsetHeight ) {
            el.classList.add('royal-sticky-compare-head');
        }else {
            el.classList.remove('royal-sticky-compare-head');
        }
    
    });

}
