<?php

if( !class_exists('Royal_Ajax_Request_Handle') ) {

    class Royal_Ajax_Request_Handle {

        public function __construct() {

            add_action( 'wp_ajax_royal_compare_get_product_search_popup', array( $this, 'royal_compare_product_requested_by_popup_search' ) );
            add_action( 'wp_ajax_nopriv_royal_compare_get_product_search_popup', array( $this, 'royal_compare_product_requested_by_popup_search' ) );

        }

        // Run Ajax Requested Product Search
        public function royal_compare_product_requested_by_popup_search() {

            global $wpdb;

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            $current_url = '';

            $GetAjaxSearchValue = $_POST['SearchValue'];

            $GetTableName = $wpdb->prefix . 'posts';
            $result = $wpdb->get_results( " SELECT * FROM $GetTableName WHERE `post_title` LIKE '%$GetAjaxSearchValue%' AND `post_type` = 'product' " );

            if( !$result ) {

                echo 'محصولی یافت نشد...';

            }else {

                foreach( $result as $GetID ) {

                    $GetProductID = $GetID->ID;
    
                    $product                = wc_get_product($GetProductID);
    
                    // Get Products Data Needed
                    $product_id                         = $product->get_id();
                    $product_title                      = $product->get_title();
                    $product_permalink                  = get_permalink($product->get_id());
                    $product_price_html                 = $product->get_price_html();
                    $product_image                      = $product->get_image();
                    $product_image_id                   = $product->get_image_id();
                    $product_image_url                  = wp_get_attachment_url($product_image_id);
                    $product_image_url_optimized        = get_the_post_thumbnail_url($product_id, 'irava-carousel-300-crop');
    
                    if( $_POST['ProductIdsExistesParam'] == 'false' ) {
                                        
                        if( isset( $get_royal_option_settings['compare_page'] ) ) {
                            $current_url = get_permalink( $get_royal_option_settings['compare_page'] ) . '?product_ids=' . $product_id;
                        }else {
                            $current_url = '#';
                        }
    
                    }else {
                        $current_url = $_POST['CurrentUrlLocation'] .','. $product_id;
                    }
    
                    ?>
                    <a href="<?= $current_url ?>" class="royal-add-to-compare-link" target="_self">
                        <div class="royal-compare-product-list">
                            <div class="product-image-section">
                                <img src="<?= $product_image_url_optimized ?>" alt="<?= $product_title ?>">
                            </div>
                            <div class="royal-product-title-section">
                                <h2 class="product-title"><?= $product_title ?></h2>
                            </div>
                            <div class="product-price-section">
                                <span class="product-price"><?= $product_price_html ?></span>
                            </div>
                        </div>
                    </a>
                    <?php
    
                }

            }

            exit;

        }

    } new Royal_Ajax_Request_Handle();

}