<?php

if( !class_exists('Royal_Class_Compare') ) {

    class Royal_Class_Compare {
        
        protected $includeFiles = '';

        public function __construct() {
            
            $this->includeFiles      = get_stylesheet_directory() . '/includes/royal-compare/inc/';
            
            // Load Royal Inc Files
            $this->load_all_royal_compare_inc_files();
            
            // All Actions
            add_action('wp_footer', array($this, 'compare_product_btn_link'));
        }
        
        // Load All PHP Files In inc Folder
        public function load_all_royal_compare_inc_files() {
            
            require_once($this->includeFiles . 'shortcodes/class-royal-all-shortcodes.php');
        }
        
        // Add Sticky Navbar For Compare Product
        public function compare_product_btn_link() {
            
            if ( class_exists('WooCommerce') ) {
                
                if( Royal_Compare_System::is_royal_compare() or is_shop() or is_product() or is_product_category() or is_product_tag() or is_product_taxonomy() or is_cart() ) {
                    ?>
                    <div class="royal-compare-buttons-holder">
                        <div class="royal-compare-button"></div>
                        <div class="royal-compare-items">
                            <ul class="royal-compare-selected-list"></ul>
                        </div>
                    </div>
                    <?php
                }
            }
        }
    } new Royal_Class_Compare();
}
