<?php 

if( !class_exists('Royal_Compare_System_Shortcodes') ) {

    class Royal_Compare_System_Shortcodes{

        public function __construct() {

            add_shortcode( 'royal_compare_button', array($this, 'royal_add_to_caompare_btn') );

        }

        // Add To Compare Button 
        public function royal_add_to_caompare_btn($atts) {

            // Get Royal Options
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            $get_compare_page_url = '';

            if( isset( $get_royal_option_settings['compare_page'] ) ) {
                $get_compare_page_url = get_permalink($get_royal_option_settings['compare_page']);
            }

            $args = shortcode_atts( array(
                'product' => '',
            ), $atts );
    
            $productId = absint($args['product']);
    
            if(empty($productId)) {
                global $product;
            } else {
                $product = wc_get_product($productId);
            }	   
    
            if(!is_object($product)) {
                return false;
            }

            $image_id  = $product->get_image_id();
            $image_url = wp_get_attachment_image_url( $image_id, 'thumbnail' );

            $add_to_compare_single_link = '';
            if( is_woocommerce() && is_single() ) {
                $add_to_compare_single_link = $get_compare_page_url . '?product_ids=' . get_the_ID();
                $add_class = 'single-btn';
            }else {
                $add_to_compare_single_link = '#';
                $add_class = 'archive-btn';
            }

            ?>
                <a href="<?= $add_to_compare_single_link ?>" class="royal-add-to-compare-btn <?= $add_class ?>" data-product-title="<?= $product->get_title() ?>" data-product-image-url="<?= $image_url ?>" data-product-id="<?= $product->get_id() ?>" rel="nofollow"><span>مقایسه</span></a>
            <?php

        }

    } new Royal_Compare_System_Shortcodes();

}