<?php 

if( !class_exists('Royal_Compare_System') ) {
    
    class Royal_Compare_System {
        
        protected $include = '';
        protected $assetsJS = '';
        protected $assetsCSS = '';
        protected $get_royal_option = '';
        
        public function __construct() {

            // Set Compare Path
            $this->include      = get_stylesheet_directory() . '/includes/royal-compare/inc/';
            $this->assetsJS     = get_stylesheet_directory_uri() . '/includes/royal-compare/assets/js/';
            $this->assetsCSS    = get_stylesheet_directory_uri() . '/includes/royal-compare/assets/css/';

            add_action( 'wp_enqueue_scripts', array($this, 'load_all_compare_script') );
            add_filter( 'display_post_states', array($this, 'irava_add_post_state_compare_page'), 10, 2 );

            // Load All Files
            $this->load_all_files_needed();
            
            $this->get_royal_option = Royal_Option_Functions::get_royal_option_settings();
            
            // Noindex For Compare
            add_filter( 'wp_robots', [$this, 'custom_wp_robots_noindex_compare'] );
            add_filter( 'wpseo_robots', [$this,'yoast_noindex_compare_page'] );
            add_filter( 'rank_math/frontend/robots', [$this,'rankmath_noindex_compare_page'] );
        }
        
        // Generic code if SEO plugin is not installed 
        public function custom_wp_robots_noindex_compare( $robots ) {
            
            if ( isset($this->get_royal_option['compare_page']) && is_page($this->get_royal_option['compare_page']) && !empty($_GET) ) {
                $robots['noindex'] = true;
            }
            return $robots;
            
        }

        // for Yoast SEO
        public function yoast_noindex_compare_page( $robots ) {
            
            if ( isset($this->get_royal_option['compare_page']) && is_page($this->get_royal_option['compare_page']) && !empty($_GET) ) {
                return 'noindex';
            }
            return $robots;
        }
        
        // for Rank Math SEO
        public function rankmath_noindex_compare_page( $robots ) {
            
            if ( isset($this->get_royal_option['compare_page']) && is_page($this->get_royal_option['compare_page']) && !empty($_GET) ) {
                $robots['index'] = 'noindex';
            }
            return $robots;
        }
        
        public static function is_royal_compare() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

            if( isset( $get_royal_option_settings['compare_page'] ) && $get_royal_option_settings['compare_page'] == url_to_postid( $_SERVER['REQUEST_URI'] ) ) {
                return true;
            }else {
                return false;
            }
        }

        // Load All Files Needed
        public function load_all_compare_script() {
            
            if ( class_exists('WooCommerce') ) {

                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
                $get_compare_page_dynamicly_url = '';
                $get_is_single_true = false;
    
                if( isset( $get_royal_option_settings['compare_page'] ) ) {
                    $get_compare_page_dynamicly_url = get_permalink($get_royal_option_settings['compare_page']) ? get_permalink($get_royal_option_settings['compare_page']) : '#';
                }
    
                if( is_woocommerce() && is_single() ) {
                    $get_is_single_true = true;
                }
    
                wp_enqueue_script('compare_archive_script', $this->assetsJS . 'royal-comapre-script.js', array('jquery'), '1.0.0', true);
    
                if( $this->is_royal_compare() ) {
                    wp_enqueue_style('compare_main_style', $this->assetsCSS . 'royal-comapre-page-style.css', '', '1.0.0');
                }
                
                if( is_shop() or is_product() or is_product_category() or is_product_tag() or is_product_taxonomy() or is_cart() ) {
                    wp_enqueue_style( 'iravada-demo-compare-styles' , get_stylesheet_directory_uri() . '/includes/royal-compare/assets/css/button-compare-styles.css', '', '1.0' );
                }
    
                wp_localize_script( 'compare_archive_script', 'royal_compare_archive_js_data', array( 
                    'compare_page_url' => $get_compare_page_dynamicly_url, 
                    'single_status' => $get_is_single_true )
                );
            }
        }

        // Load All PHP Files Needed
        public function load_all_files_needed() {

            // Load Class Royal Compare
            require_once( $this->include . 'class-royal-compare-handle.php' );
            require_once( $this->include . 'class-royal-compare-ajax-handle.php' );

        }

        // Load All Attributes In Array
        public static function royal_compare_attributes_selection() {

            $product_attributes = [];
        
            $get_attributes = wc_get_attribute_taxonomies();
        
            if ( $get_attributes && is_array( $get_attributes ) ) {
                foreach ( $get_attributes as $ProductAttr ) {
                    $label = $ProductAttr->attribute_label;
                    $name = 'pa_'.$ProductAttr->attribute_name;
                    $product_attributes[ urldecode( $name  ) ] = $label;
                }
            }
        
            return $product_attributes;
        }

        // Add Post State To Compare Page Selected On Proshop Option
        public function irava_add_post_state_compare_page( $post_states, $post ) {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            $get_royal_compare_page = '';

            if( isset( $get_royal_option_settings['compare_page'] ) ) {
                $get_royal_compare_page = $get_royal_option_settings['compare_page'];
            }else {
                $get_royal_compare_page = '';
            }

            if( $post->ID == $get_royal_compare_page ) {
                $post_states[] = __( 'Compare Page', 'royal' );
            }
            return $post_states;

        }

    } new Royal_Compare_System();

}