<?php 

if( !class_exists( 'Royal_Custom_Data' ) ) {

        class Royal_Custom_Data {

            public function __construct() {

                // Add specific Data Tab
                add_filter( 'woocommerce_product_data_tabs', array($this, 'royal_add_specific_custom_data'), 10, 1 );
                add_action( 'woocommerce_product_data_panels', array($this, 'royal_specific_tab_content') );
                add_action( 'woocommerce_process_product_meta', array($this, 'royal_specific_tab_save_data'), 10, 2 );

            }

            // Add specific Tab To Product Edit
            public function royal_add_specific_custom_data( $default_tabs ) {

                global $post;
                $tabs = array(
                    'royal_specific_data_tab' => array(
                        'label'       => __('Royal Custom Field Tab', 'royal'),
                        'target'      => 'royal_specific_data_tab', // ID of tab field
                        'priority'    => 60,
                        'class'       => array(),
                    ),
                );
                $default_tabs = array_merge( $default_tabs, $tabs );
                return $default_tabs;

            }

            // Add specific Tab Content Product
            public function royal_specific_tab_content() {

                global $woocommerce, $post;

                $royal_specific_group = get_post_meta($post->ID, 'royal_product_specific_field', true);
                $unserialize_data_specific_field = @unserialize($royal_specific_group);
                if (!is_array($unserialize_data_specific_field)) {
                    $unserialize_data_specific_field = array();
                }

                ?>

                <style>.royal-specific-field-1,.royal-specific-field-2,.royal-specific-field-3,.royal-specific-field-4,.royal-specific-field-5,.royal-specific-field-6,.royal-specific-field-7,.royal-specific-field-8{display:flex;align-items:center;gap:20px;margin:10px 0}</style>

                <div id="royal_specific_data_tab" class="panel woocommerce_options_panel" style="padding-right: 20px;">
                    <p class="form-field">
                        <div class="royal-specific-options">
                            <h3><span style="font-size: 16px;font-weight: bold;margin-bottom: 20px;display: block;color: #222;"><?php _e('Text Custom Fields.', 'royal'); ?> <span style="font-size: 14px;font-weight: normal;"><?php _e('Example: Warranty: Royal Store', 'royal'); ?></span></span></h3>
                            <div class="royal-specific-field-1">
                                <strong><?php _e('Text Field 1', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_one_p1]" id="royal-field-one_p1" placeholder="<?php _e('Seller', 'royal'); ?>" value="<?= isset($unserialize_data_specific_field['text_field_one_p1']) ? esc_attr($unserialize_data_specific_field['text_field_one_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_one_p2]" id="royal-field-one_p2" placeholder="<?php _e('Royal Store', 'royal'); ?>" value="<?= isset($unserialize_data_specific_field['text_field_one_p2']) ? esc_attr($unserialize_data_specific_field['text_field_one_p2']) : '' ?>">
                                <a href="#" class="button remove-value-1"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-2">
                                <strong><?php _e('Text Field 2', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_two_p1]" id="royal-field-two_p1" value="<?= isset($unserialize_data_specific_field['text_field_two_p1']) ? esc_attr($unserialize_data_specific_field['text_field_two_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_two_p2]" id="royal-field-two_p2" value="<?= isset($unserialize_data_specific_field['text_field_two_p2']) ? esc_attr($unserialize_data_specific_field['text_field_two_p2']) : '' ?>">
                                <a href="#" class="button remove-value-2"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-3">
                                <strong><?php _e('Text Field 3', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_three_p1]" id="royal-field-three_p1" value="<?= isset($unserialize_data_specific_field['text_field_three_p1']) ? esc_attr($unserialize_data_specific_field['text_field_three_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_three_p2]" id="royal-field-three_p2" value="<?= isset($unserialize_data_specific_field['text_field_three_p2']) ? esc_attr($unserialize_data_specific_field['text_field_three_p2']) : '' ?>">
                                <a href="#" class="button remove-value-3"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-4">
                                <strong><?php _e('Text Field 4', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_four_p1]" id="royal-field-four_p1" value="<?= isset($unserialize_data_specific_field['text_field_four_p1']) ? esc_attr($unserialize_data_specific_field['text_field_four_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_four_p2]" id="royal-field-four_p2" value="<?= isset($unserialize_data_specific_field['text_field_four_p2']) ? esc_attr($unserialize_data_specific_field['text_field_four_p2']) : '' ?>">
                                <a href="#" class="button remove-value-4"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-5">
                                <strong><?php _e('Text Field 5', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_five_p1]" id="royal-field-five_p1" value="<?= isset($unserialize_data_specific_field['text_field_five_p1']) ? esc_attr($unserialize_data_specific_field['text_field_five_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_five_p2]" id="royal-field-five_p2" value="<?= isset($unserialize_data_specific_field['text_field_five_p2']) ? esc_attr($unserialize_data_specific_field['text_field_five_p2']) : '' ?>">
                                <a href="#" class="button remove-value-5"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-6">
                                <strong><?php _e('Text Field 6', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_six_p1]" id="royal-field-six_p1" value="<?= isset($unserialize_data_specific_field['text_field_six_p1']) ? esc_attr($unserialize_data_specific_field['text_field_six_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_six_p2]" id="royal-field-six_p2" value="<?= isset($unserialize_data_specific_field['text_field_six_p2']) ? esc_attr($unserialize_data_specific_field['text_field_six_p2']) : '' ?>">
                                <a href="#" class="button remove-value-6"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-7">
                                <strong><?php _e('Text Field 7', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_seven_p1]" id="royal-field-seven_p1" value="<?= isset($unserialize_data_specific_field['text_field_seven_p1']) ? esc_attr($unserialize_data_specific_field['text_field_seven_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_seven_p2]" id="royal-field-seven_p2" value="<?= isset($unserialize_data_specific_field['text_field_seven_p2']) ? esc_attr($unserialize_data_specific_field['text_field_seven_p2']) : '' ?>">
                                <a href="#" class="button remove-value-7"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-8">
                                <strong><?php _e('Text Field 8', 'royal'); ?></strong>
                                <input style="width: 30%;" type="text" name="royal-field[text_field_eight_p1]" id="royal-field-eight_p1" value="<?= isset($unserialize_data_specific_field['text_field_eight_p1']) ? esc_attr($unserialize_data_specific_field['text_field_eight_p1']) : '' ?>">
                                <input style="width: 30%;" type="text" name="royal-field[text_field_eight_p2]" id="royal-field-eight_p2" value="<?= isset($unserialize_data_specific_field['text_field_eight_p2']) ? esc_attr($unserialize_data_specific_field['text_field_eight_p2']) : '' ?>">
                                <a href="#" class="button remove-value-8"><?php _e('Delete Value', 'royal'); ?></a>
                            </div>
                            <br>
                            <h3><?php _e('Image Custom Fields', 'royal'); ?></h3>
                            <div class="royal-specific-field-1">
                                <strong><?php _e('Image Field 1', 'royal'); ?></strong>
                                <input type="text" name="royal-field[img_field_one]" id="royal-field-img-one" value="<?= isset($unserialize_data_specific_field['img_field_one']) ? esc_attr($unserialize_data_specific_field['img_field_one']) : '' ?>">

                                <a href="#" class="button upload-img-one"><?php _e('Upload Image', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-2">
                                <strong><?php _e('Image Field 2', 'royal'); ?></strong>
                                <input type="text" name="royal-field[img_field_two]" id="royal-field-img-two" value="<?= isset($unserialize_data_specific_field['img_field_two']) ? esc_attr($unserialize_data_specific_field['img_field_two']) : '' ?>">
                                <a href="#" class="button upload-img-two"><?php _e('Upload Image', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-3">
                                <strong><?php _e('Image Field 3', 'royal'); ?></strong>
                                <input type="text" name="royal-field[img_field_three]" id="royal-field-img-three" value="<?= isset($unserialize_data_specific_field['img_field_three']) ? esc_attr($unserialize_data_specific_field['img_field_three']) : '' ?>">
                                <a href="#" class="button upload-img-three"><?php _e('Upload Image', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-4">
                                <strong><?php _e('Image Field 4', 'royal'); ?></strong>
                                <input type="text" name="royal-field[img_field_four]" id="royal-field-img-four" value="<?= isset($unserialize_data_specific_field['img_field_four']) ? esc_attr($unserialize_data_specific_field['img_field_four']) : '' ?>">
                                <a href="#" class="button upload-img-four"><?php _e('Upload Image', 'royal'); ?></a>
                            </div>
                            <div class="royal-specific-field-5">
                                <strong><?php _e('Image Field 5', 'royal'); ?></strong>
                                <input type="text" name="royal-field[img_field_five]" id="royal-field-img-five" value="<?= isset($unserialize_data_specific_field['img_field_five']) ? esc_attr($unserialize_data_specific_field['img_field_five']) : '' ?>">
                                <a href="#" class="button upload-img-five"><?php _e('Upload Image', 'royal'); ?></a>
                            </div>
                            <br>
                            <h3><?php _e('Textarea Custom Fields', 'royal'); ?></h3>
                            <div class="royal-specific-field-1">
                                <strong><?php _e('Description Field 1', 'royal'); ?></strong>
                                <textarea name="royal-field[textarea_field_one]" id="royal-field-textarea-one" rows="2" cols="50"><?= isset($unserialize_data_specific_field['textarea_field_one']) ? esc_textarea($unserialize_data_specific_field['textarea_field_one']) : '' ?></textarea>

                            </div>
                            <div class="royal-specific-field-2">
                                <strong><?php _e('Description Field 2', 'royal'); ?></strong>
                                <textarea name="royal-field[textarea_field_two]" id="royal-field-textarea-two" rows="2" cols="50"><?= isset($unserialize_data_specific_field['textarea_field_two']) ? esc_textarea($unserialize_data_specific_field['textarea_field_two']) : '' ?></textarea>
                            </div>
                            <div class="royal-specific-field-3">
                                <strong><?php _e('Description Field 3', 'royal'); ?></strong>
                                <textarea name="royal-field[textarea_field_three]" id="royal-field-textarea-three" rows="2" cols="50"><?= isset($unserialize_data_specific_field['textarea_field_three']) ? esc_textarea($unserialize_data_specific_field['textarea_field_three']) : '' ?></textarea>
                            </div>
                        </div>
                    </p>
                </div>

                <!-- Jquery For Load Upload Media Section For 5 Button Upload Image -->
                <script> jQuery(document).ready(function(t){var i,l,o,a,n;t(".upload-img-one").click(function(e){e.preventDefault(),i||(i=wp.media.frames.file_frame=wp.media({title:"آپلود / انتخاب",button:{text:"انتخاب"},multiple:!1})).on("select",function(){var e=i.state().get("selection").first().toJSON();t("#royal-field-img-one").val(e.url)}),i.open()}),t(".upload-img-two").click(function(e){e.preventDefault(),l||(l=wp.media.frames.file_frame=wp.media({title:"آپلود / انتخاب",button:{text:"انتخاب"},multiple:!1})).on("select",function(){var e=l.state().get("selection").first().toJSON();t("#royal-field-img-two").val(e.url)}),l.open()}),t(".upload-img-three").click(function(e){e.preventDefault(),o||(o=wp.media.frames.file_frame=wp.media({title:"آپلود / انتخاب",button:{text:"انتخاب"},multiple:!1})).on("select",function(){var e=o.state().get("selection").first().toJSON();t("#royal-field-img-three").val(e.url)}),o.open()}),t(".upload-img-four").click(function(e){e.preventDefault(),a||(a=wp.media.frames.file_frame=wp.media({title:"آپلود / انتخاب",button:{text:"انتخاب"},multiple:!1})).on("select",function(){var e=a.state().get("selection").first().toJSON();t("#royal-field-img-four").val(e.url)}),a.open()}),t(".upload-img-five").click(function(e){e.preventDefault(),n||(n=wp.media.frames.file_frame=wp.media({title:"آپلود / انتخاب",button:{text:"انتخاب"},multiple:!1})).on("select",function(){var e=n.state().get("selection").first().toJSON();t("#royal-field-img-five").val(e.url)}),n.open()})}); let RemoveValue1=document.querySelector(".remove-value-1"),RemoveValue2=document.querySelector(".remove-value-2"),RemoveValue3=document.querySelector(".remove-value-3"),RemoveValue4=document.querySelector(".remove-value-4"),RemoveValue5=document.querySelector(".remove-value-5"),RemoveValue6=document.querySelector(".remove-value-6"),RemoveValue7=document.querySelector(".remove-value-7"),RemoveValue8=document.querySelector(".remove-value-8");RemoveValue1.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-one_p1").value="",document.querySelector("#royal-field-one_p2").value=""}),RemoveValue2.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-two_p1").value="",document.querySelector("#royal-field-two_p2").value=""}),RemoveValue3.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-three_p1").value="",document.querySelector("#royal-field-three_p2").value=""}),RemoveValue4.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-four_p1").value="",document.querySelector("#royal-field-four_p2").value=""}),RemoveValue5.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-five_p1").value="",document.querySelector("#royal-field-five_p2").value=""}),RemoveValue6.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-six_p1").value="",document.querySelector("#royal-field-six_p2").value=""}),RemoveValue7.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-seven_p1").value="",document.querySelector("#royal-field-seven_p2").value=""}),RemoveValue8.addEventListener("click",function(e){e.preventDefault(),document.querySelector("#royal-field-eight_p1").value="",document.querySelector("#royal-field-eight_p2").value=""});

                </script>  

            <?php

            }

            // Save Royal specific Data
            public function royal_specific_tab_save_data( $post_id, $post_object ) {
                // برای امنیت بیشتر فقط برای محصولات این کد را اجرا کنید
                if ( 'product' !== $post_object->post_type ) {
                    return;
                }
                
                // اگر فیلدی پست شده باشد
                if ( isset($_POST['royal-field']) && is_array($_POST['royal-field']) ) {
                    // داده‌ها را تمیز کنید و سپس ذخیره کنید
                    $clean_data = array();
                    
                    // تمیز کردن فیلدهای متن
                    $text_fields = array(
                        'text_field_one_p1', 'text_field_one_p2',
                        'text_field_two_p1', 'text_field_two_p2',
                        'text_field_three_p1', 'text_field_three_p2',
                        'text_field_four_p1', 'text_field_four_p2',
                        'text_field_five_p1', 'text_field_five_p2',
                        'text_field_six_p1', 'text_field_six_p2',
                        'text_field_seven_p1', 'text_field_seven_p2',
                        'text_field_eight_p1', 'text_field_eight_p2'
                    );
                    
                    foreach ( $text_fields as $field ) {
                        if ( isset($_POST['royal-field'][$field]) ) {
                            $clean_data[$field] = sanitize_text_field($_POST['royal-field'][$field]);
                        }
                    }
                    
                    // تمیز کردن آدرس‌های تصویر
                    $img_fields = array(
                        'img_field_one', 'img_field_two', 'img_field_three', 'img_field_four', 'img_field_five'
                    );
                    
                    foreach ( $img_fields as $field ) {
                        if ( isset($_POST['royal-field'][$field]) ) {
                            $clean_data[$field] = esc_url_raw($_POST['royal-field'][$field]);
                        }
                    }
                    
                    // تمیز کردن فیلدهای textarea
                    $textarea_fields = array(
                        'textarea_field_one', 'textarea_field_two', 'textarea_field_three'
                    );
                    
                    foreach ( $textarea_fields as $field ) {
                        if ( isset($_POST['royal-field'][$field]) ) {
                            $clean_data[$field] = sanitize_textarea_field($_POST['royal-field'][$field]);
                        }
                    }
                    
                    // اگر داده‌ها وجود داشته باشند، ذخیره کنید
                    if ( !empty($clean_data) ) {
                        update_post_meta($post_id, 'royal_product_specific_field', serialize($clean_data));
                    } else {
                        // اگر همه فیلدها خالی هستند، متادیتا را حذف کنید
                        delete_post_meta($post_id, 'royal_product_specific_field');
                    }
                } else {
                    // اگر فرم ارسال نشده باشد، اطلاعات را پاک نکنید
                    // می‌توانید این بخش را حذف کنید یا به همین صورت نگهدارید
                }
            }

        }new Royal_Custom_Data();

}