<?php

if( !class_exists('Royal_Uniq_Attributes') ) {

  class Royal_Uniq_Attributes {

    public function __construct() {

      // Add Metabox
      add_action('admin_init', array($this, 'gpm_add_meta_boxes'), 2);

      // Save Metabox Info
      add_action('save_post', array($this, 'product_unique_attributes'));

    }

    public function gpm_add_meta_boxes() {

      add_meta_box( 

        'mcgtitle-group',  
        __('Product Important features', 'royal'), 
        array($this, 'Repeatable_meta_box_display'), 
        'product', 
        'normal', 
        'high'

      );

    }

    // MetaBox Data Content
    public function Repeatable_meta_box_display() {

      global $post;
    
      $mcg_group_title = get_post_meta($post->ID, 'mcg_group_title', true);
      $gpminvoice_group = get_post_meta($post->ID, 'customdata_group', true);
    
        wp_nonce_field( 'mcg_repeatable_meta_box_nonce', 'mcg_repeatable_meta_box_nonce' );
    
      ?>
      <style>
        table#repeatable-fieldset-one tr td {
          display: block;
          float: right;
        }
      </style>
      <script type="text/javascript">
        jQuery(document).ready(function( $ ){
            $( '#add-row' ).on('click', function() {
                var row = $( '.empty-row.screen-reader-text' ).clone(true);
                row.removeClass( 'empty-row screen-reader-text' );
                row.insertBefore( '#repeatable-fieldset-one tbody>tr:last' );
                return false;
                });
            $( '.remove-row' ).on('click', function() {
                $(this).parents('tr').remove();
                return false;
            });
        });
      </script>
    
      <table id="repeatable-fieldset-one" width="100%">
        <tbody>
          <tr>
            <td width="100%">
              <input type="text"  placeholder="عنوان ویژگی‌ها" name="mcg_gtitle" value="<?php  echo $mcg_group_title; ?>" />
            </td>
          </tr>
          <?php
          if ( $gpminvoice_group ) :
            foreach ( $gpminvoice_group as $field ) {
              ?>
              <tr>
                <td><input type="text" placeholder="عنوان" name="TitleItem[]" value="<?php if($field['TitleItem'] != '') echo esc_attr( $field['TitleItem'] ); ?>" /></td> 
                <td><input type="text" placeholder="ویژگی" name="AttrItem[]" value="<?php if($field['AttrItem'] != '') echo esc_attr( $field['AttrItem'] ); ?>" /></td> 
                <td><a class="button remove-row" href="#1"><?php _e('Delete', 'royal'); ?></a></td>
              </tr>
              <?php
            }
          else :
          // show a blank one
          ?>
            <tr>
              <td><input type="text" placeholder="عنوان" title="Title" name="TitleItem[]" /></td>
              <td><input type="text" placeholder="ویژگی" title="Attr" name="AttrItem[]" /></td>
              <td><a class="button  cmb-remove-row-button button-disabled" href="#"><?php _e('Delete', 'royal'); ?></a></td>
            </tr>
          <?php endif; ?>
    
          <!-- empty hidden one for jQuery -->
          <tr class="empty-row screen-reader-text">
            <td><input type="text" placeholder="عنوان" name="TitleItem[]"/></td>
            <td><input type="text" placeholder="ویژگی" name="AttrItem[]"/></td>
            <td><a class="button remove-row" href="#"><?php _e('Delete', 'royal'); ?></a></td>
          </tr>
        </tbody>
      </table>
      <p><a id="add-row" class="button" href="#"><?php _e('Add', 'royal'); ?></a></p>
      <?php
      
    }

    // Save Uniq Attributes MetaBox Data
    public function product_unique_attributes($post_id) {

      if ( ! isset( $_POST['mcg_repeatable_meta_box_nonce'] ) ||
      ! wp_verify_nonce( $_POST['mcg_repeatable_meta_box_nonce'], 'mcg_repeatable_meta_box_nonce' ) )
          return;
  
      if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
          return;
  
      if (!current_user_can('edit_post', $post_id))
          return;
  
      $old = get_post_meta($post_id, 'customdata_group', true);
      $new = array();
      $titleitem = $_POST['TitleItem'];
      $attrItem = $_POST['AttrItem'];
      $prices = $_POST['TitleDescription'];
      $count = count( $titleitem );

      for ( $i = 0; $i < $count; $i++ ) {

        if ( $titleitem[$i] != '' ) :
            $new[$i]['TitleItem'] = stripslashes( strip_tags( $titleitem[$i] ) );
            $new[$i]['AttrItem'] = stripslashes( strip_tags( $attrItem[$i] ) );
            $new[$i]['TitleDescription'] = stripslashes( $prices[$i] ); // and however you want to sanitize
        endif;

      }

      if ( isset ( $_POST['mcg_gtitle'] ) ) {

       update_post_meta( $post_id, 'mcg_group_title', $_POST['mcg_gtitle'] );

      }
          
      if ( !empty( $new ) && $new != $old )
            update_post_meta( $post_id, 'customdata_group', $new );

      elseif ( empty($new) && $old )
          delete_post_meta( $post_id, 'customdata_group', $old );

    }

  }new Royal_Uniq_Attributes();

}