<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'Iravada_Product_Wishlist' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class Iravada_Product_Wishlist {

		protected $args;
		protected $unique_class;
		protected $css_url_path = '';
		protected $js_url_path = '';

		public function __construct() {

			// Register All Path Needed
			$this->css_url_path	= get_stylesheet_directory_uri() . '/includes/royal-elements/includes/irava-product-wishlist/assets/css/';
			$this->js_url_path	= get_stylesheet_directory_uri() . '/includes/royal-elements/includes/irava-product-wishlist/assets/js/';

			add_filter( 'fusion_attr_irava-items-inner', [ $this, 'wrapper_attr_irava_items_inner' ] );
			add_shortcode( 'Iravada_Product_Wishlist', [ $this, 'render' ] );

			// Register All Script Needed
			add_action( 'wp_enqueue_scripts', array($this, 'irava_product_wishlist_scripts') );

			// Ajax Remove Product From Wishlist
			add_action( 'wp_ajax_irava_product_remove_wishlist_page' , array($this, 'irava_product_remove_wishlist_page_function') );
			add_action( 'wp_ajax_nopriv_irava_product_remove_wishlist_page' , array($this, 'irava_product_remove_wishlist_page_function') );

		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				// Manage Active Sections
				'irava_status_wishlist_row_sections'			=> 'product_img,product_title,product_price,product_addtocart',

				// Class ID Hide Option
				'class'											=> '',
				'id'											=> '',
                'hide_on_mobile'  								=> fusion_builder_default_visibility( 'array' ), 
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

            global $wpdb, $wishlist_product_id;

			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'Iravada_Product_Wishlist' );
			
			$this->args = $defaults;

            // Get Current User ID IF Loged IN
            $current_user_id_page        = get_current_user_id();

            // Get Post Meta Tabel Name
            $irava_postmeta_tabel_page   = $wpdb->prefix . 'postmeta';

            // Get Data Of Wishlist Product Added
            $get_wishlist_query_page     = " SELECT * FROM $irava_postmeta_tabel_page WHERE `meta_key` = '_iranavada_royal_wishlist$current_user_id_page' ";
            $get_query_result_page       = $wpdb->get_results($get_wishlist_query_page);

			// Query For Count Of Wishlist Added
			$count_data_query       = " SELECT COUNT(meta_key) FROM $irava_postmeta_tabel_page WHERE `meta_key` = '_iranavada_royal_wishlist$current_user_id_page' ";
			$count_query_wishlist   = $wpdb->get_var($count_data_query);

			wp_enqueue_script( 'irava-wishlist-js-page-list' );
			wp_enqueue_style( 'irava-wishlist-style-page-list' );

			ob_start();

            if( class_exists('Royal_Option_Functions') ) {
                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            }else {
                $get_royal_option_settings = array('wishlist_status' => '');
            }
            
            if( $get_royal_option_settings['wishlist_status'] == 'yes' ) {
                
                ?>
                <div class="irava-wishlist-page-list">
                    <?php 
    
    					if( $count_query_wishlist > 0 ) {
    
    						foreach( $get_query_result_page as $get_data_meta ) {
    
    							$wishlist_product_id = $get_data_meta->post_id ;
    	
    							$product = wc_get_product( $get_data_meta->post_id );
    							?>
    								<div <?= FusionBuilder::attributes( 'irava-items-inner' ) ?>>
    									<?php  
    										// Check Product Image If Checked For Display Image
    										if( false !== strpos( $this->args['irava_status_wishlist_row_sections'], 'product_img' ) ) {
    											?>
    											<div class="irava-wishlist-img">
        											<div class="irava-wishlist-remove" data-remove-id="<?= $get_data_meta->post_id ?>" data-user-id="<?= get_current_user_id() ?>"><span><i class="fa-times fas"></i></span></div>
        											<a href="<?= $product->get_permalink(); ?>" target="_blank"><img src="<?= get_the_post_thumbnail_url( $get_data_meta->post_id, 'thumbnail' ) ?>" alt="<?= $product->get_title(); ?>"></a>
    											</div>
    											<?php
    										}
    									?>
    									<div class="irava-wishlist-info">
    										<?php  
    											// Check Product Title If Checked For Display Title
    											if( false !== strpos( $this->args['irava_status_wishlist_row_sections'], 'product_title' ) ) {
    												?><div class="irava-product-name"><a href="<?= $product->get_permalink(); ?>" target="_blank"><span><?= $product->get_title(); ?></span></a></div><?php
    											}
    	
    											// Check Product Price If Checked For Display Price
    											if( false !== strpos( $this->args['irava_status_wishlist_row_sections'], 'product_price' ) ) {
    												?><div class="irava-product-price"><span><?= $product->get_price_html(); ?></span></div><?php
    											}
    										?>
    									</div>
    									<div class="irava-wishlist-add-to-cart">
    										<?php 
                                                if( $product->is_type('simple') ) {
                                                    
                                                    if( $product->is_in_stock() ) {
                                                        ?><a href="<?php echo '?add-to-cart='. $get_data_meta->post_id .''; ?>" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">افزودن به سبد</a><?php
                                                    }else {
                                                        ?><a href="#" style="background: #ff666624;color: #ff6767;" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">ناموجود</a><?php
                                                    }
                                                    
                                                }else if( $product->is_type('variable') ) {
                                                    
                                                    if( $product->is_in_stock() ) {
                                                        ?><a href="<?php echo $product->get_permalink(); ?>" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">انتخاب گزینه</a><?php
                                                    }else {
                                                        ?><a href="#" style="background: #ff666624;color: #ff6767;" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">ناموجود</a><?php
                                                    }
                                                    
                                                }
    										?>
    									</div>
    								</div>
    							<?php
    	
    						}// End Wishlist popup Foreach Loop
    
    					}else {
    						?>
    							<div class="irava-not-added-wishlist">
    								<p>محصولی در لیست علاقمندی شما وجود ندارد.</p>
    							</div>
    						<?php
    					}
    
                    ?>
                </div>
    
                <?php
                
            }else {
                ?>
				<div class="irava-not-added-wishlist">
					<p style="text-align: center;">برای نمایش علاقمندی لطفا از تنظیمات پروشاپ علاقمندی‌ها را فعال کنید.</p>
				</div>
				<?php
            }

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_irava_items_inner() {

			global $wishlist_product_id;

			$attr = [ 
				'class' => 'irava-items-inner ' . $this->unique_class,
				'style' => '' 
			];

			// Add Dynamic Class By Row With Product ID
			$attr['class'] .= 'item-row-id-'.$wishlist_product_id;

			// PHP Code For Handle class
            if ( isset($this->args['class']) ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( isset($this->args['id']) ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
			if( isset($this->args['hide_on_mobile']) ) {
			    $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
			}
            
			return $attr;
		}

		// Load All Scripts Needed
		public function irava_product_wishlist_scripts() {

			// Register Script File
			wp_register_script( 'irava-wishlist-js-page-list', $this->js_url_path . 'irava-wishlist-page-script.js', array('jquery'), '6.0', true );

			// Register Style File
			wp_register_style( 'irava-wishlist-style-page-list', $this->css_url_path . 'irava-wishlist-page-style.css', '', '6.0' );

			// Localize Data For irava-wishlist.js
            wp_localize_script( 'irava-wishlist-js-page-list', 'royal_wishlist_ajax_url_page', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );

		}

		// Handle Ajax Remove Product From Wishlist
		public function irava_product_remove_wishlist_page_function() {

            // Get Remove ID ==> Product ID
            $RemoveID       = $_POST['RemoveID'];

            // Get Current User ID
            $CurrentUserID  = $_POST['UserID'];

            $RemovePostMeta = delete_post_meta( $RemoveID, '_iranavada_royal_wishlist'.$CurrentUserID, 'added' );

            // Send Result To JS
            if( $RemovePostMeta == true ) {
                echo 'RemoveSuccessfuly';
            }

            exit;

		}

	}
	new Iravada_Product_Wishlist();
}

function iravada_product_wishlist_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'Iravada_Product_Wishlist', 
            [
                'name'            => __( 'Royal Product Wishlist', 'royal' ),
                'shortcode'       => 'Iravada_Product_Wishlist',
                'icon'            => 'iravada_elements_icon',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						[ 
							'type'        => 'checkbox_button_set',
							'heading'     => __( 'Active/Deactive Wishlist Sections', 'royal' ),
							'description' => __( 'Manage the display of different sections of each row of products added to Wishlist.', 'royal' ),
							'param_name'  => 'irava_status_wishlist_row_sections',
							'value'       => [
								'product_img'     		=> __( 'Product Image', 'royal' ),
								'product_title' 		=> __( 'Product Title', 'royal' ),
								'product_price'    		=> __( 'Product Price', 'royal' ),
								'product_addtocart'     => __( 'Product Add To Cart', 'royal' ),
							],
							'default'	  => ['product_img','product_title','product_price','product_addtocart'],
						], 

						// Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_product_wishlist_element' );
