<?php

if( !class_exists('IRava_Royal_Wishlist') ) {

    class IRava_Royal_Wishlist {
        
        protected $irava_wishlist_js = '';
        protected $irava_wishlist_css = '';
        protected $irava_wishlist_inc = '';

        public function __construct() {

            $this->irava_wishlist_js  = get_stylesheet_directory_uri() . '/includes/royal-elements/includes/irava-product-wishlist/assets/js/';
            $this->irava_wishlist_css = get_stylesheet_directory_uri() . '/includes/royal-elements/includes/irava-product-wishlist/assets/css/';
            $this->irava_wishlist_inc = get_stylesheet_directory() . '/includes/royal-elements/includes/irava-product-wishlist/inc/';

            // Enqueue All Scripts Needed
            add_action( 'wp_enqueue_scripts', array($this, 'irava_royal_wishlist_scripts') );

            // Add Custom Shortcode For Wishlist
            add_shortcode( 'irava_royal_wishlist', array($this, 'royal_wishlist_func') );

            // Load Popup On Footer
            add_action( 'wp_footer', array($this, 'irava_wishlist_popup_footer') );

            // Ajax Add To Wishlist
            add_action( 'wp_ajax_irava_royal_wishlist' , array($this, 'irava_royal_wishlist_function') );
            add_action( 'wp_ajax_nopriv_irava_royal_wishlist' , array($this, 'irava_royal_wishlist_function') );
            
            // Ajax Remove Product From Wishlist
            add_action( 'wp_ajax_irava_product_remove_wishlist' , array($this, 'irava_product_remove_wishlist_function') );
            add_action( 'wp_ajax_nopriv_irava_product_remove_wishlist' , array($this, 'irava_product_remove_wishlist_function') );

            // Add Post State To Wishlist Page
            add_filter( 'display_post_states', array($this, 'irava_add_post_state_wishlist_page'), 10, 2 );

        }
        
        // Register All Scripts Needed For Wishlist
        public function irava_royal_wishlist_scripts() {

            if( class_exists('Royal_Option_Functions') ) {
                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            }else {
                $get_royal_option_settings = array('wishlist_status' => '');
            }

            if( $get_royal_option_settings['wishlist_status'] == 'yes' ) {

                if( is_woocommerce() ) {
                    
                    wp_register_script( 'irava_royal_wishlist_js', $this->irava_wishlist_js . 'irava-wishlist.js', array('jquery'), '6.0', true );
                    wp_enqueue_style( 'irava_royal_wishlist_css', $this->irava_wishlist_css . 'irava-wishlist.css', '6.0' );
        
                    // Localize Data For irava-wishlist.js
                    wp_localize_script( 'irava_royal_wishlist_js', 'royal_wishlist_ajax_url', array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'cureent_user' => get_current_user_id() ) );
                    
                }
                
            }

        }
        
        // Set Product Add To Wishlist Button
        public function royal_wishlist_func() {
            
            if( class_exists('Royal_Option_Functions') ) {
                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            }else {
                $get_royal_option_settings = array('wishlist_status' => '');
            }

            if( $get_royal_option_settings['wishlist_status'] == 'yes' ) {
                
			    wp_enqueue_script( 'irava_royal_wishlist_js' );

    			if( is_product() or is_product_category() or is_archive() or is_shop() ) {
    
                    global $wpdb;
    
                    // Get Tabel Name
                    $irava_postmeta_tabel   = $wpdb->prefix . 'postmeta';
        
                    // Get Current User ID IF Loged IN
                    $current_user_id = get_current_user_id();
        
                    // Query For Count Of Wishlist Added
                    $count_data_query       = " SELECT COUNT(meta_key) FROM $irava_postmeta_tabel WHERE `meta_key` = '_iranavada_royal_wishlist$current_user_id' ";
                    $count_query_wishlist   = $wpdb->get_var($count_data_query);
    
    				$product = wc_get_product( get_the_ID() );
    				$irava_royal_wishlist_added = get_post_meta( get_the_ID(), '_iranavada_royal_wishlist'.$current_user_id, true );
    
                    $product_price_symbol = '';

                    if( $product->get_price() != '' ) {
                        $product_price_symbol = number_format( $product->get_price() ) .' '. get_woocommerce_currency_symbol();
                    }

    				ob_start();
    
    				?>
    				<div class="irava-royal-wishlist-section irava-section-id-<?php echo get_the_ID(); ?> <?php if( $irava_royal_wishlist_added == 'added' ) { echo 'added-wishlist'; } ?>">
    					<a href="#" class="irava_royal_wishlist irava-wishlist-id-<?php echo get_the_ID(); ?>" data-wishlist-count="<?= $count_query_wishlist ?>" data-product-type="<?= $product->get_type() ?>" data-pid="<?= get_the_ID(); ?>" data-image-url="<?= get_the_post_thumbnail_url( get_the_ID(), 'thumbnail' ); ?>" data-product-url="<?= $product->get_permalink(); ?>" data-product-name="<?= $product->get_title(); ?>" data-product-price="<?= $product_price_symbol ?>">
    						<?php 
    						
    						if( $irava_royal_wishlist_added == 'added' ) {
    							?><i id="iravada_heart_icon" class="fas fa-heart iravada_heart_icon_<?= get_the_ID() ?>"></i><?php
    						}else {
    							?><i id="iravada_heart_icon" class="far fa-heart iravada_heart_icon_<?= get_the_ID() ?>"></i><?php
    						}
    						
    						?>
    					</a>
    				</div>
    				<?php
    
    				return ob_get_clean();
    			
    			}
			
            }

        }

        // Load Popup Codes On Footer
        public function irava_wishlist_popup_footer() {

            global $wpdb, $post;

			if( class_exists('IPL_CLIENT_UPDATE_THEME') ) {

				if( IPL_CLIENT_UPDATE_THEME::update() ) {

                    
                    if ( is_woocommerce() ) {
        
                        if( class_exists('Royal_Option_Functions') ) {
                            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
                        }else {
                            $get_royal_option_settings = array('wishlist_page' => '');
                        }
        
                        // Get Tabel Name
                        $irava_postmeta_tabel   = $wpdb->prefix . 'postmeta';
        
                        // Get Current User ID IF Loged IN
                        $current_user_id = get_current_user_id();
        
                        // Query For Count Of Wishlist Added
                        $count_data_query       = " SELECT COUNT(meta_key) FROM $irava_postmeta_tabel WHERE `meta_key` = '_iranavada_royal_wishlist$current_user_id' ";
                        $count_query_wishlist   = $wpdb->get_var($count_data_query);
        
                        // Get Data Of Wishlist Product Added
                        $get_wishlist_query     = " SELECT * FROM $irava_postmeta_tabel WHERE `meta_key` = '_iranavada_royal_wishlist$current_user_id' ";
                        $get_query_result       = $wpdb->get_results($get_wishlist_query);
        
                        if( $get_royal_option_settings['wishlist_status'] == 'yes' ) {
                            
                            ?>
                            <div class="irava-wishlist-popup" style="opacity: 0; visibility: hidden; display: none;"></div>
                            <div class="irava-popup-wishlist-inner" style="display: none;">
                                <div class="irava-wishlist-popup-top">
                                    <span class="irava-wishlist-name">لیست علاقمندی‌ها</span>
                                    <span class="irava-wishlist-count">(<?php echo $count_query_wishlist; ?>)</span>
                                    <span class="irava-wishlist-popup-close">
                                        <i class="fa-times fas"></i>
                                    </span>
                                </div>
                                <div class="irava-wishlist-popup-body">
                                <?php 
                
                                    foreach( $get_query_result as $get_data_meta ) {
                
                                        $product = wc_get_product( $get_data_meta->post_id );
                                        ?>
                                            <div class="irava-items-inner item-row-id-<?php echo $get_data_meta->post_id ?>">
                                                <div class="irava-wishlist-img">
                                                    <div class="irava-wishlist-remove remove-id-<?php echo $get_data_meta->post_id ?>" data-count-product="<?php echo $count_query_wishlist; ?>" data-remove-id="<?php echo $get_data_meta->post_id ?>" data-user-id="<?php echo get_current_user_id() ?>"><span><i class="fa-times fas"></i></span></div>
                                                    <a href="<?php echo $product->get_permalink(); ?>" target="_blank"><img src="<?php echo get_the_post_thumbnail_url( $get_data_meta->post_id, 'thumbnail' ) ?>" alt="<?php echo $product->get_title(); ?>"></a>
                                                </div>
                                                <div class="irava-wishlist-info">
                                                    <div class="irava-product-name"><a href="<?php echo $product->get_permalink(); ?>" target="_blank"><span><?php echo $product->get_title(); ?></span></a></div>
                                                    <div class="irava-product-price"><span><?php echo $product->get_price_html(); ?></span></div>
                                                </div>
                                                <div class="irava-wishlist-add-to-cart">
                                                    <?php 
                                                    
                                                    if( $product->is_type('simple') ) {
                                                        
                                                        if( $product->is_in_stock() ) {
                                                            ?><a href="<?php echo '?add-to-cart='. $get_data_meta->post_id .''; ?>" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">افزودن به سبد</a><?php
                                                        }else {
                                                            ?><a href="#" style="background: #ff666624;color: #ff6767;" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">ناموجود</a><?php
                                                        }
                                                        
                                                    }else if( $product->is_type('variable') ) {
                                                        
                                                        if( $product->is_in_stock() ) {
                                                            ?><a href="<?php echo $product->get_permalink(); ?>" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">انتخاب گزینه</a><?php
                                                        }else {
                                                            ?><a href="#" style="background: #ff666624;color: #ff6767;" class="fusion-button button-flat fusion-button-default-size button-default irava-wishlist-add-to-cart">ناموجود</a><?php
                                                        }
                                                        
                                                    }
                                                    
                                                    ?>
                                                </div>
                                            </div>
                                        <?php
                
                                    }// End Wishlist popup Foreach Loop
                
                                ?>
                                </div>
                                <div class="irava-wishlist-popup-bottom">
                                    <div class="irava-wishlist-popup-bot-inner">
                                        <a href="<?= get_permalink( $get_royal_option_settings['wishlist_page'] ); ?>" target="_blank" class="irava-wishlist-page">مشاهده لیست علاقمندی‌ها</a>
                                    </div>
                                </div>
                            </div>            
                            <?php
                        
                        }
                
                    }
                    
                }
            
            }
            


        }

        // Handle Ajax Add Wishlist Request
        public function irava_royal_wishlist_function() {

            // Get Product Dynamic ID
            $product_ID = $_POST['pid'];

            // Get Current User ID IF Loged IN
            $current_user_id = get_current_user_id();

            if( is_user_logged_in() ) {
                update_post_meta( $product_ID, '_iranavada_royal_wishlist'.$current_user_id, 'added' );
            }else {
                echo 'UserNotLogin';
            }

            exit;

        }

        // Handle Ajax Remove Wishlist Request
        public function irava_product_remove_wishlist_function() {

            // Get Remove ID ==> Product ID
            $RemoveID       = $_POST['RemoveID'];

            // Get Current User ID
            $CurrentUserID  = $_POST['UserID'];

            $RemovePostMeta = delete_post_meta( $RemoveID, '_iranavada_royal_wishlist'.$CurrentUserID, 'added' );

            // Send Result To JS
            if( $RemovePostMeta == true ) {
                echo 'RemoveSuccessfuly';
            }

            exit;

        }

        // Add Post State To Wishlist Page Selected On Proshop Option
        public function irava_add_post_state_wishlist_page( $post_states, $post ) {

            if( class_exists('Royal_Option_Functions') ) {
                $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            }else {
                $get_royal_option_settings = array('wishlist_page' => '');
            }

            if( $post->ID == $get_royal_option_settings['wishlist_page'] ) {
                $post_states[] = __( 'Wishlist Page', 'royal' );
            }
            return $post_states;

        }

    }new IRava_Royal_Wishlist();

}