<?php

/**
 * Element class.
 *
 * @package elegant-elements
 * @since 1.0
 */
class iravada_royal_mega_menu_pro {

    /**
     * Typewriter Text counter.
     *
     * @since 1.0
     * @access private
     * @var object
     */
    private $royal_vertical_tab_counter = 1;

    /**
     * Typewriter Text.
     *
     * @since 1.0
     * @access private
     * @var object
     */
    private $royal_vertical_tab = array();

    /**
     * Constructor.
     *
     * @since 1.0
     * @access public
     */
     
    protected $royal_elements_dir = '';
    protected $royal_mega_menu_assets_uri = '';
     
    public function __construct() {

        $this->royal_elements_dir             = get_stylesheet_directory() . '/includes/royal-elements/';
        $this->royal_mega_menu_assets_uri     = get_stylesheet_directory_uri() . '/includes/royal-elements/includes/irava-royal-mega-menu/assets/';

        add_action( 'wp_enqueue_scripts', array($this, 'royal_mega_menu_needed_scripts'), 1 );

        add_shortcode( 'royal_mega_menu_tabs_parent', array( $this, 'render_parent' ) );
        add_shortcode( 'royal_mega_menu_tabs_content', array( $this, 'render_child' ) );
		
    }

    /**
     * Render the parent shortcode.
     *
     * @access public
     * @since 1.0
     * @param  array  $args    Shortcode paramters.
     * @param  string $content Content between shortcode.
     * @return string          HTML output.
     */
    public function render_parent( $args, $content = '' ) {
            
        $defaults = FusionBuilder::set_shortcode_defaults(
            array(
                'hide_on_mobile'        			=> '',
                'class'                 			=> '',
                'id'                    			=> '',

				// Tab Title Font Size
				'royal_mega_menu_tab_font_size'		=> '14px',

				// Get Height Of Mega Menu Status => Auto Or Height Value
				'select_mega_menu_height'			=> '',

				// Royal Mega Menu Vertical Tab Height
				'royal_vertical_mega_menu_height'	=> '15%',
				'royal_vertical_mega_menu_max_height'   => '400px',

                // Royal Mega Menu Tab ul Width
                'royal_mega_menu_tab_ul_width'      => '',
                
                // Royal Mega Menu Tab Ul Li Alignment
                'content_align_mega_menu_items'     => 'right',

				// Padding Tab Items
				'padding_top'    					=> '',
				'padding_right'  					=> '',
				'padding_bottom' 					=> '',
				'padding_left'   					=> '',

				// Margin Tab Items
				'margin_top'     					=> '',
				'margin_right'   					=> '',
				'margin_bottom'  					=> '',
				'margin_left'    					=> '',

				// Default Border Size
				'border_top'    					=> '',
				'border_right'  					=> '',
				'border_bottom' 					=> '',
				'border_left'   					=> '',

				// Hover Border Size
				'hover_border_top'    				=> '',
				'hover_border_right'  				=> '',
				'hover_border_bottom' 				=> '',
				'hover_border_left'   				=> '',

				// Style Not Hover
				'royal_vertical_mega_menu_tab_border_color' 		=> '',
				'royal_vertical_mega_menu_tab_color' 				=> '',
				'royal_vertical_mega_menu_tab_bg_color' 			=> '',

				// Style On Hover
				'royal_vertical_mega_menu_tab_border_hover_color' 	=> '',
				'royal_vertical_mega_menu_tab_hover_color' 			=> '',
				'royal_vertical_mega_menu_tab_hover_bg_color' 		=> '',

				// Menus Background Color
				'royal_vertical_mega_menus_background'	=> '',

				// Display Item Content Type (Hover/Click) On Menu Items
				'select_display_menu_item_content'	=> '',
				
				// Icon Font Size
				'icon_font_size'                        => '14px',
            ),
            $args
        );
		
        $args = $defaults;

        ob_start();

        include $this->royal_elements_dir . 'elements-additional/templates/royal-mega-menu/royal-mega-menu-parent.php';

        $this->royal_vertical_tab_counter++;

        ?>
        <script>
            function openContent(evt, cityName) {
              var i, tabcontent, tablinks;
              tabcontent = document.getElementsByClassName("tabcontent");
              for (i = 0; i < tabcontent.length; i++) {
                tabcontent[i].style.display = "none";
              }
              tablinks = document.getElementsByClassName("tablinks");
              for (i = 0; i < tablinks.length; i++) {
                tablinks[i].className = tablinks[i].className.replace(" active", "");
              }
              document.getElementById(cityName).style.display = "block";
              evt.currentTarget.className += " active";
            }
        </script>
        <?php

        return ob_get_clean();

    }

    /**
     * Render the child shortcode.
     *
     * @access public
     * @since 1.0
     * @param  array  $args    Shortcode paramters.
     * @param  string $content Content between shortcode.
     * @return string          HTML output.
     */
    public function render_child( $args, $content = '' ) {


		
        $defaults = FusionBuilder::set_shortcode_defaults(
            array(
				'title'     							=> '',
				'select_icon_image'                     => 'icon',
				'image_instead_of_icon'                 => '',
				'image_max_width'                       => '40px',
				'royal_mega_menu_tab_content'			=> '',
				'royal_vertical_mega_menu_tabs_icon'	=> '',
				'vertical_menu_items_link'				=> '',
				'select_link_target_type'				=> '',
            ),
            $args
        );

        $args = $defaults;

		include $this->royal_elements_dir . 'elements-additional/templates/royal-mega-menu/royal-mega-menu-child.php';

    }

    // Load All Script Needed
    public function royal_mega_menu_needed_scripts() {

        wp_enqueue_style( 'royal-mega-menu-style', $this->royal_mega_menu_assets_uri . 'css/royal-mega-menu-tab-front-end-style.css', '', '1.2' );

    }

}new iravada_royal_mega_menu_pro();

/**
 * Retrieve and return the default typography for elements.
 *
 * @since 2.1.0
 * @return array Default typography for title and description.
 */
function return_library_col() {
	// Bail, if page is saving.
	if ( isset( $_POST['action'] ) ) { // @codingStandardsIgnoreLine
		return;
	}

	// Bail, if the builder is not active or is not admin, should not make database call.
	$is_fb_live = ( isset( $_GET['fb-edit'] ) ) ? true : false; // @codingStandardsIgnoreLine
	if ( ! $is_fb_live && ! is_admin() ) {
		return;
	}

	$library_collection = array();

	$args = array(
		'post_type'      => 'fusion_element',
		'posts_per_page' => '-1',
		'tax_query'      => [ // phpcs:ignore WordPress.DB.SlowDBQuery
			[
				'taxonomy' => 'element_category',
				'field'    => 'slug',
				'terms'    => 'columns',
			],
		],
	);

	$library_query = get_posts( $args );

	// Check if there are items available.
	if ( $library_query ) {
		// The loop.
		foreach ( $library_query as $library_item ) :
			setup_postdata( $library_item );
			$element_post_id = $library_item->ID;

			$type          = $library_item->post_title;
			$display_terms = '';
			$global        = '';
			$term_name     = '';

			if ( 'yes' === get_post_meta( $element_post_id, '_fusion_is_global', true ) ) {
				$global = esc_html__( ' ( Global )', 'fusion-builder' );
			}

			if ( 'fusion_template' === $type ) {
				$term_name = esc_html__( 'Template', 'fusion-builder' );

				$library_collection[ $term_name ][ $element_post_id ] = $library_item->post_title . $global;
			} else {
				$template_content = $library_item->post_content;
				if ( 1 === strpos( $template_content, 'fusion_builder_column' ) ) {
					$term_name = esc_html__( 'Column', 'fusion-builder' );
				}

				$library_collection[ $term_name ][ $element_post_id ] = $library_item->post_title . $global;
			}

		endforeach;

	}

	// Restore original Post Data.
	wp_reset_postdata();

	return $library_collection;
}

/**
 * Map shortcode for royal_vertical_tab.
 *
 * @since 1.0
 * @return void
 */
function iravada_royal_mega_menu() {

	$parent_args = array(
		'name'                      => __( 'Royal Vertical Mega Menu', 'royal' ),
		'shortcode'                 => 'royal_mega_menu_tabs_parent',
		'icon'                      => 'iravada_elements_icon',
		'preview'                   => get_stylesheet_directory() . '/includes/royal-elements/elements-additional/previews/preview-iravada-royal-mega-menu.php',
		'preview_id'                => 'royal-mega-menu-preview',
		'multi'                     => 'multi_element_parent',
		'element_child'             => 'royal_mega_menu_tabs_content',
		'params'                    => array(
			[
				'type'        => 'tinymce',
				'heading'     => esc_attr__( 'Tabs', 'elegant-elements' ),
				'description' => esc_attr__( 'Royal Mega Menu Tab items.', 'elegant-elements' ),
				'param_name'  => 'element_content',
				'value'       => '[royal_mega_menu_tabs_content title="' . esc_attr__( 'Your Content Goes Here', 'elegant-elements' ) . '" /]',
			],
			[
				'type'        => 'radio_button_set',
				'heading'     => __( 'Select Open Content On Mouse Hover/Click', 'royal' ),
				'description' => __( 'Select the type of Display Content.', 'royal' ),
				'param_name'  => 'select_display_menu_item_content',
				'value'       => [
					'hover'    	  => __( 'Hover', 'royal' ),
					'click' 	  => __( 'Click', 'royal' ),
				],
				'default'	  => 'hover',
			],
			[
				'type'        => 'radio_button_set',
				'heading'     => __( 'Select Mega Menu Height Type', 'royal' ),
				'description' => __( 'Select the type of Mega Menu Height you want.', 'royal' ),
				'param_name'  => 'select_mega_menu_height',
				'value'       => [
					'auto'    	  => __( 'Auto', 'royal' ),
					'maxheight'   => __( 'Max Height', 'royal' ),
					'dynamic' 	  => __( 'Dynamic', 'royal' ),
				],
				'default'	  => 'dynamic',
			],
			[
				'type'        => 'textfield',
				'heading'     => __( 'Mega Menu Height', 'royal' ),
				'description' => __( 'The entered number is subtracted from the height of the entire page. Enter px or percentage. Default: 15%', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_height',
				'value'       => '',
				'dependency'       => [
					[
						'element'  => 'select_mega_menu_height',
						'value'    => 'dynamic',
						'operator' => '==',
					],
				],
			],
						[
				'type'        => 'textfield',
				'heading'     => __( 'Mega Menu Max Height', 'royal' ),
				'description' => __( 'The entered number is subtracted from the Max height of the entire page. Enter px Type. Default: 400px', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_max_height',
				'value'       => '',
				'dependency'       => [
					[
						'element'  => 'select_mega_menu_height',
						'value'    => 'maxheight',
						'operator' => '==',
					],
				],
			],
			[
				'type'        => 'range',
				'heading'     => __( 'Mega Menu Tab Width', 'royal' ),
				'description' => __( 'Controls the width of megamenu menus, if the field is empty, the width is set to 15 Percent by default.', 'royal' ),
				'param_name'  => 'royal_mega_menu_tab_ul_width',
				'value'       => '15',
				'min'         => '5',
				'max'         => '25',
				'step'        => '1',
			],
			[ 
				'type' => 'radio_button_set', 
				'heading' => esc_attr__( 'Alignment', 'fusion-builder' ),
				'description' => esc_attr__( 'Choose to align the heading left, right or center.', 'fusion-builder' ),
				'param_name' => 'content_align_mega_menu_items', 
				'value' => [ 
					'left' => esc_attr__( 'Left', 'fusion-builder' ), 
					'center' => esc_attr__( 'Center', 'fusion-builder' ), 
					'right' => esc_attr__( 'Right', 'fusion-builder' ) 
				], 
				'default' => 'right', 
			], 
			[
				'type'        => 'dimension',
				'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
				'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
				'param_name'  => 'royal_mega_menu_tabs_padding',
				'value'       => [
					'padding_top'    => '0px',
					'padding_right'  => '0px',
					'padding_bottom' => '0px',
					'padding_left'   => '0px',
				],
			],
			[
				'type'        => 'dimension',
				'heading'     => esc_attr__( 'Margin', 'fusion-builder' ),
				'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
				'param_name' => 'margin',
				'value'      => [
					'margin_top'     => '',
					'margin_right'   => '',
					'margin_bottom'  => '',
					'margin_left'    => '',
				],
			],
			[
				'type'             => 'dimension',
				'remove_from_atts' => true,
				'heading'          => __( 'Tab Item Border Size', 'royal' ),
				'description'      => __( 'Controls the border size Tab Items.', 'royal' ),
				'param_name'       => 'border_sizes',
				'value'            => [
					'border_top'    => '',
					'border_right'  => '',
					'border_bottom' => '',
					'border_left'   => '',
				],
			],
			[
				'type'             => 'dimension',
				'remove_from_atts' => true,
				'heading'          => __( 'Tab Item Border Size On Hover', 'royal' ),
				'description'      => __( 'Controls the border size On Hover Tab Items.', 'royal' ),
				'param_name'       => 'hover_border_sizes',
				'value'            => [
					'hover_border_top'    => '',
					'hover_border_right'  => '',
					'hover_border_bottom' => '',
					'hover_border_left'   => '',
				],
			],
			[
				'type'        => 'textfield',
				'heading'     => __( 'Icon Font Size', 'royal' ),
				'description' => __( 'Set Font Icon Size For Tabs.', 'royal' ),
				'param_name'  => 'icon_font_size',
				'placeholder' => true,
				'value'       => '',
			],
			[
				'type'        => 'textfield',
				'heading'     => __( 'Tab Title Font Size', 'royal' ),
				'param_name'  => 'royal_mega_menu_tab_font_size',
				'description' => __( 'Add Your Tab Title Font Size.', 'royal' ),
				'value'       => '14px',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Border Color', 'royal' ),
				'description' => __( 'Controls The color Of Tab Border Color, ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_tab_border_color',
				'value'       => '',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Border Color On Hover', 'royal' ),
				'description' => __( 'Controls The color Of Tab Border Color On hover, ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_tab_border_hover_color',
				'value'       => '',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Title Color', 'royal' ),
				'description' => __( 'Controls The color Of Tab Title,Icon Color, ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_tab_color',
				'value'       => '',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Title Color On Hover', 'royal' ),
				'description' => __( 'Controls The color Of Tab Title,Icon Color On hover, ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_tab_hover_color',
				'value'       => '',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Background Color', 'royal' ),
				'description' => __( 'Controls The color Of Tab Background, ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_tab_bg_color',
				'value'       => '',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Background Color On Hover', 'royal' ),
				'description' => __( 'Controls The color Of Tab Background On hover, ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menu_tab_hover_bg_color',
				'value'       => '',
			],
			[
				'type'        => 'colorpickeralpha',
				'heading'     => __( 'Royal Tab Menus Background', 'royal' ),
				'description' => __( 'Controls The color Of Tab Menus Background., ex: #000.', 'royal' ),
				'param_name'  => 'royal_vertical_mega_menus_background',
				'value'       => '',
			],
			[
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'CSS Class', 'elegant-elements' ),
				'param_name'  => 'class',
				'value'       => '',
				'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'elegant-elements' ),
			],
			[
				'type'        => 'textfield',
				'heading'     => esc_attr__( 'CSS ID', 'elegant-elements' ),
				'param_name'  => 'id',
				'value'       => '',
				'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'elegant-elements' ),
			],
		),
	);

	$child_args = array(
		'name'              => __( 'Royal Mega Menu Items', 'royal' ),
		'shortcode'         => 'royal_mega_menu_tabs_content',
		'hide_from_builder' => true,
		'allow_generator'   => true,
		'params'            => [

			[
				'type'        => 'textfield',
				'heading'     => __( 'Tab Title', 'royal' ),
				'param_name'  => 'title',
				'description' => __( 'Add Your Tab Title For Display Content In Mega Menu Tab Menus.', 'royal' ),
				'placeholder' => true,
				'value'       => esc_attr__( 'Your Content Goes Here', 'elegant-elements' ),
			],
			[
				'type'         => 'royal_mega_menu_tabs',
				'heading'      => __( 'Tab Content', 'royal' ),
				'description'  => __( 'Add Your Tab Content For In Mega Menu Tab Menus Just Use Columns In Avada Library.', 'royal' ),
				'param_name'   => 'royal_mega_menu_tab_content',
				'value'        => return_library_col(),
			],
			[
				'type'        => 'link_selector',
				'heading'     => __( 'Verical Menu Items Link', 'royal' ),
				'description' => __( 'Put The MegaMenu Items Link From This Section.', 'royal' ),
				'param_name'  => 'vertical_menu_items_link',
				'value'       => '',
			],
			
			[
				'type'        => 'radio_button_set',
				'heading'     => __( 'Select Link Target', 'royal' ),
				'description' => __( 'Select the type of Open Link Target.', 'royal' ),
				'param_name'  => 'select_link_target_type',
				'value'       => [
					'_self'    => esc_attr__( '_self', 'fusion-builder' ),
					'_blank'   => esc_attr__( '_blank', 'fusion-builder' ),
				],
				'default'	  => '_blank',
				'dependency'       => [
					[
						'element'  => 'vertical_menu_items_link',
						'value'    => '',
						'operator' => '!=',
					],
				],
			],
			[
				'type'        => 'radio_button_set',
				'heading'     => __( 'Select Icon/Image', 'royal' ),
				'description' => __( 'Select the type of You Want To Show.', 'royal' ),
				'param_name'  => 'select_icon_image',
				'value'       => [
					'icon' 	  => __( 'Icon', 'royal' ),
					'image'    => __( 'Image', 'royal' ),
				],
				'default'	  => 'icon',
			],
			[
				'type'        => 'iconpicker',
				'heading'     => esc_attr__( 'Select Icon', 'fusion-builder' ),
				'description' => esc_attr__( 'Add a short description for the field.', 'fusion-builder' ),
				'param_name'  => 'royal_vertical_mega_menu_tabs_icon',
				'value'       => '',
				'dependency'       => [
					[
						'element'  => 'select_icon_image',
						'value'    => 'icon',
						'operator' => '==',
					],
				],
			],
			[ 
				'type' 			=> 'textfield', 
				'heading' 		=> __( 'Set Image Max Width', 'royal' ), 
				'description' 	=> __( 'Set Specific Tab Image Width Size. default: 40px', 'royal' ),
				'param_name' 	=> 'image_max_width', 
				'value' 		=> '', 
                'dependency'  => [
					[
						'element'  => 'select_icon_image',
						'value'    => 'image',
						'operator' => '==',
					],
                ],
			], 
			[
				'type'        => 'upload',
				'heading'     => __( 'Image instead of icon', 'royal' ),
				'description' => __( 'Add a Image Instead Of Icon For This Item.', 'royal' ),
				'param_name'  => 'image_instead_of_icon',
				'value'       => '',
				'dependency'       => [
					[
						'element'  => 'select_icon_image',
						'value'    => 'image',
						'operator' => '==',
					],
				],
			],
		],
	);

	if ( function_exists( 'fusion_builder_frontend_data' ) ) {
		fusion_builder_map(
			fusion_builder_frontend_data(
				'iravada_royal_mega_menu_pro',
				$parent_args,
				'parent'
			)
		);

		fusion_builder_map(
			fusion_builder_frontend_data(
				'iravada_royal_mega_menu_pro',
				$child_args,
				'child'
			)
		);
	} else {
		fusion_builder_map(
			$parent_args
		);

		fusion_builder_map(
			$child_args
		);
	}
}

add_action( 'fusion_builder_before_init', 'iravada_royal_mega_menu', 99 );
