<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_account_avatar' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_account_avatar
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_irava_user_avatar_account', [ $this, 'wrapper_attr_account_avatar' ] );
			
			add_shortcode( 'iravada_account_avatar', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				'class'			  => '',
				'id'			  => '',
                'hide_on_mobile'  => fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_account_avatar' );
			
			$this->args = $defaults;
			
			ob_start();

				global $current_user;
				wp_get_current_user();
				
				// Get User Email Address
				$getuseremail = $current_user->user_email;
				
				// Convert email into md5 hash and set image size to 70 px
				$usergravatar = 'https://www.gravatar.com/avatar/' . md5($getuseremail) . '?s=70';
		
				if ( is_user_logged_in() )
				{
					global $current_user; wp_get_current_user();
					echo '<div ' . FusionBuilder::attributes( 'irava_user_avatar_account' ) . '><img src="' . $usergravatar . '" /></div><div class="irava_user_username_account">' . $current_user->first_name . ' ' . $current_user->last_name . '</div>';
				}

			return ob_get_clean();

			

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_account_avatar() {
			$attr = [ 
				'class' => 'irava_user_avatar_account ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}
	}
	new iravada_account_avatar();
}

function iravada_account_avatar_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_account_avatar', 
            [
                'name'            => __( 'Royal User Avatar' , 'royal' ),
                'shortcode'       => 'iravada_account_avatar',
                'icon'            => 'iravada_elements_icon',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Account Avatar Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Account Avatar
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Account Avatar
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_account_avatar_element' );
