<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'Royal_Brands_List' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class Royal_Brands_List
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;
		
		protected $assetsJS = '';
		protected $assetsCSS = '';

		public function __construct() {

            $this->assetsJS     = get_stylesheet_directory_uri() . '/includes/royal-brands/assets/js/';
            $this->assetsCSS    = get_stylesheet_directory_uri() . '/includes/royal-brands/assets/css/';

			add_filter( 'fusion_attr_brand-title', [ $this, 'wrapper_attr_brand_title' ] );
			
			add_shortcode( 'royal_brands_list', [ $this, 'render' ] );

		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'royal_brand_list_display_count_status'		=> '',
				'royal_brand_list_display_logo_status'		=> '',
				'select_brands_link_target_type'			=> '_blank',
				'royal_brands_list_title_font_size'			=> '15px',
				'royal_brand_list_items_title_font_color'	=> '#383838',
				'royal_brand_list_items_hover_color'		=> '#00c095',
				'margin_top'    							=> '50',
				'id'										=> '',
				'class'                                     => '',
                'hide_on_mobile'  							=> fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

        // Set Transient For Brands Letter
        public function set_brands_transient_letter() {

			if( class_exists('Royal_Brands_Shortcode') ) {

				$brands = get_terms('iravada-royal-brands');
				$grouped_brands = array();
	
				foreach ( $brands as $brand ) {
	
					$hide_empty = false;
	
					if ( ! $hide_empty || ( $hide_empty && self::has_products( $brand->term_id ) ) ) {
	
						$letter                      = mb_substr( htmlspecialchars_decode( $brand->name ), 0, 1 );
						$letter                      = strtolower( $letter );
						$grouped_brands[ $letter ][] = array( 'brand_term' => $brand );
	
					}
				}
	
				set_transient( 'iravada_az_brand_list_cache_' . get_locale(), $grouped_brands, 43200 );// 12 hours
	
				return Royal_Brands_Shortcode::render_template(
					'shortcodes',
					'brands-az-listing',
					array( 'grouped_brands' => $grouped_brands ),
					false
				);

			}

        }

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

			global $brand_count_product,
			$display_brand_logo_state,
			$brands_link_target_type,
			$SearchBoxHeadTop;
			
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'royal_brands_list' );
			
			$this->args = $defaults;

			// Global Options
			$brand_count_product 			= $this->args['royal_brand_list_display_count_status'];
			$display_brand_logo_state 		= $this->args['royal_brand_list_display_logo_status'];
			$brands_link_target_type		= $this->args['select_brands_link_target_type'];
			$SearchBoxHeadTop				= fusion_library()->sanitize->get_value_with_unit( $this->args['margin_top'] );
			
			if( class_exists('IPL_CLIENT_UPDATE_THEME') ) {

				if( IPL_CLIENT_UPDATE_THEME::update() ) {
			
        			ob_start();
        
        				?><style id="royal-brands-list-style">html{scroll-behavior:smooth}.royal-az-listing{margin:0;padding:10px}.royal-az-listing .royal-az-listing-header{border:1px solid #d7e1e5;padding:30px;border-radius:10px;position:sticky;z-index:5;background:#f9f9f9}.royal-az-listing .royal-az-listing-header ul{display:flex;align-items:center;justify-content:flex-start;flex-wrap:wrap;gap:20px;padding:0}.royal-az-listing .royal-az-listing-header ul li{display:flex;justify-content:center;align-items:center;list-style:none;background:#e3e3e3;border-radius:5px;width:30px;height:30px;font-size:12px;color:#333}.royal-az-listing .royal-az-listing-row{position:relative;width:100%;border:1px solid #e4e7e9;border-radius:10px;margin:10px 0;overflow:hidden}.royal-az-listing p.royal-az-listing-title{width:40px;height:40px;background:#eee;display:flex;justify-content:center;align-items:center;border-radius:5px 5px 5px 10px;color:#333;margin:0}.royal-az-listing ul.royal-az-listing-col{position:relative;width:100%;display:flex;list-style:none;gap:48px;flex-wrap:wrap;padding:10px 50px;margin:0}.royal-az-listing ul.royal-az-listing-col a li{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:0 5px;border-radius:4px;white-space:nowrap;font-size:15px}.royal-az-listing ul.royal-az-listing-col li.AlphabrandLetter span.brand-logo-img{display:flex;justify-content:center;align-items:center;max-height:40px;height:40px;width:100px;margin-bottom:10px}.royal-az-listing ul.royal-az-listing-col li.AlphabrandLetter span.brand-title{display:flex;align-items:center;justify-content:center;max-height:30px;height:30px;transition:.3s}.royal-az-listing ul.royal-az-listing-col li.AlphabrandLetter span.brand-title:hover{color:var(--brands-list-title-hover)!important}@media only screen and (max-width:750px){.royal-az-listing .royal-az-listing-header ul{gap:12px;flex-wrap:wrap}.royal-az-listing .royal-az-listing-header{position:relative;top:0}}</style><?php
        				echo $this->set_brands_transient_letter();
        				?><script id="royal-brands-list-js">let getHeadCharTextBox=document.querySelectorAll(".royal-az-listing .royal-az-listing-header ul li");getHeadCharTextBox.forEach((e=>{e.addEventListener("click",(function(e){e.preventDefault();let t=document.querySelector(".royal-az-listing-header"),l=t.getAttribute("data-top-margin-sticky"),r=t.offsetHeight-165+7,o=e.currentTarget.getAttribute("data-alpha"),a=document.querySelector(`#royal-az-listing-${o}`).offsetTop-r-parseFloat(l);window.scrollTo({top:a,behavior:"smooth"})}))}));let GetSerachBrandInput=document.querySelector(".royal-brands-search-input");function filterBrandList(e){e.preventDefault();let t=GetSerachBrandInput.value;if(t.length>0){window.scrollTo({top:0,left:0,behavior:"smooth"});let e=t[0].toLowerCase();document.querySelectorAll(".royal-az-listing-row").forEach((l=>{l.getAttribute("data-alpha").toLowerCase()==e?l.removeAttribute("style"):l.style.display="none",l.innerHTML.toLocaleLowerCase().includes(t)||(l.style.display="none")})),document.querySelectorAll(".royal-az-listing-row ul.royal-az-listing-col li").forEach((e=>{e.innerHTML.toLocaleLowerCase().includes(t)?e.closest("a").removeAttribute("style"):e.closest("a").style.display="none"}))}else if(""==t.length){document.querySelectorAll(".royal-az-listing-row").forEach((e=>{e.removeAttribute("style")})),document.querySelectorAll(".royal-az-listing-row ul.royal-az-listing-col li").forEach((e=>{e.closest("a").removeAttribute("style")}))}}GetSerachBrandInput.addEventListener("input",filterBrandList);</script><?php
        			
        			return ob_get_clean();
				    
				}
			
			}

		}

		// Brand Title Inline Styles
		public function wrapper_attr_brand_title() {

			$attr = [ 
				'class' => 'brand-title ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style'] .= '--brands-list-title-hover: '. $this->args['royal_brand_list_items_hover_color'] .';';
			$attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['royal_brands_list_title_font_size'] ) .';';
			$attr['style'] .= 'color: '. $this->args['royal_brand_list_items_title_font_color'] .';';

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}

	}
	new Royal_Brands_List();
}

function iravada_royal_brands_list() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'royal_brands_list', 
            [
                'name'            => __( 'Royal Brands List', 'royal' ),
                'shortcode'       => 'royal_brands_list',
                'icon'            => 'iravada_elements_icon',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab
					
						// Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					// Start Design Tab

						[ 
							'type' => 'textfield', 
							'heading'     => __( 'Brand Title Font Size', 'royal' ),
							'description' => __( 'Controls the font size of the brand title. Default: 15px', 'royal' ),
							'param_name' => 'royal_brands_list_title_font_size', 
							'value' => '', 
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],
						[ 
							'type'        => 'colorpickeralpha',
							'heading'     => __( 'Brand Title Font Color', 'royal' ),
							'description' => __( 'Controls the brand title font color. Default: #383838', 'royal' ),
							'param_name'  => 'royal_brand_list_items_title_font_color',
							'value'       => '',
							'states'        => [
								'hover' => [
									'label'      => __( 'Hover', 'fusion-builder' ),
									'param_name' => 'royal_brand_list_items_hover_color',
								],
							],
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],
						[
							'type'        => 'radio_button_set',
							'heading'     => __( 'Brand Product Count', 'royal' ),
							'description' => __( 'Controls the Display Number Of Count Product Per Brand.', 'royal' ),
							'param_name'  => 'royal_brand_list_display_count_status',
							'value'       => [
								'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
								'false'  => esc_attr__( 'No', 'fusion-builder' ),
							],
							'default'	  => 'true',
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],
						[
							'type'        => 'radio_button_set',
							'heading'     => __( 'Display Brand Logo', 'royal' ),
							'description' => __( 'Controls the Display Logo On Brand List.', 'royal' ),
							'param_name'  => 'royal_brand_list_display_logo_status',
							'value'       => [
								'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
								'false'  => esc_attr__( 'No', 'fusion-builder' ),
							],
							'default'	  => 'true',
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],
						'fusion_margin_placeholder'    => [
							'param_name' => 'margin',
							'group'      => esc_attr__( 'Design', 'fusion-builder' ),
							'value'      => [
								'margin_top'    => '',
							],
						],
						[
							'type'        => 'radio_button_set',
							'heading'     => __( 'Select Link Target Brands', 'royal' ),
							'description' => __( 'Select the type of Open Link Brands Target.', 'royal' ),
							'param_name'  => 'select_brands_link_target_type',
							'value'       => [
								'_self'    => esc_attr__( '_self', 'fusion-builder' ),
								'_blank'   => esc_attr__( '_blank', 'fusion-builder' ),
							],
							'default'	  => '_blank',
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],

					// End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_royal_brands_list' );
