<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_display_brand' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_display_brand
	{

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_display_brand', [ $this, 'wrapper_attr_display_brand' ] );
			add_filter( 'fusion_attr_iravada_img_brand', [ $this, 'wrapper_attr_iravada_img_brand' ] );
			
			add_shortcode( 'iravada_display_brand', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'						                => '',
				'id'						                => '',
				'hide_on_mobile'  			                => fusion_builder_default_visibility( 'array' ), 
				'iranavada_brand_lable_font_color'          => '#666',
				'iravada_display_only_brand_logo'           => 'no',
				'iravada_brand_logo_max_width'              => '120',
				'iravada_brand_name_field'                  => '',
				'margin_top'                                => '',
				'margin_right'                              => '',
				'margin_bottom'                             => '',
				'margin_left'                               => '',
				'padding_top'                               => '0px',
				'padding_right'                             => '0px',
				'padding_bottom'                            => '0px',
				'padding_left'                              => '0px',
				'iravada_brand_font_size'                   => '13px',
				'border_top'                                => '0px',
				'border_right'                              => '0px',
				'border_bottom'                             => '0px',
				'border_left'                               => '0px',
				'iravada_brand_box_border_style'            => 'dashed',
				'iravada_display_brand_box_border_color'    => '',
				'iravada_backgorund_brand_color'            => '',
				'iravada_brand_box_values_aligment'         => 'right',
			];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_display_brand' );
			
			$this->args = $defaults;
			
			ob_start();

			if( class_exists('IPL_CLIENT_UPDATE_THEME') ) {

				if( IPL_CLIENT_UPDATE_THEME::update() ) {

					// Display Brand Name = Is Default
					if( $this->args['iravada_display_only_brand_logo'] == 'no' ) {

						/* Get The Brand Name */
						$iravada_product_brand_title  = do_shortcode('[royal-brands as_link="true"]' , true );
						$iravada_title_brand_lable    = '';
						$terms = wp_get_post_terms( get_the_ID(), 'iravada-royal-brands' );
						
						if( $this->args['iravada_brand_name_field'] != '' ) {
							$iravada_title_brand_lable    = '<span ' . FusionBuilder::attributes( 'iravada_brand_lable' ) . '>'. $this->args['iravada_brand_name_field'] .' </span>';
						}elseif( $this->args['iravada_brand_name_field'] == '' ) {
							$iravada_title_brand_lable = '';
						}

						/* Start Use Perfect Brand Shortcode With Any Word */
						if( $terms ) {
							echo '<div ' . FusionBuilder::attributes( 'iravada_display_brand' ) . '>'. $iravada_title_brand_lable .' '. $iravada_product_brand_title .'</div>';  
						}
					}

					// Display Brand Logo
					if( $this->args['iravada_display_only_brand_logo'] == 'yes' ) {
						
						/* Get The Brand Logo */
						$iravada_title_brand_lable    = $this->args['iravada_brand_name_field'];
						$iravada_product_brand_image  = do_shortcode('[royal-brands image_size="full"]' , true );
						$iravada_image_brand_lable    = $this->args['iravada_brand_name_field'];
						$terms = wp_get_post_terms( get_the_id(), 'iravada-royal-brands' );

						/* Start Use Perfect Brand Shortcode With Any Word */
						if( $terms ) {
							echo '<div ' . FusionBuilder::attributes( 'iravada_img_brand' ) . '><span ' . FusionBuilder::attributes( 'iravada_brand_lable' ) . '>'. $iravada_title_brand_lable .' </span> '. $iravada_product_brand_image .'</div>';  
						}
					}

				}
			
			}

			return ob_get_clean();
		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_display_brand() {
			$attr = [ 
				'class' => 'iravada_display_brand ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Brand Box Aligment
			if ( '' == ! $this->args['iravada_brand_box_values_aligment'] ) {
				$attr['class'] .= 'iravada-brand-' . $this->args['iravada_brand_box_values_aligment'];
			}

			// PHP Code For Handle Brands Margins
			$attr['style'] .= Fusion_Builder_Margin_Helper::get_margins_style( $this->args );

			// PHP Code For Handle Description Box Padding
			$attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 

			// PHP Code For Handle Brand Font Size
			if ( $this->args['iravada_brand_font_size'] ) {
				$attr['style'] .= 'font-size:' .
					fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_brand_font_size'] ) . ';';
			}

			// PHP Code For Handle Background Color
			if( $this->args['iravada_backgorund_brand_color'] ) {
				$attr['style'] .= 'background:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_backgorund_brand_color'] ) . ' !important;';
			}

			// PHP Code For Handle Color For Brand Lable
			if( $this->args['iranavada_brand_lable_font_color'] ) {
				$attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iranavada_brand_lable_font_color'] ) . ' !important;';
			}

			// PHP Code For Handle Brand Main Box Border Top
			$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Right
			$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Bottom
			$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Left
			$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Style Dashed
			if( $this->args['iravada_brand_box_border_style'] == 'dashed' ) {
				$attr['style'] .= 'border-style: dashed;'; 
			}

			// PHP Code For Handle Brand Main Box Border Style Solid
			if( $this->args['iravada_brand_box_border_style'] == 'solid' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			// PHP Code For Handle Brand Main Box Border Style Dotted
			if( $this->args['iravada_brand_box_border_style'] == 'dotted' ) {
				$attr['style'] .= 'border-style: dotted;'; 
			}
			
			// PHP Code For Handle Brand Main Box Border Size
			if( $this->args['iravada_display_brand_box_border_color'] ) {
				$attr['style'] .= 'border-color:' .  $this->args['iravada_display_brand_box_border_color'] .';'; 
			}

			// PHP Code For Handle class
			if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
			$attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
			
			return $attr;
			
		}
		
		public function wrapper_attr_iravada_brand_lable() {
		    
			$attr = [ 
				'class' => 'iravada_brand_lable ' . $this->unique_class,
				'style' => '' 
			];

			return $attr;
			
		}

		// 
		public function wrapper_attr_iravada_img_brand() {
			$attr = [ 
				'class' => 'iravada_img_brand ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Brand Box Aligment
			if ( '' == ! $this->args['iravada_brand_box_values_aligment'] ) {
				$attr['class'] .= 'iravada-brand-' . $this->args['iravada_brand_box_values_aligment'];
			}

			// PHP Code For Handle Brand Font Size
			if ( $this->args['iravada_brand_font_size'] ) {
				$attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_brand_font_size'] ) . ';';
			}

			// PHP Code For Handle Color For Brand Lable
			if( $this->args['iranavada_brand_lable_font_color'] ) {
				$attr['style'] .= 'color: ' . $this->args['iranavada_brand_lable_font_color'] . ';';
			}

			// PHP Code For Handle Brands Margins
			$attr['style'] .= Fusion_Builder_Margin_Helper::get_margins_style( $this->args );

			// PHP Code For Handle Description Box Padding
			$attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 

			// PHP Code For Handle Color For Brand Lable
			if( $this->args['iravada_backgorund_brand_color'] ) {
				$attr['style'] .= 'background:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_backgorund_brand_color'] ) . ' !important;';
			}

			// PHP Code For Handle Brand Main Box Border Top
			$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Right
			$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Bottom
			$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Left
			$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 

			// PHP Code For Handle Brand Main Box Border Style Dashed
			if( $this->args['iravada_brand_box_border_style'] == 'dashed' ) {
				$attr['style'] .= 'border-style: dashed;'; 
			}

			// PHP Code For Handle Brand Main Box Border Style Solid
			if( $this->args['iravada_brand_box_border_style'] == 'solid' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			// PHP Code For Handle Brand Main Box Border Style Dotted
			if( $this->args['iravada_brand_box_border_style'] == 'dotted' ) {
				$attr['style'] .= 'border-style: dotted;'; 
			}
			
			// PHP Code For Handle Brand Main Box Border Size
			if( $this->args['iravada_display_brand_box_border_color'] ) {
				$attr['style'] .= 'border-color:' .  $this->args['iravada_display_brand_box_border_color'] .';'; 
			}
			
			$attr['style'] .= '--brand-shortcode-img-width: '. fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_brand_logo_max_width'] ) .';';
			
			return $attr;
		}

	}
	
}
new iravada_display_brand();

function iravada_display_brand_element_func() {

	fusion_builder_map( 
		fusion_builder_frontend_data( 
			'iravada_display_brand', 
			[
				'name'            => __( 'Royal Display Product Brand', 'royal' ),
				'shortcode'       => 'iravada_display_brand',
				'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
				'component'       => true,
				'allow_generator' => true,
				'params'          => 
				[

					// Start General Tab

						// Brand Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Brand
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Brand
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					/*
					*
					*
					* 
					*	
					*
					*/

					// Start Design Tab

					// Display Only Brand Logo
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Brand Logo', 'royal' ),
						'description' => __( 'Using this section, you can display the brand logo. By activating this option, only the brand photo will be displayed. Default: brand name', 'royal' ),
						'param_name'  => 'iravada_display_only_brand_logo',
						'value'       => [
							'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
							'no'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'default' => 'no',
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
					],
					
					[
						'type'        => 'textfield',
						'heading'     => __( 'Brand Max Width Image', 'royal' ),
						'description' => __( 'Set Max Width For Brand Logo.', 'royal' ),
						'param_name'  => 'iravada_brand_logo_max_width',
						'value'       => '120px',
						'dependency'       => [
							[
								'element'  => 'iravada_display_only_brand_logo',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
					], 

					// Iravada Brand Alignment
					[ 
						'type' => 'radio_button_set', 
						'heading' => __( 'Brand Aligment', 'royal' ),
						'description' => __( 'Controls brand alignment in postcards', 'royal' ),
						'param_name' => 'iravada_brand_box_values_aligment', 
						'value' => [ 
							'left' => esc_attr__( 'Left', 'fusion-builder' ), 
							'center' => esc_attr__( 'Center', 'fusion-builder' ), 
							'right' => esc_attr__( 'Right', 'fusion-builder' ) 
						], 
						'default' => 'right', 
						'group' => esc_attr__( 'Design', 'fusion-builder' ) 
					], 

					// Custom Brand Text
					[
						'type'        => 'textfield',
						'heading'     => __( 'Brand Label', 'royal' ),
						'description' => __( 'The label identifies the brand. Such as manufacturer, publisher and so on. Default: Brand', 'royal' ),
						'param_name'  => 'iravada_brand_name_field',
						'value'       => '',
						'default'     => __( 'Brand: ' , 'royal' ), 
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
					], 

					// Iravada Offer Box Background Color
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Brand Background Color', 'royal' ),
						'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
						'param_name'  => 'iravada_backgorund_brand_color',
						'value'       => '',
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					// Brand Lable Text Color Picker
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Brand Label', 'fusion-builder' ),
						'description' => __( 'Using this section, you can adjust the color of the brand label, default: #666', 'royal' ),
						'param_name'  => 'iranavada_brand_lable_font_color',
						'value'       => '',
						'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
					],

					// Brand Font Size
					[
						'type'        => 'textfield',
						'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 12px.', 'fusion-builder' ),
						'param_name'  => 'iravada_brand_font_size',
						'value'       => '',
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
					],

					// Iravada Display Brand Box Padding
					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
						'param_name'  => 'iravada_display_brand_box_padding',
						'value'       => [
							  'padding_top'    => '',
							  'padding_right'  => '',
							  'padding_bottom' => '',
							  'padding_left'   => '',
						],
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					// Iravada Brand Box Border Size
					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
						'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
						'param_name'       => 'border_sizes',
						'value'            => [
							'border_top'    => '',
							'border_right'  => '',
							'border_bottom' => '',
							'border_left'   => '',
						],
						'group'            => esc_attr__( 'Design', 'fusion-builder' ),
					],

					// Iravada Border Color Uniq Attr Main Box
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
						'param_name'  => 'iravada_display_brand_box_border_color',
						'value'       => '',
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					// Iravada Brand Box Border Style
					[
						'type'        => 'select',
						'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
						'description' => esc_attr__( 'Choose the separator line style. Default currently set to Dashed.', 'fusion-builder' ),
						'param_name'  => 'iravada_brand_box_border_style',
						'value'       => [
							  'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
							  'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
							  'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
						],
						'default'     => 'dashed',
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					// Brand Margin Element
					'fusion_margin_placeholder'    => [
						'param_name' => 'margin',
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
						'value'      => [
							'margin_top'    => '',
							'margin_right'  => '',
							'margin_bottom' => '',
							'margin_left'   => '',
						],
					],
					
					// End Design Tab

				]
			]
		)
	);
}
add_action( 'fusion_builder_before_init', 'iravada_display_brand_element_func' );
