<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_compare_post_card' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_compare_post_card
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_irava_better_compare', [ $this, 'wrapper_attr_compare_product' ] );
			
			add_shortcode( 'iravada_compare_post_card', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'								=> '',
				'id'								=> '',
                'hide_on_mobile'  					=> fusion_builder_default_visibility( 'array' ), 
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			
			$fusion_settings = fusion_get_fusion_settings();
			
            // Get Royal Options
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_compare_post_card' );
			
			$this->args = $defaults;
			
			ob_start();

			if( class_exists('IPL_CLIENT_UPDATE_THEME') ) {

				if( IPL_CLIENT_UPDATE_THEME::update() ) {
			
    			     ?>
                        <div <?= FusionBuilder::attributes( 'irava_better_compare' ) ?> > 
                            <?php
                                if ( isset( $get_royal_option_settings['royal_compare_status'] ) && $get_royal_option_settings['royal_compare_status'] == 'yes' or !isset( $get_royal_option_settings['royal_compare_status'] ) ) {
                                    echo do_shortcode('[royal_compare_button product="'.get_the_ID().'"]' );
                                } 
                            ?>
                        </div> 
        		    <?php 
				    
				}
			
			}
			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_compare_product() {
			$attr = [ 
				'class' => 'irava_better_compare ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( isset($this->args['class']) ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( isset($this->args['id']) ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
			if( isset($this->args['hide_on_mobile']) ) {
			    $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
			}
            
            
			return $attr;
		}
	}
	new iravada_compare_post_card();
}

function iravada_compare_product() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_compare_post_card', 
            [
                'name'            => __( 'Royal Product Compare On PostCart' , 'royal' ),
                'shortcode'       => 'iravada_compare_post_card',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
				'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_compare_product' );
