<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_display_all_product_vendors' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_display_all_product_vendors
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_add_to_cart_vendors_button', [ $this, 'wrapper_attr_addtocart_button' ] );
			add_filter( 'fusion_attr_iravada_vendors_list_title', [ $this, 'wrapper_attr_vendors_list_title' ] );
			add_filter( 'fusion_attr_iravada_display_all_product_vendors', [ $this, 'wrapper_attr_fisplay_product_vendors' ] );
			
			add_shortcode( 'iravada_display_all_product_vendors', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				'class'			    					     	=> '',
				'id'			     					     	=> '',
                'hide_on_mobile'      					     	=> fusion_builder_default_visibility( 'array' ), 
				'iravada_addtocart_vendor_border_style'   		=> 'solid',
				'iravada_display_rate_persent_number'		 	=> 'percentage',
				'iravada_addtocart_vendors_background'			=> '#fff',
				'iravada_all_vendor_addtocart_text'				=> __( 'Add To Cart' , 'royal' ),
				'border_top_addtocart_vendorlist'               => '2px',
				'border_right_addtocart_vendorlist'             => '2px',
				'border_bottom_addtocart_vendorlist'            => '2px',
				'border_left_addtocart_vendorlist'              => '2px',
				'iravada_addtocart_vendor_border_color'			=> '#48cab2',
				'iravada_addtocart_vendors_text_color'			=> '#607d8b',
				'border_radius_top_left'              			=> '5px',
				'border_radius_top_right'             			=> '5px',
				'border_radius_bottom_right'          			=> '5px',
				'border_radius_bottom_left'           			=> '5px',
				'iravada_vendorslist_title'						=> __( 'Other Vendors' , 'royal' ),
				'box_shadow_vertical'							=> '0px',
				'box_shadow_horizontal'							=> '0px',
				'box_shadow_blur'								=> '24px',
				'box_shadow_spread'								=> '-8px',
				'box_shadow_color'								=> '#eaeaea',
				'box_shadow_style'								=> '',
				'padding_top_design_vendorlist'    				=> '15px',
				'padding_right_design_vendorlist'  				=> '25px',
				'padding_bottom_design_vendorlist' 				=> '15px',
				'padding_left_design_vendorlist'   				=> '25px',
				'margin_top_design_vendorlist'    				=> '10px',
				'margin_right_design_vendorlist'  				=> '10px',
				'margin_bottom_design_vendorlist' 				=> '10px',
				'margin_left_design_vendorlist'   				=> '10px',
				'padding_top_design_addtocart_button'    		=> '13px',
				'padding_right_design_addtocart_button'  		=> '13px',
				'padding_bottom_design_addtocart_button' 		=> '13px',
				'padding_left_design_addtocart_button'   		=> '13px',
				'iranavada_main_title_font_color'				=> '#607d8b',
				'iravada_main_title_font_size'					=> '15px',
				'margin_top_main_title'    						=> '0px',
				'margin_right_main_title'  						=> '15px',
				'margin_bottom_main_title' 						=> '0px',
				'margin_left_main_title'   						=> '0px',
				'border_top_design_vendorlist'    				=> '1px',
				'border_right_design_vendorlist'  				=> '1px',
				'border_bottom_design_vendorlist' 				=> '1px',
				'border_left_design_vendorlist'   				=> '1px',
				'iravada_vendors_list_border_color'				=> '#f4f4f4',
				'iravada_vendors_list_border_style'				=> 'solid',
				'border_radius_top_left_design_vendorlist'      => '5px',
				'border_radius_top_right_design_vendorlist'     => '5px',
				'border_radius_bottom_right_design_vendorlist'  => '5px',
				'border_radius_bottom_left_design_vendorlist'   => '5px',
				'iravada_vendors_list_background_color'			=> '#fff',
				'iravada_display_shipping_site_or_vendor'		=> 'yes',

            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

            global $product;
			global $post;
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_display_all_product_vendors' );
			
			$this->args = $defaults;
			
			ob_start();

            $Dokan_Productsx = new Dokan_SPMV_Products();
               if ( ! $product ) {
                return;
            }
    
            $lists = $Dokan_Productsx->get_other_reseller_vendors( $product->get_id() );
			$get_post_meta_shipping_product_royal_element   = get_post_meta( $post->ID, 'shipping_product_royal', true );
			$get_post_meta_shipping_product_vendor_element  = get_post_meta( $post->ID, 'shipping_product_vendor', true );
    
            if ( $lists ) {
                ?>
                <div class="dokan-other-vendor-camparison">
    
                    <div class="table royal-dokan-table dokan-other-vendor-camparison-table">

						<h3><span <?php echo FusionBuilder::attributes( 'iravada_vendors_list_title' )?> ><?php echo $this->args['iravada_vendorslist_title'] ?></span></h3>
                        <?php foreach ( $lists as $key => $list ): ?>
                            <?php
                                $product_obj    = wc_get_product( $list->product_id );
                                $post_author_id = get_post_field( 'post_author', $product_obj->get_id() );
                                $seller_info    = dokan_get_store_info( $post_author_id );
                                $rating_count   = $product_obj->get_rating_count();
                                $review_count   = $product_obj->get_review_count();
                                $average        = $product_obj->get_average_rating();
    
                                if ( ! $product_obj->is_visible() ) {
                                    continue;
                                }
                            ?>
    
                        <div <?php echo FusionBuilder::attributes( 'iravada_display_all_product_vendors' )?>>

                            <div class="table-cell vendor">
                                <img src="<?php echo Avada()->settings->get( 'favicon', 'url' ); ?>" width="30px">
                                <a href="<?php echo dokan_get_store_url( $post_author_id ); ?>"><?php echo $seller_info['store_name'] ?></a><br>
								<span <?php echo FusionBuilder::attributes( 'iravada_rate_number' ); ?>>
									<?php 

										if( $this->args['iravada_display_rate_persent_number'] == 'percentage' ) { echo wp_kses_post( get_readable_rating_iravada_persentage( $post_author_id ) ); }
										if( $this->args['iravada_display_rate_persent_number'] == 'rate_number' ) { echo wp_kses_post( get_readable_rating_iravada_number( $post_author_id ) ); }

									?>
								</span>
                            </div>

							<?php if( $this->args['iravada_display_shipping_site_or_vendor'] == 'yes' ): ?>

								<div class="table-cell">

									<?php 

										if( $get_post_meta_shipping_product_royal_element == 'royal' ) {
											?>
												<span class="iravada-shipping-username" style="font-size: 11px;"><i class="fas fa-shipping-fast" style="font-size: 13px;color: #48cab2;"></i> ارسال <?php echo bloginfo( 'name' ); ?></span><br>
											<?php
										}
										
										if( $get_post_meta_shipping_product_vendor_element == 'vendor' ) {
											?>
												<span class="iravada-shipping-username" style="font-size: 11px;"><i class="fas fa-user-tie" style="font-size: 13px;color: #ffa565;"></i> ارسال فروشنده</span>
											<?php
										}
											
									?>

								</div>

							<?php endif; ?>

                            <div class="table-cell price">
                                <?php echo $product_obj->get_price_html(); ?>
                            </div>

                            <div class="table-cell action-area">

                                <?php if ( 'simple' == $product_obj->get_type() ): ?>

                                    <a href="<?php echo esc_url( $product_obj->add_to_cart_url() ) ?>" data-quantity="1" data-product_id="<?php echo esc_attr( $product_obj->get_id() ) ?>" data-product_sku="<?php echo esc_attr( $product_obj->get_sku() ) ?>" <?php echo FusionBuilder::attributes( 'iravada_add_to_cart_vendors_button' ); ?>><?php echo $this->args['iravada_all_vendor_addtocart_text']; ?></a>

                                <?php elseif ( 'variable' == $product_obj->get_type() ) : ?>

                                    <a href="<?php echo $product_obj->get_permalink(); ?>" <?php echo FusionBuilder::attributes( 'iravada_add_to_cart_vendors_button' ); ?> title="<?php _e( 'Select Options', 'dokan' ); ?>"><i class="fa fa-bars"></i> <?php _e( 'Select Options', 'dokan' ); ?></a>

                                <?php endif ?>

                            </div>

                        </div>
    
                        <?php endforeach ?>
    
                    </div>
                </div>

                <?php

            }

			return ob_get_clean();

		}

		/**
		* Builds the attributes array.
		*
		* @access public
		* @since 1.0
		* @return array
		* 
		*/
		public function wrapper_attr_addtocart_button() {
			$attr = [ 
				'class' => 'iravada_add_to_cart_vendors_button ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Main Background Section Color
            $attr['style']  .= 'background: '. $this->args['iravada_addtocart_vendors_background'] .' !important;';

			// PHP Code For Handle Offer Main Box Border Top
            $attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top_addtocart_vendorlist'] ) .';'; 

            // PHP Code For Handle Offer Main Box Border Right
            $attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right_addtocart_vendorlist'] ) .';'; 

            // PHP Code For Handle Offer Main Box Border Bottom
            $attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom_addtocart_vendorlist'] ) .';'; 

            // PHP Code For Handle Offer Main Box Border Left
            $attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left_addtocart_vendorlist'] ) .';'; 

			// PHP Code For Handle Offer Main Box Border Size
            if( $this->args['iravada_addtocart_vendor_border_color'] ) {
                $attr['style'] .= 'border-color:' .  $this->args['iravada_addtocart_vendor_border_color'] .';'; 
            }

			// PHP Code For Handle Add To Cart Button Border Style Solid
            if( $this->args['iravada_addtocart_vendor_border_style'] == 'solid' ) {
                $attr['style'] .= 'border-style: solid;'; 
            }

			// PHP Code For Handle Add To Cart Button Border Style Dashed
            if( $this->args['iravada_addtocart_vendor_border_style'] == 'dashed' ) {
                $attr['style'] .= 'border-style: dashed;'; 
            }

            // PHP Code For Handle Add To Cart Button Border Style Dotted
            if( $this->args['iravada_addtocart_vendor_border_style'] == 'dotted' ) {
                $attr['style'] .= 'border-style: dotted;'; 
            }

			// PHP Code For Handle Add To Cart Button Border Radius
			$attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  

			// PHP Code For Handle Add To Cart Button Text Color
            $attr['style'] .= 'color: '. $this->args['iravada_addtocart_vendors_text_color'] .' !important;';

			// PHP Code For Handle All Vendors Padding
            $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top_design_addtocart_button'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right_design_addtocart_button'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom_design_addtocart_button'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left_design_addtocart_button'] ) .'; '; 

			return $attr;
		}

		public function wrapper_attr_vendors_list_title() {
			$attr = [ 
				'class' => 'iravada_vendors_list_title ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Main Title Margins
			$attr['style'] .=  'color:' . $this->args['iranavada_main_title_font_color'] . '; '; 

			// PHP Code For Handle Main Title Margins
			$attr['style'] .=  'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_main_title_font_size'] ) .'; '; 
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

			return $attr;
		}

		public function wrapper_attr_fisplay_product_vendors() {
			$attr = [ 
				'class' => 'iravada_display_all_product_vendors ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Offer Main Box Border Top
			$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top_design_vendorlist'] ) .';'; 

			// PHP Code For Handle Offer Main Box Border Right
			$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right_design_vendorlist'] ) .';'; 

			// PHP Code For Handle Offer Main Box Border Bottom
			$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom_design_vendorlist'] ) .';'; 

			// PHP Code For Handle Offer Main Box Border Left
			$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left_design_vendorlist'] ) .';'; 

			// PHP Code For Handle Offer Main Box Border Size
			if( $this->args['iravada_vendors_list_border_color'] ) {
				$attr['style'] .= 'border-color:' .  $this->args['iravada_vendors_list_border_color'] .';'; 
			}

			// PHP Code For Handle Uniq Main Box Border Radius
            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left_design_vendorlist'] ) .'; ';  

			// PHP Code For Handle Vendors List Border Style
			$attr['style'] .= 'border-style: '. $this->args['iravada_vendors_list_border_style'] .';'; 
			
            // PHP Code For Handle All Vendors Padding
            $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left_design_vendorlist'] ) .'; '; 

			// PHP Code For Handle All Vendors Margins
			$attr['style'] .=  'margin:' . fusion_library()->sanitize->get_value_with_unit( $this->args['margin_top_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['margin_right_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['margin_bottom_design_vendorlist'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['margin_left_design_vendorlist'] ) .'; '; 

			// PHP For Handle All Vendors Box Shadow
			$attr['style'] .= 'box-shadow: '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_vertical'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_horizontal'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_blur'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_spread'] ) .' '. $this->args['box_shadow_color'] .' '. $this->args['box_shadow_style'] .' !important;';

			// PHP For Handle All Vendors Box Shadow
			$attr['style'] .= 'background: '. $this->args['iravada_vendors_list_background_color'] .' !important;';

			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}

			return $attr;
		}

	}
	new iravada_display_all_product_vendors();
}

function iravada_display_all_product_vendors_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_display_all_product_vendors', 
            [
                'name'            => __( 'Dokan Product Vendors List', 'royal' ),
                'shortcode'       => 'iravada_display_all_product_vendors',
                'icon'            => 'iravada_elements_icon dokan',
                'allow_generator' => true,
                'component'       => true,
				'templates'       => [ 'content', 'post_cards' ],
                'params'          => 
                [

					// Start General Tab

						[ 
							'type'        => 'radio_button_set',
							'heading'     => __( 'How to display satisfaction points', 'royal' ),
							'description' => __( 'Using this section, you can specify how to display the points of other sellers. Default: Percentage score.' , 'royal' ),
							'param_name'  => 'iravada_display_rate_persent_number',
							'value'       => [ 
								'percentage'    => __( 'Percentage Rate', 'royal' ),
								'rate_number'  	=> __( 'Number Rate', 'royal' ),
							],
							'default'     => 'percentage',
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						
						[ 
							'type'        => 'radio_button_set',
							'heading'     => __( 'Product submission box by', 'royal' ),
							'description' => __( 'Using this option, you can enable / disable the sending box in the list of other vendors.' , 'royal' ),
							'param_name'  => 'iravada_display_shipping_site_or_vendor',
							'value'       => [ 
								'yes' => __( 'Active', 'royal' ),
								'no'  => __( 'Deactive', 'royal' ),
							],
							'default'     => 'yes',
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],

						
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					/* End General Tab */

					/* Start Main Title Tab */

					[ 
						'type' => 'textfield', 
						'heading' => __( 'The main title of the sellers box', 'royal' ), 
						'param_name' => 'iravada_vendorslist_title', 
						'value' => '', 
						'description' => __( 'Using this section, you can enter the main title for the list of sellers. Default: Seller list', 'royal' ),
						'group' => __( 'Main Box Title', 'royal' )
					], 

					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Title Color', 'royal' ),
						'description' => __( 'Using this setting, you can set the color of the main title of the box. Default: #607d8b', 'royal' ),
						'param_name'  => 'iranavada_main_title_font_color',
						'value'       => '',
						'group' 	  => esc_attr__( 'Main Box Title', 'royal' ),
					],

					[
						'type'        => 'textfield',
						'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 12px.', 'fusion-builder' ),
						'param_name'  => 'iravada_main_title_font_size',
						'value'       => '',
						'group'      => esc_attr__( 'Main Box Title', 'royal' ),
					],

					/* End Main Title Tab */

					/* Start Design Tab */

					'fusion_margin_placeholder'    => [
						'param_name' => 'margin',
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
						'value'      => [
							'margin_top_design_vendorlist'    => '',
							'margin_right_design_vendorlist'  => '',
							'margin_bottom_design_vendorlist' => '',
							'margin_left_design_vendorlist'   => '',
						],
					],

					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
						'param_name'  => 'iravada_vendors_list_background_color',
						'value'       => '',
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
						'param_name'  => 'iravada_vendorsbox_padding',
						'value'       => [
							  'padding_top_design_vendorlist'    => '',
							  'padding_right_design_vendorlist'  => '',
							  'padding_bottom_design_vendorlist' => '',
							  'padding_left_design_vendorlist'   => '',
						],
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
						'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
						'param_name'       => 'design_border_sizes',
						'value'            => [
							'border_top_design_vendorlist'    => '',
							'border_right_design_vendorlist'  => '',
							'border_bottom_design_vendorlist' => '',
							'border_left_design_vendorlist'   => '',
						],
						'group'            => esc_attr__( 'Design', 'fusion-builder' ),
					],

					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
						'description' => esc_attr__( 'The color around the box line controls the description', 'fusion-builder' ),
						'param_name'  => 'iravada_vendors_list_border_color',
						'value'       => '',
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],
					
					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
						'param_name'  => 'iravada_description_text_border_radius',
						'value'       => [
							'border_radius_top_left_design_vendorlist'     => '',
							'border_radius_top_right_design_vendorlist'    => '',
							'border_radius_bottom_right_design_vendorlist' => '',
							'border_radius_bottom_left_design_vendorlist'  => '',
						],
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],

					[
						'type'        => 'radio_button_set',
						'heading'     => esc_attr__( 'Box Shadow', 'fusion-builder' ),
						'description' => esc_attr__( 'Set to "Yes" to enable box shadows.', 'fusion-builder' ),
						'param_name'  => 'box_shadow',
						'default'     => 'no',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'value'       => [
							'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
							'no'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'callback'    => [],
					],
					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => esc_attr__( 'Box Shadow Position', 'fusion-builder' ),
						'description'      => esc_attr__( 'Set the vertical and horizontal position of the box shadow. Positive values put the shadow below and right of the box, negative values put it above and left of the box. In pixels, ex. 5px.', 'fusion-builder' ),
						'param_name'       => 'dimension_box_shadow',
						'value'            => [
							'box_shadow_horizontal' => '',
							'box_shadow_vertical'   => '',
						],
						'group'            => esc_html__( 'Design', 'fusion-builder' ),
						'dependency'       => [
							[
								'element'  => 'box_shadow',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],
					[
						'type'        => 'range',
						'heading'     => esc_attr__( 'Box Shadow Blur Radius', 'fusion-builder' ),
						'description' => esc_attr__( 'Set the blur radius of the box shadow. In pixels.', 'fusion-builder' ),
						'param_name'  => 'box_shadow_blur',
						'value'       => '0',
						'min'         => '0',
						'max'         => '100',
						'step'        => '1',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'box_shadow',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					[
						'type'        => 'range',
						'heading'     => esc_attr__( 'Box Shadow Spread Radius', 'fusion-builder' ),
						'description' => esc_attr__( 'Set the spread radius of the box shadow. A positive value increases the size of the shadow, a negative value decreases the size of the shadow. In pixels.', 'fusion-builder' ),
						'param_name'  => 'box_shadow_spread',
						'value'       => '0',
						'min'         => '-100',
						'max'         => '100',
						'step'        => '1',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'box_shadow',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Box Shadow Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the color of the box shadow.', 'fusion-builder' ),
						'param_name'  => 'box_shadow_color',
						'value'       => '',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'box_shadow',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => esc_attr__( 'Box Shadow Style', 'fusion-builder' ),
						'description' => esc_attr__( 'Set the style of the box shadow to either be an outer or inner shadow.', 'fusion-builder' ),
						'param_name'  => 'box_shadow_style',
						'default'     => '',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'value'       => [
							''      => esc_attr__( 'Outer', 'fusion-builder' ),
							'inset' => esc_attr__( 'Inner', 'fusion-builder' ),
						],
						'dependency'  => [
							[
								'element'  => 'box_shadow',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],



				
				/* End Design Tab */


				/* Start Add To Cart Tab */

					[ 
						'type' => 'textfield', 
						'heading' => __( 'Add To Cart Button Text', 'royal' ), 
						'param_name' => 'iravada_all_vendor_addtocart_text', 
						'value' => '', 
						'description' => __( 'Enter the text of the Add to Cart button in this field, the default text: Add to Cart', 'royal' ),
						'group'       => __( 'Add To Cart Button', 'royal' )
					], 

					[
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
						'param_name'  => 'iravada_addtocart_vendors_background',
						'value'       => '',
						'group'       => __( 'Add To Cart Button', 'royal' )
					],
					
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Add To Cart Button Text Color', 'royal' ),
						'description' => __( 'Adjust the text color of the Add to Cart button, the default: #607d8b', 'royal' ),
						'param_name'  => 'iravada_addtocart_vendors_text_color',
						'value'       => '',
						'group'       => __( 'Add To Cart Button', 'royal' )
					],

					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
						'param_name'  => 'iravada_addtocart_button_padding',
						'value'       => [
							  'padding_top_design_addtocart_button'    => '',
							  'padding_right_design_addtocart_button'  => '',
							  'padding_bottom_design_addtocart_button' => '',
							  'padding_left_design_addtocart_button'   => '',
						],
						'group'       => __( 'Add To Cart Button', 'royal' )
					],

					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
						'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
						'param_name'       => 'border_sizes',
						'value'            => [
							'border_top_addtocart_vendorlist'    => '',
							'border_right_addtocart_vendorlist'  => '',
							'border_bottom_addtocart_vendorlist' => '',
							'border_left_addtocart_vendorlist'   => '',
						],
						'group'            => __( 'Add To Cart Button', 'royal' )
					],
					
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
						'param_name'  => 'iravada_addtocart_vendor_border_color',
						'value'       => '',
						'group'       => __( 'Add To Cart Button', 'royal' )
					],

					[
						'type'        => 'select',
						'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
						'description' => __( 'Use this option to adjust the display style of the Add to Cart button, default: Simple line', 'royal' ),
						'param_name'  => 'iravada_addtocart_vendor_border_style',
						'value'       => [
							'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
							'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
							'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
						],
						'default'     => 'solid',
						'group'       => __( 'Add To Cart Button', 'royal' )
					],

					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
						'param_name'  => 'iravada_addtocart_vendor_border_radius',
						'value'       => [
							'border_radius_top_left'     => '',
							'border_radius_top_right'    => '',
							'border_radius_bottom_right' => '',
							'border_radius_bottom_left'  => '',
						],
						'group'       => __( 'Add To Cart Button', 'royal' )
					],

				/* End Add To Cart Tab */

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_display_all_product_vendors_element' );

/*
* add Custom Field To Dokan
*/
add_action( 'dokan_product_edit_after_main' , 'iravada_custom_field_for_shipping' );
function iravada_custom_field_for_shipping() {

	global $post;

	$get_post_meta_shipping_product_royal   = get_post_meta( $post->ID, 'shipping_product_royal', true );
	$get_post_meta_shipping_product_vendor  = get_post_meta( $post->ID, 'shipping_product_vendor', true );

	?>

		<div class="dokan-other-options dokan-edit-row dokan-clearfix">
			
			<div class="dokan-section-heading" data-togglehandler="dokan_other_options">

				<h2><i class="fas fa-shipping-fast"></i> <?php _e( 'Specify The Shipping Of The Product.' , 'royal' ); ?></h2>
				<a href="#" class="dokan-section-toggle"> <i class="fa fa-sort-desc fa-flip-vertical" aria-hidden="true"></i> </a>
				<div class="dokan-clearfix"></div>

			</div>

			<div class="dokan-section-content">

				<input type="checkbox" id="shipping_royal" name="shipping_product_royal" value="royal" <?php checked( 'royal' , $get_post_meta_shipping_product_royal ); ?> ><label for="shipping_royal">ارسال توسط سایت</label><br>
				<input type="checkbox" id="shipping_vendor" name="shipping_product_vendor" value="vendor" <?php checked( 'vendor' , $get_post_meta_shipping_product_vendor ); ?> ><label for="shipping_royal">ارسال توسط فروشنده</label>

			</div>

		</div><!-- .dokan-other-options -->



	<?php

}

/*
* Saving product field data for edit and update
*/
add_action( 'dokan_new_product_added','save_add_product_meta', 10, 2 );
add_action( 'dokan_product_updated', 'save_add_product_meta', 10, 2 );

function save_add_product_meta($product_id, $postdata){

   if ( ! dokan_is_user_seller( get_current_user_id() ) ) {
		return;
	}
	
	update_post_meta( $product_id, 'shipping_product_royal', $postdata['shipping_product_royal'] );
	update_post_meta( $product_id, 'shipping_product_vendor', $postdata['shipping_product_vendor'] );
}

// add Dokan Shipping metabox
add_action( 'add_meta_boxes' , 'add_metabox_dokan_shipping_product_screen' );

function add_metabox_dokan_shipping_product_screen() {
    add_meta_box( 
        'iravada_shipping_dokan',
        __( 'Specify The Shipping Of The Product.' , 'royal' ), 
		'iravada_dokan_shipping_func_metabox',
        'product', 
        'side',
        'high'
    );
}

function iravada_dokan_shipping_func_metabox( $post ) {

	$get_post_meta_shipping_product_royal   = get_post_meta( $post->ID, 'shipping_product_royal', true );
	$get_post_meta_shipping_product_vendor  = get_post_meta( $post->ID, 'shipping_product_vendor', true );

	?>
	
		<input type="checkbox" id="shipping_royal" name="shipping_product_royal" value="royal" <?php checked( 'royal' , $get_post_meta_shipping_product_royal ); ?> ><label for="shipping_royal"><?php _e( 'Shipping By Website' , 'royal' ); ?></label><br>
		<input type="checkbox" id="shipping_vendor" name="shipping_product_vendor" value="vendor" <?php checked( 'vendor' , $get_post_meta_shipping_product_vendor ); ?> ><label for="shipping_royal"><?php _e( 'Shipping By Vendor' , 'royal' ); ?></label>

	<?php
}

// Save Dokan Shipping MetaBox fields
add_action( 'save_post' , 'iravada_update_dokan_shipping_method' );
add_action( 'save_edit' , 'iravada_update_dokan_shipping_method' );
function iravada_update_dokan_shipping_method( $post_id ) {
	update_post_meta( $post_id, 'shipping_product_royal', $_POST['shipping_product_royal'] );
	update_post_meta( $post_id, 'shipping_product_vendor', $_POST['shipping_product_vendor'] );
}




// Function For Get Rating Number From Data Base
function get_rating() {

	global $product;
	global $wpdb;

	$Dokan_Productsx = new Dokan_SPMV_Products();
	if ( ! $product ) {
		return;
 	}

	$lists = $Dokan_Productsx->get_other_reseller_vendors( $product->get_id() );
	foreach ( $lists as $key => $list ) {

		$product_obj    = wc_get_product( $list->product_id );
		$post_author_id = get_post_field( 'post_author', $product_obj->get_id() );
		$seller_info    = dokan_get_store_info( $post_author_id );
		$rating_count   = $product_obj->get_rating_count();
		$review_count   = $product_obj->get_review_count();
		$average        = $product_obj->get_average_rating();

		if ( ! $product_obj->is_visible() ) {
			continue;
		}

	}
	
	$result = $wpdb->get_row( $wpdb->prepare(
		"SELECT AVG(cm.meta_value) as average, COUNT(wc.comment_ID) as count FROM $wpdb->posts p
		INNER JOIN $wpdb->comments wc ON p.ID = wc.comment_post_ID
		LEFT JOIN $wpdb->commentmeta cm ON cm.comment_id = wc.comment_ID
		WHERE p.post_author = %d AND p.post_type = 'product' AND p.post_status = 'publish'
		AND ( cm.meta_key = 'rating' OR cm.meta_key IS NULL) AND wc.comment_approved = 1
		ORDER BY wc.comment_post_ID", $post_author_id ) );

	$rating_value = apply_filters( 'dokan_seller_rating_value', array(
		'rating' => number_format( $result->average, 1 ),
		'count'  => (int) $result->count
	), $post_author_id );

	return $rating_value;

}

// Funtion Rate Percentage Number
function get_readable_rating_iravada_persentage( $display = true ) {

	global $product;

	$Dokan_Productsx = new Dokan_SPMV_Products();
		if ( ! $product ) {
		return;
 	}

	$lists = $Dokan_Productsx->get_other_reseller_vendors( $product->get_id() );
	foreach ( $lists as $key => $list ) {

		$product_obj    = wc_get_product( $list->product_id );
		$post_author_id = get_post_field( 'post_author', $product_obj->get_id() );

		if ( ! $product_obj->is_visible() ) {
			continue;
		}

	}

	$rating = get_rating( $post_author_id );

	if ( ! $rating['count'] ) {
		$html = __( 'No ratings found yet!', 'dokan-lite' );
	} else {
		$long_text   = __( 'Satisfaction rate: (%s) out of (%d) votes' , 'royal' );
		$text        = sprintf( __( 'Rated %s out of %d', 'dokan-lite' ), $rating['rating'], number_format( 5 ) );
		$width       = ( $rating['rating']/5 ) * 100;
		$review_text = sprintf( $long_text, $width.'%', $rating['count'] );

		if ( function_exists( 'dokan_get_review_url' ) ) {
			?> <span class="text"><?php echo $review_text; ?></span> <?php
		}

	}

	if ( ! $display ) {
		return $html;
	}

	echo esc_html( $html );
}

// Function For Rate Number
function get_readable_rating_iravada_number( $display = true ) {

	global $product;

	$Dokan_Productsx = new Dokan_SPMV_Products();
		if ( ! $product ) {
		return;
 	}

	$lists = $Dokan_Productsx->get_other_reseller_vendors( $product->get_id() );
	foreach ( $lists as $key => $list ) {

		$product_obj    = wc_get_product( $list->product_id );
		$post_author_id = get_post_field( 'post_author', $product_obj->get_id() );

		if ( ! $product_obj->is_visible() ) {
			continue;
		}

	}

	$rating = get_rating( $post_author_id );

	if ( ! $rating['count'] ) {
		$html = __( 'No ratings found yet!', 'dokan-lite' );
	} else {
		$long_text   = __( 'Satisfaction rate: (%s) out of (%d) votes' , 'royal' );
		$text        = sprintf( __( 'Rated %s out of %d', 'dokan-lite' ), $rating['rating'], number_format( 5 ) );
		$width       = ( $rating['rating']/5 ) * 100;
		$review_text = sprintf( $long_text, $rating['rating'], $rating['count'] );

		if ( function_exists( 'dokan_get_review_url' ) ) {
			?> <span class="text"><?php echo $review_text; ?></span> <?php
		}
		
	}

	if ( ! $display ) {
		return $html;
	}

	echo esc_html( $html );
}

/**
 * Get seller rating in a readable rating format
 *
 * @param int $seller_id
 *
 * @return void
 */
function dokan_get_readable_seller_rating_iravada( $seller_id ) {
    return get_readable_rating_iravada( $seller_id );
}