<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_display_store_name' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_display_store_name
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_display_store_name', [ $this, 'wrapper_attr_store_name' ] );
			add_filter( 'fusion_attr_iravada_display_store_label', [ $this, 'wrapper_attr_store_label' ] );
			
			add_shortcode( 'iravada_display_store_name', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				'class'			                  			=> '',
				'id'			                  			=> '',
                'hide_on_mobile'                  			=> fusion_builder_default_visibility( 'array' ), 
                'iravada_store_name_color'        			=> '#607d8b', 
                'iravada_store_name_font_size'    			=> '16px',
				'iravada_label_before_store_name_title'		=> __( 'Store Name' , 'royal' ),
				'iravada_store_label_color'        			=> '##666666', 
				'iravada_store_label_font_size'    			=> '16px',
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_display_store_name' );
			
			$this->args = $defaults;

			$get_label_before_store_name = $this->args['iravada_label_before_store_name_title'];
			
			ob_start();

                $get_the_seller	= get_post_field( 'post_author' );
                $get_user_id	= get_user_by( 'id', $get_the_seller );
                $get_the_vendor	= dokan()->vendor->get( $get_the_seller );
                $get_store_data = dokan_get_store_info( $get_user_id->ID );

                if ( !empty( $get_store_data['store_name'] ) ) { 
                    
                    ?>
                        <div class="iravada_store_name">
                            <span <?php echo FusionBuilder::attributes( 'iravada_display_store_label' ); ?> ><?php echo $get_label_before_store_name; ?> </span><a href="<?php echo $get_the_vendor->get_shop_url() ?>" <?php echo FusionBuilder::attributes( 'iravada_display_store_name' ); ?> target="_blank"><?php echo $get_the_vendor->get_shop_name(); ?></a>
                        </div>
                    <?php 
                }

			return ob_get_clean();

			

		}

		/**
		* Builds the attributes array.
		*
		* @access public
		* @since 1.0
		* @return array
		* 
		*/
		public function wrapper_attr_store_name() {
			$attr = [ 
				'class' => 'iravada_display_store_name ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

            // PHP Code For Handle Color --> Store Name Title
            if( $this->args['iravada_store_name_color'] ) {
                $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_store_name_color'] ) . ' !important;';
            }

			// PHP Code For Handle Store Name Text Font Size
            if( $this->args['iravada_store_name_font_size'] ) {
                $attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_store_name_font_size'] ) . ';';
            }
            
			return $attr;
		}


		// Function For Store Name Label
		public function wrapper_attr_store_label() {
			$attr = [ 
				'class' => 'iravada_display_store_label ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

            // PHP Code For Handle Color --> Store Name Title
            if( $this->args['iravada_store_label_color'] ) {
                $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_store_label_color'] ) . ' !important;';
            }

			// PHP Code For Handle Store Name Text Font Size
            if( $this->args['iravada_store_label_font_size'] ) {
                $attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_store_label_font_size'] ) . ';';
            }
            
			return $attr;
		}
	}
	new iravada_display_store_name();
}

function iravada_display_store_name_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_display_store_name', 
            [
                'name'            => __( 'Dokan Display Store Name', 'royal' ),
                'shortcode'       => 'iravada_display_store_name',
                'icon'            => 'iravada_elements_icon dokan',
                'allow_generator' => true,
                'component'       => true,
				'templates'       => [ 'content', 'post_cards'],
                'params'          => 
                [

					// Start General Tab

						// iravada Text Field For Before Store Name
						[
							'type'        => 'textfield',
							'heading'     => __( 'Store Label', 'royal' ),
							'description' => __( 'Controls the name of the label that appears before the store name.', 'royal' ),
							'param_name'  => 'iravada_label_before_store_name_title',
							'value'       => '',
							'default'     => __( 'Store Name' , 'royal' ),
							'group'       => esc_attr__( 'General', 'fusion-builder' )
						],

						// Element Visibility Store Name
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Store Name & Link Page
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Store Name & Link Page
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					/* End General Tab */

					/* Start Design Tab */
					
						// Color Picker For --> Store Name & Link Page
                        [
                            'type'        => 'colorpicker',
                            'heading'     => __( 'Store Name Color', 'royal' ),
                            'description' => __( 'The title color controls the store name. Default color: #607d8b', 'royal' ),
                            'param_name'  => 'iravada_store_name_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Handle The Font Size --> Store Name & Link Page
                        [
                            'type'        => 'textfield',
                            'heading'     => __( 'Store Name Font Size', 'royal' ),
                            'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 16px. Leave empty for default value of 12px.', 'fusion-builder' ),
                            'param_name'  => 'iravada_store_name_font_size',
                            'value'       => '',
                            'group'      => esc_attr__( 'Design', 'fusion-builder' ),
                        ],

						// Color Picker For --> Label Store Name & Link Page
                        [
                            'type'        => 'colorpicker',
                            'heading'     => __( 'Label Font Color', 'royal' ),
                            'description' => __( 'The Label color controls the store name. Default color: #666666', 'royal' ),
                            'param_name'  => 'iravada_store_label_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Handle The Font Size --> Label Store Name & Link Page
                        [
                            'type'        => 'textfield',
                            'heading'     => __( 'Label Font Size', 'royal' ),
                            'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 16px. Leave empty for default value of 12px.', 'fusion-builder' ),
                            'param_name'  => 'iravada_store_label_font_size',
                            'value'       => '',
                            'group'      => esc_attr__( 'Design', 'fusion-builder' ),
                        ],

					/* End Design Tab */

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_display_store_name_element' );
