<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_sell_this_product' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_sell_this_product
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_sell_this_product', [ $this, 'wrapper_attr_store_name' ] );
			
			add_shortcode( 'iravada_sell_this_product', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				'class'			    					=> '',
				'id'			     					=> '',
                'hide_on_mobile'      					=> fusion_builder_default_visibility( 'array' ), 
				'iravada_get_sell_this_product_button'  => __( 'Be Seller of this product' , 'royal' ),
				'padding_top'                           => '8px',
				'padding_right'                         => '13px',
				'padding_bottom'                        => '8px',
				'padding_left'                          => '13px',
				'sell_button_aligment'					=> 'right',
				'iravada_sell_button_background_color'  => '#48cab2',
				'iravada_sell_button_text_color'		=> '#fff',
				'bordersize'							=> '0',
				'iravada_sell_button_border_color'		=> '#45cbda',
				'border_radius_top_left'                => '5px',
				'border_radius_top_right'               => '5px',
				'border_radius_bottom_right'            => '5px',
				'border_radius_bottom_left'             => '5px',
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

            global $product;
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_sell_this_product' );
			
			$this->args = $defaults;

			$get_label_before_store_name 	= $this->args['iravada_label_before_store_name_title'];
			$get_sell_this_product_button	= $this->args['iravada_get_sell_this_product_button'];
			
			ob_start();

                $Dokan_Products = new Dokan_SPMV_Products();
                
                if ( $product->get_type() == 'product_pack' ) {
                    return;
                }
        
                if ( !$Dokan_Products->is_valid_user( $product->get_id() ) ) {
                    return;
                }

                ?>
                    <form method="post">
                        <?php wp_nonce_field( 'dokan-sell-item-action', 'dokan-sell-item-nonce' ); ?>
                        <button name="dokan_sell_this_item" <?php echo FusionBuilder::attributes( 'iravada_sell_this_product' ); ?>"><?php echo $get_sell_this_product_button; ?></button>
                        <input type="hidden" name="product_id" value="<?php echo $product->get_id(); ?>">
                        <input type="hidden" name="user_id" value="<?php echo get_current_user_id(); ?>">
                    </form>
                <?php

			return ob_get_clean();

			

		}

		/**
		* Builds the attributes array.
		*
		* @access public
		* @since 1.0
		* @return array
		* 
		*/
		public function wrapper_attr_store_name() {
			$attr = [ 
				'class' => 'iravada_sell_this_product ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

			// PHP Code For Handle Sell This Product Button Padding
			if( $this->args['iravada_sell_this_product_butoon_padding'] =='' ) {
				$attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 
			}

			// PHP Code For Handle Align Button Sell This Product
            if ( '' == ! $this->args['sell_button_aligment'] ) {
				$attr['class'] .= 'iravada-sell-product-button-align-' . $this->args['sell_button_aligment'];
			}
			
			if(  $this->args['sell_button_aligment'] == 'left' ) {
			    $attr['style'] .= 'float:left !important;'; 
			}

			if(  $this->args['sell_button_aligment'] == 'right' ) {
			    $attr['style'] .= 'float:right !important;'; 
			}

			// PHP Code For Handle Sell Button Background Color
			if( $this->args['iravada_sell_button_background_color'] ) {
				$attr['style'] .= 'background:' . $this->args['iravada_sell_button_background_color'] . ' !important;'; 
			}

			// PHP Code For Handle Description Box Text Color
			$attr['style'] .= 'color:' . $this->args['iravada_sell_button_text_color'] . ' !important;'; 

			// PHP Code For Handle Description Box Text Color
			$attr['style'] .= 'font-family: inherit !important;'; 

			// PHP Code For Handle Description Box Border Radius
            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  

			// PHP Code For Handle Description Box Border Size
			$attr['style'] .= 'border:' . fusion_library()->sanitize->get_value_with_unit( $this->args['bordersize'] ) . ' solid '. $this->args['iravada_sell_button_border_color'] .' !important;'; 
            
			return $attr;
		}

	}
	new iravada_sell_this_product();
}

function iravada_sell_this_product_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_sell_this_product', 
            [
                'name'            => __( 'Dokan Sell This Product Button', 'royal' ),
                'shortcode'       => 'iravada_sell_this_product',
                'icon'            => 'iravada_elements_icon dokan',
                'allow_generator' => true,
                'component'       => true,
				'templates'       => [ 'content', 'post_cards'],
                'params'          => 
                [

					// Start General Tab

						// Iravada Set The Button Text --> Sell This Product
						[
							'type'        => 'textfield',
							'heading'     => __( 'Button Text', 'royal' ),
							'description' => __( 'The text of the seller button controls this product.', 'royal' ),
							'param_name'  => 'iravada_get_sell_this_product_button',
							'value'       => '',
							'default'     => __( 'Be Seller of this product' , 'royal' ),
							'group'       => esc_attr__( 'General', 'fusion-builder' )
						],

						// Element Visibility Sell This product Button
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Store Name & Link Page
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Store Name & Link Page
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					/* End General Tab */

					/* Start Design Tab */
					
                        // Iravada Sell This Product Button Padding
                        [
                            'type'        => 'dimension',
                            'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                            'param_name'  => 'iravada_sell_this_product_butoon_padding',
                            'value'       => [
                                  'padding_top'    => '',
                                  'padding_right'  => '',
                                  'padding_bottom' => '',
                                  'padding_left'   => '',
                            ],
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

						// Sell Button Alignment
						[ 
							'type' => 'radio_button_set', 
							'heading' => esc_attr__( 'Alignment', 'fusion-builder' ),
							'description' => esc_attr__( 'Choose to align the heading left, right or center.', 'fusion-builder' ),
							'param_name' => 'sell_button_aligment', 
							'value' => [ 
								'left' => esc_attr__( 'Left', 'fusion-builder' ), 
								'right' => esc_attr__( 'Right', 'fusion-builder' ) 
							], 
							'default' => 'right', 
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						],

						// Sell Button Background Color
                        [ 
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
                            'param_name'  => 'iravada_sell_button_background_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

						// Sell Button Text Color
                        [ 
                            'type'        => 'colorpickeralpha',
                            'heading'     => __( 'Button Text Color', 'royal' ),
                            'description' => __( 'Using this field you can control the text color of the button. Default: #fff', 'royal' ),
                            'param_name'  => 'iravada_sell_button_text_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

						// Sell Button Border Size
                        [
                            'type'        => 'range',
                            'heading'     => esc_attr__( 'Border Size', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                            'param_name'  => 'bordersize',
                            'value'       => '0',
                            'min'         => '0',
                            'max'         => '10',
                            'step'        => '1',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

						// Sell Button Border Color
                        [ 
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
                            'description' => esc_attr__( 'The color around the box line controls the description', 'fusion-builder' ),
                            'param_name'  => 'iravada_sell_button_border_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

						// Sell Button Border Radius
                        [
                            'type'        => 'dimension',
                            'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                            'param_name'  => 'iravada_sell_button_border_radius',
                            'value'       => [
                                'border_radius_top_left'     => '',
                                'border_radius_top_right'    => '',
                                'border_radius_bottom_right' => '',
                                'border_radius_bottom_left'  => '',
                            ],
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],
					/* End Design Tab */
                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_sell_this_product_element' );
