<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_cart_calculate' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_cart_calculate
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada-free-notice-content', [ $this, 'wrapper_attr_iravada_free_notice_content' ] );
			add_filter( 'fusion_attr_iravada-free-shipping-notice', [ $this, 'wrapper_attr_iravada_free_shipping_notice' ] );
			add_filter( 'fusion_attr_iravada-free-shipping-icon', [ $this, 'wrapper_attr_iravada_free_shipping_icon' ] );
			
			add_shortcode( 'iravada_cart_calculate', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;

			return [ 
                'content_align_cart_message'   				=> 'right', 
				'cart_message_font_color'					=> '',
				'padding_top'    							=> '15px',
				'padding_right'  							=> '0px',
				'padding_bottom' 							=> '15px',
				'padding_left'   							=> '0px',
				'border_top'    							=> '0px',
				'border_right'  							=> '0px',
				'border_bottom' 							=> '0px',
				'border_left'   							=> '0px',
				'margin_top'                                => '0px',
				'margin_right'                              => '0px',
				'margin_bottom'                             => '10px',
				'margin_left'                               => '0px',
				'cart_calculate_border_style'				=> 'solid',
				'cart_calculate_border_color'				=> '#cecece', 
				'border_radius_top_left'     				=> '0px',
				'border_radius_top_right'    				=> '0px',
				'border_radius_bottom_right' 				=> '0px',
				'border_radius_bottom_left'  				=> '0px',
				'cart_calculate_background'					=> '',
				'cart_calculate_text_before_price'			=> '',
				'cart_calculate_text_after_price'			=> '',
				'cart_calculate_free_shipping'				=> '',
				'cart_calculate_icon'						=> '',
				'cart_calculate_icon_color'					=> '#717171',
				'cart_calculate_icon_size'					=> '17px',
				'fusion_font_family_text_font'				=> '',
				'fusion_font_variant_text_font'				=> '400',
				'letter_spacing'							=> '',
				'text_transform'							=> '',
				'font_size'									=> '13px',
				'line_height'								=> '1',
				'select_type_of_message'					=> 'dynamic',
				'class'										=> '',
				'id'										=> '',
                'hide_on_mobile'  							=> fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_cart_calculate' );
			$get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

			$this->args = $defaults;

			if ( ! WC()->cart->prices_include_tax ) {
				$amount = WC()->cart->cart_contents_total;
			} else {
				$amount = WC()->cart->cart_contents_total + WC()->cart->tax_total;
			}
			
			if( $get_royal_option_settings['cart_calculate_price_display_text'] != '' ) {

				$calculate_sum = str_replace( ',', '', $get_royal_option_settings['cart_calculate_price_display_text'] ) - $amount;
				$sum_total = number_format($calculate_sum);
	
				$percent = $amount * 100 / str_replace( ',', '', $get_royal_option_settings['cart_calculate_price_display_text'] );

			}

			ob_start();

				?>
				<style>
					.iravada-free-shipping-notice {
						position: relative;
					}
                    .iravada-progress-bar {
                        position: absolute;
                        width: 100%;
                        height: 7px;
                        background: #ededed;
                        border-radius: 45px;
                    }
                    .iravada-notice-text {
                        margin-top: 20px;
                        display: flex;
                        align-items: center;
                    }
					<?php 
					if( $percent < 100 ) {
						?>
						.iravada-free-notice-content.dynamic-messages .iravada-progress-bar::after {
							content: '';
							position: absolute;
							width: <?= $percent ?>%;
							border-radius: 45px;
							height: 7px !important;
							background: linear-gradient(to right,#ff3a30,#ff6a00)!important;
							top: 0;
							right: 0;
						}
						.iravada-free-notice-content.dynamic-messages .iravada-progress-bar::before {
                            content: '<?= round($percent, 0, PHP_ROUND_HALF_UP) ?>%';
                            font-size: 10px;
                            position: absolute;
                            background: #fff;
                            border: 2px solid #ff6a00;
                            color: #000;
                            top: -12px;
                            width: 28px;
                            height: 28px;
                            right: calc( <?= round($percent, 0, PHP_ROUND_HALF_UP) ?>% - 1% );
                            border-radius: 50%;
                            z-index: 99;
                            display: flex;
                            justify-content: center;
                            align-items: center;
                        }
						<?php
					}elseif ( $percent >= 100 ) {
						?>
						.iravada-free-notice-content.dynamic-messages .iravada-progress-bar::after {
							content: '';
							position: absolute;
							width: 100%;
							border-radius: 45px;
							height: 7px !important;
							background: #00a32a !important;
							top: 0;
							right: 0;
						}
						.iravada-free-notice-content.dynamic-messages .iravada-progress-bar::before {
                            content: '100%';
                            font-size: 10px;
                            position: absolute;
                            background: #fff;
                            border: 2px solid #00a32a;
                            color: #000;
                            top: -12px;
                            width: 28px;
                            height: 28px;
                            left: 0;
                            border-radius: 50%;
                            z-index: 99;
                            display: flex;
                            justify-content: center;
                            align-items: center;
                        }
						<?php
					}
					?>
				</style>
				<?php

				// if( ! WC()->cart->is_empty() ) {
					?>
						<div <?= FusionBuilder::attributes( 'iravada-free-shipping-notice' ) ?> >
                            <div <?= FusionBuilder::attributes( 'iravada-free-notice-content' ) ?>>
                                <div class="iravada-progress-bar" <?php if( $this->args['select_type_of_message'] == 'fixed' ) { echo 'style="display: none;"'; } ?>></div>
                                <div class="iravada-notice-text" <?php if( $this->args['select_type_of_message'] == 'fixed' ) { echo 'style="margin-top: 0px !important;"'; } ?>>
                                <?php 
    
    								if( $this->args['select_type_of_message'] == 'dynamic' ) {
    
    									if( $amount < str_replace( ',', '', $get_royal_option_settings['cart_calculate_price_display_text'] ) ) {
    										echo '<i '. FusionBuilder::attributes( 'iravada-free-shipping-icon' ) .'></i>' . $this->args['cart_calculate_text_before_price'] . ' ' . $sum_total . ' ' . get_woocommerce_currency_symbol() . ' ' . $this->args['cart_calculate_text_after_price'];
    									}else {
    										echo '<i '. FusionBuilder::attributes( 'iravada-free-shipping-icon' ) .'></i>' . $this->args['cart_calculate_free_shipping'];
    									}
    
    								}else {
										if( $get_royal_option_settings['cart_calculate_price_display_text'] == '' ) {
											?>
											<span class="free-shipping-no-price-setting-notice">مبلغ ارسال رایگان را در تنظیمات پروشاپ رویال وارد کنید.</span>
											<?php
										}else {
											echo '<i '. FusionBuilder::attributes( 'iravada-free-shipping-icon' ) .'></i>' . $this->args['cart_calculate_text_before_price'] . ' ' . number_format( $get_royal_option_settings['cart_calculate_price_display_text'] ) . ' ' . get_woocommerce_currency_symbol() . ' ' . $this->args['cart_calculate_text_after_price'];
										}
    								}
    		
    							?>
                                </div>
                            </div>
						</div>
					<?php
				// }

			return ob_get_clean();

			

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_iravada_free_notice_content() {

			$attr = [ 
				'class' => 'iravada-free-notice-content ' . $this->unique_class,
				'style' => '' 
			];

			if( $this->args['select_type_of_message'] == 'dynamic' ) {
				$attr['class'] .= 'dynamic-messages ';
			}

			if( $this->args['select_type_of_message'] == 'fixed' ) {
				$attr['class'] .= 'fixed-messages ';
			}
			
			// PHP Code For Handle Content Alignment
			$attr['style'] .= 'display: flex;';
			$attr['style'] .= 'align-items: flex-start;';
			$attr['style'] .= 'flex-direction: column;';
			$attr['style'] .= 'position: relative;';

			if( $this->args['content_align_cart_message'] == 'right' ) {
				$attr['style'] .= 'justify-content: flex-start;';
			}
			if( $this->args['content_align_cart_message'] == 'center' ) {
				$attr['style'] .= 'justify-content: center;';
			}
			if( $this->args['content_align_cart_message'] == 'left' ) {
				$attr['style'] .= 'justify-content: flex-end;';
			}
			
			// Handle Typography Option
			$attr['style'] .= 'font-family: '. $this->args['fusion_font_family_text_font'] .';';
			$attr['style'] .= 'line-height: '. $this->args['line_height'] .';';
			$attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['font_size'] ) . ';';
			$attr['style'] .= 'font-weight: '. $this->args['fusion_font_variant_text_font'] .';';
			$attr['style'] .= 'letter-spacing: '. fusion_library()->sanitize->get_value_with_unit( $this->args['letter_spacing'] ) .';';
			$attr['style'] .= 'text-transform: '. $this->args['text_transform'] .';';

			$attr['style'] .= 'padding:  '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_top']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_bottom']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_left']) .';';

			// Border Style
			$attr['style'] .= 'border-top:  '. fusion_library()->sanitize->get_value_with_unit($this->args['border_top']) .';';
			$attr['style'] .= 'border-right:  '. fusion_library()->sanitize->get_value_with_unit($this->args['border_right']) .';';
			$attr['style'] .= 'border-bottom:  '. fusion_library()->sanitize->get_value_with_unit($this->args['border_bottom']) .';';
			$attr['style'] .= 'border-left:  '. fusion_library()->sanitize->get_value_with_unit($this->args['border_left']) .';';
			$attr['style'] .= 'border-style:  '. $this->args['cart_calculate_border_style'] .';';
			$attr['style'] .= 'border-color:  '. $this->args['cart_calculate_border_color'] .';';
			$attr['style'] .= 'border-radius:  '. fusion_library()->sanitize->get_value_with_unit($this->args['border_radius_top_left']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['border_radius_top_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['border_radius_bottom_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['border_radius_bottom_left']) .';';
			
			$attr['style'] .= 'background: '. $this->args['cart_calculate_background'] .';';


			if( $this->args['cart_message_font_color'] ) {
				$attr['style'] .= 'color:' . $this->args['cart_message_font_color'] . ';';
			}

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}

        public function wrapper_attr_iravada_free_shipping_notice() {
            
			$attr = [ 
				'class' => 'iravada-free-shipping-notice ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style'] .= 'margin: '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_top']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_bottom']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_left']) .';';

			return $attr;
            
        }

		public function wrapper_attr_iravada_free_shipping_icon() {

			$attr = [ 
				'class' => 'iravada-free-shipping-icon ' . $this->unique_class,
				'style' => '' 
			];
			
			$attr['class'] .= $this->args['cart_calculate_icon'];

			$attr['style'] .= 'padding-left: 10px;';
			$attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['cart_calculate_icon_size'] ) .';';
			$attr['style'] .= 'color: '. $this->args['cart_calculate_icon_color'] .';';

			return $attr;

		}

	}
	new iravada_cart_calculate();
}

function iravada_cart_calculate_products() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_cart_calculate', 
            [
                'name'            => __( 'Royal Cart Display Message', 'royal' ),
                'shortcode'       => 'iravada_cart_calculate',
                'icon'            => 'iravada_elements_icon',
                'allow_generator' => true,
				'subparam_map'    => [
					'fusion_font_family_text_font'  => 'main_typography',
					'fusion_font_variant_text_font' => 'main_typography',
					'font_size'                     => 'main_typography',
					'line_height'                   => 'main_typography',
					'letter_spacing'                => 'main_typography',
					'text_transform'                => 'main_typography',
				],
                'params'          => 
                [

					// Start General Tab
						[
							'type'        => 'radio_button_set',
							'heading'     => __( 'Select Message Type', 'royal' ),
							'description' => __( 'Select the type of Meesage you want To Display.', 'royal' ),
							'param_name'  => 'select_type_of_message',
							'value'       => [
								'fixed' 	  => __( 'fixed', 'royal' ),
								'dynamic'     => __( 'dynamic', 'royal' ),
							],
							'default'	  => 'dynamic',
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						[ 
							'type' => 'textfield', 
							'heading' => __( 'Text Before Price', 'royal' ), 
							'description' => __( 'Add Your Own Text Before Price.', 'royal' ),
							'param_name' => 'cart_calculate_text_before_price', 
							'value' => '',
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						[ 
							'type' => 'textfield', 
							'heading' => __( 'Text After Price', 'royal' ), 
							'description' => __( 'Add Your Own Text After Price.', 'royal' ),
							'param_name' => 'cart_calculate_text_after_price', 
							'value' => '',
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						[ 
							'type' => 'textfield', 
							'heading' => __( 'Free Shipping Message', 'royal' ), 
							'description' => __( 'Type Your Own Free Shipping.', 'royal' ),
							'param_name' => 'cart_calculate_free_shipping', 
							'value' => '',
							'dependency'       => [
								[
									'element'  => 'select_type_of_message',
									'value'    => 'dynamic',
									'operator' => '==',
								],
							],
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						],
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					/*
					*
					*
					* 
					*	
					*
					*/

					// Start Design Tab

						[
							'type'             => 'typography',
							'remove_from_atts' => true,
							'global'           => true,
							'heading'          => esc_attr__( 'Typography', 'fusion-builder' ),
							'description'      => esc_html__( 'Controls the text typography.', 'fusion-builder' ),
							'param_name'       => 'main_typography',
							'group'            => esc_attr__( 'Design', 'fusion-builder' ),
							'choices'          => [
								'font-family'    => 'text_font',
								'font-size'      => 'font_size',
								'line-height'    => 'line_height',
								'letter-spacing' => 'letter_spacing',
								'text-transform' => 'text_transform',
							],
							'default'          => [
								'font-family'    => '',
								'variant'        => '',
								'font-size'      => '',
								'line-height'    => '',
								'letter-spacing' => '',
								'text-transform' => '',
							],
						],
						[
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Font Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #c1c1c1.', 'fusion-builder' ),
							'param_name'  => 'cart_message_font_color',
							'value'       => '',
							'default' 	  => '#c1c1c1',
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],
    					'fusion_margin_placeholder'    => [
    						'param_name' => 'margin',
    						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
    						'value'      => [
    							'margin_top'    => '',
    							'margin_right'  => '',
    							'margin_bottom' => '',
    							'margin_left'   => '',
    						],
    					],
						[ 
							'type' => 'radio_button_set', 
							'heading' => esc_attr__( 'Alignment', 'fusion-builder' ),
							'description' => esc_attr__( 'Choose to align the heading left, right or center.', 'fusion-builder' ),
							'param_name' => 'content_align_cart_message', 
							'value' => [ 
								'left' => esc_attr__( 'Left', 'fusion-builder' ), 
								'center' => esc_attr__( 'Center', 'fusion-builder' ), 
								'right' => esc_attr__( 'Right', 'fusion-builder' ) 
							], 
							'default' => 'right', 
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						], 
						[
							'type'        => 'dimension',
							'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
							'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
							'param_name'  => 'cart_calculate_box_padding',
							'value'       => [
								  'padding_top'    => '',
								  'padding_right'  => '',
								  'padding_bottom' => '',
								  'padding_left'   => '',
							],
							'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
						],
						[
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
							'param_name'  => 'cart_calculate_background',
							'value'       => '',
							'group'       => esc_attr__( 'Design', 'fusion-builder' )
						],
						[
							'type'             => 'dimension',
							'remove_from_atts' => true,
							'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
							'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
							'param_name'       => 'border_sizes',
							'value'            => [
								'border_top'    => '',
								'border_right'  => '',
								'border_bottom' => '',
								'border_left'   => '',
							],
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						],

						[
							'type'        => 'select',
							'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
							'description' => esc_attr__( 'Choose the separator line style. Default currently set to Dashed.', 'fusion-builder' ),
							'param_name'  => 'cart_calculate_border_style',
							'value'       => [
								'none'        => esc_attr__( 'None', 'fusion-builder' ),
								'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
								'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
								'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
							],
							'default'     => 'solid',
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						],
						[ 
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
							'param_name'  => 'cart_calculate_border_color',
							'value'       => '',
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						],
						[
							'type'        => 'dimension',
							'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
							'param_name'  => 'cart_calculate_border_radius',
							'value'       => [
								'border_radius_top_left'     => '',
								'border_radius_top_right'    => '',
								'border_radius_bottom_right' => '',
								'border_radius_bottom_left'  => '',
							],
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						],
						[
							'type'        => 'iconpicker',
							'heading'     => __( 'Select Icon', 'royal' ),
							'description' => __( 'Select Any Icon For Add To Cart Button In Carousel Template.', 'royal' ),
							'param_name'  => 'cart_calculate_icon',
							'value'       => 'fa-shipping-fast fas',
							'group' => esc_attr__( 'Design', 'fusion-builder' )
						],
						[
							'type'        => 'colorpickeralpha',
							'heading'     => __( 'Select Icon Color', 'royal' ),
							'description' => __( 'you can select add to cart icon color.', 'royal' ),
							'param_name'  => 'cart_calculate_icon_color',
							'value'       => '',
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
							'default'	=> '',
						],
                        [ 
							'type' => 'textfield', 
							'heading'     => __( 'Icon Size', 'royal' ),
                            'description' => __( 'Controls The Icon Font Size.', 'royal' ),
							'param_name'  => 'cart_calculate_icon_size', 
							'value'       => '', 
							'group'       => esc_attr__( 'Design', 'fusion-builder' )
						], 

					// End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_cart_calculate_products' );