<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_icons' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_icons
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_single_product_icon', [ $this, 'wrapper_attr_single_product_icons' ] );
			
			add_shortcode( 'iravada_icons', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'iravada_product_page_icons'    => 'compare,wishlist,share',
				'class'			  				=> '',
				'id'			  				=> '',
                'hide_on_mobile' 				=> fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_icons' );
			
            // Get Royal Options
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

			$this->args = $defaults;
			
			ob_start();

				echo '<div ' . FusionBuilder::attributes( 'iravada_single_product_icon' ) . ' >';

				if( class_exists('IPL_CLIENT_UPDATE_THEME') ) {

					if( IPL_CLIENT_UPDATE_THEME::update() ) {

						if( false !== strpos( $this->args['iravada_product_page_icons'], 'compare' ) ) {
						
							?>
								<style>.single .proshop_share_box i:before{content:"\f040";font-family:IranAvadaIcons;font-size:21px;color:#888}.iravada_single_product_icon .irava_better_compare{width:35px;height:35px;display:flex;align-items:center;justify-content:center}.iravada_single_product_icon .proshop_share_box a{display:flex;justify-content:center;align-items:center}.rtl.single a.royal-add-to-compare-btn.single-btn::before{font-family:IranAvadaIcons;color:#888;content:"\f041";font-size:20px}.irava_better_compare a.royal-add-to-compare-btn.single-btn span{display:none}</style>
								<div <?php echo FusionBuilder::attributes( 'irava_better_compare' ); ?> > 
									<?php
										if ( isset( $get_royal_option_settings['royal_compare_status'] ) && $get_royal_option_settings['royal_compare_status'] == 'yes' ) {
											echo do_shortcode('[royal_compare_button product="get_the_id()"]' );
										} 
									?>
								</div> 
							<?php 
	
						}					
						
						if(  false !== strpos( $this->args['iravada_product_page_icons'], 'wishlist' ) ) {
							
							if ( $get_royal_option_settings['wishlist_status'] == 'yes') {
								?>
									<div <?php echo FusionBuilder::attributes( 'irava_wishlist' ) ?> > 
										<?php
											echo do_shortcode("[irava_royal_wishlist]");
										?>
									</div> 	
								<?php 
							}
	
						}

					}

				}

					if( false !== strpos( $this->args['iravada_product_page_icons'], 'share' ) ) {
						
						?>
							<style>.iravada_single_product_icon .proshop_share_box {width: 35px;height: 35px;display: flex;align-items: center; justify-content: center;}</style>
							<div <?php echo FusionBuilder::attributes( 'proshop_share_box' ); ?> > 

								<?php
					
									echo do_shortcode('
										[fusion_modal_text_link name="single_share_box" class="" id=""]<i class="fa fa-share-alt share_icon"></i>[/fusion_modal_text_link]
										[fusion_modal name="single_share_box" title="شبکه‌های اجتماعی" size="small" background="" border_color="#f2f2f2" show_footer="no" class="" id=""]
										[fusion_sharing layout_small="stacked" layout="floated" tagline_visibility="show" tagline="اشتراک گذاری" description="توضیحات" sticky_display="normal,sticky" class="" margin_top="30" backgroundcolor="rgba(249,249,251,0)" border_color="#cccccc" stacked_align_small="center" stacked_align="center" alignment_small="space-between" alignment="center" padding_top="5" padding_right="5" padding_bottom="5" padding_left="5" tagline_placement="after" separator_border_sizes="0" separator_border_color="#cccccc"][/fusion_sharing]
										[/fusion_modal]
									');
									
								?> 

							</div>
						<?php 

					}

				echo '</div>';
            
			return ob_get_clean();

			

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_single_product_icons() {
			$attr = [ 
				'class' => 'iravada_single_product_icon ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}
	}
	new iravada_icons();
}

function iravada_single_product_icons() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_icons', 
            [
                'name'            => __( 'Royal Single Product Page Icons', 'royal' ),
                'shortcode'       => 'iravada_icons',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
                'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

                    [
                        'type'        => 'checkbox_button_set',
                        'heading'     => __( 'Active/Deactive Icons', 'royal' ),
                        'description' => esc_attr__( 'Product introduction page icons are enabled by default, you can use the following options to disable any of the icons.', 'fusion-builder' ),
                        'param_name'  => 'iravada_product_page_icons',
                        'value'       => [
                              'compare'      => __( 'Product Compare', 'royal' ),
							  'wishlist'     => __( 'Product Wishlist', 'royal' ),
                              'share'        => __( 'Product Share', 'royal' ),
                        ],
						'default'	  => ['compare','wishlist','share'],
						'group' => esc_attr__( 'General', 'fusion-builder' )
                    ],

						// Iravada Icons Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Iravada Icons
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Iravada Icons
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_single_product_icons' );
