<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_offer' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_offer
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_tb_distime', [ $this, 'wrapper_attr_product_offer' ] );
			add_filter( 'fusion_attr_single_distime', [ $this, 'wrapper_attr_single_distime' ] );
			
			add_shortcode( 'iravada_offer', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'								  => '',
				'id'								  => '',
                'hide_on_mobile'  					  => fusion_builder_default_visibility( 'array' ), 
				'iravada_off_timer_background_color'  => '#f26363',
				'iravada_off_text_box_timer_color'	  => '#fff',
				'border_radius_top_left'              => '0px',
				'border_radius_top_right'             => '0px',
				'border_radius_bottom_right'          => '0px',
				'border_radius_bottom_left'           => '0px',
				'border_top'                          => '0px',
				'border_right'                        => '0px',
				'border_bottom'                       => '0px',
				'border_left'                         => '0px',
				'iravada_offer_box_border_color'	  => '',
				'iravada_offer_box_border_style'	  => 'solid',
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_offer' );
			
			$this->args = $defaults;
			
			ob_start();

                global $product;
                $customProduct = $product;
                
                $body_classes = [];

                wp_enqueue_style("iranavadasopc.main");
                wp_enqueue_script("iranavadasopc.countdown");
                wp_enqueue_script("iranavadasopc.main");

                if(!is_product()) {
                    return $body_classes;
                }

                if(current_action() == 'body_class' ) {
                global $post;
                $customProduct = new WC_Product($post->ID);
                }

                $sale_date = null;
                $dateCountDown = null;

                if ($customProduct->is_on_sale() && get_post_meta($customProduct->get_id(), '_iranavadasopc', $single = true) == 'yes' ) {
                $sale_date = $customProduct->get_date_on_sale_to();
                }
                $ended = !$customProduct->is_in_stock();

                $product_on_sale_to_1 = get_post_meta( $customProduct->get_id(), '_iranavadasopc', true );
                $product_on_sale_to_2 = get_post_meta( $customProduct->get_id(), '_iranavadasopc_date', true );

                if ($customProduct->is_type('variable') && "yes" == $product_on_sale_to_1 && !empty($product_on_sale_to_2)){
                $dateCountDown = (new DateTime($product_on_sale_to_2))->format('Y/m/d') . " 23:59:59";
                }else{
                if ($sale_date != null){
                    $dateCountDown = $sale_date->date('Y/m/d') . " 23:59:59";
                }
                }

                if(current_action() == 'body_class' ){
                    if($sale_date != null || $dateCountDown != null || $ended ) {
                        $body_classes[] = 'single-product-has-countdown';
                    }
                    return $body_classes;
                }

                if($sale_date != null || $dateCountDown != null ) : ?>
                <div <?php echo FusionBuilder::attributes( 'iravada_tb_distime' ) ?> >
                    <div <?php echo FusionBuilder::attributes( 'single_distime' ) ?> >
						<i class="far fa-clock"></i>
						<span <?php echo FusionBuilder::attributes( 'iranavada-sopcaw-countdown-raw' ) ?> data-options="spancolon|box" data-date="<?=esc_attr($dateCountDown);?>">--:--:--</span>
                    </div>
                </div>
                <?php endif;

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_product_offer() {
			$attr = [ 
				'class' => 'iravada_tb_distime ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Offer Main Box Border Top
            $attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 

            // PHP Code For Handle Offer Main Box Border Right
            $attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 

            // PHP Code For Handle Offer Main Box Border Bottom
            $attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 

            // PHP Code For Handle Offer Main Box Border Left
            $attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 

            // PHP Code For Handle Offer Main Box Border Style Dashed
            if( $this->args['iravada_offer_box_border_style'] == 'dashed' ) {
                $attr['style'] .= 'border-style: dashed;'; 
            }

            // PHP Code For Handle Offer Main Box Border Style Solid
            if( $this->args['iravada_offer_box_border_style'] == 'solid' ) {
                $attr['style'] .= 'border-style: solid;'; 
            }

            // PHP Code For Handle Offer Main Box Border Style Dotted
            if( $this->args['iravada_offer_box_border_style'] == 'dotted' ) {
                $attr['style'] .= 'border-style: dotted;'; 
            }
                
            // PHP Code For Handle Offer Main Box Border Size
            if( $this->args['iravada_offer_box_border_color'] ) {
                $attr['style'] .= 'border-color:' .  $this->args['iravada_offer_box_border_color'] .';'; 
            }

			// PHP Code For Handle Timer Background Color
			if ( $this->args['iravada_off_timer_background_color'] ) {
				$attr['style'] .= 'background: ' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_off_timer_background_color'] ) . ';';
			}

            // PHP Code For Handle Description Box Border Radius
            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
			
			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}

		public function wrapper_attr_single_distime() {
			$attr = [ 
				'class' => 'single_distime ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle Timer And Offer Text Color
			if ( $this->args['iravada_off_text_box_timer_color'] ) {
				$attr['style'] .= 'color: ' . $this->args['iravada_off_text_box_timer_color'] . ';';
			}
            
			return $attr;
		}
	}
	new iravada_offer();
}

function iravada_single_shop_product_offer_timer() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_offer', 
            [
                'name'            => __( 'Royal Product Amazing Timer' , 'royal' ),
                'shortcode'       => 'iravada_offer',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
				'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					/*
					*
						*
							*
						*	
					*
					*/

					// Start Design Tab

						// Iravada Offer Box Background Color
						[
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
							'param_name'  => 'iravada_off_timer_background_color',
							'value'       => '',
							'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
						],

						// Iravada Offer Box Timer Text And Offer Main Text Color
						[
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Font Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #fff.', 'fusion-builder' ),
							'param_name'  => 'iravada_off_text_box_timer_color',
							'value'       => '',
							'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
						],
						
						// Iravada Offer Box Border Radius
                        [
                            'type'        => 'dimension',
                            'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                            'param_name'  => 'iravada_offer_box_border_radius',
                            'value'       => [
                                'border_radius_top_left'     => '',
                                'border_radius_top_right'    => '',
                                'border_radius_bottom_right' => '',
                                'border_radius_bottom_left'  => '',
                            ],
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],
						
					    // Iravada Offer Border Size
                        [
                            'type'             => 'dimension',
                            'remove_from_atts' => true,
                            'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
                            'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
                            'param_name'       => 'border_sizes',
                            'value'            => [
                                'border_top'    => '',
                                'border_right'  => '',
                                'border_bottom' => '',
                                'border_left'   => '',
                            ],
                            'group'            => esc_attr__( 'Design', 'fusion-builder' ),
                        ],

						// Iravada Brand Box Border Style
                        [
                            'type'        => 'select',
                            'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
                            'description' => esc_attr__( 'Choose the separator line style. Default currently set to Dashed.', 'fusion-builder' ),
                            'param_name'  => 'iravada_offer_box_border_style',
                            'value'       => [
								'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
                                'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
                                'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
                            ],
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

						// Iravada Border Color Offer Main Box
                        [ 
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
                            'param_name'  => 'iravada_offer_box_border_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

					// End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_single_shop_product_offer_timer' );
