<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_rate_comment' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_rate_comment
	{

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_irava_rating_info_section', [ $this, 'wrapper_attr_irava_rating_info_section' ] );
			add_filter( 'fusion_attr_irava_rate_icon_color', [ $this, 'wrapper_attr_irava_rate_icon_color' ] );
			add_shortcode( 'iravada_rate_comment', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'				=> '',
				'id'				=> '',
				'hide_on_mobile'  	=> fusion_builder_default_visibility( 'array' ), 
				'icon'              => 'fa-star fas',              
				'rgba_color'        => '#ffc107',
				'font_size'         => '12px',
			];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
		    
		    global $product;
		    
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_rate_comment' );
			
			$this->args = $defaults;
			
			ob_start();

                global $woocommerce, $product;  

				$average      = get_post_meta( get_the_ID(), '_wc_average_rating', true );
                $review_count = get_post_meta( get_the_ID(), '_wc_review_count', true );
            
                ?>
                    <div <?php echo FusionBuilder::attributes( 'irava_rating_info_section' ); ?>>
                        <span <?php echo FusionBuilder::attributes( 'irava_rate_icon_color' ); ?>><i class="<?php echo $this->args['icon']; ?>"></i></span>
                        <span itemprop="ratingValue" class="rating-average"><?php echo $average; ?> </span> 
                        <span class="review-count">(<?php echo $review_count; ?>)</span> 
                        <span class="irava-dot"> • </span> 
                        <span><a href="#reviews" class="woocommerce-review-link" rel="nofollow"><?php echo $review_count . ' دیدگاه'; ?></a></span>   
                    </div>
                <?php

			return ob_get_clean();
		}
		
		public function wrapper_attr_irava_rating_info_section() {
			$attr = [ 
				'class' => 'irava_rating_info_section' . $this->unique_class,
				'style' => '' 
		    ];
		    
		    // PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
            		    
		    // PHP Code For Handle Timer And Offer Text Color
			$attr['style'] .= 'font-size: ' . $this->args['font_size'] . ';';
            
            return $attr;
		}
		
		public function wrapper_attr_irava_rate_icon_color() {
			$attr = [ 
				'class' => 'irava_rate_icon_color ' . $this->unique_class,
				'style' => '' 
		    ];
		    
		    // PHP Code For Handle Timer And Offer Text Color
			$attr['style'] .= 'color: ' . $this->args['rgba_color'] . ';';

            return $attr;

		}
	}
	
}
new iravada_rate_comment();

function iravada_rate_comment_element_func() {

	fusion_builder_map( 
		fusion_builder_frontend_data( 
			'iravada_rate_comment', 
			[
				'name'            => __( 'Royal Product Rate Comment', 'royal' ),
				'shortcode'       => 'iravada_rate_comment',
				'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
				'component'       => true,
				'allow_generator' => true,
				'params'          => 
				[

					// Start General Tab

                        [
                          'type'        => 'iconpicker',
                          'heading'     => esc_attr__( 'Select Icon', 'fusion-builder' ),
                          'description' => esc_attr__( 'Add a short description for the field.', 'fusion-builder' ),
                          'param_name'  => 'icon',
                          'value'       => 'fa-star fas',
                          'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],
                        
                        [
                          'type'        => 'colorpickeralpha',
                          'heading'     => esc_attr__( 'Select RGBA Color.', 'fusion-builder' ),
                          'description' => esc_attr__( 'This field allows you to select the color with rgba value.', 'fusion-builder' ),
                          'param_name'  => 'rgba_color',
                          'value'       => '#ffc107',
                          'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],
                        
                        [ 
							'type' => 'textfield', 
							'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 12px.', 'fusion-builder' ),
							'param_name'  => 'font_size', 
							'value'       => '', 
							'group'       => esc_attr__( 'General', 'fusion-builder' )
						], 
                        
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Brand
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Brand
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

				]
			]
		)
	);
}
add_action( 'fusion_builder_before_init', 'iravada_rate_comment_element_func' );
