<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'Royal_Compare_Product' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class Royal_Compare_Product
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;
		
		protected $assetsJS = '';

		public function __construct() {

            $this->assetsJS     = get_stylesheet_directory_uri() . '/includes/royal-compare/assets/js/';

			add_filter( 'fusion_attr_royal-compare-products', [ $this, 'wrapper_attr_royal_compare_products' ] );
			add_filter( 'fusion_attr_royal-compare-product-holder', [ $this, 'wrapper_attr_royal_compare_product_holder' ] );
			add_filter( 'fusion_attr_compare-product-button', [ $this, 'wrapper_attr_compare_product_button' ] );
			add_filter( 'fusion_attr_royal-attr-row-label', [ $this, 'wrapper_attr_royal_attr_row_label' ] );
			add_filter( 'fusion_attr_compare-product-holder-in', [ $this, 'wrapper_attr_compare_product_holder_in' ] );

			add_shortcode( 'Royal_Compare_Product', [ $this, 'render' ] );

            add_action('wp_footer', array($this, 'compare_popup_section'));

		}

        // Compare Popup Section
        public function compare_popup_section() {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
            $current_url = '';

            if( isset($_GET['product_ids']) ) {

                $array_ids              = explode(',', $_GET['product_ids']);
                $get_first_pid          = $array_ids[0];
                $cat_slug               = '';

                $terms = get_the_terms ( $get_first_pid, 'product_cat' );
                if ( $terms && ! is_wp_error( $terms ) ) { // اطمینان از وجود ترم‌ها و عدم خطا
                    foreach ( $terms as $term ) {
                        $cat_slug = $term->slug ;
                    }
                }

                $query_get_product     = array( 
                    'post_type'         => 'product', 
                    'post_status'       => 'publish',
                    'limit'             => 12,
                    'product_cat'       => $cat_slug,
                    'exclude'           => $array_ids,
                    'type'              => array("simple","variable"),
                    'stock_status'      => 'instock',
                  );

            }else {

                $query_get_product     = array( 
                    'post_type'       => 'product', 
                    'post_status'     => 'publish',
                    'limit'           => 12,
                    'type'            => array("simple","variable"),
                    'stock_status'    => 'instock',
                );

            }
            
            $get_product = wc_get_products( $query_get_product );
            
            
            if( isset( $get_royal_option_settings['royal_compare_status'] ) && $get_royal_option_settings['royal_compare_status'] == 'yes' ) {
                
                if( isset( $get_royal_option_settings['compare_page'] ) && $get_royal_option_settings['compare_page'] == get_the_ID() ) {
    
                    ?>
                        
                    <div class="royal-compare-selected-product royal-compare-popup-overlay"></div>
                    <div class="royal-select-product-popup">
                        <div class="royal-popup-header">
                            <div class="popup-title">
                                <p>انتخاب کالا برای مقایسه</p>
                            </div>
                            <div class="close-popup-x"><i class="fa-times fas"></i></div>
                        </div>
                        <div class="royal-popup-content">
                            <div class="royal-popup-search">
                                <div class="royal-popup-search-box">
                                    <div class="royal-serach-icon-popup">
                                        <svg viewBox="25 25 50 50" style="display: none;"><circle r="20" cy="50" cx="50"></circle></svg>
                                        <i class="fa-search fas"></i>
                                    </div>
                                    <div class="royal-popup-serach-box">
                                        <input type="text" class="serach-royal-compare-input" value="" placeholder="جستجوی محصول...">
                                    </div>
                                </div>
                            </div>
                            <div class="royal-add-to-compare-product-list">
                                <?php 
    
                                    foreach( $get_product as $compare_product ) {
                                        
                                        $product = wc_get_product($compare_product);
    
                                        if ( ! $product || ! is_a( $product, 'WC_Product' ) ) {
                                            continue; // اگر محصول معتبر نیست، به ایتریشن بعدی حلقه بروید
                                        }
    
                                        // Get Products Data Needed
                                        $product_id = $product->get_id();
                                        $product_title = $product->get_title();
                                        $product_permalink = get_permalink($product->get_id());
                                        $product_price_html = $product->get_price_html();
                                        $product_image = $product->get_image();
                                        $product_image_id = $product->get_image_id();
                                        $product_image_url = wp_get_attachment_url($product_image_id);
                                        $product_image_url_optimized = get_the_post_thumbnail_url($product_id, 'irava-carousel-300-crop');
    
                                        if( !isset($_GET['product_ids']) ) {
                                            
                                            if( isset( $get_royal_option_settings['compare_page'] ) ) {
                                                $current_url = get_permalink( $get_royal_option_settings['compare_page'] ) . '?product_ids=' . $product_id;
                                            }else {
                                                $current_url = '#';
                                            }
    
                                        }else {
    
                                            $current_url = home_url($_SERVER['REQUEST_URI']) .','. $product_id;
                                        }
    
                                        ?>
                                        <a href="<?= $current_url ?>" class="royal-add-to-compare-link" target="_self">
                                            <div class="royal-compare-product-list">
                                                <div class="product-image-section">
                                                    <img src="<?= $product_image_url_optimized ?>" alt="<?= $product_title ?>">
                                                </div>
                                                <div class="royal-product-title-section">
                                                    <p class="product-title"><?= $product_title ?></p>
                                                </div>
                                                <div class="product-price-section">
                                                    <span class="product-price"><?= $product_price_html ?></span>
                                                </div>
                                            </div>
                                        </a>
                                        <?php
                                    }
    
                                ?>
                            </div>
                        </div>
                    </div>
                    
                    <?php
                }
            }

        }

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

                'iravada_royal_compare_attributes'          => '',
                'royal_compare_view_product_btn_backgrond'  => '#0182b9',
                'royal_compare_view_product_btn_font_color' => '#fff',
                'royal_compare_attribute_label_backgrond'   => '#f5f5f5',
                'royal_compare_attribute_label_font_color'  => '#000',
                'compare_head_sticky_status'                => 'true',
				'class'								        => '',
				'id'								        => '',
                'hide_on_mobile'  					        => fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();
			$fusion_settings = fusion_get_fusion_settings();
            $sticky_status = false;
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'Royal_Compare_Product' );
			
			$this->args = $defaults;
			
			ob_start();

                if( isset( $get_royal_option_settings['royal_compare_status'] ) && $get_royal_option_settings['royal_compare_status'] == 'yes' ) {

                    if( $this->args['compare_head_sticky_status'] == 'true' ) {
                        $sticky_status = true;
                    }
                    
                    wp_enqueue_script('compare_page_script', $this->assetsJS . 'royal-compare-page-script.js', array('jquery'), '10.4', true);

                    wp_localize_script( 'compare_page_script', 'royal_compare_js_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'sticky_status' => $sticky_status ) );

                    if( class_exists('Royal_Compare_System') ) {

                        if( Royal_Compare_System::is_royal_compare() ) {

                            if( isset($_GET['product_ids']) ) {
    
                                $array_ids              = explode(',', $_GET['product_ids']);
                                $firstFourElements      = array_slice($array_ids, 0, 4);
                                $compare_item_data      = explode(',', $this->args['iravada_royal_compare_attributes']);
                                $productID_in_compare   = $firstFourElements;
                                $count_product_load     = 0;
                                ?>
                                
                                <div <?= FusionBuilder::attributes( 'royal-compare-products' ) ?> >
                                    <div <?= FusionBuilder::attributes( 'royal-compare-product-holder' ) ?> >
                                        <div <?= FusionBuilder::attributes( 'compare-product-holder-in' ) ?> >
                                            <?php
        
                                                foreach( $productID_in_compare as $pids ) {
                                                    
                                                    $product = wc_get_product( $pids );
                                                    
                                                    // اضافه کردن این شرط برای اطمینان از اینکه $product یک شیء معتبر است
                                                    if ( ! $product || ! is_a( $product, 'WC_Product' ) ) {
                                                        continue; // اگر محصول معتبر نیست، به ایتریشن بعدی حلقه بروید
                                                    }

                                                    $product_image_url = get_the_post_thumbnail_url( $pids, 'thumbnail' );
                                                    $product_price_html = $product->get_price_html();
                                                    $product_permalink = get_permalink($product->get_id());
                
                                                    ?>
                                                        <div class="product-compare-head-data">
                                                            <div class="royal-remove-from-compare"><span class="royal-remove-compare-icon" data-product-id="<?= $pids ?>"><i class="fa-times fas"></i></span></div>
                                                            <div class="product-compare-img"><img src="<?= $product_image_url ?>" alt="<?= $product->get_title() ?>"></div>
                                                            <div class="product-compare-title"><p <?= FusionBuilder::attributes( 'product-compare-title' ) ?> ><?= $product->get_title() ?></p></div>
                                                            <div class="product-compare-price"><span class="product-price"><?= $product_price_html ?></span></div>
                                                            <div class="product-compare-button">
                                                                <a href="<?= $product_permalink ?>" class="product-compare-link">
                                                                    <span <?= FusionBuilder::attributes( 'compare-product-button' ) ?> >مشاهده و خرید</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    <?php
                                                    $count_product_load++;
        
                                                }
    
                                                if( $count_product_load <= 3 ) {
                                                    ?>
                                                        <div class="compare-search-box">
                                                            <div class="compare-serach-box-in">
                                                                <span class="compare-search-box-icon">
                                                                    <i class="fa-plus fas"></i> 
                                                                </span>
                                                                <span class="compare-serach-box-text">برای افزودن کالا کلیک کنید.</span>
                                                            </div>
                                                            <div class="product-compare-button">
                                                                <span class="compare-product-button search-btn">افزودن کالا</span>
                                                            </div>
                                                        </div>
                                                    <?php
            
                                                }
    
                                            ?>
                                        </div>
                                    
                                    </div>
                                    
                                    <?php
                                    if( $this->args['iravada_royal_compare_attributes'] != '' ) {
        
                                        ?>
                                        <div class="royal-compare-attribute-data">
                                            <ul class="royal-attr-item">
                                                <?php 
        
                                                    foreach( $compare_item_data as $attrCompareListElement ) {
                                                                                                    
                                                        $check_product_has_attr = false;
                                                        $AttributeID = wc_attribute_taxonomy_id_by_name($attrCompareListElement);
                                                        $attr_options_html = '';
        
                                                        for( $a = 0; $a < $count_product_load; $a++ ) {

                                                            $product = wc_get_product( $productID_in_compare[$a] );
                                                        
                                                            // **این شرط جدید اضافه شده است:**
                                                            if ( ! $product || ! is_a( $product, 'WC_Product' ) ) {
                                                                $attr_options_html .= '<span class="royal-attr-value-row">';
                                                                $attr_options_html .= '<span class="royal-attr-value-items">ناموجود/خطا</span>'; // یا هر پیام مناسب دیگر
                                                                $attr_options_html .= '</span>';
                                                                continue; // اگر محصول معتبر نیست، به ایتریشن بعدی حلقه بروید
                                                            }
                                                        
                                                            $product_attributes = $product->get_attributes(); // Get the product attributes
                                                        
                                                            $attr_options_html .= '<span class="royal-attr-value-row">';
                                                            foreach( $product_attributes as $attrOption ) {
                                                                // ... ادامه کد شما در اینجا بدون تغییر باقی می‌ماند
                                                                if ( $AttributeID == $attrOption['id'] ) {
                                                        
                                                                    $check_product_has_attr = true;
                                                        
                                                                    $getAttrOption = $attrOption['options'];
                                                                    foreach( $getAttrOption as $getOptionsID ) {
                                                                        $term = get_term( $getOptionsID ); // ترم را دریافت می کنیم
                                                                        if ( $term && ! is_wp_error( $term ) ) { // بررسی می کنیم که ترم معتبر است و خطا نیست
                                                                            $attr_options_html .= '<span class="royal-attr-value-items">'. $term->name .'</span>';
                                                                        } else {
                                                                            // در صورتی که ترم پیدا نشد یا خطا بود، می توانید یک متن جایگزین بگذارید
                                                                            $attr_options_html .= '<span class="royal-attr-value-items">N/A</span>';
                                                                        }
                                                                    }
                                                        
                                                                }
                                                        
                                                            }
                                                            $attr_options_html .= '</span>';
                                                        
                                                        }
                                                        if( $check_product_has_attr == true ) {
        
                                                            ?>
                                                                <li>
                                                                    <span <?= FusionBuilder::attributes( 'royal-attr-row-label' ) ?> ><?= wc_attribute_label($attrCompareListElement) ?></span>
                                                                    <span class="royal-attr-value-holder"><?= $attr_options_html ?></span>
                                                                </li>
                                                            <?php
        
                                                        }
        
                                                    }
        
                                                ?>
                                            </ul>
                                        </div>
                                        <?php
        
                                    }else {
                                        ?>
                                        <div class="royal-compare-notice">
                                            <span>لطفا از تنظیمات المان ویژگی هایی که باید مقایسه شوند را تنظیم نمایید.</span>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                                
                                <?php
            
                            }else {
            
                                ?>
                                <div class="royal-compare-products">
                                    <div <?= FusionBuilder::attributes( 'royal-compare-product-holder' ) ?> >
                                        <div <?= FusionBuilder::attributes( 'compare-product-holder-in' ) ?> >
                                            <?php 
                                            
                                            for ($x = 0; $x < 1; $x++) {
                
                                                ?>
                                                    <div class="compare-search-box">
                                                        <div class="compare-serach-box-in">
                                                            <span class="compare-search-box-icon">
                                                                <i class="fa-plus fas"></i> 
                                                            </span>
                                                            <span class="compare-serach-box-text">برای افزودن کالا کلیک کنید.</span>
                                                        </div>
                                                        <div class="product-compare-button">
                                                            <span class="compare-product-button search-btn">افزودن کالا به مقایسه</span>
                                                        </div>
                                                    </div>
                                                <?php
                        
                                            }
                                            
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
            
                            }
    
                        }else {
                            ?>
                            <div class="royal-compare-notice" style="text-align: center;">
                                <span>لطفا از منوی تنظیمات قالب » منوی مقایسه این برگه رو به عنوان برگه مقایسه ست کنید تا جداول نمایش داده شود.</span>
                            </div>
                            <?php
                        }

                    }
                    
                }

			return ob_get_clean();

			

		}

        // Royal Compare Main Parent Tag
        public function wrapper_attr_royal_compare_products() {

            $attr = [ 
				'class' => 'royal-compare-products ' . $this->unique_class,
				'style' => '' 
			];

            if( isset($_GET['product_ids']) ) {

                $array_ids      = explode(',', $_GET['product_ids']);
                $count_items    = count($array_ids);

                $attr['class'] .= "added-product-col-$count_items ";
                $attr['class'] .= "added-product";

            }

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
            return $attr;

        }
        
        // Compare Head Holder
        public function wrapper_attr_royal_compare_product_holder() {
            
			$attr = [ 
				'class' => 'royal-compare-product-holder ' . $this->unique_class,
				'style' => '' 
			];

            if( is_admin_bar_showing() ) {
                $attr['class'] .= 'is-admin-bar-active';
            }
            
			return $attr;
            
        }

        // Compare Product View Btn Style
        public function wrapper_attr_compare_product_button() {

			$attr = [ 
				'class' => 'compare-product-button ' . $this->unique_class,
				'style' => '' 
			];

            $attr['style'] .= 'background: '. $this->args['royal_compare_view_product_btn_backgrond'] .';';
            $attr['style'] .= 'color: '. $this->args['royal_compare_view_product_btn_font_color'] .';';
            $attr['class'] .= 'preview-btn ';
            
			return $attr;

        }

        // Compare Product Attribute Label
        public function wrapper_attr_royal_attr_row_label() {

            $attr = [ 
				'class' => 'royal-attr-row-label ' . $this->unique_class,
				'style' => '' 
			];

            $attr['style'] .= 'background: '. $this->args['royal_compare_attribute_label_backgrond'] .';';
            $attr['style'] .= 'color: '. $this->args['royal_compare_attribute_label_font_color'] .';';
            
			return $attr;

        }

        // Compare Product Head Holder IN
        public function wrapper_attr_compare_product_holder_in() {

            $attr = [ 
				'class' => 'compare-product-holder-in ' . $this->unique_class,
				'style' => '' 
			];

            if( !isset($_GET['product_ids']) ) {
                $attr['style'] .= 'justify-content: center;';
            }
            
			return $attr;

        }


	}
	new Royal_Compare_Product();
}

function iravada_royal_compare_options() {

    if( !class_exists('Royal_Compare_System') ) {
        require_once(get_stylesheet_directory() . '/includes/royal-compare/royal-compare.php');
    }

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'Royal_Compare_Product', 
            [
                'name'            => __( 'Royal Product Compare', 'royal' ),
                'shortcode'       => 'Royal_Compare_Product',
                'icon'            => 'iravada_elements_icon',
				'component'       => false,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 
						
    					[
    						'type'          => 'connected_sortable',
    						'heading'       => __( 'Select Attributes To Compare', 'royal' ),
    						'description'   => __( 'Select The Attributes To Compare Products.', 'royal' ),
    						'param_name'    => 'iravada_royal_compare_attributes',
    						'default'       => '',
    						'choices'       => Royal_Compare_System::royal_compare_attributes_selection(),
    						'group'         => esc_attr__( 'General', 'fusion-builder' )
    					],

						// Css Class Field
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					// Start Design Tab

                    [
						'type'        => 'radio_button_set',
						'heading'     => __( 'Sitcky Head Section', 'royal' ),
						'description' => __( 'Controls the Head Section Sticky.', 'royal' ),
						'param_name'  => 'compare_head_sticky_status',
						'value'       => [
							'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
							'false'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'default'	  => 'true',
						'group' => esc_attr__( 'Design', 'fusion-builder' )
					],
                //  [
				// 		'type'        => 'multiple_select',
				// 		'heading'     => __( 'Select Attributes To Compare', 'royal' ),
				// 		'description' => __( 'Select The Attributes To Compare Products.', 'royal' ),
				// 		'param_name'  => 'iravada_royal_compare_attributes',
				// 		'value'       => Royal_Compare_System::royal_compare_attributes_selection(),
				// 		'default'     => '',
				// 		'group' => esc_attr__( 'Design', 'fusion-builder' )
				// 	],
                    [ 
						'type'          => 'colorpickeralpha',
						'heading'       => __( 'View Product Button Background', 'royal' ),
						'description'   => __( 'Controls the View Product Button Background, default: #0182b9', 'royal' ),
						'param_name'    => 'royal_compare_view_product_btn_backgrond',
						'value'         => '',
						'group'         => esc_attr__( 'Design', 'fusion-builder' )
					],
                    [ 
						'type'          => 'colorpickeralpha',
						'heading'       => __( 'View Product Button Font Color', 'royal' ),
						'description'   => __( 'Controls the View Product Button Font Color, default: #fff', 'royal' ),
						'param_name'    => 'royal_compare_view_product_btn_font_color',
						'value'         => '',
						'group'         => esc_attr__( 'Design', 'fusion-builder' )
					],
                    [ 
						'type'          => 'colorpickeralpha',
						'heading'       => __( 'Product Attribute Label Background', 'royal' ),
						'description'   => __( 'Controls the Product Attribute Label Background, default: #f5f5f5', 'royal' ),
						'param_name'    => 'royal_compare_attribute_label_backgrond',
						'value'         => '',
						'group'         => esc_attr__( 'Design', 'fusion-builder' )
					],
                    [ 
						'type'          => 'colorpickeralpha',
						'heading'       => __( 'Product Attribute Label Font Color', 'royal' ),
						'description'   => __( 'Controls the Product Attribute Label Font Color, default: #000', 'royal' ),
						'param_name'    => 'royal_compare_attribute_label_font_color',
						'value'         => '',
						'group'         => esc_attr__( 'Design', 'fusion-builder' )
					],

					// End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_royal_compare_options' );
