<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_product_video' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_product_video
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_proshop_video_box', [ $this, 'wrapper_attr_product_video' ] );
			
			add_shortcode( 'iravada_product_video', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'								=> '',
				'id'								=> '',
                'hide_on_mobile'  					=> fusion_builder_default_visibility( 'array' ), 
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_product_video' );
			
			$this->args = $defaults;
			
			ob_start();

                $get_video_loop_link_array = array('url' => get_post_meta( get_the_id() , '_iravada_get_product_video_url' , true ));
                $atts = '';
                if (get_post_meta( get_the_id() , '_iravada_get_product_video_url' , true )) {
                    
                    $iravada_video_shortcode = shortcode_atts( array(
                        
                        'class' 	=> 'tooltip_video_icon video_icon',
                        'link'		=> esc_url($get_video_loop_link_array["url"]),
                        'target'	=> 'lightbox',
                        'rel'		=> 'iLightbox',
                        
                    ), $atts );
                
                    echo '<div ' . FusionBuilder::attributes( 'proshop_video_box' ) . '><a class="'.esc_attr($iravada_video_shortcode['class']).'" target="'.esc_attr($iravada_video_shortcode['target']).'" rel="'.esc_attr($iravada_video_shortcode['rel']).'" href="'.esc_attr($iravada_video_shortcode['link']).'" data-caption><i class="iranavada-icon video_icon"></i></a></div>';
                    
                }

			return ob_get_clean();

			

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_product_video() {
			$attr = [ 
				'class' => 'proshop_video_box ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}
	}
	new iravada_product_video();
}

function iravada_product_video_func() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_product_video', 
            [
                'name'            => __( 'Royal Product Video Icon' , 'royal' ),
                'shortcode'       => 'iravada_product_video',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
				'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_product_video_func' );
