<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_reg_login' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_reg_login
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_header_login', [ $this, 'wrapper_attr_iravada_header_login' ] );
			add_filter( 'fusion_attr_awb-menu__mega-wrap', [ $this, 'wrapper_attr_awb_menu_mega_wrap' ] );
			add_filter( 'fusion_attr_royal_header_login_btn', [ $this, 'wrapper_attr_royal_header_login_btn' ] );
			add_filter( 'fusion_attr_royal_header_icon', [ $this, 'wrapper_attr_royal_header_icon' ] );
			add_filter( 'fusion_attr_royal_header_title', [ $this, 'wrapper_attr_royal_header_title' ] );
			
			add_shortcode( 'iravada_reg_login', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
			    'royal_login_title_after_logged_in'  => '',
				'royal_login_title_before_logged_in'	=> '',
				'royal_header_login_register_icon'  => '',
				'royal_header_before_login_register_icon'	=> '',
				'royal_header_login_color'          => '#212934',
			    'royal_mega_menu_submenu'           => '',
                'iravada_set_display_log_reg_form' 	=> 'popup',
				'iravada_popup_type'				=> 'royal_login',
				'royal_custom_class_login_popup'    => '',
				'royal_select_own_login_link'		=> 'woo_my_account',
				'royal_custom_login_link_type'		=> '',
				'margin_top'                        => '0px',
				'margin_right'                      => '20px',
				'margin_bottom'                     => '0px',
				'margin_left'                       => '20px',
				'content_align_login_menu'		    => 'right',
				'content_align_mega_menu'		    => 'left',
				'royal_login_icon_font_size'        => '17px', 
				'royal_login_title_font_size'       => '14px',
				'set_mega_menu_max_width'	        => '200px',
				'class'								=> '',
				'id'								=> '',
                'hide_on_mobile'  					=> fusion_builder_default_visibility( 'array' ), 
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_reg_login' );
			
			$this->args = $defaults;
			
			// Get the width.
			$width   = fusion_data()->post_meta( $this->args['royal_mega_menu_submenu'] )->get( 'megamenu_wrapper_width' );
			$width   = empty( $width ) ? 'site_width' : $width;
			$css_var = 'var(--site_width)';
			if ( 'viewport_width' === $width ) {
				$css_var = '100vw';
			} elseif ( 'custom_width' === $width ) {
				$max_width = fusion_data()->post_meta( $this->args['royal_mega_menu_submenu'] )->get( 'megamenu_wrapper_max_width' );
				$css_var   = ! empty( $max_width ) ? Fusion_Sanitize::number( $max_width ) . 'px' : '1200px';
			}
			
			ob_start();

            if ( is_user_logged_in() ) {
        
                global $current_user; 
                wp_get_current_user();
                $get_user_email = $current_user->user_email;
                
                $useravatar_login_dropdown = get_stylesheet_directory_uri() . '/includes/royal-elements/assets/images/iravada-register-login-icon.svg';
                $redirect = home_url();

                ?>
                
                <div <?= FusionBuilder::attributes( 'iravada_header_login' ) ?> >
                    <ul>
                        <li <?= FusionBuilder::attributes( 'logged_in_acount' ) ?> >
							<a <?= FusionBuilder::attributes( 'royal_header_login_btn' ) ?> href="<?= $this->args['royal_custom_login_link_type'] ? $this->args['royal_custom_login_link_type'] : get_permalink( get_option('woocommerce_myaccount_page_id')) ?>">
                                <i <?= FusionBuilder::attributes( 'royal_header_icon' ) ?> iravada_margin_left_register_login" style="position: relative;"></i>
                                <span <?= FusionBuilder::attributes( 'royal_header_title' ) ?>><?= $this->args['royal_login_title_after_logged_in'] ? $this->args['royal_login_title_after_logged_in'] : 'حساب کاربری' ?></span>
							</a>
                            
							<?php 
							if ( ! empty( $this->args['royal_mega_menu_submenu'] ) && '0' !== $this->args['royal_mega_menu_submenu'] ) {
                                ?>
                                <div <?= FusionBuilder::attributes( 'awb-menu__mega-wrap' ) ?> id="awb-mega-menu-<?= $this->args['royal_mega_menu_submenu'] ?>" data-width="' . $width . '" style="--awb-megamenu-width: <?= $css_var ?>; padding-top: 10px;">
                                    <div <?= FusionBuilder::attributes( 'royal-mega-menu-content' ) ?> >
                                        <?= do_shortcode( get_post_field( 'post_content', $this->args['royal_mega_menu_submenu'] ) ) ?>
                                    </div>
                                </div>
                                <?php
                            }
							?>
                            
                        </li>
                    </ul>
                </div>
                
                <?php
                
            } else { // Start Not Login Section
                
                // If For How Display Form On Popup
                if( $this->args['iravada_set_display_log_reg_form'] == 'popup' ) { 
                    
					// Check Popup Status On Royal Popup
					if( $this->args['iravada_popup_type'] == 'royal_login' ) {

						?>
						<div <?= FusionBuilder::attributes( 'iravada_header_login' ) ?> >
							<ul>
								<li <?= FusionBuilder::attributes( 'logged_out_acount' ) ?> >
									<a <?= FusionBuilder::attributes( 'royal_header_login_btn' ) ?> target="_self" href="#" data-toggle="modal" data-target=".fusion-modal.royal_header_login">
										<i <?= FusionBuilder::attributes( 'royal_header_icon' ) ?> aria-hidden="true" style="position: relative;"></i>
										<span <?= FusionBuilder::attributes( 'royal_header_title' ) ?> ><?= $this->args['royal_login_title_before_logged_in'] ? $this->args['royal_login_title_before_logged_in'] : 'ورود/عضویت' ?></span>
									</a>
								</li>
							</ul>
						</div>
						<?php

					}

					if( $this->args['iravada_popup_type'] == 'kerasno' ) {

						?>
						<div <?= FusionBuilder::attributes( 'iravada_header_login' ) ?> >
							<ul>
								<li <?= FusionBuilder::attributes( 'logged_out_acount' ) ?> >
									<a <?= FusionBuilder::attributes( 'royal_header_login_btn mreeir-modal-full' ) ?> target="_self" href="#" data-toggle="modal">
										<i <?= FusionBuilder::attributes( 'royal_header_icon' ) ?> aria-hidden="true" style="position: relative;"></i>
										<span <?= FusionBuilder::attributes( 'royal_header_title' ) ?> ><?= $this->args['royal_login_title_before_logged_in'] ? $this->args['royal_login_title_before_logged_in'] : 'ورود/عضویت' ?></span>
									</a>
								</li>
							</ul>
						</div>
						<?php

					}

					if( $this->args['iravada_popup_type'] == 'custom_class' ) {
						
						?>
						<div <?= FusionBuilder::attributes( 'iravada_header_login' ) ?> >
							<ul>
								<li <?= FusionBuilder::attributes( 'logged_out_acount' ) ?> >
									<a <?= FusionBuilder::attributes( 'royal_header_login_btn'.$this->args['royal_custom_class_login_popup'].' ' ) ?> target="_self" href="#" data-toggle="modal">
										<i <?= FusionBuilder::attributes( 'royal_header_icon' ) ?> aria-hidden="true" style="position: relative;"></i>
										<span <?= FusionBuilder::attributes( 'royal_header_title' ) ?> ><?= $this->args['royal_login_title_before_logged_in'] ? $this->args['royal_login_title_before_logged_in'] : 'ورود/عضویت' ?></span>
									</a>
								</li>
							</ul>
						</div>
						<?php

					}

                }
                
                // If For How Display Form On My Account Page
                if( $this->args['iravada_set_display_log_reg_form'] == 'my_account_page' ) {
                
					if( $this->args['royal_select_own_login_link'] == 'woo_my_account' ) {

						?>
						<div <?= FusionBuilder::attributes( 'iravada_header_login' ) ?> >
							<ul>
								<li <?= FusionBuilder::attributes( 'logged_out_acount' ) ?> >
									<a <?= FusionBuilder::attributes( 'royal_header_login_btn' ) ?> href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ) ?>">
										<i <?= FusionBuilder::attributes( 'royal_header_icon' ) ?> aria-hidden="true" style="position: relative;"></i>
										<span <?= FusionBuilder::attributes( 'royal_header_title' ) ?> ><?= $this->args['royal_login_title_before_logged_in'] ? $this->args['royal_login_title_before_logged_in'] : 'ورود/عضویت' ?></span>
									</a>
								</li>
							</ul>
						</div>
						<?php

					}

					if( $this->args['royal_select_own_login_link'] == 'custom_link' ) {

						?>
						<div <?= FusionBuilder::attributes( 'iravada_header_login' ) ?> >
							<ul>
								<li <?= FusionBuilder::attributes( 'logged_out_acount' ) ?> >
									<a <?= FusionBuilder::attributes( 'royal_header_login_btn' ) ?> href="<?= $this->args['royal_custom_login_link_type'] ?>">
										<i <?= FusionBuilder::attributes( 'royal_header_icon' ) ?> aria-hidden="true" style="position: relative;"></i>
										<span<?= FusionBuilder::attributes( 'royal_header_title' ) ?> ><?= $this->args['royal_login_title_before_logged_in'] ? $this->args['royal_login_title_before_logged_in'] : 'ورود/عضویت' ?></span>
									</a>
								</li>
							</ul>
						</div>
						<?php

					}
                    
                }

            }

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_iravada_header_login() {
			$attr = [ 
				'class' => 'iravada_header_login ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			if( $this->args['content_align_login_menu'] == 'right' ) {
			    $attr['style'] .= 'display: flex;';
				$attr['style'] .= 'justify-content: flex-start;';
			}

			if( $this->args['content_align_login_menu'] == 'center' ) {
			    $attr['style'] .= 'display: flex;';
				$attr['style'] .= 'justify-content: center;';
			}

			if( $this->args['content_align_login_menu'] == 'left' ) {
			    $attr['style'] .= 'display: flex;';
				$attr['style'] .= 'justify-content: flex-end;';
			}
			
            $attr['style'] .= 'margin: '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_top']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_bottom']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['margin_left']) .';';

			return $attr;
		}

		// Main Parent Mega Menu
		public function wrapper_attr_awb_menu_mega_wrap() {

			$attr = [ 
				'class' => 'awb-menu__mega-wrap ' . $this->unique_class,
				'style' => '' 
			];

			$attr['class'] .= 'royal-account-mega-menu';
			
			if( $this->args['content_align_mega_menu'] == 'left' ) {
				$attr['style'] .= 'left: 0px;';
				$attr['style'] .= 'right: auto;';
			}

			if( $this->args['content_align_mega_menu'] == 'right' ) {
				$attr['style'] .= 'right: 0px;';
				$attr['style'] .= 'left: auto;';
			}

			$attr['style'] .= 'max-width: '. fusion_library()->sanitize->get_value_with_unit( $this->args['set_mega_menu_max_width'] ) .' ;';

			return $attr;

		}
		
		// a Tag Attr Needed
		public function wrapper_attr_royal_header_login_btn() {
		    
			$attr = [ 
				'class' => 'royal_header_login_btn ' . $this->unique_class,
				'style' => '' 
			];
			
			$attr['style'] .= 'color: '. $this->args['royal_header_login_color'] .';';

			return $attr;
		    
		}
		
		// Icon Attributes
		public function wrapper_attr_royal_header_icon() {
		    
			$attr = [ 
				'class' => 'royal_header_icon ' . $this->unique_class,
				'style' => '' 
			];
			
			if( is_user_logged_in() ) {
			    $attr['class'] .= fusion_font_awesome_name_handler( $this->args['royal_header_login_register_icon'] ) ? fusion_font_awesome_name_handler( $this->args['royal_header_login_register_icon'] ) : 'fas fa-user';   
			}else {
			    $attr['class'] .= fusion_font_awesome_name_handler( $this->args['royal_header_before_login_register_icon'] ) ? fusion_font_awesome_name_handler( $this->args['royal_header_before_login_register_icon'] ) : 'fas fa-user';   
			}
			
			$attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['royal_login_icon_font_size'] ) .' ;';

			return $attr;
		    
		}
		
		// Title Attributes
		public function wrapper_attr_royal_header_title() {
		    
			$attr = [ 
				'class' => 'royal_header_title ' . $this->unique_class,
				'style' => '' 
			];
			
			$attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['royal_login_title_font_size'] ) .' ;';

			return $attr;
		    
		}

	}new iravada_reg_login();
}

/**
 * Return Avada mega-menus (admin / fb live only).
 *
 * @return array  ID => title
 */
function return_mega_menu_submenu() {

    if ( ! ( is_admin() || ( isset( $_GET['fb-edit'] ) && $_GET['fb-edit'] ) ) ) {
        return [];
    }

    $list = [ '' => __( 'Select a mega menu', 'royal' ) ];

    $mega_menus = get_posts( [
        'post_type'        => 'fusion_element',
        'post_status'      => 'publish',
        'posts_per_page'   => -1,
        'suppress_filters' => true,   // جلوگیری از تداخل افزونه‌ها
        'fields'           => 'ids',  // سبک‌ترین حالت
    ] );

    foreach ( $mega_menus as $id ) {
        $list[ $id ] = get_the_title( $id );
    }

    return $list;
}

function iravada_register_login_func() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_reg_login', 
            [
                'name'            => __( 'Royal Register/Login Form' , 'royal' ),
                'shortcode'       => 'iravada_reg_login',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'header' ],
				'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					// Start Design Tab
					[
    					'type'        => 'textfield',
    					'heading'     => __( 'Title Before Logged In', 'royal' ),
    					'description' => __( 'Set Title For Before Logged In.', 'royal' ),
    					'param_name'  => 'royal_login_title_before_logged_in',
    					'value'       => '',
        				'group' => esc_attr__( 'Design', 'fusion-builder' )
    				],
					[
						'type'        => 'iconpicker',
						'heading'     => __( 'Select Icon Before Login', 'royal' ),
						'description' => __( 'Select Any Icon For Login/Register Button In Header Template Before Login.', 'royal' ),
						'param_name'  => 'royal_header_before_login_register_icon',
						'value'       => '',
        				'group' => esc_attr__( 'Design', 'fusion-builder' )
					],
					[
    					'type'        => 'textfield',
    					'heading'     => __( 'Title After Loged In', 'royal' ),
    					'description' => __( 'Set Title For After Loged In.', 'royal' ),
    					'param_name'  => 'royal_login_title_after_logged_in',
    					'value'       => '',
        				'group' => esc_attr__( 'Design', 'fusion-builder' )
    				],
					[
						'type'        => 'iconpicker',
						'heading'     => __( 'Select Icon logged in', 'royal' ),
						'description' => __( 'Select Any Icon For Login/Register Button In Header Template.', 'royal' ),
						'param_name'  => 'royal_header_login_register_icon',
						'value'       => '',
        				'group' => esc_attr__( 'Design', 'fusion-builder' )
					],
					[
    					'type'        => 'textfield',
    					'heading'     => __( 'Menu Title Font Size', 'royal' ),
    					'description' => __( 'Set Title Font Size.', 'royal' ),
    					'param_name'  => 'royal_login_title_font_size',
    					'value'       => '',
        				'group' => esc_attr__( 'Design', 'fusion-builder' )
    				],
					[
    					'type'        => 'textfield',
    					'heading'     => __( 'Menu Icon Font Size', 'royal' ),
    					'description' => __( 'Set Icon Font Size.', 'royal' ),
    					'param_name'  => 'royal_login_icon_font_size',
    					'value'       => '',
        				'group' => esc_attr__( 'Design', 'fusion-builder' )
    				],
    					'fusion_margin_placeholder'    => [
    						'param_name' => 'margin',
    						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
    						'value'      => [
    							'margin_top'    => '',
    							'margin_right'  => '',
    							'margin_bottom' => '',
    							'margin_left'   => '',
    						],
    					],
					[ 
						'type' => 'radio_button_set', 
						'heading' => __( 'Alignment Menu', 'royal' ),
						'description' => __( 'Choose to align the Menu left, right or center.', 'royal' ),
						'param_name' => 'content_align_login_menu', 
						'value' => [ 
							'left' => esc_attr__( 'Left', 'fusion-builder' ), 
							'center' => esc_attr__( 'Center', 'fusion-builder' ), 
							'right' => esc_attr__( 'Right', 'fusion-builder' ) 
						], 
						'default' => 'right', 
						'group' => esc_attr__( 'Design', 'fusion-builder' ) 
					], 
					[ 
						'type' => 'radio_button_set', 
						'heading' => __( 'Alignment Mega Menu', 'royal' ),
						'description' => esc_attr__( 'Choose to align the Mega Menu left, right or center.', 'royal' ),
						'param_name' => 'content_align_mega_menu', 
						'value' => [ 
							'left' => esc_attr__( 'Left', 'fusion-builder' ), 
							'right' => esc_attr__( 'Right', 'fusion-builder' ) 
						], 
						'default' => 'left', 
						'group' => esc_attr__( 'Design', 'fusion-builder' ) 
					], 
					[
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Font Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #c1c1c1.', 'fusion-builder' ),
						'param_name'  => 'royal_header_login_color',
						'value'       => '',
						'default' 	  => '',
						'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
					],
					[
                        'type'        => 'select',
                        'heading'     => __( 'Mega Menu Submenu', 'royal' ),
                        'description' => __( 'Select Your Own Mega Menu For Display In Register/Login Submenu.', 'royal' ),
                        'param_name'  => 'royal_mega_menu_submenu',
                        'value'       => return_mega_menu_submenu(),
                        'placeholder' => __( 'Select a mega menu', 'royal' ),
                        'group'       => esc_attr__( 'Design', 'fusion-builder' )
                    ],
					[
						'type'        => 'range',
						'heading'     => __( 'My Account Mega Menu Width', 'royal' ),
						'description' =>__( 'Set Mega Menu Width, Default: 100px', 'royal' ),
						'param_name'  => 'set_mega_menu_max_width',
						'value'       => '220',
						'min'         => '100',
						'max'         => '500',
						'step'        => '1',
						'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
					],
                    [ 
                        'type'        => 'radio_button_set',
                        'heading'     => __( 'How to display the login form' , 'royal' ),
                        'description' => __( 'Using this section, you can choose how to display the login / membership form.' , 'royal' ),
                        'param_name'  => 'iravada_set_display_log_reg_form',
                        'value'       => [ 
                            'popup'             => __( 'PopUp' , 'royal' ),
                            'my_account_page'   => __( 'My Account Page' , 'royal' ),
                        ],
                        'default'     => 'popup',
                        'group' => esc_attr__( 'Design', 'fusion-builder' )
                    ],

					// Popup
                    [ 
                        'type'        => 'radio_button_set',
                        'heading'     => __( 'Select Type Of Login Popup' , 'royal' ),
                        'description' => __( 'Using this section, you can choose Type Of Login Popups.' , 'royal' ),
                        'param_name'  => 'iravada_popup_type',
                        'value'       => [ 
                            'royal_login'          => __( 'Royal Login' , 'royal' ),
                            'kerasno'   				 => __( 'Kerasno' , 'royal' ),
                            'custom_class'   	=> __( 'Custom' , 'royal' ),
                        ],
                        'default'     => 'royal_login',
                        'group' => esc_attr__( 'Design', 'fusion-builder' ),
						'dependency'       => [
							[
								'element'  => 'iravada_set_display_log_reg_form',
								'value'    => 'popup',
								'operator' => '==',
							],
						],
                    ],
					[
						'type'        => 'textfield',
						'heading'     => __( 'Custom Popup On Click Class', 'royal' ),
						'description' => __( 'Set Custom Popup On Click Class For Load Popup.', 'royal' ),
						'param_name'  => 'royal_custom_class_login_popup',
						'value'       => '',
						'callback'         => [],
                        'group' => esc_attr__( 'Design', 'fusion-builder' ),
						'dependency'       => [
							[
								'element'  => 'iravada_popup_type',
								'value'    => 'custom_class',
								'operator' => '==',
							],
						],
					],

					// My Account
                    [ 
                        'type'        => 'radio_button_set',
                        'heading'     => __( 'Select Type Of Login Account Page' , 'royal' ),
                        'description' => __( 'Using this section, you can choose Type Of Login Account Page.' , 'royal' ),
                        'param_name'  => 'royal_select_own_login_link',
                        'value'       => [ 
                            'woo_my_account'     => __( 'Woo My Acoount' , 'royal' ),
                            'custom_link'   	    => __( 'Custom' , 'royal' ),
                        ],
                        'default'     => 'woo_my_account',
                        'group' => esc_attr__( 'Design', 'fusion-builder' ),
						'dependency'       => [
							[
								'element'  => 'iravada_set_display_log_reg_form',
								'value'    => 'my_account_page',
								'operator' => '==',
							],
						],
                    ],
					[
						'type'        => 'link_selector',
						'heading'     => __( 'Woo Custom Login Link', 'royal' ),
						'description' => __( 'Put The Custom Login Link Here.', 'royal' ),
						'param_name'  => 'royal_custom_login_link_type',
						'value'       => '',
						'group' => esc_attr__( 'Design', 'fusion-builder' ),
						'callback'         => [],
						'dependency'       => [
							[
								'element'  => 'royal_select_own_login_link',
								'value'    => 'custom_link',
								'operator' => '==',
							],
						],
					],
					// End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_register_login_func' );
