<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_products_specific' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_products_specific
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {

			add_filter( 'fusion_attr_parent_text_field', [ $this, 'wrapper_attr_parent_text_field' ] ); // Text Field Parent
			add_filter( 'fusion_attr_royal_text_field', [ $this, 'wrapper_attr_royal_text_field' ] ); // Text Field Child
			add_filter( 'fusion_attr_text_field_icon', [ $this, 'wrapper_attr_text_field_icon' ] ); // Icon Attr
			add_filter( 'fusion_attr_text_field_title', [ $this, 'wrapper_attr_text_field_title' ] ); // Text Firld Title Attr
			add_filter( 'fusion_attr_text_field_value', [ $this, 'wrapper_attr_text_field_value' ] ); // Text Firld Value Attr
			add_filter( 'fusion_attr_parent_textarea_field', [ $this, 'wrapper_attr_parent_textarea_field' ] ); // Textarea Field Parent
			add_filter( 'fusion_attr_parent_img_field', [ $this, 'wrapper_attr_parent_img_field' ] ); // Image Field Parent
			add_filter( 'fusion_attr_royal-products-specific-data-textarea', [ $this, 'wrapper_attr_royal_products_specific_data_textarea' ] ); // Textarea Field
			add_filter( 'fusion_attr_royal-custom-data-img', [ $this, 'wrapper_attr_royal_custom_data_img' ] ); // Img Main Parent
			add_shortcode( 'iravada_products_specific', [ $this, 'render' ] );

		}
        
		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'royal_products_specific'                           => '',
                'specific_product_data_icon'                        => '',
                'specific_product_data_icon_font_size'              => '20px',
                'specific_product_data_icon_color'                  => '#555555',
                'specific_product_data_icon_alignment'              => 'right',
                'specific_product_data_text_title_size'             => '14px',
                'specific_product_data_text_title_color'            => '#666',
                'specific_product_data_text_title_bold'             => 'no',
                'specific_product_data_text_text_size'              => '14px',
                'specific_product_data_text_color'                  => '#666',
                'margin_top'                                        => '10px',
                'margin_right'                                      => '0px',
                'margin_bottom'                                     => '10px',
                'margin_left'                                       => '0px',
                'specific_product_data_text_description_align'      => 'right',
                'specific_product_data_position_absolute'           => 'no',
                'specific_product_data_img_max_width'               => '100px',
				'border_radius_top_left'                            => '0px',
				'border_radius_top_right'                           => '0px',
				'border_radius_bottom_right'                        => '0px',
				'border_radius_bottom_left'                         => '0px',
				'text_field_background_color'                       => '',
                'specific_product_data_text_description_color'  => '',
                'specific_product_data_description_size'        => '14px',
                'royal_custom_data_alignment'      => '',
                'padding_top'                                       => '0px',
                'padding_right'                                     => '0px',
                'padding_bottom'                                    => '0px',
                'padding_left'                                      => '0px',
                'border_top'                                        => '0px',
                'border_right'                                      => '0px',
                'border_bottom'                                     => '0px',
                'border_left'                                       => '0px',
                'royal_acf_border_color'                            => '#e0e0e2',
				'class'			  				                    => '',
				'id'			  				                    => '',
                'hide_on_mobile' 				                    => fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

        // Get Safe Value
        public function get_safe_value($array, $key, $default = null) {
            return isset($array[$key]) ? $array[$key] : $default;
        }

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_products_specific' );
			
            // Get Royal Options
            $get_royal_option_settings = Royal_Option_Functions::get_royal_option_settings();

			$this->args = $defaults;
			
			ob_start();

                $get_royal_specific_group = get_post_meta(get_the_ID(), 'royal_product_specific_field', true);
                $unserialize_royal_specific_data = unserialize( $get_royal_specific_group );

                if( $get_royal_specific_group ) {

                    // Start Text Field 
                    if( $this->args['royal_products_specific'] == 'text_field_one' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_one_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_one_p2') ) {
                            
                            ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_one_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_one_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_one_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_one_p2') ?></span>
                                        </div>
                                        <?php
                                    }
    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                            
                        }
                    }
    
                    if( $this->args['royal_products_specific'] == 'text_field_two' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_two_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_two_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_two_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_two_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_two_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_two_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
    
                    if( $this->args['royal_products_specific'] == 'text_field_three' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_three_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_three_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_three_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_three_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_three_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_three_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
    
                    if( $this->args['royal_products_specific'] == 'text_field_four' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_four_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_four_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_four_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_four_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_four_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_four_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
    
                    if( $this->args['royal_products_specific'] == 'text_field_five' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_five_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_five_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_five_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_five_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_five_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_five_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
                    if( $this->args['royal_products_specific'] == 'text_field_six' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_six_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_six_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_six_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_six_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_six_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_six_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
                    if( $this->args['royal_products_specific'] == 'text_field_seven' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_seven_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_seven_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_seven_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_seven_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_seven_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_seven_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
                    if( $this->args['royal_products_specific'] == 'text_field_eight' ) {
                        if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_eight_p1') != '' or $this->get_safe_value($unserialize_royal_specific_data, 'text_field_eight_p2') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_text_field' ) ?> >
                                
                                <div <?= FusionBuilder::attributes( 'royal_text_field' ) ?> >
                                    <?php 
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_eight_p1') != '' ) {
                                        ?>
                                        <div class="royal-text-title">
                                            <span <?= FusionBuilder::attributes( 'text_field_title' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_eight_p1') ?></span>
                                        </div>
                                        <?php
                                    }
                                    if( $this->get_safe_value($unserialize_royal_specific_data, 'text_field_eight_p2') != '' ) {
                                        ?>
                                        <div class="royal-text-value">
                                            <span <?= FusionBuilder::attributes( 'text_field_value' ) ?> ><?= $this->get_safe_value($unserialize_royal_specific_data, 'text_field_eight_p2') ?></span>
                                        </div>
                                        <?php
                                    }
                                    
                                    if( $this->args['specific_product_data_icon'] != '' ) {
                                        ?>
                                        <div class="royal-product-specific-data-icon" style="display: flex;">
                                            <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </div>
                        <?php
                        }
                    }
                    // End Text Field 

                    // Start Image Field
                    if( $this->args['royal_products_specific'] == 'img_field_one' and $this->get_safe_value($unserialize_royal_specific_data, 'img_field_one') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'royal-custom-data-img' ) ?>>
                                <div  <?= FusionBuilder::attributes( 'parent_img_field' ) ?> >
                                    <img src="<?= $this->get_safe_value($unserialize_royal_specific_data, 'img_field_one') ?>" class="royal-specific-img-one">
                                </div>
                            </div>
                        <?php
                    }

                    if( $this->args['royal_products_specific'] == 'img_field_two' and $this->get_safe_value($unserialize_royal_specific_data, 'img_field_two') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'royal-custom-data-img' ) ?>>
                                <div  <?= FusionBuilder::attributes( 'parent_img_field' ) ?> >
                                    <img src="<?= $this->get_safe_value($unserialize_royal_specific_data, 'img_field_two') ?>" class="royal-specific-img-one">
                                </div>
                            </div>
                        <?php
                    }

                    if( $this->args['royal_products_specific'] == 'img_field_three' and $this->get_safe_value($unserialize_royal_specific_data, 'img_field_three') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'royal-custom-data-img' ) ?>>
                                <div  <?= FusionBuilder::attributes( 'parent_img_field' ) ?> >
                                    <img src="<?= $this->get_safe_value($unserialize_royal_specific_data, 'img_field_three') ?>" class="royal-specific-img-one">
                                </div>
                            </div>
                        <?php
                    }

                    if( $this->args['royal_products_specific'] == 'img_field_four' and $this->get_safe_value($unserialize_royal_specific_data, 'img_field_four') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'royal-custom-data-img' ) ?>>
                                <div  <?= FusionBuilder::attributes( 'parent_img_field' ) ?> >
                                    <img src="<?= $this->get_safe_value($unserialize_royal_specific_data, 'img_field_four') ?>" class="royal-specific-img-one">
                                </div>
                            </div>
                        <?php
                    }

                    if( $this->args['royal_products_specific'] == 'img_field_five' and $this->get_safe_value($unserialize_royal_specific_data, 'img_field_five') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'royal-custom-data-img' ) ?>>
                                <div  <?= FusionBuilder::attributes( 'parent_img_field' ) ?> >
                                    <img src="<?= $this->get_safe_value($unserialize_royal_specific_data, 'img_field_five') ?>" class="royal-specific-img-one">
                                </div>
                            </div>
                        <?php
                    }
                    // End Image Field

                    // Start Textarea Field
                    if( $this->args['royal_products_specific'] == 'textarea_field_one' and $this->get_safe_value($unserialize_royal_specific_data, 'textarea_field_one') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_textarea_field' ) ?> style="display: flex;flex-direction: row;align-items: flex-start;" >
                                <?php 
                                if( $this->args['specific_product_data_icon'] != '' ) {
                                    ?>
                                    <div class="royal-product-specific-data-icon" style="display: flex;">
                                        <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                    </div>
                                    <?php
                                }
                                ?>
                                <div <?= FusionBuilder::attributes( 'royal-products-specific-data-textarea' ) ?>>
                                    <span class="iravada-royal-products-specific-data-title"><?= $this->get_safe_value($unserialize_royal_specific_data, 'textarea_field_one') ?></span>
                                </div>
                                <?php 
                                if( $this->args['specific_product_data_icon'] != '' ) {
                                    ?>
                                    <div class="royal-product-specific-data-icon" style="display: flex;">
                                        <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        <?php
                    }

                    if( $this->args['royal_products_specific'] == 'textarea_field_two' and $this->get_safe_value($unserialize_royal_specific_data, 'textarea_field_two') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_textarea_field' ) ?> style="display: flex;flex-direction: row;align-items: flex-start;" >
                                <?php 
                                if( $this->args['specific_product_data_icon'] != '' ) {
                                    ?>
                                    <div class="royal-product-specific-data-icon" style="display: flex;">
                                        <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="royal-products-specific-data-textarea">
                                    <span class="iravada-royal-products-specific-data-title"><?= $this->get_safe_value($unserialize_royal_specific_data, 'textarea_field_two') ?></span>
                                </div>
                                <?php 
                                if( $this->args['specific_product_data_icon'] != '' ) {
                                    ?>
                                    <div class="royal-product-specific-data-icon" style="display: flex;">
                                        <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        <?php
                    }

                    if( $this->args['royal_products_specific'] == 'textarea_field_three' and $this->get_safe_value($unserialize_royal_specific_data, 'textarea_field_three') != '' ) {
                        ?>
                            <div <?= FusionBuilder::attributes( 'parent_textarea_field' ) ?> style="display: flex;flex-direction: row;align-items: flex-start;" >
                                <?php 
                                if( $this->args['specific_product_data_icon'] != '' ) {
                                    ?>
                                    <div class="royal-product-specific-data-icon" style="display: flex;">
                                        <?php if( $this->args['specific_product_data_icon_alignment'] == 'right' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                    </div>
                                    <?php
                                }
                                ?>
                                <div class="royal-products-specific-data-textarea">
                                    <span class="iravada-royal-products-specific-data-title"><?= $this->get_safe_value($unserialize_royal_specific_data, 'textarea_field_three') ?></span>
                                </div>
                                <?php 
                                if( $this->args['specific_product_data_icon'] != '' ) {
                                    ?>
                                    <div class="royal-product-specific-data-icon" style="display: flex;">
                                        <?php if( $this->args['specific_product_data_icon_alignment'] == 'left' ) { ?> <i <?= FusionBuilder::attributes( 'text_field_icon' ) ?>></i> <?php } ?>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                        <?php
                    }
                    // End Textarea Field

                }
            
			return ob_get_clean();

			

		}

        // Attr  For Text Field Parent
        public function wrapper_attr_parent_text_field() {

			$attr = [ 
				'class' => 'parent_text_field ' . $this->unique_class,
				'style' => '' 
			];

            // General Tab Options
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

            // Class Attr
            $attr['class'] .= 'iravada-royal-products-specific-data';

            if( $this->args['specific_product_data_position_absolute'] == 'yes' ) {
                // dont add border On Position Absolute
            }else {
                $attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 
                $attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 
                $attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 
                $attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 
                $attr['style'] .= 'border-style: solid;'; 
                $attr['style'] .= 'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
                $attr['style'] .= 'border-color:' .  $this->args['royal_acf_border_color'] .';'; 
            }

            // Style Attr
            $attr['style'] .= 'z-index: 100;';
            $attr['style'] .= 'width: 100%;';
            $attr['style'] .= 'display: flex;';
            $attr['style'] .= 'flex-direction: row;';
            
            if( $this->args['royal_custom_data_alignment'] == 'right' ) {
                $attr['style'] .= 'justify-content: flex-start;';
            }

            if( $this->args['royal_custom_data_alignment'] == 'center' ) {
                $attr['style'] .= 'justify-content: center;';
            }

            if( $this->args['royal_custom_data_alignment'] == 'left' ) {
                $attr['style'] .= 'justify-content: flex-end;';
            }

            return $attr;

        }

        // Attr For Text Field Child
        public function wrapper_attr_royal_text_field() {
            
			$attr = [ 
				'class' => 'royal_text_field ' . $this->unique_class,
				'style' => '' 
			];
			
			if( $this->args['text_field_background_color'] != '' ) {
                $attr['style'] .= 'background:' . fusion_library()->sanitize->get_value_with_unit( $this->args['text_field_background_color'] ) . ';';   
            }
            $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 
            
            if( $this->args['specific_product_data_position_absolute'] == 'yes' ) {
                $attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 
                $attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 
                $attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 
                $attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 
                $attr['style'] .= 'border-style: solid;'; 
                $attr['style'] .= 'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
                $attr['style'] .= 'border-color:' .  $this->args['royal_acf_border_color'] .';'; 
            }else {
                // dont add border On Position Absolute
            }
            
            if( $this->args['specific_product_data_position_absolute'] == 'yes' ) {
                $attr['style'] .= 'position: absolute;';
            }
            
            $attr['style'] .= 'display: inline-flex;';
            $attr['style'] .= 'margin: '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_top'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_right'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_bottom'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_left'] ) .';';

			
			return $attr;
            
        }

        // Attr For Icon
		public function wrapper_attr_text_field_icon() {

			$attr = [ 
				'class' => 'text_field_icon ' . $this->unique_class,
				'style' => '' 
			];

            $attr['class'] .= fusion_font_awesome_name_handler( $this->args['specific_product_data_icon'] );

            // Style For Icon
            $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['specific_product_data_icon_color'] ) . ';';
            $attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['specific_product_data_icon_font_size'] ) .';';

            $attr['style'] .= 'display: flex;';
            $attr['style'] .= 'align-items: center;';

            if( $this->args['specific_product_data_icon_alignment'] == 'right' ) {
                $attr['style'] .= 'margin-left: 10px;';
            }
            if( $this->args['specific_product_data_icon_alignment'] == 'left' ) {
                $attr['style'] .= 'margin-right: 10px;';
            }
            
			return $attr;

		}

        // Attr Text Field Title
        public function wrapper_attr_text_field_title() {

            $attr = [ 
				'class' => 'text_field_title ' . $this->unique_class,
				'style' => '' 
			];

            $attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['specific_product_data_text_title_size'] ) .';';
            $attr['style'] .= 'color: '. $this->args['specific_product_data_text_title_color'] . ';';

            if( $this->args['specific_product_data_text_title_bold'] == 'yes' ) {
                $attr['style'] .= 'font-weight: bold;';
            }

            return $attr;

        }

        // Attr Text Field Value
        public function wrapper_attr_text_field_value() {

            $attr = [ 
				'class' => 'text_field_value ' . $this->unique_class,
				'style' => '' 
			];

            $attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['specific_product_data_text_text_size'] ) .';';
            $attr['style'] .= 'color: '. $this->args['specific_product_data_text_color'] . ';';
            $attr['style'] .= 'margin: 0 5px;';
             
            return $attr;

        }

        // Image Field Parent
        public function wrapper_attr_parent_img_field() {

            $attr = [ 
				'class' => 'parent_img_field ' . $this->unique_class,
				'style' => '' 
			];

            // Class Attr
            $attr['class'] .= 'iravada-royal-products-specific-data';

            // Style Attr  
            $attr['style'] .= 'margin: '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_top'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_right'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_bottom'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_left'] ) .';';
            $attr['style'] .= 'max-width: '. fusion_library()->sanitize->get_value_with_unit( $this->args['specific_product_data_img_max_width'] )  .';';
            $attr['style'] .= 'z-index: 100;';
            
            if( $this->args['specific_product_data_position_absolute'] == 'yes' ) {
                $attr['style'] .= 'position: absolute;';
            }

            // General Tab Options
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

            return $attr;

        }

        // Textarea Field Parent
        public function wrapper_attr_parent_textarea_field() {

			$attr = [ 
				'class' => 'parent_textarea_field ' . $this->unique_class,
				'style' => '' 
			];

            // General Tab Options
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

            // Class Attr
            $attr['class'] .= 'iravada-royal-products-specific-data';

            // Style Attr
            $attr['style'] .= 'display: flex;';
            $attr['style'] .= 'flex-direction: row;';
            $attr['style'] .= 'align-items: flex-start;';
            $attr['style'] .= 'margin-top: '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_top'] ) .';';
            $attr['style'] .= 'margin-bottom: '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_bottom'] ) .';';
            $attr['style'] .= 'text-align: '. $this->args['specific_product_data_text_description_align'] .';';

			return $attr;

        }

        // Textarea text 
        public function wrapper_attr_royal_products_specific_data_textarea() {

			$attr = [ 
				'class' => 'royal-products-specific-data-textarea ' . $this->unique_class,
				'style' => '' 
			];

            if( $this->args['specific_product_data_text_description_color'] != '' ) {
                $attr['style'] .= 'color: '. $this->args['specific_product_data_text_description_color'] .';';
            }

            $attr['style'] .= 'font-size: '. $this->args['specific_product_data_description_size'] .';';

            return $attr;

        }

        // Image Main Parent Style
        public function wrapper_attr_royal_custom_data_img() {

			$attr = [ 
				'class' => 'royal-custom-data-img ' . $this->unique_class,
				'style' => '' 
			];

            $attr['style'] .= 'width: 100%;';

            if( $this->args['royal_custom_data_alignment'] == 'right' ) {
                $attr['style'] .= 'display: flex;';
                $attr['style'] .= 'justify-content: flex-start;';
            }

            if( $this->args['royal_custom_data_alignment'] == 'center' ) {
                $attr['style'] .= 'display: flex;';
                $attr['style'] .= 'justify-content: center;';
            }

            if( $this->args['royal_custom_data_alignment'] == 'left' ) {
                $attr['style'] .= 'display: flex;';
                $attr['style'] .= 'justify-content: flex-end;';
            }

            $attr['style'] .= 'z-index: 70;';

            return $attr;

        }

	}
	new iravada_products_specific();
}

function iravada_products_specific_data() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_products_specific', 
            [
                'name'            => __( 'Royal Custom Field', 'royal' ),
                'shortcode'       => 'iravada_products_specific',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
                'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

                    // Element Visibility
                    [ 
                        'type' => 'checkbox_button_set', 
                        'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
                        'param_name' => 'hide_on_mobile', 
                        'value' => fusion_builder_visibility_options( 'full' ), 
                        'default' => fusion_builder_default_visibility( 'array' ), 
                        'description' => esc_attr__( 
                            'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
                            'fusion-builder' ),
                        'group' => esc_attr__( 'General', 'fusion-builder' )
                    ], 

                    // Css Class Field
                    [ 
                        'type' => 'textfield', 
                        'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
                        'param_name' => 'class', 
                        'value' => '', 
                        'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
                        'group' => esc_attr__( 'General', 'fusion-builder' )
                    ], 

                    // Css ID Field
                    [ 
                        'type' => 'textfield', 
                        'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
                        'param_name' => 'id', 
                        'value' => '', 
                        'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
                        'group' => esc_attr__( 'General', 'fusion-builder' ) 
                    ],

                    // Start Design Tab
                    [
						'type'        => 'select',
                        'heading'      => __( 'Select Specific Data', 'royal' ),
                        'description'  => __( 'Select Own Specific For Display In Single Product Page.', 'royal' ),
                        'param_name'   => 'royal_products_specific',
                        'value'        => [

                            //Default Item
                            'select_item'  => 'لطفا یک مورد را انتخاب کنید',

                            // Text Fields
                            'text_field_one'  => __( 'Text Field 1', 'royal' ),
                            'text_field_two'  => __( 'Text Field 2', 'royal' ),
                            'text_field_three'  => __( 'Text Field 3', 'royal' ),
                            'text_field_four'  => __( 'Text Field 4', 'royal' ),
                            'text_field_five'  => __( 'Text Field 5', 'royal' ),
                            'text_field_six'  => __( 'Text Field 6', 'royal' ),
                            'text_field_seven'  => __( 'Text Field 7', 'royal' ),
                            'text_field_eight'  => __( 'Text Field 8', 'royal' ),
                            
                            // Image Fields
                            'img_field_one'  => __( 'Image Field 1', 'royal' ),
                            'img_field_two'  => __( 'Image Field 2', 'royal' ),
                            'img_field_three'  => __( 'Image Field 3', 'royal' ),
                            'img_field_four'  => __( 'Image Field 4', 'royal' ),
                            'img_field_five'  => __( 'Image Field 5', 'royal' ),

                            // Textarea
                            'textarea_field_one'  =>  __( 'Textarea Field 1', 'royal' ),
                            'textarea_field_two'  =>  __( 'Textarea Field 2', 'royal' ),
                            'textarea_field_three'  =>  __( 'Textarea Field 3', 'royal' ),
                        ],
                        'default'   => 'select_item',
                        'group' => esc_attr__( 'Design', 'fusion-builder' )
					],
                    [
						'type'        => 'iconpicker',
						'heading'     => __( 'Select Icon', 'royal' ),
						'description' => __( 'Select Any Icon For Specific Products Data.', 'royal' ),
						'param_name'  => 'specific_product_data_icon',
						'value'       => '',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                        ],
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [ 
						'type' 			=> 'textfield', 
						'heading' 		=> __( 'Set Icon Size', 'royal' ), 
						'description' 	=> __( 'Set Specific Product Icon Size.', 'royal' ),
						'param_name' 	=> 'specific_product_data_icon_font_size', 
						'value' 		=> '', 
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                        ],
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					], 
                    [
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Icon Font Color', 'royal' ),
						'description' => __( 'Controls the color of the icon, ex: #000.', 'royal' ),
						'param_name'  => 'specific_product_data_icon_color',
						'value'       => '',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [
						'type'        => 'radio_button_set',
						'heading'     => __( 'Icon Alignment', 'royal' ),
						'description' => __( "Select the icon alignment.", 'royal' ),
						'param_name'  => 'specific_product_data_icon_alignment',
						'default'     => 'right',
						'value'       => [
							'left'   => esc_attr__( 'Left', 'fusion-builder' ),
							'right'  => esc_attr__( 'Right', 'fusion-builder' ),
						],
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                        ],
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [ 
						'type' 			=> 'textfield', 
						'heading' 		=> __( 'Set Title Size', 'royal' ), 
						'description' 	=> __( 'Set Specific Product Text Title Size.', 'royal' ),
						'param_name' 	=> 'specific_product_data_text_title_size', 
						'value' 		=> '', 
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],  
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					], 
                    [
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Text Title Font Color', 'royal' ),
						'description' => __( 'Controls the color of the icon, ex: #000.', 'royal' ),
						'param_name'  => 'specific_product_data_text_title_color',
						'value'       => '',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Select Text Background', 'royal' ),
						'description' => __( 'This field allows you to select the color with rgba value For Text Background.', 'royal' ),
						'param_name'  => 'text_field_background_color',
						'value'       => '',
						'group' 	  => esc_html__( 'Design', 'fusion-builder' ),
						'dependency'       => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
						],
						'default'	=> '',
					],
					[
                        'type'             => 'dimension',
                        'remove_from_atts' => true,
                        'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
                        'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
                        'param_name'       => 'border_sizes',
                        'value'            => [
                            'border_top'    => '',
                            'border_right'  => '',
                            'border_bottom' => '',
                            'border_left'   => '',
                            ],
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],  
                        'group'            => esc_attr__( 'Design', 'fusion-builder' ),
                    ],
                    [ 
                        'type'        => 'colorpickeralpha',
                        'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
                        'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
                        'param_name'  => 'royal_acf_border_color',
                        'value'       => '',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],  
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],
					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
						'description' => esc_attr__( 'Set Field Border Radius.', 'royal' ),
						'param_name'  => 'text_field_border_radius',
						'value'       => [
							'border_radius_top_left'     => '',
							'border_radius_top_right'    => '',
							'border_radius_bottom_right' => '',
							'border_radius_bottom_left'  => '',
						],
						'dependency'       => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
						],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
					                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                        'param_name'  => 'iravada_description_text_padding',
                        'value'       => [
                                'padding_top'    => '',
                                'padding_right'  => '',
                                'padding_bottom' => '',
                                'padding_left'   => '',
                        ],
                        'dependency'       => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
						],
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
                    ],
					'fusion_margin_placeholder'    => [
						'param_name' => 'margin',
						'value'      => [
							'margin_top'    => '',
							'margin_right'  => '',
							'margin_bottom' => '',
							'margin_left'   => '',
						],
						'group'      => esc_attr__( 'Design', 'fusion-builder' ),
					],
                    [ 
                        'type' => 'radio_button_set', 
                        'heading' => esc_attr__( 'Alignment', 'fusion-builder' ),
                        'description' => __( 'Choose to align the Text, Image Field left, right or center.', 'royal' ),
                        'param_name' => 'royal_custom_data_alignment', 
                        'value' => [ 
                            'left' => esc_attr__( 'Left', 'fusion-builder' ), 
                            'center' => esc_attr__( 'Center', 'fusion-builder' ), 
                            'right' => esc_attr__( 'Right', 'fusion-builder' ) 
                        ], 
                        'dependency'       => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
						],
                        'default' => 'right', 
                        'group' => esc_attr__( 'Design', 'fusion-builder' ) 
                    ], 
                    [
						'type'        => 'radio_button_set',
						'heading'     => __( 'Text Title Bold', 'royal' ),
						'description' => __( 'If You Need Bold Title, Set Option to Yes.', 'royal' ),
						'param_name'  => 'specific_product_data_text_title_bold',
						'value'       => [
                            'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
                            'no'  => esc_attr__( 'No', 'fusion-builder' ),
						],
                        'default'   => 'no',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [ 
						'type' 			=> 'textfield', 
						'heading' 		=> __( 'Set Text Size', 'royal' ), 
						'description' 	=> __( 'Set Specific Product Text Value Size.', 'royal' ),
						'param_name' 	=> 'specific_product_data_text_text_size', 
						'value' 		=> '', 
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],  
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					], 
                    [
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Text Font Color', 'royal' ),
						'description' => __( 'Controls the color of the icon, ex: #000.', 'royal' ),
						'param_name'  => 'specific_product_data_text_color',
						'value'       => '',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [ 
						'type' 			=> 'textfield', 
						'heading' 		=> __( 'Set Description Size', 'royal' ), 
						'description' 	=> __( 'Set Specific Product Description Size.', 'royal' ),
						'param_name' 	=> 'specific_product_data_description_size', 
						'value' 		=> '', 
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_six',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_seven',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_eight',
                                'operator' => '!=',
                            ],
                        ],  
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					], 
                    [
						'type'        => 'radio_button_set',
						'heading'     => esc_attr__( 'Position Absolute', 'fusion-builder' ),
						'description' => __( 'If You Need Position Absolute, Set This Option On Yes.', 'royal' ),
						'param_name'  => 'specific_product_data_position_absolute',
						'value'       => [
                            'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
                            'no'  => esc_attr__( 'No', 'fusion-builder' ),
						],
                        'default'   => 'no',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [ 
						'type' 			=> 'textfield', 
						'heading' 		=> __( 'Set Image Max Width', 'royal' ), 
						'description' 	=> __( 'Set Specific Product Data Image Field Max Width Size.', 'royal' ),
						'param_name' 	=> 'specific_product_data_img_max_width', 
						'value' 		=> '', 
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_five',
                                'operator' => '!=',
                            ],
                                                        [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_six',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_seven',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_eight',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'textarea_field_three',
                                'operator' => '!=',
                            ],
                        ],
                        'group'       => esc_html__( 'Design', 'fusion-builder' ),
					], 
                    [
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Description Font Color', 'royal' ),
						'description' => __( 'Controls the color of the Description, ex: #000.', 'royal' ),
						'param_name'  => 'specific_product_data_text_description_color',
						'value'       => '',
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_six',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_seven',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_eight',
                                'operator' => '!=',
                            ],
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
					],
                    [ 
                        'type' => 'radio_button_set', 
                        'heading' => esc_attr__( 'Alignment', 'fusion-builder' ),
                        'description' => esc_attr__( 'Choose to align the heading left, right or center.', 'fusion-builder' ),
                        'param_name' => 'specific_product_data_text_description_align', 
                        'value' => [ 
                            'left' => esc_attr__( 'Left', 'fusion-builder' ), 
                            'center' => esc_attr__( 'Center', 'fusion-builder' ), 
                            'right' => esc_attr__( 'Right', 'fusion-builder' ),
                            'justify' => esc_attr__( 'justify', 'fusion-builder' ) 
                        ], 
                        'default' => 'right', 
                        'dependency'  => [
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'select_item',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'img_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_one',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_two',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_three',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_four',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_five',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_six',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_seven',
                                'operator' => '!=',
                            ],
                            [
                                'element'  => 'royal_products_specific',
                                'value'    => 'text_field_eight',
                                'operator' => '!=',
                            ],
                        ],  
                        'group' => esc_attr__( 'Design', 'fusion-builder' ) 
                    ], 
                    // End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_products_specific_data' );
