<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_soon_post_card' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_soon_post_card
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_fusion_soon_product', [ $this, 'wrapper_attr_product_shop_soon_lable' ] );
			
			add_shortcode( 'iravada_soon_post_card', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'								            => '',
				'id'								            => '',
                'hide_on_mobile'  					            => fusion_builder_default_visibility( 'array' ), 
                'iravada_soon_product_shop_lable'               => __( 'Soon....' , 'royal' ),
                'iravada_soon_product_shop_lable_background'    => '#48cab2',
                'iravada_soon_product_shop_lable_text_color'    => '#fff',
                'padding_top'                                   => '5px',
                'padding_right'                                 => '10px',
                'padding_bottom'                                => '5px',
                'padding_left'                                  => '10px',
                'border_radius_top_left'                        => '0px',
                'border_radius_top_right'                       => '50px',
                'border_radius_bottom_right'                    => '50px',
                'border_radius_bottom_left'                     => '50px',
                'iravada_soon_product_lable_font_size'          => '14px',
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_soon_post_card' );
			
			$this->args = $defaults;
			
			ob_start();

                global $product;
                if ( get_post_meta( get_the_ID(), '_sj_soon_product', $single = true ) == 'yes' && $this->args['iravada_soon_product_shop_lable'] ) {
                    echo '<span '. FusionBuilder::attributes( 'fusion_soon_product' ) .'>' . $this->args['iravada_soon_product_shop_lable'] . '</span>';
                }

			return ob_get_clean();

			

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_product_shop_soon_lable() {
			$attr = [ 
				'class' => 'fusion_soon_product ' . $this->unique_class,
				'style' => '' 
			];

            // PHP Code For Handle Lable Background
            if( $this->args['iravada_soon_product_shop_lable_background'] ) {
                $attr['style'] .= 'background:' . $this->args['iravada_soon_product_shop_lable_background'] . ';';
            }

            // PHP Code For Handle Lable Font Color
            if( $this->args['iravada_soon_product_shop_lable_text_color'] ) {
                $attr['style'] .= 'color:' . $this->args['iravada_soon_product_shop_lable_text_color'] . ';';
            }

            // PHP Code For Handle Lable Padding
            $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 

            // PHP Code For Handle Lable Font Color
            if( $this->args['iravada_soon_product_lable_font_size'] ) {
                $attr['style'] .= 'font-size:' . $this->args['iravada_soon_product_lable_font_size'] . ';';
            }

            // PHP Code For Handle Lable Border Radius
            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
            
			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}
	}
	new iravada_soon_post_card();
}

function iravada_soon_product_shop_lable_func() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_soon_post_card', 
            [
                'name'            => __( 'Royal Soon Product Shop Label', 'royal' ),
                'shortcode'       => 'iravada_soon_post_card',
                'icon'            => 'iravada_elements_icon',
				'templates'       => [ 'content', 'post_cards'],
                'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

                        // Soon Product Description Box Title
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_attr__( 'Title', 'fusion-builder' ),
                            'description' => esc_attr__( 'Insert the title text.', 'fusion-builder' ),
                            'param_name'  => 'iravada_soon_product_shop_lable',
                            'value'       => '',
                            'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],

						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

                    // Start Design Tab

                    // Iravada Soon Product Background Color
                    [
                        'type'        => 'colorpickeralpha',
                        'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
                        'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
                        'param_name'  => 'iravada_soon_product_shop_lable_background',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Iravada Soon Product Lable Text Color
                    [
                        'type'        => 'colorpickeralpha',
                        'heading'     => esc_attr__( 'Font Color', 'fusion-builder' ),
                        'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #fff.', 'fusion-builder' ),
                        'param_name'  => 'iravada_soon_product_shop_lable_text_color',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Css ID Field Subtitle
					[ 
						'type' => 'textfield', 
						'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
                        'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 14px.', 'fusion-builder' ),
                        'param_name' => 'iravada_soon_product_lable_font_size', 
                        'value' => '', 
						'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						],

                    // iravada Soon Product Shop Lable Padding
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                        'param_name'  => 'iravada_soon_product_shop_lable_padding',
                        'value'       => [
                            'padding_top'    => '',
                            'padding_right'  => '',
                            'padding_bottom' => '',
                            'padding_left'   => '',
                        ],
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // iravada Soon Product Shop Lable Border Radius
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                        'param_name'  => 'iravada_soon_product_shop_lable_border_radius',
                        'value'       => [
                            'border_radius_top_left'     => '',
                            'border_radius_top_right'    => '',
                            'border_radius_bottom_right' => '',
                            'border_radius_bottom_left'  => '',
                        ],
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_soon_product_shop_lable_func' );
