<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */

if ( ! class_exists( 'iravada_soon_product' ) ) {

    /**
     * Shortcode class.
     *
     * @since 1.0
     */
    class iravada_soon_product
    {

        /**
         * An array of the shortcode arguments.
         *
         * @access protected
         * @since 1.0
         * @var array
         */
        protected $args;

        protected $unique_class;

        public function __construct() {
            add_filter( 'fusion_attr_soon_text', [ $this, 'wrapper_attr_soon_text' ] );
            add_filter( 'fusion_attr_soon_title', [ $this, 'wrapper_attr_soon_title' ] );
            add_filter( 'fusion_attr_iravada-soon-product-main-box', [ $this, 'wrapper_attr_iravada_soon_product_main_box' ] );
            
            add_shortcode( 'iravada_soon_product', [ $this, 'render' ] );
        }

        /**
         * Gets the default values.
         *
         * @static
         * @access public
         * @since 2.0.0
         * @return array
         */
        public static function get_element_defaults() {
            global $fusion_settings;
            
            return [ 
                'class'						                            => '',
                'id'						                            => '',
                'hide_on_mobile'  			                            => fusion_builder_default_visibility( 'array' ), 
                'iravada_soon_product_box_title'                        => __( 'Soon....' , 'royal' ),
                'iravada_description_box_text'                          => __( 'This product will be available in the store. You can enter your email in the form below to be notified once it is available.' , 'royal' ),
                'iravada_soon_product_success_register_email_notice'    => __( 'We will notify you as soon as this product is available.' , 'royal' ),
                'iravada_soon_product_Error_register_email_notice'      => __( 'There was a problem sending your request, please try again.' , 'royal' ),
                'iravada_soon_product_box_title_color'                  => '#747474',
                'iravada_description_box_text_color'                    => '#747474',
                'iravada_description_box_border_color'                  => '#45cbda',
                'iravada_description_box_background_color'              => '#f1feff',
                'bordersize'                                            => '1',
                'padding_top'                                           => '10px',
                'padding_right'                                         => '15px',
                'padding_bottom'                                        => '10px',
                'padding_left'                                          => '15px',
                'border_radius_top_left'                                => '5px',
                'border_radius_top_right'                               => '5px',
                'border_radius_bottom_right'                            => '5px',
                'border_radius_bottom_left'                             => '5px',
                'iravada_soon_product_description_font_size'            => '12px',
            ];
        }

        /**
         * Render the shortcode
         *
         * @access public
         * @since 1.0
         * @param  array  $args    Shortcode parameters.
         * @param  string $content Content between shortcode.
         * @return string          HTML output.
         */
        public function render( $args, $content = '' ) {
            $fusion_settings = fusion_get_fusion_settings();
            
            $defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_soon_product' );
            
            $this->args = $defaults;
            
            ob_start();

                global $product;

                //show soon product avalible form and message

                if (get_post_meta( get_the_ID(), '_sj_soon_product', $single = true )=='yes') {

                    // Get Text Field Value For Soon Text
                    $iravada_description_box_title    = $this->args['iravada_soon_product_box_title'];
                    $iravada_description_box_text     = $this->args['iravada_description_box_text'];

                    ?>
                    <div <?php echo FusionBuilder::attributes( 'iravada-soon-product-main-box' ) ?> >
                        <div <?php echo FusionBuilder::attributes( 'post-content sj_soon_avalible_product soon' ) ?> >
                            <i class="far fa-smile"></i>
                            <h3 <?php echo FusionBuilder::attributes( 'soon_title' ) ?> ><?php echo $iravada_description_box_title ?></h3>
                            <p <?php echo FusionBuilder::attributes( 'soon_text' ) ?> ><?php echo $iravada_description_box_text ?></p>
                        </div>
                        
                        <div <?php echo FusionBuilder::attributes( 'post-content sj_soon_avalible_product-form' ) ?> >
                                <h4 style="margin-bottom: 5px;margin-right: 5px;">وقتی موجود شد به من اطلاع بده</h4>
                            <div class="sj-footer">
                                <form action="" method="post">
                                <input id="sj-email" class="sj-input-email" name="sj-email" type="email" value="" placeholder="ایمیل خود را وارد نمایید."/>
                                        <button class="sj-email-submit" type="submit" name="sj-send-email">
                                        <i class="fa fa-bell-o fa-lg" aria-hidden="true"></i>
                                        به من اطـلاع بده!
                                        </button>

                                </form>
                            </div>
                        </div>
                    </div>
                        <?php
                }
                    
                if (isset($_POST['sj-send-email']) AND isset($_POST['sj-email']) AND $_POST['sj-email']!="") {

                        global $product;

                        if( !class_exists('Royal_Soon_Product_Functions') ) {
                            require_once( get_stylesheet_directory() . '/includes/soon-product/admin/functions.php' );

                            $royal_soon_product_functions = new Royal_Soon_Product_Functions();
                        }

                        if ( $royal_soon_product_functions->sjsp_save_request( get_the_ID(), sanitize_email( $_POST['sj-email'] ) ) ) {

                            // Get display of email registration results
                            $iravada_success_email_register_notice    = $this->args['iravada_soon_product_success_register_email_notice'];
                            $iravada_error_email_register_notice      = $this->args['iravada_soon_product_error_register_email_notice'];

                            ?>
                                <div <?php echo FusionBuilder::attributes( 'post-content sj_soon_avalible_product-form display_success_register_email' ) ?> >
                                    <h4 style="text-align: center; color: #15b200;"><?php echo $iravada_success_email_register_notice; ?></h4>
                                </div>
                            <?php
                        }else
                        {
                            ?>
                                <div <?php echo FusionBuilder::attributes( 'post-content sj_soon_avalible_product-form display_error_register_email' ) ?> >
                                    <h4 style="color: red; text-align: center;"><?php echo $iravada_error_email_register_notice; ?></h4>
                                </div>
                            <?php
                        }
                }

            return ob_get_clean();

        }
        
        /**
         * Builds the attributes array.
         *
         * @access public
         * @since 1.0
         * @return array
         * 
         */

        public function wrapper_attr_iravada_soon_product_main_box() {
            $attr = [ 
                'class' => 'iravada-soon-product-main-box ' . $this->unique_class,
                'style' => '' 
            ];

            // PHP Code For Handle class
            if ( $this->args['class'] ) {
                $attr['class'] .= '' . $this->args['class'];
            }
            
            // PHP Code For Handle id
            if ( $this->args['id'] ) {
                $attr['id'] = $this->args['id'];
            }
            
            // PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
            return $attr;
        }

        public function wrapper_attr_soon_text() {
            $attr = [ 
                'class' => 'soon_text' . $this->unique_class,
                'style' => '' 
            ];

            // PHP Code For Handle Description Box Border Size
            if( $this->args['bordersize'] ) {
                $attr['style'] .= 'border:' . fusion_library()->sanitize->get_value_with_unit( $this->args['bordersize'] ) . ' solid '. $this->args['iravada_description_box_border_color'] .' !important;'; 
            }
            
            // PHP Code For Handle Description Box Text Color
            if( $this->args['iravada_description_box_text_color'] ) {
                $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_description_box_text_color'] ) . ' !important;'; 
            }
            
            // PHP Code For Handle Description Box Border Radius
            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
            
            // PHP Code For Handle Description Box Background Color
            if( $this->args['iravada_description_box_background_color'] ) {
                $attr['style'] .= 'background:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_description_box_background_color'] ) . ' !important;'; 
            }

            // PHP Code For Handle Description Text Font Size
            if( $this->args['iravada_soon_product_description_font_size'] ) {
                $attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_soon_product_description_font_size'] ) . ' !important;'; 
            }

            // PHP Code For Handle Description Box Padding
            $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 

            return $attr;
        }

        public function wrapper_attr_soon_title() {
            $attr = [ 
                'class' => 'soon_title' . $this->unique_class,
                'style' => '' 
            ];

            // PHP Code For Handle Description Box Title Color
            if( $this->args['iravada_soon_product_box_title_color'] ) {
                $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_soon_product_box_title_color'] ) . ' !important;'; 
            }
            
            return $attr;
        }

    }

}
new iravada_soon_product();

function iravada_soon_product_element_func() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
            'iravada_soon_product', 
            [
                'name'            => __( 'Royal Soon Product Message', 'royal' ),
                'shortcode'       => 'iravada_soon_product',
                'icon'            => 'iravada_elements_icon',
                'templates'    	  => [ 'content' ],
                'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

                    // Start General Tab

                        // Soon Product Description Box Title
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_attr__( 'Title', 'fusion-builder' ),
                            'description' => esc_attr__( 'Insert the title text.', 'fusion-builder' ),
                            'param_name'  => 'iravada_soon_product_box_title',
                            'value'       => '',
                            'default'     => __( 'Soon....' , 'royal' ),
                            'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],

                        // Soon Product Description Box Text
                        [
                            'type'        => 'textarea',
                            'heading'     => esc_attr__( 'Content', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter some content for this text block.', 'fusion-builder' ),
                            'param_name'  => 'iravada_description_box_text',
                            'value'       => '',
                            'default'     => __( 'This product will be available in the store. You can enter your email in the form below to be notified once it is available.' , 'royal' ),
                            'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],

                        // Soon Product Success Notice Register Email
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_attr__( 'Success Message', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter a message to be shown when the form has been successfully submitted.', 'fusion-builder' ),
                            'param_name'  => 'iravada_soon_product_success_register_email_notice',
                            'value'       => '',
                            'default'     => __( 'We will notify you as soon as this product is available.' , 'royal' ),
                            'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],

                        // Soon Product Error Notice Register Email
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_attr__( 'Error Message', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter a message to be shown when a problem has been encountered while submitting the form.', 'fusion-builder' ),
                            'param_name'  => 'iravada_soon_product_Error_register_email_notice',
                            'value'       => '',
                            'default'     => __( 'There was a problem sending your request, please try again.' , 'royal' ),
                            'group'       => esc_attr__( 'General', 'fusion-builder' )
                        ],

                        // SP Element Visibility
                        [ 
                            'type' => 'checkbox_button_set', 
                            'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
                            'param_name' => 'hide_on_mobile', 
                            'value' => fusion_builder_visibility_options( 'full' ), 
                            'default' => fusion_builder_default_visibility( 'array' ), 
                            'description' => esc_attr__( 
                                'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
                                'fusion-builder' ),
                            'group' => esc_attr__( 'General', 'fusion-builder' )
                        ], 

                        // Css Class Field SP
                        [ 
                            'type' => 'textfield', 
                            'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
                            'param_name' => 'class', 
                            'value' => '', 
                            'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
                            'group' => esc_attr__( 'General', 'fusion-builder' )
                        ], 

                        // Css ID Field SP
                        [ 
                            'type' => 'textfield', 
                            'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
                            'param_name' => 'id', 
                            'value' => '', 
                            'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
                            'group' => esc_attr__( 'General', 'fusion-builder' ) 
                        ],

                    // End General Tab

                    /*
                    *
                    *
                    * 
                    *	
                    *
                    */

                    // Start Design Tab

                    // Soon Product Box Title Color
                    [ 
                        'type'        => 'colorpickeralpha',
                        'heading'     => __( 'Title Color', 'royal' ),
                        'description' => __( 'Use this field to control the color of the box title soon. Default: #747474', 'royal' ),
                        'param_name'  => 'iravada_soon_product_box_title_color',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Box Text Color
                    [ 
                        'type'        => 'colorpickeralpha',
                        'heading'     => __( 'Color text Description box', 'royal' ),
                        'description' => __( 'Using this field you can control the color of the description text. Default: #747474', 'royal' ),
                        'param_name'  => 'iravada_description_box_text_color',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Description Font Size
                    [
                        'type'        => 'textfield',
                        'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
                        'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 12px.', 'fusion-builder' ),
                        'param_name'  => 'iravada_soon_product_description_font_size',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Description Box Background Color
                    [ 
                        'type'        => 'colorpickeralpha',
                        'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
                        'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
                        'param_name'  => 'iravada_description_box_background_color',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Description Box Padding
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                        'param_name'  => 'padding',
                        'value'       => [
                                'padding_top'    => '',
                                'padding_right'  => '',
                                'padding_bottom' => '',
                                'padding_left'   => '',
                        ],
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Description Box Border Size
                    [
                        'type'        => 'range',
                        'heading'     => esc_attr__( 'Border Size', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                        'param_name'  => 'bordersize',
                        'value'       => '1',
                        'min'         => '0',
                        'max'         => '10',
                        'step'        => '1',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Description Box Border Radius
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                        'param_name'  => 'iravada_description_text_border_radius',
                        'value'       => [
                            'border_radius_top_left'     => '',
                            'border_radius_top_right'    => '',
                            'border_radius_bottom_right' => '',
                            'border_radius_bottom_left'  => '',
                        ],
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],

                    // Soon Product Description Box Border Color
                    [ 
                        'type'        => 'colorpickeralpha',
                        'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
                        'description' => esc_attr__( 'The color around the box line controls the description', 'fusion-builder' ),
                        'param_name'  => 'iravada_description_box_border_color',
                        'value'       => '',
                        'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                    ],
                    
                    // End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_soon_product_element_func' );
