<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_royal_stories' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_royal_stories
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_stories_element', [ $this, 'wrapper_stories_element' ] );
			add_shortcode( 'iravada_royal_stories', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

                'irava_stories'     		    => '',
                'padding_top'                   => '0px',
                'padding_right'                 => '0px',
                'padding_bottom'                => '0px',
                'padding_left'                  => '0px',
				'margin_top'                    => '0px',
				'margin_right'                  => '0px',
				'margin_bottom'                 => '0px',
				'margin_left'                   => '0px',
				'class'			                => '',
				'id'			                => '',
                'hide_on_mobile'                => fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			
			if( class_exists('RoyalStoryMnage') ) {

				$fusion_settings = fusion_get_fusion_settings();
				$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_royal_stories' );
				$this->args = $defaults;
	
				ob_start();
	
				?>
				<div <?php echo FusionBuilder::attributes( 'iravada_stories_element' ); ?>>
					<?php RoyalStoryMnage::royal_element_story($args); ?>
				</div>
				<?php
	
				return ob_get_clean();

			}

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_stories_element() {
			$attr = [ 
				'class' => 'iravada_stories_element ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
			$attr['class'] .= ' ' . $this->args['class'];
			
			// PHP Code For Handle id
			$attr['id'] = $this->args['id'];
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

            // Handle Padding / Margin
            $attr['style'] .= 'padding: '. fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .';';
            $attr['style'] .= 'margin: '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_top'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_right'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_bottom'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['margin_left'] ) .';';
            
			return $attr;
		}
	}
	new iravada_royal_stories();
}

function iravada_stories_element() {

	$list_storeis = [];
	
	if( class_exists('RoyalStoryMnage') ) {

		$allStories =  RoyalStoryMnage::get_royal_highlights();
		if(! empty($allStories) ){
			foreach ($allStories as $story){
				if ($story->status == 'deactive' && ! RoyalStoryMnage::now_to_date_active($story->deactive_from)) continue;
				
				$list_storeis[$story->id] = $story->title;
			}
		}else{
				$list_storeis[0] = __('None', 'royal');
		}

	}
	
    fusion_builder_map(
        fusion_builder_frontend_data( 
			'iravada_royal_stories', 
            [
                'name'            => __( 'royal story' , 'royal' ),
                'shortcode'       => 'iravada_royal_stories',
                'icon'            => 'iravada_elements_icon stories',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab
					
				    [
						'type'        => 'select',
						'heading'     => __( 'Story type', 'royal' ),
						'description' => __( 'Select the type of story. "All" displays all highlights. "Optional" is based on your choice. "Dynamic" is used in the product category page and makes the sub-categories a dynamic story.', 'royal' ),
						'param_name'  => 'story_element_type',
						'value'       => [
							'all'        	  => __( 'All', 'royal' ),
							'selective'       => __( 'Selective', 'royal' ),
							'dynamic'      => __( 'Dynamic', 'royal' ),
						],
						'default'     => 'all',
						'group'       => esc_html__( 'General', 'fusion-builder' )
					],
					
					// Start Dynamic Options
					
					[
					    'type'        => 'range',
						'heading'     => __( 'Number of highlights', 'royal' ),
						'description' => __( 'Choose how many highlights to display. 0 means all.', 'royal' ),
						'param_name'  => 'dynamic_highlight_limit',
						'value'       => '0',
						'min'         => '0',
						'max'         => '20',
						'step'        => '1',
						'group'       => esc_html__( 'General', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'dynamic',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					
					[
					    'type'        => 'range',
						'heading'     => __( 'Show Story Time', 'royal' ),
						'description' => __( 'Set Time Show Stories In Highlight. second.', 'royal' ),
						'param_name'  => 'dynamic_highlight_story_time',
						'value'       => '8',
						'min'         => '1',
						'max'         => '20',
						'step'        => '1',
						'group'       => esc_html__( 'General', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'dynamic',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					
					[
					    'type'        => 'range',
						'heading'     => __( 'Limit Show Story', 'royal' ),
						'description' => __( 'Set Limit Show Stories In Highlight.', 'royal' ),
						'param_name'  => 'dynamic_highlight_story_limit',
						'value'       => '5',
						'min'         => '1',
						'max'         => '20',
						'step'        => '1',
						'group'       => esc_html__( 'General', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'dynamic',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Open New Tab Links', 'royal' ),
						'description' => __( 'Set to "Yes" to enable Open New Tab Links.', 'royal' ),
						'param_name'  => 'dynamic_highlight_open_links',
						'default'     => '_blank',
						'group'       => esc_html__( 'General', 'fusion-builder' ),
						'value'       => [
							'_blank' => __( 'Yes', 'fusion-builder' ),
							'_self'  => __( 'No', 'fusion-builder' ),
						],
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'dynamic',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Image display size', 'royal' ),
						'description' => __( 'Set image display size in stories. Cover mode is only used for photos.', 'royal' ),
						'param_name'  => 'dynamic_highlight_display_size',
						'default'     => 'contain',
						'group'       => esc_html__( 'General', 'fusion-builder' ),
						'value'       => [
							'contain' => __( 'contain', 'fusion-builder' ),
							'cover'  => __( 'cover', 'fusion-builder' ),
						],
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'dynamic',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					
					[
						'type'        => 'select',
						'heading'     => __('OrderBy', 'royal' ),
						'description' => __( 'Choose the order in which the products will be stories.', 'royal' ),
						'param_name'  => 'dynamic_highlight_order',
						'value'       => [
							'latest'     => __( 'latest', 'royal' ),
							'rand'       => __( 'Random', 'royal' ),
							'popularity' => __( 'Popularity', 'royal' ),
							'price'      => __( 'Price', 'royal' ),
							'price-desc' => __( 'Price Desc', 'royal' )
						],
						'default'     => 'latest',
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'dynamic',
								'operator' => '==',
							],
						],
						'callback'    => [],
						'group'       => esc_html__( 'General', 'fusion-builder' )
					],
					
					// End Dynamic Options
                    
                    [
					    'type'        => 'multiple_select',
						'heading'     => __( 'select', 'royal' ),
						'description' => __( 'Select From Stories', 'royal' ),
						'param_name'  => 'stories_selected',
						'value'       => $list_storeis,
						'default'     => '',
						'group'       => esc_html__( 'General', 'fusion-builder' ),
						'dependency'  => [
							[
								'element'  => 'story_element_type',
								'value'    => 'selective',
								'operator' => '==',
							],
						],
						'callback'    => [],
					],
					
					[ 
						'type' => 'textfield', 
						'heading' => __( 'CSS Class', 'fusion-builder' ), 
						'param_name' => 'class', 
						'value' => '', 
						'description' => __( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
						'group' => __( 'General', 'fusion-builder' )
					], 

					[ 
						'type' => 'textfield', 
						'heading' => __( 'CSS ID', 'fusion-builder' ), 
						'param_name' => 'id', 
						'value' => '', 
						'description' => __( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
						'group' => __( 'General', 'fusion-builder' ) 
					],
					
					// End General Tab
						
					/* Start Design Tab */
					
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'From: ', 'royal' ),
						'description' => __( 'Start Gradiant color', 'royal' ),
						'param_name'  => 'border_gradiant_from',
						'value'       => '#E03d96',
						'group'       => esc_html__( 'Design', 'fusion-builder' )
					],
					
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'To: ', 'royal' ),
						'description' => __( 'End Gradiant color', 'royal' ),
						'param_name'  => 'border_gradiant_to',
						'value'       => '#7D4C9E',
						'group'       => esc_html__( 'Design', 'fusion-builder' )
					],
					
					[
						'type'        => 'range',
						'heading'     => __( 'Angle', 'royal' ),
						'description' => __( 'Set the Angle Gradient.', 'royal' ),
						'param_name'  => 'border_gradiant_angle',
						'value'       => '45',
						'min'         => '0',
						'max'         => '180',
						'step'        => '1',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'callback'    => [],
					],
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                        'param_name'  => 'cat_filter_item_padding',
                        'value'       => [
                                'padding_top'    => '',
                                'padding_right'  => '',
                                'padding_bottom' => '',
                                'padding_left'   => '',
                        ],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'callback'    => [],
                    ],
        			[
        				'type'        => 'dimension',
        				'heading'     => esc_attr__( 'Margin', 'fusion-builder' ),
        				'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
        				'param_name' => 'margin',
        				'value'      => [
        					'margin_top'     => '',
        					'margin_right'   => '',
        					'margin_bottom'  => '',
        					'margin_left'    => '',
        				],
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'callback'    => [],
        			],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __('Title Color Before Click', 'royal'),
						'description' => __( 'Choosing the color of the stories text before clicking.', 'royal' ),
						'param_name'  => 'title_color_before_click',
						'value'       => '#222222',
						'group'       => esc_html__( 'Design', 'fusion-builder' )
					],
					
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Title Color After Click', 'royal' ),
						'description' => __( 'Choosing the color of the story text after clicking.', 'royal' ),
						'param_name'  => 'title_color_after_click',
						'value'       => '#666666',
						'group'       => esc_html__( 'Design', 'fusion-builder' )
					],
					
					[
						'type'        => 'range',
						'heading'     => __( 'Title Size (px)', 'royal' ),
						'description' => __( 'Choose the font size of the title. In pixels.', 'royal' ),
						'param_name'  => 'title_size',
						'value'       => '12',
						'min'         => '8',
						'max'         => '22',
						'step'        => '1',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'callback'    => [],
					],
					
					[
						'type'        => 'range',
						'heading'     => __( 'Border Weight (px)', 'royal' ),
						'description' => __( 'Selection of border weight. In pixels.', 'royal' ),
						'param_name'  => 'border_weight',
						'value'       => '2',
						'min'         => '0',
						'max'         => '10',
						'step'        => '1',
						'group'       => esc_html__( 'Design', 'fusion-builder' ),
						'callback'    => [],
					],

					/* End Design Tab */
						
                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_stories_element' );