<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_sec_title' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_sec_title
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_capp_sec_title_style', [ $this, 'wrapper_attr_product_subtitle' ] );
			
			add_shortcode( 'iravada_sec_title', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
                'font_size_subtitle_products'       => '12px',
                'content_align_subtitle_products'   => 'right', 
				'iranavada_subtitle_select_tag'		=> 'iravada_default_tag',
				'iranavada_subtitle_font_color'		=> '#c1c1c1',
				'class'								=> '',
				'id'								=> '',
                'hide_on_mobile'  					=> fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_sec_title' );
			
			$this->args = $defaults;
			
			ob_start();

                /* start tshow Field Content in Single page */
                if( 'iravada_default_tag' == $this->args['iranavada_subtitle_select_tag'] ) {
                    echo '<span ' . FusionBuilder::attributes( 'iravada_capp_sec_title_style' ) . '>'. get_post_meta(get_the_ID(), 'iravada_sec_title', true ) .'</span>';
                }
                if( $this->args['iranavada_subtitle_select_tag'] == 'H2' ) {
                    echo '<h2 ' . FusionBuilder::attributes( 'iravada_capp_sec_title_style' ) . '>'. get_post_meta(get_the_ID(), 'iravada_sec_title', true ) .'</h2>';
                }
                if( $this->args['iranavada_subtitle_select_tag'] == 'H3' ) {
                    echo '<h3 ' . FusionBuilder::attributes( 'iravada_capp_sec_title_style' ) . '>'. get_post_meta(get_the_ID(), 'iravada_sec_title', true ) .'</h3>';
                }
                if( $this->args['iranavada_subtitle_select_tag'] == 'H4' ) {
                    echo '<h4 ' . FusionBuilder::attributes( 'iravada_capp_sec_title_style' ) . '>'. get_post_meta(get_the_ID(), 'iravada_sec_title', true ) .'</h4>';
                }
                if( $this->args['iranavada_subtitle_select_tag'] == 'SPAN' ) {
					echo '<span ' . FusionBuilder::attributes( 'iravada_capp_sec_title_style' ) . '>'. get_post_meta(get_the_ID(), 'iravada_sec_title', true ) .'</span>';
                }
                /* end show Field Content in Single page */

			return ob_get_clean();

			

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_product_subtitle() {
			$attr = [ 
				'class' => 'iravada_capp_sec_title_style ' . $this->unique_class,
				'style' => '' 
			];
			
            $attr['style'] .= 'width: 100%;';
            $attr['style'] .= 'text-align: '. $this->args['content_align_subtitle_products'] .';';
			
			// PHP Code For Handle font_size_subtitle_products
			if ( $this->args['font_size_subtitle_products'] ) {
				$attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['font_size_subtitle_products'] ) . ';';
			}

			// PHP Code For Handle iranavada_subtitle_font_color
			if( $this->args['iranavada_subtitle_font_color'] ) {
				$attr['style'] .= 'color:' . $this->args['iranavada_subtitle_font_color'] . ';';
			}

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}

	}
	new iravada_sec_title();
}

function iravada_subtitle_products() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_sec_title', 
            [
                'name'            => __( 'Royal Product Subtitle', 'royal' ),
                'shortcode'       => 'iravada_sec_title',
                'icon'            => 'iravada_elements_icon',
				'templates'    	  => [ 'content', 'post_cards' ],
				'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

					/*
					*
					*
					* 
					*	
					*
					*/

					// Start Design Tab

						// Subtitle Font Size
						[ 
							'type' => 'textfield', 
							'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 12px.', 'fusion-builder' ),
							'param_name' => 'font_size_subtitle_products', 
							'value' => '', 
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						], 

						// Subtitle Html Tag
						[
							'type'        => 'select',
							'heading'     => esc_attr__( 'HTML Heading Size', 'fusion-builder' ),
							'description' => esc_attr__( 'Choose HTML tag of the heading, either div or the heading tag, h1-h6.', 'fusion-builder' ),
							'param_name'  => 'iranavada_subtitle_select_tag',
							'value'       => [
								  'iravada_default_tag'		 => __( 'Select Subtitle Html Tag. Default: Span' , 'royal' ),
								  'SPAN'     				 => 'span',
								  'H2' 		 				 => 'h2',
								  'H3'       				 => 'h3',
								  'H4'       				 => 'h4',
							],
							'default' => 'SPAN',
							'group' => esc_attr__( 'Design', 'fusion-builder' ),
						],
						[
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Font Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #c1c1c1.', 'fusion-builder' ),
							'param_name'  => 'iranavada_subtitle_font_color',
							'value'       => '',
							'default' 	  => '#c1c1c1',
							'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
						],
						[ 
							'type' => 'radio_button_set', 
							'heading' => esc_attr__( 'Alignment', 'fusion-builder' ),
							'description' => esc_attr__( 'Choose to align the heading left, right or center.', 'fusion-builder' ),
							'param_name' => 'content_align_subtitle_products', 
							'value' => [ 
								'left' => esc_attr__( 'Left', 'fusion-builder' ), 
								'center' => esc_attr__( 'Center', 'fusion-builder' ), 
								'right' => esc_attr__( 'Right', 'fusion-builder' ) 
							], 
							'default' => 'right', 
							'group' => esc_attr__( 'Design', 'fusion-builder' ) 
						], 

					// End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_subtitle_products' );
