<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_uniq_attr' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_uniq_attr
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_desc_box_uniq_attr', [ $this, 'wrapper_attr_uniq_attr' ] );
			add_filter( 'fusion_attr_title_heading_right', [ $this, 'wrapper_attr_title_heading_right' ] );
			add_filter( 'fusion_attr_view_all_text', [ $this, 'wrapper_attr_view_all_text' ] );
			add_filter( 'fusion_attr_iravada_uniq_attr_li', [ $this, 'wrapper_attr_iravada_uniq_attr_li' ] );
			add_filter( 'fusion_attr_irava-uniq-attr-last-item', [ $this, 'wrapper_irava_uniq_attr_last_item' ] );
			
			add_shortcode( 'iravada_uniq_attr', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 
				'class'								            => '',
				'id'								            => '',
				'royal_uniq_attr_status'                        => '',
                'hide_on_mobile'  					            => fusion_builder_default_visibility( 'array' ), 
                'iravada_uniq_attr_main_background_color'       => '#fff',
                'padding_top'                                   => '10px',
                'padding_right'                                 => '10px',
                'padding_bottom'                                => '10px',
                'padding_left'                                  => '10px',
                'border_radius_top_left'                        => '0px',
                'border_radius_top_right'                       => '0px',
                'border_radius_bottom_right'                    => '0px',
                'border_radius_bottom_left'                     => '0px',
                'border_top'                                    => '0px',
                'border_right'                                  => '0px',
                'border_bottom'                                 => '0px',
                'border_left'                                   => '0px',
                'iravada_uniq_attr_main_box_border_color'       => '#dddddd',
                'iravada_uniq_border_style'                     => 'dashed',
                'iravada_uniq_attr_box_title_size'              => '17px',
                'iravada_uniq_attr_box_title_font_color'        => '#ff8100',
                'iravada_uniq_attr_box_list_font_size'          => '12px',
                'iravada_uniq_attr_box_list_font_color'         => '#888',
                'uniq_attr_main_title_icon'                     => '',
                'select_uniq_attr'                              => 'list',
                'uniq_attr_box_style_column'                    => '3',
                'box_style_btn_text'                            => '',
                'box_style_btn_href_container_id'               => '',
                'irava_uniq_attr_modal_mobile'                  => '',
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_uniq_attr' );
			
			$this->args = $defaults;
			$uniq_attr_icon_tag = '';
			$uniq_attr_box_button_tag = '';
			
			if( $this->args['uniq_attr_main_title_icon'] != '' ) {
			    $uniq_attr_icon_tag = '<i class="'. fusion_font_awesome_name_handler($this->args['uniq_attr_main_title_icon']) .'"></i>';
			}
			
			if( $this->args['box_style_btn_text'] != '' && $this->args['select_uniq_attr'] == 'box' ) {
			    $uniq_attr_box_button_tag = '<div class="uniq-attr-button-section"><hr class="uniq-attr-button-right-hr"><a href="#'. $this->args['box_style_btn_href_container_id'] .'" class="uniq-attr-btn-box-style">'. $this->args['box_style_btn_text'] .' <i class="fa-angle-left fas"></i></a><hr class="uniq-attr-button-left-hr"></div>';
			}
			
			ob_start();
			
			    if($this->args['royal_uniq_attr_status'] == 'true' && $this->args['select_uniq_attr'] == 'list' ) {

                    $show_more_html = '<div class="show-more-button"><span class="show-more-text">+ نمایش بیشتر</span></div>';
                    $show_more_javascript = '<script>let GetShowMoreButtonParent=document.querySelector(".show-more-button"),GetAllUniqList=document.querySelectorAll(".iravada_uniq_attr_li");GetAllUniqList.length<=4&&GetShowMoreButtonParent.remove(),GetShowMoreButtonParent.addEventListener("click",function(e){let t=document.querySelector(".royal-uniq-attr");var o=document.querySelector(".show-more-text"),n=document.createElement("span");t.classList.toggle("show"),t.classList.contains("show")?(n.classList.add("show-more-text"),n.appendChild(document.createTextNode("- نمایش کمتر"))):(n.classList.add("show-more-text"),n.appendChild(document.createTextNode("+ نمایش بیشتر"))),GetShowMoreButtonParent.replaceChild(n,o)});</script>';
                    ?>
                    <style>
                        div.royal-uniq-attr {
                            min-height: 145px;
                            overflow: hidden;
                            height: 125px;
                        }
                        span.show-more-text {
                            color: #00BFD6;
                            font-size: 12px;
                            cursor: pointer;
                            margin-right: 9px;
                        }
                        .royal-uniq-attr.show {
                            min-height: auto;
                            height: auto;
                            overflow: hidden;
                        }
                    </style>
                    <?php

			    }else {
			        
			        $show_more_html = '';
			        $show_more_javascript = '';
			        ?>
                    <style>
                        html {
                          scroll-behavior: smooth;
                        }
                        div.royal-uniq-attr {
                            min-height: auto;
                            height: auto;
                            overflow: hidden;
                        }
                        span.show-more-text {
                            color: #00BFD6;
                            font-size: 12px;
                            cursor: pointer;
                            margin-right: 9px;
                        }

                    </style>
                    <?php
                    
			    }

                $ContainerID    = $this->args['box_style_btn_href_container_id'];
                $ModalID        = $this->args['irava_uniq_attr_modal_mobile'];
                $BtnText        = $this->args['box_style_btn_text'] ? $this->args['box_style_btn_text'] : 'مشاهده همه';
                $ViewAllAttr    = '';
                $IfModalActvie  = '';

                if( !empty($ModalID) ) {
                    $IfModalActvie = "data-toggle='modal' data-target='.fusion-modal.$ModalID'";
                }

                if( $this->args['select_uniq_attr'] == 'box' ) {
                    $ViewAllAttr = "<a href='#$ContainerID' class='uniq-attr-btn-box-style' $IfModalActvie >$BtnText <i class='fa-angle-left fas'></i></a>"; 
                }
                /* description box */
                $mcg_group_title = get_post_meta(get_the_ID(), 'mcg_group_title', true);
                if( empty($mcg_group_title) ){
                    $mcg_group_title = __('Important features', 'royal');
                }
                $gpminvoice_group = get_post_meta(get_the_ID(), 'customdata_group', true);
                if ( !empty( $gpminvoice_group ) ){
                    echo '<section '. FusionBuilder::attributes( 'desc_box_uniq_attr' ) .'><div class="royal-uniq-attr"><div '. FusionBuilder::attributes( 'desc-title' ) .' style="display: flex;justify-content: space-between;align-items: center;"><span '. FusionBuilder::attributes( 'title_heading_right' ) .'>'. $uniq_attr_icon_tag .' '.$mcg_group_title.'</span><span '. FusionBuilder::attributes( 'view_all_text' ) .'>'. $ViewAllAttr .'</span></div><ul '. FusionBuilder::attributes( 'value_field' ) .'>';
                    foreach ( $gpminvoice_group as $field ) {
                        echo '<li '. FusionBuilder::attributes( 'iravada_uniq_attr_li' ) .'><span class="irava-uniq-item-title">'.esc_attr( $field['TitleItem'] ).'</span> <span class="irava-uniq-bold">'.esc_attr( $field['AttrItem'] ).'</span></li>'; 
                    }
                    echo '</ul>'. $uniq_attr_box_button_tag .'</div>'.$show_more_html.'</section>'; 
                }
                
                echo $show_more_javascript;

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_uniq_attr() {
			$attr = [ 
				'class' => 'desc_box_uniq_attr ' . $this->unique_class,
				'style' => '' 
			];

            if( $this->args['select_uniq_attr'] == 'list' ) {
                
                // PHP Code For Handle Main Background Section Color
                if( $this->args['iravada_uniq_attr_main_background_color'] ) {
                    $attr['style']  .= 'background: '. $this->args['iravada_uniq_attr_main_background_color'] .';';
                }
                
                // PHP Code For Handle Uniq Main Box Border Top
                $attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Right
                $attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Bottom
                $attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Left
                $attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Radius
                $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
    
                // PHP Code For Handle Uniq Main Box Border Style Dashed
                if( $this->args['iravada_uniq_border_style'] == 'dashed' ) {
                    $attr['style'] .= 'border-style: dashed;'; 
                }
    
                // PHP Code For Handle Uniq Main Box Border Style Solid
                if( $this->args['iravada_uniq_border_style'] == 'solid' ) {
                    $attr['style'] .= 'border-style: solid;'; 
                }
    
                // PHP Code For Handle Uniq Main Box Border Style Dotted
                if( $this->args['iravada_uniq_border_style'] == 'dotted' ) {
                    $attr['style'] .= 'border-style: dotted;'; 
                }
                
                // PHP Code For Handle Uniq Main Box Border Size
                if( $this->args['iravada_uniq_attr_main_box_border_color'] ) {
                    $attr['style'] .= 'border-color:' .  $this->args['iravada_uniq_attr_main_box_border_color'] .';'; 
                }
    
                // PHP Code For Handle Uniq Main Box Padding
                $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 

                
            }

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle id hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
            if( $this->args['select_uniq_attr'] == 'box' ) {
                $attr['class'] .= ' irava-uniq-box-style ';
                $attr['class'] .= 'col' . $this->args['uniq_attr_box_style_column'];
            }
            
            if( $this->args['select_uniq_attr'] == 'list' ) {
                $attr['class'] .= ' irava-uniq-list-style';
            }
            
			return $attr;
		}

        // Add Filter To Title
        public function wrapper_attr_title_heading_right() {
			$attr = [ 
				'class' => 'title_heading_right ' . $this->unique_class,
				'style' => '' 
			];

            // PHP Code For Handle Uniq Main Box Title Font Size
            if( $this->args['iravada_uniq_attr_box_title_size'] ) {
                $attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_uniq_attr_box_title_size'] ) . ';'; 
            }

            // PHP Code For Handle Uniq Main Box Titlet Color
            if( $this->args['iravada_uniq_attr_box_title_font_color'] ) {
                $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_uniq_attr_box_title_font_color'] ) . ';'; 
            }
            
			return $attr;
		}

        // Add Font Size To Veiw All Text
        public function wrapper_attr_view_all_text() {

			$attr = [ 
				'class' => 'view_all_text ' . $this->unique_class,
				'style' => '' 
			];

            // PHP Code For Handle Uniq Main Box Title Font Size
            if( $this->args['iravada_uniq_attr_box_title_size'] ) {
                $attr['style'] .= 'font-size: 13px;'; 
            }
            
			return $attr;

		}

        // Add Filter To Iravada Uniq Attr li
        public function wrapper_attr_iravada_uniq_attr_li() {
			$attr = [ 
				'class' => 'iravada_uniq_attr_li ' . $this->unique_class,
				'style' => '' 
			];

            if( $this->args['select_uniq_attr'] == 'box' ) {
                
                // PHP Code For Handle Main Background Section Color
                if( $this->args['iravada_uniq_attr_main_background_color'] ) {
                    $attr['style']  .= 'background: '. $this->args['iravada_uniq_attr_main_background_color'] .';';
                }
    
                // PHP Code For Handle Uniq Main Box Border Top
                $attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Right
                $attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Bottom
                $attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Left
                $attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';'; 
    
                // PHP Code For Handle Uniq Main Box Border Radius
                $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
    
                // PHP Code For Handle Uniq Main Box Border Style Dashed
                if( $this->args['iravada_uniq_border_style'] == 'dashed' ) {
                    $attr['style'] .= 'border-style: dashed;'; 
                }
    
                // PHP Code For Handle Uniq Main Box Border Style Solid
                if( $this->args['iravada_uniq_border_style'] == 'solid' ) {
                    $attr['style'] .= 'border-style: solid;'; 
                }
    
                // PHP Code For Handle Uniq Main Box Border Style Dotted
                if( $this->args['iravada_uniq_border_style'] == 'dotted' ) {
                    $attr['style'] .= 'border-style: dotted;'; 
                }
                
                // PHP Code For Handle Uniq Main Box Border Size
                if( $this->args['iravada_uniq_attr_main_box_border_color'] ) {
                    $attr['style'] .= 'border-color:' .  $this->args['iravada_uniq_attr_main_box_border_color'] .';'; 
                }
    
                // PHP Code For Handle Uniq Main Box Padding
                $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 

            }

            // PHP Code For Handle Uniq Main Box Title Font Size
            if( $this->args['iravada_uniq_attr_box_list_font_size'] ) {
                $attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_uniq_attr_box_list_font_size'] ) . ';'; 
            }

            // PHP Code For Handle Uniq Main Box Titlet Color
            if( $this->args['iravada_uniq_attr_box_list_font_color'] ) {
                $attr['style'] .= 'color:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_uniq_attr_box_list_font_color'] ) . ';'; 
            }
            
			return $attr;
		}
		
		public function wrapper_irava_uniq_attr_last_item() {
		    
			$attr = [ 
				'class' => 'irava-uniq-attr-last-item ' . $this->unique_class,
				'style' => '' 
			];

            $attr['class'] .= 'iravada_uniq_attr_li ';

            if( $this->args['select_uniq_attr'] == 'box' ) {
    
                // PHP Code For Handle Uniq Main Box Padding
                $attr['style'] .=  'padding:' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_top'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_bottom'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['padding_left'] ) .'; '; 
                
                // PHP Code For Handle Uniq Main Box Title Font Size
                if( $this->args['iravada_uniq_attr_box_list_font_size'] ) {
                    $attr['style'] .= 'font-size:' . fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_uniq_attr_box_list_font_size'] ) . ';'; 
                }
                
                // PHP Code For Handle Uniq Main Box Border Radius
                $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
            
            }
            
			return $attr;
		    
		}

        
	}
	new iravada_uniq_attr();
}

function iravada_uniq_attr_func() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_uniq_attr', 
            [
                'name'            => __( 'Royal Uniq Attributes', 'royal' ),
                'shortcode'       => 'iravada_uniq_attr',
                'icon'            => 'iravada_elements_icon',
                'templates'    	  => [ 'content' ],
				'component'       => true,
                'allow_generator' => true,
                'params'          => 
                [

    					// Start General Tab
    					
						// Subtitle Element Visibility
						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css Class Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						// Css ID Field Subtitle
						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					// End General Tab

                    // Start Design Tab
    					[
    						'type'        => 'radio_button_set',
    						'heading'     => __( 'Select Uniq Attr Style', 'royal' ),
    						'description' => __( 'Select Uniq Attr Style. Default: List', 'royal' ),
    						'param_name'  => 'select_uniq_attr',
    						'value'       => [
    							'list' 	  => __( 'List', 'royal' ),
    							'box'     => __( 'Box', 'royal' ),
    						],
    						'default'	  => 'list',
    						'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
    					],
            			[
            				'type'        => 'range',
            				'heading'     => __( 'Uniq Attr Columns In Box Style', 'royal' ),
            				'description' => __( 'Controls the Carousel Category Filter Gap.', 'royal' ),
            				'param_name'  => 'uniq_attr_box_style_column',
            				'value'       => '3',
            				'min'         => '2',
            				'max'         => '4',
            				'step'        => '1',
    						'dependency'       => [
    							[
    								'element'  => 'select_uniq_attr',
    								'value'    => 'box',
    								'operator' => '==',
    							],
    						],
            				'group' 	  => esc_attr__( 'Design', 'fusion-builder' ),
            			],
						[ 
							'type'        => 'textfield', 
							'heading'     => __( 'Box Style Button Text', 'royal' ), 
							'description' => __( 'Add a Text For Button In box Style. If Empty Button Not Shown.', 'royal' ),
							'param_name'  => 'box_style_btn_text', 
							'value'       => '', 
							'group'       => esc_attr__( 'Design', 'fusion-builder' ),
    						'dependency'       => [
    							[
    								'element'  => 'select_uniq_attr',
    								'value'    => 'box',
    								'operator' => '==',
    							],
    						],
						],
    					[
    						'type'        => 'textfield',
    						'heading'     => __( 'Box Button Container ID', 'royal' ),
    						'description' => __( 'Put The Container ID.', 'royal' ),
    						'param_name'  => 'box_style_btn_href_container_id',
    						'value'       => '',
							'group'       => esc_attr__( 'Design', 'fusion-builder' ),
    						'dependency'       => [
    							[
    								'element'  => 'select_uniq_attr',
    								'value'    => 'box',
    								'operator' => '==',
    							],
    						],
    						'callback'         => [],
    					],
						[ 
							'type' => 'textfield', 
							'heading' => __( 'Modal Name', 'royal' ), 
							'description' => __( 'If you have designed a modal box after clicking the View More title, put the name of the modal here so that the content of the modal will pop up.', 'royal' ),
							'param_name' => 'irava_uniq_attr_modal_mobile', 
							'value' => '', 
							'group' => esc_attr__( 'Design', 'fusion-builder' ),
                            'dependency'       => [
    							[
    								'element'  => 'select_uniq_attr',
    								'value'    => 'box',
    								'operator' => '==',
    							],
    						],
    						'callback'         => [],
						],
    					[
    						'type'        => 'radio_button_set',
    						'heading'     => __( 'Show More Status', 'royal' ),
    						'description' => __( 'Select Show More Active/Deactive', 'royal' ),
    						'param_name'  => 'royal_uniq_attr_status',
    						'value'       => [
    							'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
    							'false'  => esc_attr__( 'No', 'fusion-builder' ),
    						],
    						'group' => esc_attr__( 'Design', 'fusion-builder' ),
    						'default'	  => 'true',
    						'dependency'       => [
    							[
    								'element'  => 'select_uniq_attr',
    								'value'    => 'list',
    								'operator' => '==',
    							],
    						],
    					],

                        // Iravada Uniq Attr Main Box Title Font Size
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_attr__( 'Heading Font Size', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 17px.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_box_title_size',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Uniq Attr Main Box Title Font Color
                        [
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Uniq Attr Main Title Size', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #ff8100.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_box_title_font_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],
                        
    					[
    						'type'        => 'iconpicker',
    						'heading'     => __( 'Select Uniq Attr Title Icon', 'royal' ),
    						'description' => __( 'Select Any Icon For Uniq Attributes Main Title.', 'royal' ),
    						'param_name'  => 'uniq_attr_main_title_icon',
    						'value'       => '',
    						'group' 	  => esc_attr__( 'Design', 'fusion-builder' ) 
    					],

                        // Iravada Uniq Attr Main Box List Font Size
                        [
                            'type'        => 'textfield',
                            'heading'     => esc_attr__( 'Font Size', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the font size of the text. Enter value including any valid CSS unit, ex: 20px. Leave empty for default value of 12px.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_box_list_font_size',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Uniq Attr Main Box List Font Color
                        [
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Font Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the color of the text, ex: #000. Leave empty for default value of #888.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_box_list_font_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Uniq Attr Main Background Box Color
                        [
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Background Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the background color.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_main_background_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Uniq Attr Box padding
                        [
                            'type'        => 'dimension',
                            'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                            'param_name'  => 'iravada_main_box_uniq_attr_box_padding',
                            'value'       => [
                                'padding_top'    => '',
                                'padding_right'  => '',
                                'padding_bottom' => '',
                                'padding_left'   => '',
                            ],
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Box Border Size Uniq Attr
                        [
                            'type'             => 'dimension',
                            'remove_from_atts' => true,
                            'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
                            'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
                            'param_name'       => 'border_sizes',
                            'value'            => [
                                'border_top'    => '',
                                'border_right'  => '',
                                'border_bottom' => '',
                                'border_left'   => '',
                            ],
                            'group'            => esc_attr__( 'Design', 'fusion-builder' ),
                        ],
                        
                        // Iravada Uniq Attr Box Border Style
                        [
                            'type'        => 'select',
                            'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
                            'description' => esc_attr__( 'Choose the separator line style. Default currently set to Dashed.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_border_style',
                            'value'       => [
                                  'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
                                  'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
                                  'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
                            ],
                            'default'     => 'dashed',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Border Color Uniq Attr Main Box
                        [ 
                            'type'        => 'colorpickeralpha',
                            'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
                            'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_main_box_border_color',
                            'value'       => '',
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                        // Iravada Border Radius Uniq Attr Main Box
                        [
                            'type'        => 'dimension',
                            'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
                            'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
                            'param_name'  => 'iravada_uniq_attr_main_box_border_radius',
                            'value'       => [
                                'border_radius_top_left'     => '',
                                'border_radius_top_right'    => '',
                                'border_radius_bottom_right' => '',
                                'border_radius_bottom_left'  => '',
                            ],
                            'group'       => esc_attr__( 'Design', 'fusion-builder' ) 
                        ],

                    // End Design Tab

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_uniq_attr_func' );
