(function($) {
    $(document).ready(function() {
      var items = $('.iranavada-sopc-slides'),
        heights = [],
        tallest;
      if (items.length) {
        function normalizeHeights() {
          items.each(function() {
            heights.push($(this).height());
          });
          tallest = Math.max.apply(null, heights);
          items.each(function() {
            $(this).css('min-height', tallest + 'px');
          });
        };
        normalizeHeights();
        $(window).on('resize orientationchange', function() {
          tallest = 0, heights.length = 0;
          items.each(function() {
            $(this).css('min-height', '0');
          });
          normalizeHeights();
        });
      }
      var totalItems = $('.iranavada-sopc-items').length;
      var currentIndex = $('div.iranavada-sopc-active').index();
      $('.num').html('' + currentIndex + '/' + totalItems + '');
      $('.carouselExampleControls').on('click', function() {
        currentIndex = $('div.iranavada-sopc-active').index();
        $('.num').html('' + currentIndex + '/' + totalItems + '');
      });
      $('.iranavada-sopcaw-countdown').each(function() {
        var $countdown = $(this);
        $countdown.countdown($countdown.data('date'), function(event) {
          var htmlCounter = '';
          if (event.strftime('%-D') == 0) {
            htmlCounter = event.strftime('<span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%H</span></span><div class="iranavada-soc-countdown-hour-text"> ' + sscw_params.text_hours + '</div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%M</span></span><div class="iranavada-soc-countdown-min-text"> ' + sscw_params.text_mins + '</div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%S</span></span><div class="iranavada-soc-countdown-sec-text"> ' + sscw_params.text_secs + '</div></span>');
          } else {
            htmlCounter = event.strftime('<span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%D</span></span><div class="iranavada-soc-countdown-day-text">' + sscw_params.text_days + '</div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%H</span></span><div class="iranavada-soc-countdown-hour-text"> ' + sscw_params.text_hours + '</div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%M</span></span><div class="iranavada-soc-countdown-min-text"> ' + sscw_params.text_mins + '</div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%S</span></span><div class="iranavada-soc-countdown-sec-text"> ' + sscw_params.text_secs + '</div></span>');
          }
          $(this).html(htmlCounter);
        });
      });
      $('.iranavada-sopcaw-countdown-single').each(function() {
        var $countdown = $(this);
        $countdown.countdown($countdown.data('date'), function(event) {
          var htmlCounter = '';
          if (event.strftime('%-D') == 0) {
            htmlCounter = event.strftime('<span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%H</span></span><div class="iranavada-soc-countdown-hour-text"></div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%M</span></span><div class="iranavada-soc-countdown-min-text"></div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%S</span></span><div class="iranavada-soc-countdown-sec-text"></div></span>');
          } else {
            htmlCounter = event.strftime('<span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%D</span></span><div class="iranavada-soc-countdown-day-text"></div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%H</span></span><div class="iranavada-soc-countdown-hour-text"></div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%M</span></span><div class="iranavada-soc-countdown-min-text"></div></span><span class="iranavada-sopcaw-time-box-dot">:</span><span class="iranavada-sopcaw-time-box"><span class="iranavada-sopcaw-time-content"><span class="iranavada-sopcaw-time">%S</span></span><div class="iranavada-soc-countdown-sec-text"></div></span>');
          }
          $(this).html(htmlCounter);
        });
      });
      $('.iranavada-sopcaw-countdown-raw').each(function() {
        var $countdown = $(this);
        var opts = $(this).data('options');
        $countdown.countdown($countdown.data('date'), function(event) {
          var htmlCounter = '';
          if (event.strftime('%-D') != 0) {
            htmlCounter += '%D:';
          }
          htmlCounter += '%H:%M:%S';
          if (opts !== undefined) {
            var options = opts.split('|');
            for (var i = 0; i < options.length; i++) {
              var option = options[i];
              if (option == 'spancolon' || option == 'colonspan') {
                htmlCounter = htmlCounter.split(':').join('<span class="colon">:</span>');
                continue;
              }
              if (option == 'box') {
                htmlCounter = htmlCounter.replace('%D', '<span class="box day">%D</span>');
                htmlCounter = htmlCounter.replace('%H', '<span class="box hour">%H</span>');
                htmlCounter = htmlCounter.replace('%M', '<span class="box minute">%M</span>');
                htmlCounter = htmlCounter.replace('%S', '<span class="box second">%S</span>');
              }
              if (option == 'label') {
                htmlCounter = htmlCounter.replace('%D', '%D<span class="label day">روز</span>');
                htmlCounter = htmlCounter.replace('%H', '%H<span class="label hour">ساعت</span>');
                htmlCounter = htmlCounter.replace('%M', '%M<span class="label minute">دقیقه</span>');
                htmlCounter = htmlCounter.replace('%S', '%S<span class="label second">ثانیه</span>');
              }
            }
          }
          $(this).html(event.strftime(htmlCounter));
        });
      });
    });
  })(jQuery);