<?php

/* End Function Load Css Royal Elements In Frontend */

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
if ( ! class_exists( 'iravada_special_carousel' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_special_carousel
    {
		
		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;
		
		protected $td = '';
		protected $lang = '';
		protected $special_dir_path = '';
		protected $special_url_path = '';
		protected $special_assets_url = '';
		protected $version = '';

		public function __construct() {

            $this->td                   = 'iranavadasopc';
            $this->lang                 = 'royal';
            $this->special_dir_path     = get_stylesheet_directory() . '/includes/royal-elements/includes/special-product-swiper/';
            $this->special_url_path     = get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper';
            $this->special_assets_url   = $this->special_url_path . '/assets';
			$this->version 				= "1.0.0";
			
			add_filter( 'fusion_attr_irava-cat-filter-first-item', [ $this, 'wrapper_irava_cat_filter_first_item' ] );
			add_filter( 'fusion_attr_hero-img', [ $this, 'wrapper_hero_img' ] );
			add_filter( 'fusion_attr_iravada-swiper-filter', [ $this, 'wrapper_iravada_swiper_filter' ] );
			add_filter( 'fusion_attr_irava-filter-item', [ $this, 'wrapper_irava_filter_item' ] );
			add_filter( 'fusion_attr_regular-price', [ $this, 'wrapper_regular_price' ] );
			add_filter( 'fusion_attr_product-title', [ $this, 'wrapper_product_title' ] );
			add_filter( 'fusion_attr_iravada-special-product-carousel', [ $this, 'wrapper_fusion_special_carousel' ] );
			add_filter( 'fusion_attr_irava-hero-img', [ $this, 'wrapper_irava_hero_img' ] );
			add_filter( 'fusion_attr_product-off-timer', [ $this, 'wrapper_product_off_timer' ] );
			add_filter( 'fusion_attr_carousel', [ $this, 'wrapper_carousel' ] );
			add_filter( 'fusion_attr_grid', [ $this, 'wrapper_grid' ] );
			add_filter( 'fusion_attr_special-carousel-add-to-cart', [ $this, 'wrapper_special_carousel_add_to_cart' ] );
			add_filter( 'fusion_attr_show-more-product-text', [ $this, 'wrapper_show_more_product_text' ] );
			add_filter( 'fusion_attr_royal_brand', [ $this, 'wrapper_royal_brand' ] );
			add_filter( 'fusion_attr_royal-brand-detail', [ $this, 'wrapper_royal_brand_detail' ] );
			add_filter( 'fusion_attr_irava-brand-name', [ $this, 'wrapper_irava_brand_name' ] );
			add_filter( 'fusion_attr_iranavada-view-current-filter-line', [ $this, 'wrapper_iranavada_view_current_filter_line' ] );
			add_shortcode( 'iravada_special_carousel', [ $this, 'render' ] );
			
			// Ajax Request For Load Products By Filter
			add_action( 'wp_ajax_irava_swiper_category_filter', array($this, 'iranavada_load_product_swiper_filter_ajax') );
			add_action( 'wp_ajax_nopriv_irava_swiper_category_filter', array($this, 'iranavada_load_product_swiper_filter_ajax') );

            // save woocommerce product extra options
            add_action("woocommerce_process_product_meta", array( $this, "save_iravada_product_options"));

            // Add a custom product data tab data
            add_action("woocommerce_product_data_panels", array( $this, "iravada_woocommerce_product_data_panels"));

            // Add a custom product data tab
            add_filter("woocommerce_product_data_tabs", array( $this, "iravada_woocommerce_product_data_tabs") );

			// Ajax mechanism for query related part.
			add_action( 'wp_ajax_irava_get_fusion_products', [ $this, 'irava_ajax_query' ] );

			// add thumbnail sizes
            add_theme_support('post-thumbnails');
            add_image_size('irava-slider-75-crop', 75, 75, true);		// Hard Crop for special slider small images
            add_image_size('irava-slider-400-crop', 400, 400, true); 	// Hard Crop for special slider large images
			add_image_size( 'irava-carousel-300-crop', 300, 300, true );// Hard Crop for special carousel images

			// styles & scripts on front-end, prepare but enqueue only if Element is called
            add_action("init", array($this, 'wp_enqueue_scripts'));

			add_filter( 'body_class', array($this, 'my_body_classes') );

		}

		// Load Product By Swiper Cat Filter Ajax
		public function iranavada_load_product_swiper_filter_ajax() {

			// Get All Data Sended From Ajax
			$templateName 						= $_POST['TemplateName'];
			$carouselBanner						= $_POST['CarouselBanner'];
			$displayBannerStatus 				= $_POST['DisplayBannerBtn'];
			$carouselBtnLink 					= $_POST['CarouselBtnLink'];
			$carsouelBtnText 					= $_POST['CarouselBtnText'];
			$requestCatProduct 					= $_POST['RequestCatProduct'];
			$discounted_products				= $_POST['ProductSaleStatus'];
			$shegeftangiz						= $_POST['SpecialProductStatus'];
			$irava_sortby						= $_POST['ProductSortType'];
			$irava_orderby						= $_POST['ProductOrderByType'];
			$carouselLimit						= $_POST['ProductLimitProduct'];
			$product_display_price				= $_POST['ProductPriceStatus'];
			$product_display_title				= $_POST['ProductTitleStatus'];
			$product_addtocart_button			= $_POST['ProductAddToCartStatus'];
			$addtocart_button_icon				= $_POST['ProductAddToCartIcon'];
			$addtocart_background				= $_POST['ProductAddToCartBackground'];
			$addtocart_icon_color				= $_POST['ProductAddToCartIconColor'];
			$product_off_type_status			= $_POST['ProductOffTypeStatus'];
			$product_timer_status				= $_POST['productTimerStatus'];
			$product_timer_color				= $_POST['productTimerColor'];
			$items_border_top					= $_POST['TopBorder'];
			$items_border_right					= $_POST['RightBorder'];
			$items_border_bottom				= $_POST['BottomBorder'];
			$items_border_left					= $_POST['LeftBorder'];
			$item_top_left_radius				= $_POST['TopLeftRadius'];
			$item_top_right_radius				= $_POST['TopRightRadius'];
			$item_bottom_right_radius			= $_POST['BottomRightRadius'];
			$item_bottom_left_radius			= $_POST['BottomLeftRadius'];
			$item_border_style					= $_POST['BorderStyle'];
			$item_border_color					= $_POST['BorderColor'];
			$dynamicID							= $_POST['dynamicID'];
			$categories_selected				= $_POST['CategorySelected'];
			$cat_filter_status					= $_POST['CatFilterStatus'];
			$current_terms_link					= $_POST['CurrentTermsLink'];
			$display_last_slide					= $_POST['DisplayLastSlide'];
			$get_data_items_gap					= isset($_POST['dataItemsGap']) ? $_POST['dataItemsGap'] : '';
			
			if( $item_top_left_radius == '' ) {
				$item_top_left_radius = '0px';
			}
			if( $item_top_right_radius == '' ) {
				$item_top_right_radius = '0px';
			}
			if( $item_bottom_right_radius == '' ) {
				$item_bottom_right_radius = '0px';
			}
			if( $item_bottom_left_radius == '' ) {
				$item_bottom_left_radius = '0px';
			}

			if( $discounted_products == 'yes' ) {

				$query_args     = array( 
				  'post_type'       => 'product', 
				  'post_status'     => 'publish',
				  'limit'           => $carouselLimit,
				  'product_cat'     => $requestCatProduct,
				  'orderby'         => $irava_orderby,
				  'order'           => $irava_sortby,
				  'type'            => array("simple","variable"),
				  'stock_status'    => 'instock',
				  'include'         => wc_get_product_ids_on_sale(),
				);
			  
			}elseif( $shegeftangiz == 'yes' ) {

				$query_args     = array( 
					'post_type'       => 'product', 
					'post_status'     => 'publish',
					'limit'           => $carouselLimit,
					'product_cat'     => $requestCatProduct,
					'orderby'         => $irava_orderby,
					'order'           => $irava_sortby,
					'type'            => array("simple","variable"),
					'stock_status'    => 'instock',
					'_iranavadasopc'  => 'yes',
				);

			}else {

				$query_args     = array( 
					'post_type'       => 'product', 
					'post_status'     => 'publish',
					'limit'           => $carouselLimit,
					'product_cat'     => $requestCatProduct,
					'orderby'         => $irava_orderby,
					'order'           => $irava_sortby,
					'type'            => array("simple","variable"),
					'stock_status'    => 'instock',
				);

			}

			$iranavada_products = wc_get_products( $query_args );

			if( $templateName == 'carousel' ) {
  
				?>
				<div class="iravada-ajax-load <?= $dynamicID ?>"></div>
				<div class="swiper-wrapper carousel <?= $dynamicID ?>" id="<?= $dynamicID ?>">
					<?php
					// Create Carousel Banner/Button
					if( $carouselBanner != '' && $displayBannerStatus == 'yes' && $cat_filter_status == 'no' ) {
						?>
						<div class="swiper-slide carousel" style="background: none;">
							<a href="<?= $carouselBtnLink ?>" class="hero-img-link" target="_blank">
								<div class="irava-hero-img" >
									<div class="hero-img"><img width="110" height="245" src="<?= $carouselBanner ?>" alt=""></div>
									<span class="show-more-product-text"><?= $carsouelBtnText ?></span>
								</div>
							</a>
						</div>
						<?php
					}
					
					foreach ($iranavada_products as $products) {

						$product = wc_get_product($products);
						$product_id = $product->get_id();
						// $product_name = strlen($product->get_name()) > 55 ? mb_substr($product->get_name(), 0, 55, "utf-8") . "&hellip;" : $product->get_name();
						// $product_title = strlen($product->get_title()) > 55 ? mb_substr($product->get_title(), 0, 55, "utf-8") . "&hellip;" : $product->get_title();
						$product_name = $product->get_name();
						$product_title = $product->get_title();
						$product_slug = $product->get_slug();
						$product_permalink = get_permalink($product->get_id());
						$product_price = $product->get_price();
						$product_price_html = $product->get_price_html();
						$product_sale_price = $product->is_type('variable') ? $product->get_variation_sale_price('min', true) : $product->get_sale_price();
						$product_regular_price = $product->is_type('variable') ? $product->get_variation_regular_price('min', true) : $product->get_regular_price();
						$product_is_on_sale = $product->is_on_sale();
						$product_is_in_stock = $product->is_in_stock();
						$product_stock_status = $product->get_stock_status();
						$product_on_sale_to = $product->get_date_on_sale_to();
						$product_stock_quantity = $product->get_stock_quantity();
						$product_image = $product->get_image();
						$product_image_id = $product->get_image_id();
						$product_image_url = wp_get_attachment_url($product_image_id);
						$product_image_url_optimized = get_the_post_thumbnail_url($product_id, 'irava-carousel-300-crop'); // large carousel image
						$product_image_url_optimized_full = get_the_post_thumbnail_url($product_id, 'irava-slider-75-crop');
						$product_gallery_image_ids = $product->get_gallery_image_ids();
						$product_sale_price = $product->is_type('variable') ? $product->get_variation_sale_price('min', true) : $product->get_sale_price();
						$percentage         = "";
						$price_off_number   = "";
						if ($product_is_in_stock && $product_is_on_sale) {
							if ($product_regular_price !== $product_sale_price ) { 
							$percentage         = round(( $product_regular_price - $product_sale_price ) / $product_regular_price * 100);
							$price_off_number   = $product_regular_price - $product_sale_price;
							}
						}
						$product_special_true = get_post_meta($product_id, '_iranavadasopc', true);
						$product_on_sale_to_2 = get_post_meta($product_id, '_iranavadasopc_date', true);
						$product_on_sale_to_final = null;
						if ($product->is_type('variable') && "yes" == $product_special_true && !empty($product_on_sale_to_2)) {
							$product_on_sale_to_final = (new DateTime($product_on_sale_to_2))->format('Y/m/d') . ' 23:59:59';
						}
						else{
							if ($product_is_in_stock && $product_on_sale_to != null) {
								$product_on_sale_to_final = $product_on_sale_to->date('Y/m/d') . ' 23:59:59';
							}
							elseif($product_is_in_stock) {
								$product_on_sale_to_final = null;
							}
						}
				
						if( $product_on_sale_to_final != null ) {
						if (date("Y/m/d H:i:s") > $product_on_sale_to_final ) {
							update_post_meta( $product_id, '_iranavadasopc', 'no' );
						}
						}
				
						?>
						<div class="carousel swiper-slide <?php if( $product_addtocart_button == 'yes' ) { echo 'add-to-cart'; }else { echo 'no-add-to-cart'; } ?> <?php if( $product_display_title == 'no' ) { echo 'no-title'; } ?> <?php if( $product_display_price == 'no' ) { echo 'no-price'; } ?> <?php if( $product_timer_status == "yes" ) { echo 'is-timer'; } ?>" style="<?php if( $items_border_top != '' ) { echo 'border-top:'. $items_border_top .';'; } ?> <?php if( $items_border_right != '' ) { echo 'border-right:'. $items_border_right .';'; } ?> <?php if( $items_border_bottom != '' ) { echo 'border-bottom:'. $items_border_bottom .';'; } ?> <?php if( $items_border_left != '' ) { echo 'border-left:'. $items_border_left .';'; } ?> border-radius: <?= $item_top_left_radius ?> <?= $item_top_right_radius ?> <?= $item_bottom_right_radius ?> <?= $item_bottom_left_radius ?>; border-style: <?= $item_border_style ?>; border-color: <?= $item_border_color ?>;">
							<a href="<?=$product_permalink;?>" class="product-link"></a>
							<div class="product-img">
							<?php 
				
							if( $product_image_url_optimized ) {
								?><img width="300" height="300" alt="<?=$product_name;?>" src="<?=$product_image_url_optimized;?>"><?php
							}else {
								?><img width="300" height="300" alt="<?=$product_name;?>" src="<?=wc_placeholder_img_src();?>"><?php
							}
							
							?>
							</div>
							<?php 
							if( $product_is_on_sale ) {
								if( $product_off_type_status == 'percentage' ) {
								?><div class="price-discount percentage"><span><?= $percentage; ?>%</span></div><?php
								}
				
								if( $product_off_type_status == 'number' ) {
								?><div class="price-discount number"><span><?= number_format($price_off_number).' '.get_woocommerce_currency_symbol(); ?></span></div><?php
								}
							}
							?>
							<div class="swiper-product-details">
								
								<?php 
								
								if( $product_display_title == 'yes' ) {
									?><h3 <?= FusionBuilder::attributes( 'product-title' ) ?>><?=$product_name;?></h3><?php
								}
								
								if( $product_display_price == 'yes' ) {
								?>
								<span class="product-price<?php if($product_is_on_sale) { echo ' discounted'; } ?>">
									<?php echo $product_price_html; ?>
								</span>
								<?php
								}
								?>
				
								<?php 
									if( $product_addtocart_button == 'yes' ) : 
										if( $product_display_price == 'yes' ) :
											?>
											
											<span class="addtocart-icon">
                                                <a href="<?php echo ( $product->is_type('simple') ) ? '?add-to-cart=' . $product_id : $product_permalink; ?>"
                                                  <?= FusionBuilder::attributes( 'special-carousel-add-to-cart' ) ?> 
                                                  target="_blank" 
                                                  data-quantity="1" 
                                                  data-product_id="<?= $product_id; ?>" 
                                                  data-product_sku=""
                                                  data-product_sku="<?= esc_attr( $product->get_sku() ); ?>"
                                                  aria-label="<?= $product_title; ?>" 
                                                  rel="nofollow">
                                                    <span class="tooltip-text">
                                                        <?php echo $product->add_to_cart_text(); ?>
                                                    </span>
                                                    <i class="<?php echo $addtocart_button_icon; ?>" aria-hidden="true"></i>
                                                </a>
                                            </span>

											<?php 
										endif;
									endif; 
								?>
				
								<div class="product-off-timer js-counter" style="<?php if( $product_timer_color != '' ) { echo 'color:'. $product_timer_color . ';'; } ?> <?php if( $product_timer_status == 'yes' && $product_on_sale_to_final != null ) { echo 'display: block;'; }else { echo 'display: none;'; } ?>" data-countdown="<?=$product_on_sale_to_final;?>"></div>
				
							</div>
				
						</div>
						<?php
				
					}

					if( $display_last_slide == 'yes' ) {

						?>
						<div class="carousel swiper-slide <?php if( $product_addtocart_button == 'yes' ) { echo 'add-to-cart'; }else { echo 'no-add-to-cart'; } ?> <?php if( $product_display_title == 'no' ) { echo 'no-title'; } ?> <?php if( $product_display_price == 'no' ) { echo 'no-price'; } ?> <?php if( $product_timer_status == "yes" ) { echo 'is-timer'; } ?>" style="<?php if( $items_border_top != '' ) { echo 'border-top:'. $items_border_top .';'; } ?> <?php if( $items_border_right != '' ) { echo 'border-right:'. $items_border_right .';'; } ?> <?php if( $items_border_bottom != '' ) { echo 'border-bottom:'. $items_border_bottom .';'; } ?> <?php if( $items_border_left != '' ) { echo 'border-left:'. $items_border_left .';'; } ?> border-radius: <?= $item_top_left_radius ?> <?= $item_top_right_radius ?> <?= $item_bottom_right_radius ?> <?= $item_bottom_left_radius ?>; border-style: <?= $item_border_style ?>; border-color: <?= $item_border_color ?>;">
							<div class="show-more-section">
								<a href="<?= $current_terms_link ?>" class="show-more-products-irava" target="_blank">
								<div class="show-more-icon">
									<img width="300" height="300" src="<?php echo get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/carousel/img/last-item-carousel-ok.svg'; ?>" alt="show all" />
								</div>
								<div class="show-more-text" style="width: 100%;">
									<span><?=$carsouelBtnText;?></span>
								</div>
								</a>
							</div>
						</div>
						<?php

					}
					// End Loop
					?>
				</div>
				<div class="swiper-button-next"></div>
  				<div class="swiper-button-prev"></div>
				<?php

			} // End Check Template Name

			wp_die();

		}

        public function iravada_woocommerce_product_data_tabs( $tabs ) {

            $tabs['shegeftangiz'] = array(
            'label'    => __("Special Offer",$this->lang),
            'target'   => 'shegeftangiz_data',
            'class'    => array("show_if_variable show_if_simple"),
            'priority' => 19,
            );
            return $tabs;

        }

        public function iravada_woocommerce_product_data_panels() {

			wp_enqueue_style("{$this->td}_product-edit", get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/backend/css/product-edit.css');
            wp_enqueue_script("{$this->td}_product-edit", get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/backend/js/product-edit.js', array("jquery") );

            echo '<div id="shegeftangiz_data" class="panel woocommerce_options_panel hidden">';

                woocommerce_wp_checkbox( array(
                    'id'            => '_iranavadasopc',
                    'value'         => get_post_meta( get_the_ID(), '_iranavadasopc', true ),
                    'label'         => __("Special Offering",$this->lang),
                'description'   => __("Check if this is an Special Offering product",$this->lang),
                'desc_tip'      => true,
                ));

                ?>
                    <p class="form-field _iranavadasopc_date_field_helper_2 show_if_simple" style="padding: 1rem !important;">
                    <?=sprintf(_x("Special Offering Date Start and End could be set from %s.","wc-helper",$this->lang),"<a href='#general_product_data' class='nivigatetowcproductmeta'>"._x("General Tab","wc-helper",$this->lang)."</a>");?>
                    </p>
                    <p class="form-field _iranavadasopc_date_field_helper show_if_variable" style="padding: 1rem !important;">
                    <?=_x("Special Offering Date End can be set from Datepicker below.","wc-helper",$this->lang);?>
                    </p>
                <?php

                woocommerce_wp_text_input( array(
                'id'            => '_iranavadasopc_date_fa',
                'value'         => get_post_meta( get_the_ID(), '_iranavadasopc_date_fa', true ),
                'label'         => __("Offering End Date",$this->lang),
                'wrapper_class' => 'show_if_variable',
                'style'         => 'width: 150px;',
                'description'   => __("Set Special Offering finish date<br>(at 23:59:59)",$this->lang),
                'desc_tip'      => true,
                ) );
                woocommerce_wp_hidden_input( array(
                'id'            => '_iranavadasopc_date',
                'wrapper_class' => 'show_if_variable show_if_simple',
                'value'         => get_post_meta( get_the_ID(), '_iranavadasopc_date', true ),
                ) );

            echo '</div>';

        }

		/**
		 * Gets the query data.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @param array $defaults An array of defaults.
		 * @return void
		 */
		public function irava_ajax_query( $defaults ) {
			check_ajax_referer( 'fusion_load_nonce', 'fusion_load_nonce' );
			$this->query( $defaults );
		}

		public function wp_enqueue_scripts($hook)
        {
            
			// Countdown Script Js
			wp_enqueue_script( 'countdown-script', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/frontend/js/countdown-custom-script.js', array('jquery'), '10.4', true );

			// Main Assets
			wp_enqueue_style( 'filter-category-style', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/frontend/css/category-filter-style.css', '', '10.4' );
			wp_enqueue_style( 'main-swiper-style', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/frontend/css/swiper-bundle.min.css', '', '10.4' );
			wp_enqueue_script( 'main-swiper-script', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/frontend/js/swiper-bundle.min.js', array('jquery'), '10.4', true );
			wp_enqueue_script( 'filter-category-script', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/assets/frontend/js/category-filter-script.js', array('jquery'), '10.4', true );
			
			// Template Assets ==> Casrousel
			wp_register_style( 'carousel-style', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/carousel/css/template-style.css', '', '10.4' );
			wp_register_script( 'carousel-script', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/carousel/js/template-script.js', array('jquery'), '10.4', true );

			
			// Template Assets ==> Slider
			wp_register_style( 'slider-style', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/slider/css/template-style.css', '', '10.4' );
			wp_register_script( 'slider-script', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/slider/js/template-script.js', array('jquery'), '10.4', true );
			
			// Template Assets ==> brands
			wp_register_style( 'brands-style', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/brands/css/template-style.css', '', '10.4' );
			wp_register_script( 'brands-script', get_stylesheet_directory_uri() . '/includes/royal-elements/includes/special-product-swiper/template/brands/js/template-script.js', array('jquery'), '10.4', true );

            wp_register_script("iranavadasopc.countdown", "{$this->special_assets_url}/frontend/js/jquery.countdown.min.js", array("jquery"), $this->version, true);
            wp_localize_script(
                "iranavadasopc.countdown", '_i18n', array(
                "text_days"  => __("Days", $this->lang),
                "text_hours" => __("Hours", $this->lang),
                "text_mins"  => __("Minutes", $this->lang),
                "text_secs"  => __("Seconds", $this->lang),
                )
            );

			wp_localize_script( 'filter-category-script', 'special_element_options', array( 
				'ajax_url' => admin_url('admin-ajax.php')
			) );
            
        }

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				'class'			  		  				=> '',
				'id'			  		  				=> '',
                'hide_on_mobile'  		  				=> fusion_builder_default_visibility( 'array' ), 
				'select_slider'		  					=> 'carousel',
				'irava_display_title'                   => 'yes',
				'irava_display_price'					=> 'yes',
				'irava_banner_show_all_button_color'    => '#fff',
				'responsive_min_0'	  	  				=> '2',
				'responsive_min_480'	  				=> '3',
				'responsive_min_720'	  				=> '4',
				'responsive_min_960'	  				=> '5',
				'responsive_min_1200'	  				=> '6',
				'carousel_button_name'	  				=> 'نمایش همه',
				'btn_link'				  				=> '',
				'cat_slug'        		  				=> '',
				'cat_filter_default'					=> '',
				'shegeftangiz'	  		  				=> 'no',
				'discounted_products'	  				=> '',
				'show_timer'			  				=> 'yes',
				'carousel_banner'						=> '',
				'display_product_limit'					=> '',
				'irava_orderby'							=> 'date',
				'irava_product_type'					=> '',
				'irava_sortby'							=> 'DESC',
				'display_banner_button'					=> 'no',
				'slider_heading_text'					=> '',
				'slider_template_font_icon'				=> '',
				'border_top'    						=> '0px',
				'border_right'  						=> '0px',
				'border_bottom' 						=> '0px',
				'border_left'   						=> '0px',
				'special_offer_item_border_style'		=> '',
				'border_radius_top_left'            	=> '0px',
                'border_radius_top_right'           	=> '0px',
                'border_radius_bottom_right'        	=> '0px',
                'border_radius_bottom_left'         	=> '0px',
				'special_offer_item_border_color'		=> '',
				'slider_title_text_banner_image'		=> 'text',
				'display_percentage_number_off'			=> 'percentage',
				'special_carousel_stop_on_last'			=> 'false',
				'irava_display_last_slide'				=> '',
				'hero_img_height_pc'                    => '260px',
				'hero_img_height_mobile'                => '200px',
				// 'carousel_items_gap'                    => '17px',

				// Add To Cart Style Defaults
				'enable_disable_addtocart_button'		=> 'no',
				'addtocart_button_icon_carousel'		=> '',
				'addtocart_background_color'			=> '',
				'addtocart_icon_color'					=> '',

				// Background Setting Default Option
				'irava_background_color'				=> '',
				'irava_background_image'				=> '',
				'irava_background_repeat'				=> 'repeat',
				'irava_background_position'				=> 'center center',

				// Product Title Setting
				'irava_product_title_color'				=> '',

				// Product Sale Price Setting Values
				'irava_product_sale_price_font_color'	=> '',

				// Product Del Price Setting Values
				'irava_product_del_price_font_color'	=> '',
				
				// Product Category Filter Setting Values
				'special_carousel_cat_filter'					=> 'no',
				'filter_seperator_line_height'                  => '1px',
				'filter_seperator_line_color'                   => '#dbdbdb',
				'cat_filter_title'								=> '',
				'view_all_btn_text_ajax_cat_filter'				=> 'محصولات این دسته ',
				'view_all_btn_cat_filter'						=> '',
				'cat_filter_border_top'							=> '0px',
				'cat_filter_border_right'						=> '0px',
				'cat_filter_border_bottom'						=> '2px',
				'cat_filter_border_left'						=> '0px',
				'cat_filter_items_border_color'					=> 'transparent',
				'cat_filter_items_color'						=> '',
				'carousel_filter_cat_background_color'			=> '',
				'active_cat_filter_items_color'					=> '#1b1f22',
				'active_carousel_filter_cat_background_color'	=> 'transparent',
				'view_all_cat_filter_btn_link'					=> '',
				'active_cat_filter_items_border_color'          => '#00c095',
				'border_radius_top_left_item'                   => '0px',
				'border_radius_top_right_item'                  => '0px',
				'border_radius_bottom_right_item'               => '0px',
				'border_radius_bottom_left_item'                => '0px',
                'padding_top'                                   => '8px',
                'padding_right'                                 => '0px',
                'padding_bottom'                                => '8px',
                'padding_left'                                  => '0px',
                'cat_filter_item_gap'                           => '20px',

				// Product Special Offer Time
				'irava_off_timer_color'                 => '',

				// Auto Play And Auto Play Time Values
				'special_carousel_auto_play_set'		=> '',
				'special_carousel_auto_play_time'		=> '',
				'special_carousel_rewind'               => '',

				// Brand Default Value
				'iravada_royal_brands'						=> '',
				'select_link_target_type'					=> '_blank',
				'irava_brands_gray_scale'					=> '',
				'royal_brands_background'					=> '#fff',
				'brand_carousel_padding_top'    			=> '15px',
				'brand_carousel_padding_right'  			=> '0px',
				'brand_carousel_padding_bottom' 			=> '15px',
				'brand_carousel_padding_left'   			=> '0px',
				'brand_items_border_top'    				=> '0px',
				'brand_items_border_right'  				=> '0px',
				'brand_items_border_bottom' 				=> '0px',
				'brand_items_border_left'   				=> '0px',
				'border_radius_top_left_brand'     			=> '0px',
				'border_radius_top_right_brand'    			=> '0px',
				'border_radius_bottom_right_brand' 			=> '0px',
				'border_radius_bottom_left_brand'  			=> '0px',
				'royal_brand_items_border_color'			=> '',
				'iravada_royal_brand_title_font_size'		=> '15px',
				'royal_brand_items_title_font_color'		=> '#383838',
				'special_brand_carousel_auto_play_set'		=> '',
				'special_brand_carousel_auto_play_time'		=> '',
				'special_brand_loop_status'                 => 'true',
				'royal_brand_limit_display_items'           => '12',
            ];						
			
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {

			global // All Variable Global In Bottom
			
			$get_template_name,
			$irava_display_title,
			$irava_display_price,
			$carousel_banner,
			$responsive_min_0,
			$responsive_min_480,
			$responsive_min_720,
			$responsive_min_960,
			$responsive_min_1200,
			$carousel_button_text,
			$Carousel_button_link,
			$category,
			$shegeftangiz,
			$discounted_products,
			$Show_timer,
			$timerColor,
			$display_product_limit,
			$irava_orderby,
			$irava_product_type,
			$irava_sortby,
			$display_banner_button,
			$id,
			$slider_heading_text,
			$slider_template_font_icon,
			$slider_title_text_banner_image,
			$enable_disable_addtocart_button,
			$display_percentage_number_off,
			$addtocart_button_icon,
			$auto_play_on_off,
			$auto_play_time,
			$rewind_carousel,
			$stop_on_last_slide,
			$special_carousel_cat_filter,
			$cat_filter_default,
			$cat_filter_title,
			$view_all_btn_cat_filter,
			$irava_display_last_slide,
			$view_all_btn_text_ajax_cat_filter,
			$active_cat_filter_items_color,
			$active_carousel_filter_cat_background_color,
			$view_all_cat_filter_btn_link,
			$active_cat_filter_items_border_color,
			$border_radius_top_left_item,
			$border_radius_top_right_item,
			$border_radius_bottom_right_item,
			$border_radius_bottom_left_item,
			$iravada_royal_brands,
			$select_link_target_type,
			$special_brand_carousel_auto_play_set,
			$special_brand_carousel_auto_play_time,
			$special_brand_loop_status,
			$royal_brand_limit_display_items;
// 			$carousel_items_gap;
			
			$fusion_settings 	= fusion_get_fusion_settings();		
			$defaults 			= FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_special_carousel' );
			$this->args 		= $defaults;

			$get_template_name = $this->args['select_slider'];
			
			$irava_display_title = $this->args['irava_display_title'];
			$irava_display_price = $this->args['irava_display_price'];
			// Get Responsive In Global -> Carousel Template
			$responsive_min_0 		= $this->args['responsive_min_0'];	
			$responsive_min_480 	= $this->args['responsive_min_480'];	
			$responsive_min_720 	= $this->args['responsive_min_720'];	
			$responsive_min_960 	= $this->args['responsive_min_960'];	
			$responsive_min_1200 	= $this->args['responsive_min_1200'];	
			
			// Generate Random ID For Slider Loop.php
			$id							= 'iranavada-'.rand();

            // Carousel Items Gap
            // $carousel_items_gap         = $this->args['carousel_items_gap'];

			// Timer Color
			$timerColor 				= $this->args['irava_off_timer_color'];

			// Get Slider Heading Text For Loop.php
			$slider_heading_text		= $this->args['slider_heading_text'];

			// Get Button Text In Global For Loop.php
			$carousel_button_text		= $this->args['carousel_button_name'];

			// Get Carousel Button Link For Loop.php
			$Carousel_button_link		= $this->args['btn_link'];

			// Get Carousel Banner Template For Loop.php
			$carousel_banner			= $this->args['carousel_banner'];

			// Get Product Category Slug
			$category					= $this->args['cat_slug'];

			// Get All Royal Brand Options
			$select_link_target_type	= $this->args['select_link_target_type'];
			$iravada_royal_brands		= $this->args['iravada_royal_brands'];
			$special_brand_carousel_auto_play_set 	= $this->args['special_brand_carousel_auto_play_set'];
			$special_brand_carousel_auto_play_time 	= $this->args['special_brand_carousel_auto_play_time'];
			$special_brand_loop_status              = $this->args['special_brand_loop_status'];
			$royal_brand_limit_display_items        = $this->args['royal_brand_limit_display_items'];

			// Get Amazing Product List For Loop.php
			$shegeftangiz				= $this->args['shegeftangiz'];

			// Get Show Timer Or Not For Loop.php
			$Show_timer					= $this->args['show_timer'];

			// Get Limit Number Display Product For Lopp.php
			$display_product_limit		= $this->args['display_product_limit'];

			// Get All Discount Product List For Loop.php
			$discounted_products		= $this->args['discounted_products'];

			// Get OrderBy Type Display Product For Loop.php
			$irava_orderby				= $this->args['irava_orderby'];

			// Get Product Type Display For Loop.php
			$irava_product_type			= $this->args['irava_product_type'];

			// Get SortBy Type Display Product For Loop.php
			$irava_sortby				= $this->args['irava_sortby'];

			// Get Display Banner Or Not Carousel For Loop.php
			$display_banner_button		= $this->args['display_banner_button'];

			// Get Banner Url For Slider Template Loop.php
			$slider_template_font_icon	= $this->args['slider_template_font_icon'];

			// Get The Display Type Of Slider Banner Or Text For Loop.php
			$slider_title_text_banner_image	= $this->args['slider_title_text_banner_image'];

			// Enable Add to Cart Button in Carousel
			$enable_disable_addtocart_button	= $this->args['enable_disable_addtocart_button'];

			// Get Off Value Type (number/percentage)
			$display_percentage_number_off	= $this->args['display_percentage_number_off'];

			// Get Category Filter Status
			$special_carousel_cat_filter = $this->args['special_carousel_cat_filter'];

			// Get Last Slide Status
			$irava_display_last_slide = $this->args['irava_display_last_slide'];

			// Get Cat Filter Default
			$cat_filter_default = $this->args['cat_filter_default'];
			$cat_filter_title = $this->args['cat_filter_title'];
			$view_all_btn_cat_filter = $this->args['view_all_btn_cat_filter'];
			$view_all_btn_text_ajax_cat_filter = $this->args['view_all_btn_text_ajax_cat_filter'];
			$active_cat_filter_items_color	= $this->args['active_cat_filter_items_color'];
			$active_carousel_filter_cat_background_color = $this->args['active_carousel_filter_cat_background_color'];
			$view_all_cat_filter_btn_link = $this->args['view_all_cat_filter_btn_link'];
			$active_cat_filter_items_border_color = $this->args['active_cat_filter_items_border_color'];
			$border_radius_top_left_item = $this->args['border_radius_top_left_item'];
			$border_radius_top_right_item = $this->args['border_radius_top_right_item'];
			$border_radius_bottom_right_item = $this->args['border_radius_bottom_right_item'];
			$border_radius_bottom_left_item = $this->args['border_radius_bottom_left_item'];

			// Get Icon Css Class
			if( $this->args['addtocart_button_icon_carousel'] == '' ) {
			    $addtocart_button_icon	= 'iravaadmicon-royal-icon-b';
			}else {
			    if( $this->args['addtocart_button_icon_carousel'] ) {
			        $addtocart_button_icon	= fusion_font_awesome_name_handler($this->args['addtocart_button_icon_carousel']);
			    }
			}

			// JS Play Carousel Values
			$auto_play_on_off = $this->args['special_carousel_auto_play_set'];
			$auto_play_time   = $this->args['special_carousel_auto_play_time'];
			$rewind_carousel  = $this->args['special_carousel_rewind'];
			$stop_on_last_slide = $this->args['special_carousel_stop_on_last'];

			ob_start();

				?>
                    <style>
                        @media only screen and (max-width: 480px) {
                            .swiper-button-next, .swiper-rtl .swiper-button-prev {
                                display: none !important;
                            }
                        }
                    </style>
					<div <?= FusionBuilder::attributes( 'iravada-special-product-carousel' ) ?> >
						<?php include $this->special_dir_path . "/template/$get_template_name/loop.php"; ?>
					</div>
				<?php

				wp_enqueue_script(  "iranavadasopc.countdown");

				wp_enqueue_style( "{$get_template_name}-style" );
				wp_enqueue_script( "{$get_template_name}-script" );

			return ob_get_clean();
			

		}

        public function save_iravada_product_options( $post_id ) {

            $_iranavadasopc = isset($_POST["_iranavadasopc"]) ? "yes" : "no";
            $_iranavadasopc_date = isset($_POST["_iranavadasopc_date"]) ? $_POST["_iranavadasopc_date"] : "";
            $_iranavadasopc_date_fa = isset($_POST["_iranavadasopc_date_fa"]) ? $_POST["_iranavadasopc_date_fa"] : "";
            $product = wc_get_product($post_id);
            $product->update_meta_data("_iranavadasopc", $_iranavadasopc);
            $product->update_meta_data("_iranavadasopc_date", $_iranavadasopc_date);
            $product->update_meta_data("_iranavadasopc_date_fa", $_iranavadasopc_date_fa);
			$product->save();			

        }

		public function my_body_classes( $classes ) {
 
			$classes[] = 'class-name';
			 
			return $classes;
			 
		}		

		public function wrapper_carousel() {

            global $Show_timer, $enable_disable_addtocart_button, $irava_display_title, $irava_display_price;

			$attr = [ 
				'class' => 'carousel ' . $this->unique_class,
				'style' => '' 
			];
			
			$attr['class'] .= 'swiper-slide';

			if( $Show_timer == "yes" ) { 
			   $attr['class']  .= ' is-timer';
			}
			
			if( $irava_display_price == 'no' ) {
				$attr['class']  .= ' no-price';
			}

			if( $irava_display_title == 'no' ) {
			    $attr['class']  .= ' no-title';
			}
			
			if( $enable_disable_addtocart_button == "yes" ) {
			    $attr['class']  .= ' add-to-cart';
			}else {
				$attr['class']  .= ' no-add-to-cart';
			}
			
			if( $this->args['border_top'] != '' ) {
				$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 
			}
			
			if( $this->args['border_right'] != '' ) {
				$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 
			}

			if( $this->args['border_bottom'] != '' ) {
				$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 
			}

			if( $this->args['border_left'] != '' ) {
				$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';';
			}
			
			if( $this->args['special_offer_item_border_style'] == 'dashed' ) {
				$attr['style'] .= 'border-style: dashed;'; 
			}

			if( $this->args['special_offer_item_border_style'] == 'solid' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			if( $this->args['special_offer_item_border_style'] == 'dotted' ) {
				$attr['style'] .= 'border-style: dotted;'; 
			}

			$attr['style'] .= 'border-color:' .  $this->args['special_offer_item_border_color'] .';'; 

            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
            
			return $attr;

		}

		// Grid Template
		public function wrapper_grid() {

			$attr = [ 
				'class' => 'grid ' . $this->unique_class,
				'style' => '' 
			];
			
			$attr['class'] .= 'swiper-slide';

			if( $this->args['border_top'] != '' ) {
				$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top'] ).';'; 
			}
			
			if( $this->args['border_right'] != '' ) {
				$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right'] ).';'; 
			}

			if( $this->args['border_bottom'] != '' ) {
				$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom'] ).';'; 
			}

			if( $this->args['border_left'] != '' ) {
				$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left'] ).';';
			}
			
			if( $this->args['special_offer_item_border_style'] == 'dashed' ) {
				$attr['style'] .= 'border-style: dashed;'; 
			}

			if( $this->args['special_offer_item_border_style'] == 'solid' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			if( $this->args['special_offer_item_border_style'] == 'dotted' ) {
				$attr['style'] .= 'border-style: dotted;'; 
			}

			$attr['style'] .= 'border-color:' .  $this->args['special_offer_item_border_color'] .';'; 

            $attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
            
			return $attr;
			
		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */

		public function wrapper_fusion_special_carousel() {

			$attr = [ 
				'class' => 'iravada-special-product-carousel ' . $this->unique_class,
				'style' => '' 
			];

			if( $this->args['irava_product_del_price_font_color'] == '' ) {
				$attr['style']	.= '--irava-del-price-color: #f63348;';
			}else {
				$attr['style']	.= '--irava-del-price-color: '. $this->args['irava_product_del_price_font_color'] .' ;';
			}

			if( $this->args['irava_product_sale_price_font_color'] == '' ) {
				$attr['style']	.= '--irava-sale-price-color: #56798c;';
			}else {
				$attr['style']	.= '--irava-sale-price-color: '. $this->args['irava_product_sale_price_font_color'] .' ;';
			}

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;

		}

		public function wrapper_irava_hero_img() {

            global $Show_timer, $enable_disable_addtocart_button, $irava_display_title;

			$attr = [ 
				'class' => 'irava-hero-img ' . $this->unique_class,
				'style' => '' 
			];

			if( $Show_timer == "yes" ) { 
			   $attr['class']  .= ' is-timer';
			}
			
			if( $irava_display_title == 'no' ) {
			    $attr['class']  .= ' no-title';
			}
			
			if( $enable_disable_addtocart_button == "yes" ) {
			    $attr['class']  .= ' add-to-cart';
			}
            
			return $attr;

		}

        public function wrapper_product_off_timer() {
            
            global $product_on_sale_to_final,$Show_timer, $id;

            $attr = [ 
				'class' => 'product-off-timer ' . $this->unique_class,
				'style' => '' 
			];
            
            $attr['class'] .= ' js-counter';
            
            if( $product_on_sale_to_final == null or $Show_timer == 'no' ) {
                $attr['style'] .= 'display: none;';
            }
            
			if( $this->args['irava_off_timer_color'] != '' ) {
				$attr['style'] .= 'color: '. $this->args['irava_off_timer_color'] .';';
			}
            
            return $attr;
        }

		public function wrapper_special_carousel_add_to_cart() {

			$attr = [ 
				'class' => 'special-carousel-add-to-cart ' . $this->unique_class,
				'style' => '' 
			];
            
			$attr['style'] .= 'background:'. $this->args['addtocart_background_color'] .';';
			$attr['style'] .= 'color:'. $this->args['addtocart_icon_color'] .';';

			return $attr;

		}

		public function wrapper_product_title() {

			$attr = [ 
				'class' => 'product-title ' . $this->unique_class,
				'style' => '' 
			];

			if( isset($this->args['irava_product_title_color']) ) {
				$attr['style']	.= 'color: '. $this->args['irava_product_title_color'] .' ;';
			}
			
			return $attr;
		}
		
		public function wrapper_hero_img() {
		    
			$attr = [ 
				'class' => 'hero-img ' . $this->unique_class,
				'style' => '' 
			];
 
			$attr['style']	.= '--max-height-pc: '. fusion_library()->sanitize->get_value_with_unit( $this->args['hero_img_height_pc'] ) .';';
			$attr['style']	.= '--max-height-mobile: '. fusion_library()->sanitize->get_value_with_unit( $this->args['hero_img_height_mobile'] ) .';';
			
			return $attr;
		    
		}

		public function wrapper_regular_price() {

			$attr = [ 
				'class' => 'regular-price ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style']	.= 'color: '. $this->args['irava_product_sale_price_font_color'] .' ;';

			return $attr;
		}

		public function wrapper_irava_filter_item() {

			$attr = [ 
				'class' => 'irava-filter-item ' . $this->unique_class,
				'style' => '' 
			];

			global $product_on_sale_to_final,$Show_timer, $id;

			if( $this->args['cat_filter_border_top'] != '' ) {
				$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_top'] ).';'; 
			}
			
			if( $this->args['cat_filter_border_right'] != '' ) {
				$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_right'] ).';'; 
			}

			if( $this->args['cat_filter_border_bottom'] != '' ) {
				$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_bottom'] ).';'; 
			}

			if( $this->args['cat_filter_border_left'] != '' ) {
				$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_left'] ).';';
			}

			if( $this->args['cat_filter_border_top'] != '' or $this->args['cat_filter_border_right'] != '' or $this->args['cat_filter_border_bottom'] != '' or $this->args['cat_filter_border_left'] != '' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			$attr['style'] .= 'border-color:' .  $this->args['cat_filter_items_border_color'] .';'; 
			
			if( $this->args['carousel_filter_cat_background_color'] != '' ) {
				$attr['style'] .= 'background: '. $this->args['carousel_filter_cat_background_color'] .';';
			}

			if( $this->args['cat_filter_items_color'] != '' ) {
				$attr['style'] .= 'color: '. $this->args['cat_filter_items_color'] .';';
			}
			
			$attr['style'] .= 'padding: '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_top']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_bottom']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_left']) .';';
			   
			return $attr;

		}

		public function wrapper_irava_cat_filter_first_item() {

			$attr = [ 
				'class' => 'irava-cat-filter-first-item ' . $this->unique_class,
				'style' => '' 
			];

			$attr['class'] .= 'irava-filter-item active';

			if( $this->args['cat_filter_border_top'] != '' ) {
				$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_top'] ).';'; 
			}
			
			if( $this->args['cat_filter_border_right'] != '' ) {
				$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_right'] ).';'; 
			}

			if( $this->args['cat_filter_border_bottom'] != '' ) {
				$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_bottom'] ).';'; 
			}

			if( $this->args['cat_filter_border_left'] != '' ) {
				$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_border_left'] ).';';
			}

			if( $this->args['cat_filter_border_top'] != '' or $this->args['cat_filter_border_right'] != '' or $this->args['cat_filter_border_bottom'] != '' or $this->args['cat_filter_border_left'] != '' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			if( $this->args['cat_filter_items_border_color'] != '' ) {
				$attr['style'] .= 'border-color:' .  $this->args['cat_filter_items_border_color'] .';'; 
			}

			if( $this->args['carousel_filter_cat_background_color'] != '' ) {
				$attr['style'] .= 'background: '. $this->args['carousel_filter_cat_background_color'] .';';
			}

			if( $this->args['cat_filter_items_color'] != '' ) {
				$attr['style'] .= 'color: '. $this->args['cat_filter_items_color'] .';';
			}

            $attr['style'] .= 'padding: '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_top']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_right']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_bottom']) .' '. fusion_library()->sanitize->get_value_with_unit($this->args['padding_left']) .';';

			return $attr;

		}

		public function wrapper_iravada_swiper_filter() {

			global $id, $active_cat_filter_items_color, 
			$active_carousel_filter_cat_background_color,
			$border_radius_top_left_item,
			$border_radius_top_right_item,
			$border_radius_bottom_right_item,
			$border_radius_bottom_left_item; 
			
			$attr = [ 
				'class' => 'iravada-swiper-filter ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style'] .= '--active-color-cat-item: '. $active_cat_filter_items_color .';';
			$attr['style'] .= '--active-background-cat-item: '. $active_carousel_filter_cat_background_color .';';
			$attr['style'] .= '--active-border-color-item: '. $this->args['active_cat_filter_items_border_color'] .';';
			$attr['style'] .= '--border-radius-top-left-item: '. fusion_library()->sanitize->get_value_with_unit( $border_radius_top_left_item ) .';';
			$attr['style'] .= '--border-radius-top-right-item: '. fusion_library()->sanitize->get_value_with_unit( $border_radius_top_right_item ) .';';
			$attr['style'] .= '--border-radius-bottom-right-item: '. fusion_library()->sanitize->get_value_with_unit( $border_radius_bottom_right_item ) .';';
			$attr['style'] .= '--border-radius-bottom-left-item: '. fusion_library()->sanitize->get_value_with_unit( $border_radius_bottom_left_item ) .';';
			
			$attr['style'] .= 'gap: '. fusion_library()->sanitize->get_value_with_unit( $this->args['cat_filter_item_gap'] ) .';';
			
			$attr['class'] .= $id;

			return $attr;

		}
		
		public function wrapper_show_more_product_text() {
		    
		    $attr = [ 
				'class' => 'show-more-product-text ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style']	.= 'color: '. $this->args['irava_banner_show_all_button_color'] .' ;';

			return $attr;
		    
		}

		public function wrapper_royal_brand() {

			$attr = [ 
				'class' => 'royal_brand ' . $this->unique_class,
				'style' => '' 
			];

			$attr['class'] .= 'swiper-slide';

			if( $this->args['irava_brands_gray_scale'] == 'yes' ) {
				$attr['class'] .= ' brands-gray-scale';
			}

			if( $this->args['brand_items_border_top'] != '' ) {
				$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['brand_items_border_top'] ).';'; 
			}
			
			if( $this->args['brand_items_border_right'] != '' ) {
				$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['brand_items_border_right'] ).';'; 
			}

			if( $this->args['brand_items_border_bottom'] != '' ) {
				$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['brand_items_border_bottom'] ).';'; 
			}

			if( $this->args['brand_items_border_left'] != '' ) {
				$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['brand_items_border_left'] ).';';
			}

			if( $this->args['brand_items_border_top'] != '' or $this->args['brand_items_border_right'] != '' or $this->args['brand_items_border_bottom'] != '' or $this->args['brand_items_border_left'] != '' ) {
				$attr['style'] .= 'border-style: solid;'; 
			}

			if( $this->args['royal_brand_items_border_color'] != '' ) {
				$attr['style'] .= 'border-color:' .  $this->args['royal_brand_items_border_color'] .';'; 
			}

			$attr['style'] .=  'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left_brand'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right_brand'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right_brand'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left_brand'] ) .'; ';  

			$attr['style'] .= 'background: '. $this->args['royal_brands_background'] .';';
			

			return $attr;

		}

		public function wrapper_royal_brand_detail() {

			$attr = [ 
				'class' => 'royal-brand-detail ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style'] .= 'padding: '. fusion_library()->sanitize->get_value_with_unit( $this->args['brand_carousel_padding_top'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['brand_carousel_padding_right'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['brand_carousel_padding_bottom'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['brand_carousel_padding_left'] ) .';';

			return $attr;

		}

		public function wrapper_irava_brand_name() {

			$attr = [ 
				'class' => 'irava-brand-name ' . $this->unique_class,
				'style' => '' 
			];

			$attr['style'] .= 'font-size: '. fusion_library()->sanitize->get_value_with_unit( $this->args['iravada_royal_brand_title_font_size'] ) .';';
			$attr['style'] .= 'color: '. $this->args['royal_brand_items_title_font_color'] .';';

			return $attr;

		}
		
		public function wrapper_iranavada_view_current_filter_line() {
		    
		    $attr = [ 
				'class' => 'iranavada-view-current-filter-line ' . $this->unique_class,
				'style' => '' 
			];
			
			$attr['style'] .= 'height: '. fusion_library()->sanitize->get_value_with_unit( $this->args['filter_seperator_line_height'] ) .';';
			$attr['style'] .= 'background: '. $this->args['filter_seperator_line_color'] .';';

			return $attr;
		    
		}
		
	}
	new iravada_special_carousel();
}

function iranavada_shortcodes_categories( $taxonomy, $empty_choice = false, $empty_choice_label = false, $max_cat = 0 ) {

	if ( ! $empty_choice_label ) {
		$empty_choice_label = esc_attr__( 'Default', 'fusion-builder' );
	}
	$post_categories = [];

	if ( $empty_choice ) {
		$post_categories[ $empty_choice_label ] = '';
	}

	$get_categories = get_categories( 'hide_empty=0&taxonomy=' . $taxonomy . '&number=' . $max_cat );

	if ( $get_categories && is_array( $get_categories ) ) {
		foreach ( $get_categories as $cat ) {
			if ( isset( $cat->slug ) && isset( $cat->name ) ) {
				$label                                      = $cat->name . ( ( isset( $cat->count ) ) ? ' (' . $cat->count . ')' : '' );
				$post_categories[ urldecode( $cat->slug ) ] = $label;
			}
		}
	}

	return $post_categories;
}

function iravada_special_carousel_element() {

	if( !function_exists('fusion_builder_shortcodes_categories') ) {
		require_once( ABSPATH .'/wp-content/plugins/fusion-builder/inc/helpers.php' );
	}

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_special_carousel', 
            [
                'name'            => __( 'Royal Special Carousel' , 'royal' ),
                'shortcode'       => 'iravada_special_carousel',
                'icon'            => 'iravada_elements_icon',
                'allow_generator' => true,
                'params'          => 
                [

					[ 
						'type' => 'checkbox_button_set', 
						'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
						'param_name' => 'hide_on_mobile', 
						'value' => fusion_builder_visibility_options( 'full' ), 
						'default' => fusion_builder_default_visibility( 'array' ), 
						'description' => esc_attr__( 
							'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
							'fusion-builder' ),
						'group' => esc_attr__( 'General', 'fusion-builder' )
					], 

					[ 
						'type' => 'textfield', 
						'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
						'param_name' => 'class', 
						'value' => '', 
						'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
						'group' => esc_attr__( 'General', 'fusion-builder' ),
					], 

					[ 
						'type' => 'textfield', 
						'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
						'param_name' => 'id', 
						'value' => '', 
						'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
						'group' => esc_attr__( 'General', 'fusion-builder' ) 
					],

					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Select Slider', 'royal' ),
						'description' => __( 'Select the type of slider you want.', 'royal' ),
						'param_name'  => 'select_slider',
						'value'       => [
							'slider' 	  => __( 'Slider', 'royal' ),
							'carousel'    => __( 'Carousel', 'royal' ),
							'brands'      => __( 'Brand', 'royal' ),
						],
						'default'	  => 'carousel',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Carousel Auto Play', 'royal' ),
						'description' => __( 'Controls the automatic rotation of the carousel.', 'royal' ),
						'param_name'  => 'special_brand_carousel_auto_play_set',
						'value'       => [
							'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
							'false'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'default'	  => 'true',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'range',
						'heading'     => __( 'Auto Play Time', 'royal' ),
						'description' => __( 'Select The Auto Play You Need To Carousel Products.', 'royal' ),
						'param_name'  => 'special_brand_carousel_auto_play_time',
						'value'       => '7000',
						'min'         => '3000',
						'max'         => '15000',
						'step'        => '500',
						'dependency'       => [
							[
								'element'  => 'special_brand_carousel_auto_play_set',
								'value'    => 'true',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Brand Loop', 'royal' ),
						'description' => __( 'Controls the brand carouse loop status.', 'royal' ),
						'param_name'  => 'special_brand_loop_status',
						'value'       => [
							'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
							'false'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'default'	  => 'true',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'multiple_select',
						'heading'     => __( 'Brands', 'royal' ),
						'placeholder' => __( 'select brand for display or leave blank for all', 'royal' ),
						'description' => __( 'Select a brand or leave blank for all.', 'royal' ),
						'param_name'  => 'iravada_royal_brands',
						'value'       => fusion_builder_shortcodes_categories( 'iravada-royal-brands' ),
						'default'     => '',
						'callback'    => [
							'function' => 'fusion_ajax',
							'action'   => 'get_fusion_products',
							'ajax'     => true,
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'range',
						'heading'     => __( 'Limit Display Brand Items', 'royal' ),
						'description' => __( 'Select The Limit Number For Display Brand Default: 12.', 'royal' ),
						'param_name'  => 'royal_brand_limit_display_items',
						'value'       => '12',
						'min'         => '1',
						'max'         => '30',
						'step'        => '1',
						'dependency'       => [
							[
								'element'  => 'iravada_royal_brands',
								'value'    => '',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Select Link Target Brands', 'royal' ),
						'description' => __( 'Select the type of Open Link Brands Target.', 'royal' ),
						'param_name'  => 'select_link_target_type',
						'value'       => [
							'_self'    => esc_attr__( '_self', 'fusion-builder' ),
							'_blank'   => esc_attr__( '_blank', 'fusion-builder' ),
						],
						'default'	  => '_blank',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Grayscale Filter', 'royal' ),
						'description' => __( 'Select To Display Grayscale Style Status.', 'royal' ),
						'param_name'  => 'irava_brands_gray_scale',
						'value'       => [
							'yes'     => __( 'Yes', 'fusion-builder' ),
							'no' 	  => __( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'default'	  => 'yes',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type' => 'textfield', 
						'heading'     => __( 'Brand Title Font Size', 'royal' ),
                        'description' => __( 'Controls the font size of the brand title. Default: 15px', 'royal' ),
                        'param_name' => 'iravada_royal_brand_title_font_size', 
                        'value' => '', 
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'group' => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Brand Title Font Color', 'royal' ),
						'description' => __( 'Controls the brand title font color. Default: #383838', 'royal' ),
						'param_name'  => 'royal_brand_items_title_font_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Royal Brands Item Background', 'royal' ),
						'description' => __( 'Controls the Brands Items Background color. Default: #fff', 'royal' ),
						'param_name'  => 'royal_brands_background',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                        'param_name'  => 'brands_item_carousel_padding',
                        'value'       => [
                                'brand_carousel_padding_top'    => '',
                                'brand_carousel_padding_right'  => '',
                                'brand_carousel_padding_bottom' => '',
                                'brand_carousel_padding_left'   => '',
                        ],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
                    ],
					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => __( 'Brands Item Border Size', 'royal' ),
						'description'      => __( 'Controls the Brnads Item border size', 'royal' ),
						'param_name'       => 'royal_brand_items_border_sizes',
						'value'            => [
							'brand_items_border_top'    => '',
							'brand_items_border_right'  => '',
							'brand_items_border_bottom' => '',
							'brand_items_border_left'   => '',
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'dimension',
						'heading'     => __( 'Brands Item Border Radius', 'royal' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
						'param_name'  => 'royal_brand_items_border_radius',
						'value'       => [
							'border_radius_top_left_brand'     => '',
							'border_radius_top_right_brand'    => '',
							'border_radius_bottom_right_brand' => '',
							'border_radius_bottom_left_brand'  => '',
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
						'param_name'  => 'royal_brand_items_border_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Category Filter', 'royal' ),
						'description' => __( 'Select The Category FIlter Status For Carousel Products.', 'royal' ),
						'param_name'  => 'special_carousel_cat_filter',
						'value'       => [
							'yes'     => __( 'Yes', 'fusion-builder' ),
							'no' 	  => __( 'No', 'fusion-builder' ),
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'default'	  => 'no',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
					],
					[
						'type'        => 'textfield',
						'heading'     => __( 'Filter Seperator Line Height', 'royal' ),
						'description' => __( 'Enter The Seperator Line Height. Default: 1px', 'royal' ),
						'param_name'  => 'filter_seperator_line_height',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Filter Seperator Line Color', 'royal' ),
						'description' => esc_attr__( 'Controls The Filter Seperator line Color. Default: #dbdbdb', 'royal' ),
						'param_name'  => 'filter_seperator_line_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'select',
						'heading'     => __( 'Default Category Filter', 'royal' ),
						'description' => __( 'Choose The Default Category For First Item Filters', 'royal' ),
						'param_name'  => 'cat_filter_default',
						'value'       => fusion_builder_shortcodes_categories( 'product_cat' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'multiple_select',
						'heading'     => esc_attr__( 'Categories', 'fusion-builder' ),
						'placeholder' => esc_attr__( 'Categories', 'fusion-builder' ),
						'description' => esc_attr__( 'Select a category or leave blank for all.', 'fusion-builder' ),
						'param_name'  => 'cat_slug',
						'value'       => fusion_builder_shortcodes_categories( 'product_cat' ),
						'default'     => '',
						'callback'    => [
							'function' => 'fusion_ajax',
							'action'   => 'get_fusion_products',
							'ajax'     => true,
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'textfield',
						'heading'     => __( 'Filter Title Text', 'royal' ),
						'description' => __( 'Enter the name of the Filters Title On Top Of Carousel.', 'royal' ),
						'param_name'  => 'cat_filter_title',
						'value'       => 'محصولات ویژه',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],
					[
						'type'        => 'textfield',
						'heading'     => __( 'View All Filter Button', 'royal' ),
						'description' => __( 'Set View All Button Text. default: "All Products"', 'royal' ),
						'param_name'  => 'view_all_btn_cat_filter',
						'value'       => 'همه محصولات',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
					],
					[
						'type'        => 'link_selector',
						'heading'     => __( 'View All Button Link', 'royal' ),
						'description' => __( 'Put The View All Button Link From This Section.', 'royal' ),
						'param_name'  => 'view_all_cat_filter_btn_link',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],
					[
						'type'        => 'textfield',
						'heading'     => __( 'View All Button Text After Ajax Request', 'royal' ),
						'description' => __( 'Set View All Button Text After Complate Ajax Request. default: "View Current Cat Products"', 'royal' ),
						'param_name'  => 'view_all_btn_text_ajax_cat_filter',
						'value'       => 'محصولات این دسته',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
					],
					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => __( 'Filters Item Border Size', 'royal' ),
						'description'      => __( 'Controls the Filters Item border size', 'royal' ),
						'param_name'       => 'cat_filter_border_sizes',
						'value'            => [
							'cat_filter_border_top'    => '',
							'cat_filter_border_right'  => '',
							'cat_filter_border_bottom' => '',
							'cat_filter_border_left'   => '',
						],
						'dependency'       => [
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'dimension',
						'heading'     => __( 'Filters Item Border Radius', 'royal' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
						'param_name'  => 'cat_filter_item_border_radius',
						'value'       => [
							'border_radius_top_left_item'     => '',
							'border_radius_top_right_item'    => '',
							'border_radius_bottom_right_item' => '',
							'border_radius_bottom_left_item'  => '',
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
						'param_name'  => 'cat_filter_items_border_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Filter Background', 'royal' ),
						'description' => __( 'Controls the Filter Items Background color', 'royal' ),
						'param_name'  => 'carousel_filter_cat_background_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Filter Items Color', 'royal' ),
						'description' => esc_attr__( 'Controls the color of the text, ex: #000.', 'fusion-builder' ),
						'param_name'  => 'cat_filter_items_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Active Filter Background', 'royal' ),
						'description' => __( 'Controls the Filter Items Background color', 'royal' ),
						'param_name'  => 'active_carousel_filter_cat_background_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Active Filter Items Color', 'royal' ),
						'description' => esc_attr__( 'Controls the color of the text, ex: #000.', 'fusion-builder' ),
						'param_name'  => 'active_cat_filter_items_color',
						'value'       => '#1b1f22',
						'dependency'       => [
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Active Filter Items Border Color', 'royal' ),
						'description' => esc_attr__( 'Controls the color of the text, ex: #000.', 'fusion-builder' ),
						'param_name'  => 'active_cat_filter_items_border_color',
						'value'       => '#00c095',
						'dependency'       => [
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
                    [
                        'type'        => 'dimension',
                        'heading'     => esc_attr__( 'Padding', 'fusion-builder' ),
                        'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 4%.', 'fusion-builder' ),
                        'param_name'  => 'cat_filter_item_padding',
                        'value'       => [
                                'padding_top'    => '',
                                'padding_right'  => '',
                                'padding_bottom' => '',
                                'padding_left'   => '',
                        ],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
                    ],
        			[
        				'type'        => 'range',
        				'heading'     => __( 'Carousel Category Filter Gap', 'royal' ),
        				'description' => __( 'Controls the Carousel Category Filter Gap.', 'royal' ),
        				'param_name'  => 'cat_filter_item_gap',
        				'value'       => '10',
        				'min'         => '0',
        				'max'         => '60',
        				'step'        => '1',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
        				'group' 	  => __( 'Create Carousel', 'royal' ),
        			],
					// [
					// 	'type'        => 'connected_sortable',
					// 	'heading'     => esc_attr__( 'Categories', 'fusion-builder' ),
					// 	'description' => esc_attr__( 'Select a category or leave blank for all.', 'fusion-builder' ),
					// 	'param_name'  => 'cat_slug',
					// 	'default'     => '',
					// 	'choices'     => iranavada_shortcodes_categories( 'product_cat' ),
					// 	'group' 	  => __( 'Create Carousel', 'royal' ),
					// ],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Carousel Auto Play', 'royal' ),
						'description' => __( 'Controls the automatic rotation of the carousel.', 'royal' ),
						'param_name'  => 'special_carousel_auto_play_set',
						'value'       => [
							'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
							'false'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'default'	  => 'true',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Rewind', 'royal' ),
						'description' => __( 'Select The Rewind Status For Carousel Products.', 'royal' ),
						'param_name'  => 'special_carousel_rewind',
						'value'       => [
							'true'   => esc_attr__( 'Yes', 'fusion-builder' ),
							'false'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'default'	  => 'false',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'special_carousel_auto_play_set',
								'value'    => 'true',
								'operator' => '==',
							],
						],
					],
					[
						'type'        => 'range',
						'heading'     => __( 'Auto Play Time', 'royal' ),
						'description' => __( 'Select The Auto Play You Need To Carousel Products.', 'royal' ),
						'param_name'  => 'special_carousel_auto_play_time',
						'value'       => '7000',
						'min'         => '3000',
						'max'         => '15000',
						'step'        => '500',
						'dependency'       => [
							[
								'element'  => 'special_carousel_auto_play_set',
								'value'    => 'true',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Title', 'royal' ),
						'description' => __( 'Select To Display Title Or Hide.', 'royal' ),
						'param_name'  => 'irava_display_title',
						'value'       => [
							'yes'     => __( 'Yes', 'fusion-builder' ),
							'no' 	  => __( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
						],
						'default'	  => 'yes',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
    //     			[
    //     				'type'        => 'range',
    //     				'heading'     => __( 'Carousel Carousel Items Gap', 'royal' ),
    //     				'description' => __( 'Controls the Carousel Items Gap.', 'royal' ),
    //     				'param_name'  => 'carousel_items_gap',
    //     				'value'       => '17',
    //     				'min'         => '0',
    //     				'max'         => '50',
    //     				'step'        => '1',
				// 		'dependency'       => [
				// 			[
				// 				'element'  => 'select_slider',
				// 				'value'    => 'carousel',
				// 				'operator' => '==',
				// 			],
				// 		],
    //     				'group' 	  => __( 'Create Carousel', 'royal' ),
    //     			],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Title Font Color', 'royal' ),
							'description' => esc_attr__( 'Controls the color of the text, ex: #000.', 'fusion-builder' ),
						'param_name'  => 'irava_product_title_color',
						'value'       => '#333',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_title',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Price', 'royal' ),
						'description' => __( 'Select To Display Price Or Hide.', 'royal' ),
						'param_name'  => 'irava_display_price',
						'value'       => [
							'yes'     => __( 'Yes', 'fusion-builder' ),
							'no' 	  => __( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
						],
						'default'	  => 'yes',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Regular Price Color', 'royal' ),
							'description' => __( 'Controls the Regular Price color, ex: #000.', 'royal' ),
						'param_name'  => 'irava_product_del_price_font_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_price',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Sale Price Color', 'royal' ),
						'description' => __( 'Controls the Sale Price color, ex: #000.', 'royal' ),
						'param_name'  => 'irava_product_sale_price_font_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_price',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Last Slide', 'royal' ),
						'description' => __( 'Select To Display Last Slide Or Hide.', 'royal' ),
						'param_name'  => 'irava_display_last_slide',
						'value'       => [
							'yes'     => __( 'Yes', 'fusion-builder' ),
							'no' 	  => __( 'No', 'fusion-builder' ),
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
						],
						'default'	  => 'no',
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Banner And Button', 'royal' ),
						'description' => __( 'display Intro Column For Carousel Template.', 'royal' ),
						'param_name'  => 'display_banner_button',
						'value'       => [
							  'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
							  'no'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'default'	  => 'no',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'no',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					[ 
						'type' => 'textfield', 
						'heading' => __( 'Hero Image Height On PC', 'royal' ), 
						'param_name' => 'hero_img_height_pc', 
						'value' => '260px', 
						'description' => __( 'Add Hero Image Height On PC Device.', 'royal' ),
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'display_banner_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
						],
					], 
					[ 
						'type' => 'textfield', 
						'heading' => __( 'Hero Image Height On Mobile', 'royal' ), 
						'param_name' => 'hero_img_height_mobile', 
						'value' => '200px', 
						'description' => __( 'Add Hero Image Height On Mobile Device.', 'royal' ),
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'display_banner_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
						],
					], 
					[
						'type'        => 'upload',
						'heading'     => __( 'Carousel Banner', 'royal' ),
						'description' => __( 'Add a Banner For Product Carousel Template.', 'royal' ),
						'param_name'  => 'carousel_banner',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'display_banner_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'no',
								'operator' => '==',
							],							
						],
						'callback'         => [],
					],

					[
						'type'        => 'textfield',
						'heading'     => __( 'Button Text', 'royal' ),
						'description' => __( 'Enter the name of the button, it sets the name of the buttons used at the beginning and end of the slider. Default: "Display All"', 'royal' ),
						'param_name'  => 'carousel_button_name',
						'value'       => 'نمایش همه',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'display_banner_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'no',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],
					
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Hero Image Show All Text Color', 'royal' ),
							'description' => __( 'Controls The Hero Image Show All Text Color', 'royal' ),
						'param_name'  => 'irava_banner_show_all_button_color',
						'value'       => '#fff',
						'dependency'       => [
							[
								'element'  => 'display_banner_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'no',
								'operator' => '==',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[
						'type'        => 'link_selector',
						'heading'     => __( 'Carousel Button Link', 'royal' ),
						'description' => __( 'Put The Carousel Button Link From This Section.', 'royal' ),
						'param_name'  => 'btn_link',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'special_carousel_cat_filter',
								'value'    => 'no',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],

					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Banner Or Text In Slider Template', 'royal' ),
						'description' => __( 'display any Text Or Font Icon in Slider Template Top Of Product Image.', 'royal' ),
						'param_name'  => 'slider_title_text_banner_image',
						'value'       => [
								'text'   => __( 'Text', 'royal' ),
								'banner' => __( 'Banner', 'royal' ),
							],
						'default'	  => 'text',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[
						'type'        => 'upload',
						'heading'     => __( 'Slider Font Icon', 'royal' ),
						'description' => __( 'Add a Font Icon For Slider Template On Top Of product Image.', 'royal' ),
						'param_name'  => 'slider_template_font_icon',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'slider_title_text_banner_image',
								'value'    => 'banner',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '==',
							],
						],
						'callback'         => [],
					],

					[ 
						'type' 			=> 'textfield', 
						'heading' 		=> __( 'Slider Title', 'royal' ), 
						'description' 	=> __( 'add title for slider template. default: Special offers', 'royal' ),
						'param_name' 	=> 'slider_heading_text', 
						'value' 		=> '', 
						'dependency'       => [
							[
								'element'  => 'slider_title_text_banner_image',
								'value'    => 'text',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '==',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					], 
					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Display Percentage/Number Off Price', 'royal' ),
						'description' => __( 'You can specify how to display the discount price to be displayed as a percentage / number.', 'royal' ),
						'param_name'  => 'display_percentage_number_off',
						'value'       => [
							  'percentage'  => __( 'Percentage', 'royal' ),
							  'number'  	=> __( 'Number', 'royal' ),
						],
						'default'	  => 'percentage',
						'callback'         => [],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[
						'type'        => 'textfield',
						'heading'     => __( 'Product Limit', 'royal' ),
						'description' => __( 'Enter the number of product display limits in the carousel / slider. Default: 12', 'royal' ),
						'param_name'  => 'display_product_limit',
						'value'       => '12',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[
						'type'             => 'dimension',
						'remove_from_atts' => true,
						'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
						'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
						'param_name'       => 'border_sizes',
						'value'            => [
							'border_top'    => '',
							'border_right'  => '',
							'border_bottom' => '',
							'border_left'   => '',
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
					
					[
						'type'        => 'select',
						'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
						'description' => esc_attr__( 'Choose the separator line style. Default currently set to Dashed.', 'fusion-builder' ),
						'param_name'  => 'special_offer_item_border_style',
						'value'       => [
							'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
							'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
							'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
						],
						'default'     => 'solid',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
							[
								'element'  => 'border_top',
								'value'    => '',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[ 
						'type'        => 'colorpickeralpha',
						'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
						'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
						'param_name'  => 'special_offer_item_border_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

					[
						'type'        => 'dimension',
						'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
						'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
						'param_name'  => 'special_offer_item_border_radius',
						'value'       => [
							'border_radius_top_left'     => '',
							'border_radius_top_right'    => '',
							'border_radius_bottom_right' => '',
							'border_radius_bottom_left'  => '',
						],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'slider',
								'operator' => '!=',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'callback'         => [],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],

    				[
    					'type'        => 'radio_button_set',
    					'heading'     => __( 'Show Timer', 'royal' ),
    					'description' => __( 'Show timer at the bottom of the products', 'royal' ),
    					'param_name'  => 'show_timer',
    					'value'       => [
    							'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
    							'no'  => esc_attr__( 'No', 'fusion-builder' ),
    					],
    					'default'	  => 'yes',
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    				
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Timer Color', 'royal' ),
						'description' => esc_attr__( 'Controls the color of the text, ex: #000.', 'fusion-builder' ),
						'param_name'  => 'irava_off_timer_color',
						'value'       => '',
						'dependency'       => [
							[
								'element'  => 'show_timer',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
						'group' 	  => __( 'Create Carousel', 'royal' ),
					],
    				
    			// ************************ Start Add To Cart Tab ************************ //

					[
						'type'        => 'radio_button_set',
						'heading'     => __( 'Enable Add To Cart Button', 'royal' ),
						'description' => __( 'Enable This Option For Display Add to Cart Button On Selected Template.', 'royal' ),
						'param_name'  => 'enable_disable_addtocart_button',
						'value'       => [
							'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
							'no'  => esc_attr__( 'No', 'fusion-builder' ),
						],
						'default'	  => 'no',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_price',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
					],
					[
						'type'        => 'iconpicker',
						'heading'     => __( 'Select Add To Cart Icon', 'royal' ),
						'description' => __( 'Select Any Icon For Add To Cart Button In Carousel Template.', 'royal' ),
						'param_name'  => 'addtocart_button_icon_carousel',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'enable_disable_addtocart_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_price',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
					],
					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Select Add To Cart Background', 'royal' ),
						'description' => __( 'This field allows you to select the color with rgba value For Add To Cart Background.', 'royal' ),
						'param_name'  => 'addtocart_background_color',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'enable_disable_addtocart_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_price',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'default'	=> '',
					],

					[
						'type'        => 'colorpickeralpha',
						'heading'     => __( 'Select Add To Cart Icon Color', 'royal' ),
						'description' => __( 'you can select add to cart icon color.', 'royal' ),
						'param_name'  => 'addtocart_icon_color',
						'value'       => '',
						'group' 	  => __( 'Create Carousel', 'royal' ),
						'dependency'       => [
							[
								'element'  => 'enable_disable_addtocart_button',
								'value'    => 'yes',
								'operator' => '==',
							],
							[
								'element'  => 'select_slider',
								'value'    => 'carousel',
								'operator' => '==',
							],
							[
								'element'  => 'irava_display_price',
								'value'    => 'yes',
								'operator' => '==',
							],
						],
						'default'	=> '',
					],

				// ************************ End Add To Cart Tab ************************ //

    				[
    					'type'        => 'select',
    					'heading'     => esc_attr__( 'Order By', 'fusion-builder' ),
    					'description' => esc_attr__( 'Defines how posts should be ordered.', 'fusion-builder' ),
    					'param_name'  => 'irava_orderby',
    					'value'       => [
    						'none'     		=> __( 'None', 'royal' ),
    						'ID'     		=> __( 'ID', 'royal' ),
    						'name'     		=> __( 'Name', 'royal' ),
    						'date'     		=> __( 'Date published', 'royal' ),
    						'modified'      => __( 'Date Modified', 'royal' ),
    					],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
    					'default'	  => 'date',
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'select',
    					'heading'     => esc_attr__( 'Order', 'fusion-builder' ),
    					'description' => esc_attr__( 'Defines the sorting order of posts.', 'fusion-builder' ),
    					'param_name'  => 'irava_sortby',
    					'value'       => [
    						'DESC' => esc_attr__( 'Descending', 'fusion-builder' ),
    						'ASC'  => esc_attr__( 'Ascending', 'fusion-builder' ),
    					],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
    					'default'	  => 'DESC',
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'radio_button_set',
    					'heading'     => __( 'Discounted products', 'royal' ),
    					'description' => __( 'display all discounted products.', 'royal' ),
    					'param_name'  => 'discounted_products',
    					'value'       => [
    							'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
    							'no'  => esc_attr__( 'No', 'fusion-builder' ),
    					],
						'dependency'       => [
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
						],
    					'default'	  => 'no',
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],

    				[
    					'type'        => 'radio_button_set',
    					'heading'     => __( 'Shegeftangiz', 'royal' ),
    					'description' => __( 'display amazing products.', 'royal' ),
    					'param_name'  => 'shegeftangiz',
    					'value'       => [
    							'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
    							'no'  => esc_attr__( 'No', 'fusion-builder' ),
    					],
						'dependency'       => [
    						[
    							'element'  => 'discounted_products',
    							'value'    => 'no',
    							'operator' => '==',
    						],
							[
								'element'  => 'select_slider',
								'value'    => 'brands',
								'operator' => '!=',
							],
    					],
    					'default'	  => 'no',
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'textfield',
    					'heading'     => __( 'Small Mobile columns', 'royal' ),
    					'description' => __( 'Set columns in small mobile', 'royal' ),
    					'param_name'  => 'responsive_min_0',
    					'value'       => '2',
    					'dependency'       => [
    						[
    							'element'  => 'select_slider',
    							'value'    => 'slider',
    							'operator' => '!=',
    						],
    					],
    					'callback'         => [],
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'textfield',
    					'heading'     => __( 'Large Mobile columns', 'royal' ),
    					'description' => __( 'Set columns in large mobile', 'royal' ),
    					'param_name'  => 'responsive_min_480',
    					'value'       => '3',
    					'dependency'       => [
    						[
    							'element'  => 'select_slider',
    							'value'    => 'slider',
    							'operator' => '!=',
    						],
    					],
    					'callback'         => [],
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'textfield',
    					'heading'     => __( 'Tablet columns', 'royal' ),
    					'description' => __( 'Set columns in tablet', 'royal' ),
    					'param_name'  => 'responsive_min_720',
    					'value'       => '4',
    					'dependency'       => [
    						[
    							'element'  => 'select_slider',
    							'value'    => 'slider',
    							'operator' => '!=',
    						],
    					],
    					'callback'         => [],
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'textfield',
    					'heading'     => __( 'Laptop columns', 'royal' ),
    					'description' => __( 'Set columns in Laptop', 'royal' ),
    					'param_name'  => 'responsive_min_960',
    					'value'       => '5',
    					'dependency'       => [
    						[
    							'element'  => 'select_slider',
    							'value'    => 'slider',
    							'operator' => '!=',
    						],
    					],
    					'callback'         => [],
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    
    				[
    					'type'        => 'textfield',
    					'heading'     => __( 'PC columns', 'royal' ),
    					'description' => __( 'Set columns in pc', 'royal' ),
    					'param_name'  => 'responsive_min_1200',
    					'value'       => '6',
    					'dependency'       => [
    						[
    							'element'  => 'select_slider',
    							'value'    => 'slider',
    							'operator' => '!=',
    						],
    					],
    					'callback'         => [],
    					'group' 	  => __( 'Create Carousel', 'royal' ),
    				],
    			],
    			'callback'  => [
    				'function' => 'fusion_ajax',
    				'action'   => 'get_fusion_products',
    				'ajax'     => true,
    			],
            ]
        )
    );
}
add_action( 'wp_loaded', 'iravada_special_carousel_element' );