<?php
/**
 * @Author: Iranavada Team
 * @Email:  iranavada@gmail.com
 * @Last modified by:   Iranavada Team
 */

global // Get All Global Variables Value
$id,
$responsive_min_0,
$responsive_min_480,
$responsive_min_720,
$responsive_min_960,
$responsive_min_1200,
$iravada_royal_brands,
$special_brand_carousel_auto_play_set,
$special_brand_carousel_auto_play_time,
$select_link_target_type,
$special_brand_loop_status,
$royal_brand_limit_display_items;

$responsive = array(
  "r_0" => $responsive_min_0 + 0.2,
  "r_480" => $responsive_min_480 + 0.2,
  "r_720" => $responsive_min_720 + 0.2,
  "r_960" => $responsive_min_960 + 0.2,
  "r_1200" => $responsive_min_1200 + 0.2,
);

// برای اطمینان از اینکه اسلاگ‌ها به درستی جدا می‌شوند و فاقد فضای خالی اضافی هستند
$brands_items = array_map('trim', preg_split ("/\,/", $iravada_royal_brands));
$responsive = esc_attr( esc_js( wp_json_encode( $responsive ) ) ) ;

?>

<div class="swiper iranavada-brand-template" data-responsive="<?= $responsive ?>" data-autoplay="<?= $special_brand_carousel_auto_play_set ?>" data-autoplaytime="<?= $special_brand_carousel_auto_play_time ?>" data-loop-status="<?= $special_brand_loop_status ?>">

  <div class="iravada-ajax-load <?= $id ?>"></div>
  <div class="swiper-wrapper iravada-brand <?= $id ?>" id="<?= $id ?>">

    <?php

        if( class_exists('IPL_CLIENT_UPDATE_THEME') ) {

            if( empty( $iravada_royal_brands ) && IPL_CLIENT_UPDATE_THEME::update() ) {

                $terms = get_terms([
                    'taxonomy' => 'iravada-royal-brands',
                    'hide_empty' => false,
                    'number'    => $royal_brand_limit_display_items,
                ]);

                foreach ($terms as $all_terms) {
                    // اضافه کردن بررسی برای اطمینان از اینکه $all_terms یک شیء معتبر است
                    if ( $all_terms && !is_wp_error( $all_terms ) ) {
                        $term_meta = get_term_meta( $all_terms->term_id, 'royal_brands_logo', true );
                        $current_image = wp_get_attachment_image( $term_meta, array(220, 50), false );
                        ?>
                        <div <?= FusionBuilder::attributes( 'royal_brand' ) ?>>
                            <a href="<?= get_term_link( $all_terms->term_id, 'iravada-royal-brands' ) ?>" class="product-link" target="<?= $select_link_target_type ?>">
                                <div <?= FusionBuilder::attributes( 'royal-brand-detail' ) ?>>
                                    <div class="royal-brand-logo-section">
                                        <?php
                                            echo wp_kses_post( $current_image );
                                        ?>
                                    </div>
                                    <span <?= FusionBuilder::attributes( 'irava-brand-name' ) ?>><?= $all_terms->name ?></span>
                                </div>
                            </a>
                        </div>
                        <?php
                    }
                }

            }elseif( !empty($iravada_royal_brands) ) {

                foreach ($brands_items as $brands_selected_slug) {
                    // اطمینان حاصل کنید که اسلاگ خالی پردازش نمی‌شود
                    if (empty($brands_selected_slug)) {
                        continue;
                    }

                    $term = get_term_by('slug', $brands_selected_slug, 'iravada-royal-brands');

                    if ( $term && !is_wp_error( $term ) ) { // بررسی کنید که $term یک شیء معتبر WP_Term است
                        $term_meta = get_term_meta( $term->term_id, 'royal_brands_logo', true );
                        $current_image = wp_get_attachment_image( $term_meta, array(220, 50), false );
                        ?>
                        <div <?= FusionBuilder::attributes( 'royal_brand' ) ?>>
                            <a href="<?= get_term_link( $term->term_id, 'iravada-royal-brands' ) ?>" class="product-link" target="<?= $select_link_target_type ?>">
                                <div <?= FusionBuilder::attributes( 'royal-brand-detail' ) ?>>
                                    <div class="royal-brand-logo-section">
                                        <?php
                                            echo wp_kses_post( $current_image );
                                        ?>
                                    </div>
                                    <span <?= FusionBuilder::attributes( 'irava-brand-name' ) ?>><?= $term->name ?></span>
                                </div>
                            </a>
                        </div>
                        <?php
                    } else {
                        // (اختیاری) می‌توانید در اینجا یک پیام خطا لاگ کنید یا به کاربر اطلاع دهید که برندی با این اسلاگ یافت نشد
                        // error_log("خطا: برند با اسلاگ '" . esc_html($brands_selected_slug) . "' در طبقه‌بندی 'iravada-royal-brands' یافت نشد.");
                    }
                }
            }
        }
    ?>
    </div>
  <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div>
</div>